# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class IncludeText(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IncludeText."""

    YES = "yes"
    """Include all textual data in response."""
    NO = "no"
    """Exclude textual data from response. Only images and country/region names will be in response."""


class LocalizedMapView(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LocalizedMapView."""

    AE = "AE"
    """United Arab Emirates (Arabic View)"""
    AR = "AR"
    """Argentina (Argentinian View)"""
    BH = "BH"
    """Bahrain (Arabic View)"""
    IN = "IN"
    """India (Indian View)"""
    IQ = "IQ"
    """Iraq (Arabic View)"""
    JO = "JO"
    """Jordan (Arabic View)"""
    KW = "KW"
    """Kuwait (Arabic View)"""
    LB = "LB"
    """Lebanon (Arabic View)"""
    MA = "MA"
    """Morocco (Moroccan View)"""
    OM = "OM"
    """Oman (Arabic View)"""
    PK = "PK"
    """Pakistan (Pakistani View)"""
    PS = "PS"
    """Palestinian Authority (Arabic View)"""
    QA = "QA"
    """Qatar (Arabic View)"""
    SA = "SA"
    """Saudi Arabia (Arabic View)"""
    SY = "SY"
    """Syria (Arabic View)"""
    YE = "YE"
    """Yemen (Arabic View)"""
    AUTO = "Auto"
    """Return the map data based on the IP address of the request."""
    UNIFIED = "Unified"
    """Unified View (Others)"""


class MapImageStyle(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MapImageStyle."""

    MAIN = "main"
    """Azure Maps main style"""
    DARK = "dark"
    """Dark grey version of the Azure Maps main style"""


class MapTileSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MapTileSize."""

    SIZE256 = "256"
    """Return a 256 by 256 pixel tile."""
    SIZE512 = "512"
    """Return a 512 by 512 pixel tile."""


class RasterTileFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RasterTileFormat."""

    PNG = "png"
    """An image in the png format. Supports zoom levels 0 through 18."""


class ResponseFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ResponseFormat."""

    JSON = "json"
    """`The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_"""
    XML = "xml"
    """`The Extensible Markup Language <https://www.w3.org/TR/xml/>`_"""


class StaticMapLayer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StaticMapLayer."""

    BASIC = "basic"
    """Returns an image containing all map features including polygons, borders, roads and labels."""
    HYBRID = "hybrid"
    """Returns an image containing borders, roads, and labels, and can be overlaid on other tiles
    #: (such as satellite imagery) to produce hybrid tiles."""
    LABELS = "labels"
    """Returns an image of just the map's label information."""


class TilesetID(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TilesetID."""

    MICROSOFT_BASE = "microsoft.base"
    """A base map is a standard map that displays roads, natural and artificial features along with
    #: the labels for those features in a vector tile.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: vector (pbf)."""
    MICROSOFT_BASE_LABELS = "microsoft.base.labels"
    """Displays labels for roads, natural and artificial features in a vector tile.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: vector (pbf)."""
    MICROSOFT_BASE_HYBRID = "microsoft.base.hybrid"
    """Displays road, boundary and label data in a vector tile.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: vector (pbf)."""
    MICROSOFT_TERRA_MAIN = "microsoft.terra.main"
    """Shaded relief and terra layers.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 6. Format: raster (png)."""
    MICROSOFT_BASE_ROAD = "microsoft.base.road"
    """All layers with our main style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_BASE_DARKGREY = "microsoft.base.darkgrey"
    """All layers with our dark grey style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_BASE_LABELS_ROAD = "microsoft.base.labels.road"
    """Label data in our main style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_BASE_LABELS_DARKGREY = "microsoft.base.labels.darkgrey"
    """Label data in our dark grey style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_BASE_HYBRID_ROAD = "microsoft.base.hybrid.road"
    """Road, boundary and label data in our main style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_BASE_HYBRID_DARKGREY = "microsoft.base.hybrid.darkgrey"
    """Road, boundary and label data in our dark grey style.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 22. Format: raster (png)."""
    MICROSOFT_IMAGERY = "microsoft.imagery"
    """A combination of satellite and aerial imagery. Only available in S1 pricing SKU.:code:`<br>`
    #: 
    #: Supports zoom levels 1 through 19. Format: raster (jpeg)."""
    MICROSOFT_WEATHER_RADAR_MAIN = "microsoft.weather.radar.main"
    """Weather radar tiles. Latest weather radar images including areas of rain, snow, ice and mixed
    #: conditions. Please see `coverage information <https://aka.ms/AzureMapsWeatherCoverage>`_ for
    #: Azure Maps Weather service.  To learn more about the Radar data, please see `Weather concepts
    #: <https://aka.ms/AzureMapsWeatherConcepts>`_.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 15. Format: raster (png)."""
    MICROSOFT_WEATHER_INFRARED_MAIN = "microsoft.weather.infrared.main"
    """Weather infrared tiles. Latest Infrared Satellite images shows clouds by their temperature.
    #: Please see `coverage information <https://aka.ms/AzureMapsWeatherCoverage>`_ for Azure Maps
    #: Weather service. To learn more about the returned Satellite data, please see `Weather concepts
    #: <https://aka.ms/AzureMapsWeatherConcepts>`_.:code:`<br>`
    #: 
    #: Supports zoom levels 0 through 15. Format: raster (png)."""
    MICROSOFT_TRAFFIC_ABSOLUTE = "microsoft.traffic.absolute"
    """absolute traffic tiles in vector"""
    MICROSOFT_TRAFFIC_ABSOLUTE_MAIN = "microsoft.traffic.absolute.main"
    """absolute traffic tiles in raster in our main style."""
    MICROSOFT_TRAFFIC_RELATIVE = "microsoft.traffic.relative"
    """relative traffic tiles in vector"""
    MICROSOFT_TRAFFIC_RELATIVE_MAIN = "microsoft.traffic.relative.main"
    """relative traffic tiles in raster in our main style."""
    MICROSOFT_TRAFFIC_RELATIVE_DARK = "microsoft.traffic.relative.dark"
    """relative traffic tiles in raster in our dark style."""
    MICROSOFT_TRAFFIC_DELAY = "microsoft.traffic.delay"
    """traffic tiles in vector"""
    MICROSOFT_TRAFFIC_DELAY_MAIN = "microsoft.traffic.delay.main"
    """traffic tiles in raster in our main style"""
    MICROSOFT_TRAFFIC_REDUCED_MAIN = "microsoft.traffic.reduced.main"
    """reduced traffic tiles in raster in our main style"""
    MICROSOFT_TRAFFIC_INCIDENT = "microsoft.traffic.incident"
    """incident tiles in vector"""
