/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.reflect.instruction.Opcodes;
import java.util.HashMap;

public class Instruction
implements Cloneable {
    private HashMap attributes;
    private byte[] bytes;
    private short offset;
    private static final short UNKNOWN_STACK_USAGE = 99;
    private static short[] stackUsages = new short[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 0, -1, 0, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1, -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -3, -4, -3, -4, -3, -3, -3, -3, -1, -2, 1, 1, 1, 2, 2, 2, 0, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -2, 0, 1, 0, 1, -1, -1, 0, 0, 1, 1, -1, 0, -1, 0, 0, 0, -3, -1, -1, -3, -3, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, 0, 1, 0, -1, -1, -1, -2, -1, -2, -1, 0, 1, -1, 0, -2, 99, 99, 99, 99, 0, 1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 99, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static short[] stackConsumptions = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 3, 4, 3, 4, 3, 3, 3, 3, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 1, 2, 1, 2, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2, 4, 0, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 1, 4, 2, 2, 4, 4, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 1, 2, 1, 0, 0, 1, 1, 2, 99, 99, 99, 99, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 99, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    Instruction() {
    }

    public Instruction(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("bytes.length of Instruction must be greater than 0");
        }
        this.bytes = bytes;
    }

    protected void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte getOpcode() {
        return this.bytes[0];
    }

    public int length() {
        return this.bytes.length;
    }

    public String toString() {
        int opCode = this.getOpcode();
        StringBuffer sb = new StringBuffer(Opcodes.opcodeStrings[opCode &= 0xFF]);
        for (int i = 1; i < this.bytes.length; ++i) {
            sb.append(" " + (0xFF & this.bytes[i]));
        }
        return sb.toString();
    }

    public short stackUsage() {
        short opcode = this.getOpcode();
        if (opcode == -74) {
            byte[] byArray = this.getBytes();
        }
        return stackUsages[0xFF & opcode];
    }

    public short stackConsumption() {
        short opcode = this.getOpcode();
        if (opcode == -59) {
            byte[] bytes = this.getBytes();
            return bytes[3];
        }
        return stackConsumptions[0xFF & opcode];
    }

    protected void setOffset(short offset) {
        this.offset = offset;
    }

    protected short getOffset() {
        return this.offset;
    }

    public void setAttribute(String name) {
        this.setAttribute(name, "");
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }
}

