# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementDomainTopicsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domain_topics_get(self, resource_group):
        response = await self.client.domain_topics.get(
            resource_group_name=resource_group.name,
            domain_name="str",
            domain_topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domain_topics_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.domain_topics.begin_create_or_update(
                resource_group_name=resource_group.name,
                domain_name="str",
                domain_topic_name="str",
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domain_topics_begin_delete(self, resource_group):
        response = await (
            await self.client.domain_topics.begin_delete(
                resource_group_name=resource_group.name,
                domain_name="str",
                domain_topic_name="str",
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domain_topics_list_by_domain(self, resource_group):
        response = self.client.domain_topics.list_by_domain(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2025-02-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
