# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.neonpostgres.aio import NeonPostgresMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNeonPostgresMgmtOrganizationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NeonPostgresMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_get(self, resource_group):
        response = await self.client.organizations.get(
            resource_group_name=resource_group.name,
            organization_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.organizations.begin_create_or_update(
                resource_group_name=resource_group.name,
                organization_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "companyDetails": {
                            "businessPhone": "str",
                            "companyName": "str",
                            "country": "str",
                            "domain": "str",
                            "numberOfEmployees": 0,
                            "officeAddress": "str",
                        },
                        "marketplaceDetails": {
                            "offerDetails": {
                                "offerId": "str",
                                "planId": "str",
                                "publisherId": "str",
                                "planName": "str",
                                "termId": "str",
                                "termUnit": "str",
                            },
                            "subscriptionId": "str",
                            "subscriptionStatus": "str",
                        },
                        "userDetails": {
                            "emailAddress": "str",
                            "firstName": "str",
                            "lastName": "str",
                            "phoneNumber": "str",
                            "upn": "str",
                        },
                        "partnerOrganizationProperties": {
                            "organizationName": "str",
                            "organizationId": "str",
                            "singleSignOnProperties": {
                                "aadDomains": ["str"],
                                "enterpriseAppId": "str",
                                "singleSignOnState": "str",
                                "singleSignOnUrl": "str",
                            },
                        },
                        "projectProperties": {
                            "attributes": [{"name": "str", "value": "str"}],
                            "branch": {
                                "attributes": [{"name": "str", "value": "str"}],
                                "createdAt": "str",
                                "databaseName": "str",
                                "databases": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "ownerName": "str",
                                        "provisioningState": "str",
                                    }
                                ],
                                "endpoints": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "endpointType": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "projectId": "str",
                                        "provisioningState": "str",
                                    }
                                ],
                                "entityId": "str",
                                "entityName": "str",
                                "parentId": "str",
                                "projectId": "str",
                                "provisioningState": "str",
                                "roleName": "str",
                                "roles": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "isSuperUser": bool,
                                        "permissions": ["str"],
                                        "provisioningState": "str",
                                    }
                                ],
                            },
                            "createdAt": "str",
                            "databases": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "ownerName": "str",
                                    "provisioningState": "str",
                                }
                            ],
                            "defaultEndpointSettings": {"autoscalingLimitMaxCu": 0.0, "autoscalingLimitMinCu": 0.0},
                            "endpoints": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "endpointType": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "projectId": "str",
                                    "provisioningState": "str",
                                }
                            ],
                            "entityId": "str",
                            "entityName": "str",
                            "historyRetention": 0,
                            "pgVersion": 0,
                            "provisioningState": "str",
                            "regionId": "str",
                            "roles": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "isSuperUser": bool,
                                    "permissions": ["str"],
                                    "provisioningState": "str",
                                }
                            ],
                            "storage": 0,
                        },
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_update(self, resource_group):
        response = await (
            await self.client.organizations.begin_update(
                resource_group_name=resource_group.name,
                organization_name="str",
                properties={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "companyDetails": {
                            "businessPhone": "str",
                            "companyName": "str",
                            "country": "str",
                            "domain": "str",
                            "numberOfEmployees": 0,
                            "officeAddress": "str",
                        },
                        "marketplaceDetails": {
                            "offerDetails": {
                                "offerId": "str",
                                "planId": "str",
                                "publisherId": "str",
                                "planName": "str",
                                "termId": "str",
                                "termUnit": "str",
                            },
                            "subscriptionId": "str",
                            "subscriptionStatus": "str",
                        },
                        "userDetails": {
                            "emailAddress": "str",
                            "firstName": "str",
                            "lastName": "str",
                            "phoneNumber": "str",
                            "upn": "str",
                        },
                        "partnerOrganizationProperties": {
                            "organizationName": "str",
                            "organizationId": "str",
                            "singleSignOnProperties": {
                                "aadDomains": ["str"],
                                "enterpriseAppId": "str",
                                "singleSignOnState": "str",
                                "singleSignOnUrl": "str",
                            },
                        },
                        "projectProperties": {
                            "attributes": [{"name": "str", "value": "str"}],
                            "branch": {
                                "attributes": [{"name": "str", "value": "str"}],
                                "createdAt": "str",
                                "databaseName": "str",
                                "databases": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "ownerName": "str",
                                        "provisioningState": "str",
                                    }
                                ],
                                "endpoints": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "endpointType": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "projectId": "str",
                                        "provisioningState": "str",
                                    }
                                ],
                                "entityId": "str",
                                "entityName": "str",
                                "parentId": "str",
                                "projectId": "str",
                                "provisioningState": "str",
                                "roleName": "str",
                                "roles": [
                                    {
                                        "attributes": [{"name": "str", "value": "str"}],
                                        "branchId": "str",
                                        "createdAt": "str",
                                        "entityId": "str",
                                        "entityName": "str",
                                        "isSuperUser": bool,
                                        "permissions": ["str"],
                                        "provisioningState": "str",
                                    }
                                ],
                            },
                            "createdAt": "str",
                            "databases": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "ownerName": "str",
                                    "provisioningState": "str",
                                }
                            ],
                            "defaultEndpointSettings": {"autoscalingLimitMaxCu": 0.0, "autoscalingLimitMinCu": 0.0},
                            "endpoints": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "endpointType": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "projectId": "str",
                                    "provisioningState": "str",
                                }
                            ],
                            "entityId": "str",
                            "entityName": "str",
                            "historyRetention": 0,
                            "pgVersion": 0,
                            "provisioningState": "str",
                            "regionId": "str",
                            "roles": [
                                {
                                    "attributes": [{"name": "str", "value": "str"}],
                                    "branchId": "str",
                                    "createdAt": "str",
                                    "entityId": "str",
                                    "entityName": "str",
                                    "isSuperUser": bool,
                                    "permissions": ["str"],
                                    "provisioningState": "str",
                                }
                            ],
                            "storage": 0,
                        },
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_delete(self, resource_group):
        response = await (
            await self.client.organizations.begin_delete(
                resource_group_name=resource_group.name,
                organization_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_list_by_resource_group(self, resource_group):
        response = self.client.organizations.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_list_by_subscription(self, resource_group):
        response = self.client.organizations.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_get_postgres_versions(self, resource_group):
        response = await self.client.organizations.get_postgres_versions(
            resource_group_name=resource_group.name,
        )

        # please add some check logic here by yourself
        # ...
