.so crisp.mac
.SP 9
.ce
\s+5\s+9\s+9\f(HBC\s-9RISP  User  Guide\fR\s-9\s-5
.SP 10
.nf
.in +2i
\s+5\f(HBVersion:	2.2

Author:	Paul Fox

Date:		July 1991
.in
\s-5\fR
.SP 9
.in +1i
.ll -1i
.ce
\f(HBCopyright Notice\fR
.SP 2
.fi
This document and the software it describes is Copyright (C) 1991
by Foxtrot Systems Ltd and Paul Fox. This copyright notice will remain
in effect at all times.
This manual may be reproduced under the terms of the CRISP copyright notice
associated with the distribution software.
.in
.ll
.SP 4
.nf
Foxtrot Systems Ltd
8, Theobalds Way
Frimley,
Surrey,
England GU16 5RF
.fi
.bp
.PH "'''Page %'"
.PF "'CRISP User Guide'July 1991'Release 2.2'"
.H 1 Introduction
.P
This guide covers
how to run & use CRISP, describing the editing functions available
and the keys that are assigned, and is aimed at the users who are new
to CRISP. It does not yet cover all aspects of using CRISP, and hopefully
later versions of the help system will cater for this.
This manual should be read in conjunction 
with the following documents:
.DL
.LI
CRISP Configuration and Installation Guide. This covers the installation
and customisation of CRISP, together with descriptions of various parts
of the sources making up the distribution.
.LI
CRISP Programmers Guide. This document should be read by people who wish to
write their own macros in either the lisp-like language or the 
\f(HBcrunch\fR language.
.LI
CRISP Primitives Reference Guide. This describes the builtin function
available to macro programmers.
.LE
.P
CRISP is a programmers editor containing many advanced features.
The following is just a small list of features available:
.BL
.LI
Full color support and highlighting of blocks for
copying and deleting.
.LI
Full infinite levels of undo and redo.
.LI
Multiple buffers and windows on screen.
.LI
Multiple backups of files.
.LI
Multiple named scrap buffers for cutting and pasting between buffers.
.LI
C-like programming language allowing users to
enhance and customise the functionality of the editor.
.LI
Integrated access to external system programs, e.g.
C compiler, shells, etc.
.LI
Scroll-locking two windows together to allow side by side file comparisons.
.LE
.P
Where ever possible, CRISP has no internal limitation on the number of
files being edited, maximum line length, etc. CRISP is only limited by
your machines memory and disk space limitations.
.P
In essence, CRISP combines some of the best features of other
editors available, e.g. vi, emacs, BRIEF.
.P
PLEASE NOTE:: This document describes the \fInormal\fR key bindings of
CRISP. These bindings may be changed and reconfigured by the user or the
system administrator. Depending on the keyboard, operating system
or windowing system, some keystroke sequences will not be typeable. The
keystrokes defined in this manual are all with reference to a PC keyboard.
Many terminal emulators under the X-windows and Sunview windowing systems do
not allow access to the required keystrokes. Please consult the configuration
guide if you have a problem making certain key strokes work properly.
.H 1 "Running CRISP"
.P
When CRISP starts up, it displays a single window, covering the whole
of the screen, except the bottom line of the screen. The bottom line of
the screen is a status and command line. It is used to display the
current line and column information, together with a clock to show you
the current time.

Most of the time, the cursor is in this window, until the user wishes
to issue a command which requires some information to be
filled in. For example, to edit a file (using \fH<Alt-E>\fR), causes
an "\f(CBEdit file:\fR" prompt to appear at the bottom left of the screen.
The user types in the appropriate response, and hits \fH<Enter>\fR to
cause the command to take effect.

Within the current buffer, the user can type in text, delete text
and perform various editing actions. CRISP has many editing functions,
the most useful of which are accessible from the function keys. Some functions
which are not used very often are accessible from the command line,
or the features menu.

Although CRISP has a large number of functions accessible from the 
function keys, the user should not be put off when trying to learn
CRISP. The most commonly used operations in CRISP are either accessible
from the key markings on the keyboard (e.g. page-up, home, left-arrow),
or are accessed using the \fH<Alt>\fR key plus a letter, e.g. \fH<Alt-W>\fR writes
the current buffer away.

In addition, CRISP provides full on-line help, so that the
user can quickly find out what keys are mapped to which functions or
understand the idiosyncrasies of certain parts of the system, e.g.
regular expressions.
.H 1 "Undoing changes to the buffer"
.P
CRISP provides a facility called \fIundo\fR. This facility allows
the user to undo any operation applied to the current buffer. It
is useful to be aware of this function before doing anything else
since you can always backtrack if you make any mistakes.
.P
The undo function is accessed via the \f(HB<Alt-U>\fR key.
.P
The undo facility is like an audit trail kept of all modifications
to the buffer. Modifications to the buffer can be undone sequentially
all the way back to the point at which the current buffer was read in to
CRISP or saved to disk. CRISP keeps an infinite level of
undo information for the current buffer.
.P
CRISP also provides a \fIredo\fR facility. Redo is the opposite of
undo. If you undo too much, the last 'undo' can be undone. The redo
facility is available via the \f(HB<Ctrl-U>\fR key.
.P
The undo information is kept in a list allowing all operations to be
undone. When a buffer is written away, a special marker is saved
in the undo file which causes the user to be prompted if you try
to undo past this mark. This is done because if you undo
past a file marker, you may end up with a buffer which is not
the same as that on disk and may cause confusion if you were to exit
CRISP. For example, say you edit the file fred, make some changes
and save it away. You then make some more changes, and start hitting
\f(HB<Alt-U>\fR to undo these changes. When you get to the point where the
buffer in memory and the file on disk are the same, CRISP prompts you with
the message:
.DS
	Undo past saved file mark [yn] ?
.DE
.P
If you press 'y' and keep on undoing, you will eventually have a copy
of the buffer which corresponds to the way the file 'fred' looked when you
first started editing it. CRISP will then say '\fBNothing to undo\fR'. This
may fool you into believing it is safe to exit CRISP with the file named
fred as you perceive it from within CRISP. 
.P
Be very careful when undoing past these file marks as CRISP cannot undo
changes to a file already written to disk.
.H 1 "Moving the cursor"
.P
The cursor can be moved around the current buffer with a variety
of keystrokes, similar to most other editors. Where possible, CRISP uses
the appropriately labelled key on the keyboard.

All movements within a buffer are undo-able. The table at end of this
section summarises the keystrokes available for moving the cursor.

CRISP supports a virtual-space mechanism. What this means is that the
cursor can be moved to arbitrary positions within the current window,
even beyond the last character in a line. Tabs are not treated as single
characters (as they are in 'vi'), but instead are treated as a set
of space characters. If the user tries to type when the cursor is not
on a physical character within the buffer, then CRISP will automatically
provide enough spaces and/or tabs so that when the file is printed, it
will be printed as it appears on the screen.

This mechanism means that when moving the cursor from one line to the
next, the cursor will stay in the same column on the screen, irrespective
of the 'shape' of the line being moved onto. (vi has a habit of moving
the cursor backwards and forwards over tabs, and can be very confusing).

CRISP supports arbitrarily long lines. Lines which are too wide to
fit on the display are truncated at the right hand side of the window. If
the user moves the cursor to the right, the window will scroll
sideways to show more of the line.

.TS H
center allbox;
cB cB
l lw(4i).
Key	Description
=
.TH
<Left-arrow>	T{
Move cursor left one character position, wrapping around
to the end of the previous line if necessary.
T}
<Right-arrow>	T{
Move cursor right one character position. With the default
setup, the cursor does NOT wrap around to the beginning of the
next line.
T}
<Up-arrow>	T{
Moves cursor up one line, maintaining the same column position.
T}
<Down-arrow>	T{
Moves cursor down one line, maintaining the same column position.
T}
<Home>	T{
When pressed the first time, moves the cursor to the beginning of
the current line. The second time it moves the cursor to the top of the
current window; the third time it moves the cursor to the beginning of
the buffer.
T}
<Alt-Home>	T{
Moves the cursor to the left edge of the current window.
T}
<End>	T{
When pressed the first time, moves the cursor to the end
of the current line. The second time it moves the cursor
to the end of the current window; the third time it moves
the cursor to the end of the buffer.
T}
<Alt-End>	T{
Moves the cursor to the right edge of the current window.
T}
<PgDn>	T{
(Page Down). Moves cursor down one windows worth of the buffer.
T}
<PgUp>	T{
(Page Up). Moves cursor up one windows worth of the buffer.
T}
<Ctrl-End>	T{
On those keyboards that allow it, hitting the Ctrl and <End> key at
the same time moves the cursor to the bottom of the current window.
T}
<Ctrl-Home>	T{
On those keyboards that allow it, hitting Ctrl and <Home> moves
the cursor to the top of the current window.
T}
<Ctrl-Left arrow>	T{
Moves the cursor to the beginning of the previous word.
T}
<Ctrl-Right arrow>	T{
Moves the cursor to the beginning of the next word.
T}
<Ctrl-PgDn>	T{
Goes to the last line in the buffer. (Note that this
keystroke is not available on many terminals).
T}
<Ctrl-PgUp>	T{
Goes to the first line in the buffer. (Note that this
keystroke is not available on many terminals).
T}
<Alt-G>	T{
Hitting <Alt-G> causes the user to be prompted for a line number to go to
on the command line. Type in the line number and press \fH<Enter>\fR.
T}
<Ctrl-B>	T{
Moves the current line to the to the bottom of the
window allowing the user to see the text above the cursor.
T}
<Ctrl-C>	T{
Centers the current line in the current window allowing
the user to see the lines before and after the current window.
T}
<Ctrl-T>	T{
Moves the current line to the top of the window allowing
the user to see lines below the cursor.
T}
.TE
.H 1 "Inserting and Deleting Text"
.P
Inserting text is simple -- just start typing. CRISP is a modeless
editor in the sense that all normal typeable keys are inserted directly
into the current buffer. No 'mode' needs to be entered to type in text.
This is because the function keys provide access to the useful
editing commands. (In comparison, the 'vi' editor has an insert
mode and a command mode, which can be very annoying, especially when
you start typing in text in command mode). 
.P
CRISP supports an insert mode where characters typed are inserted
between existing characters, and a replace or \fIoverwrite\fR mode, where
characters typed replace the character underneath the cursor. This
is toggled by using the \f(HBAlt-I>\fR key. On systems which support it,
the cursor will change shape to indicate the current mode. On other systems,
the string \f(HBOV\fR will appear on status line to indicate that overwrite
mode is active.
.P
CRISP provides a set of word-processing macros which can aid in
typing in documentation and comments in programs (currently only C language
comments are supported). These macros provide for line wrapping and
paragraph justification. CRISP also provides, by default, an auto-indent
facility, that is when hitting the <Enter> key, the cursor moves to the
next line underneath the first character position of the previous line.
This autoindent facility may be turned off if the user does not like it.

CRISP also supports the ability to map <Tab> characters to spaces as
they are typed in. Some people prefer this, and they can even set the tab-width.
Mapping <Tab> characters to spaces can be useful especially when non-standard
tab withs are used, so that the printed file looks the same as it appears on
screen.

There are many functions for deleting text. Text may be deleted
in chunks -- characters, words, lines or blocks. (A block is an arbitrary
sized region of the current buffer defined by the user).

All inserts and deletes in the current buffer are undoable at any time.

The following table summarises the keys for deleting text from the
buffer:

.TS H
allbox;
cB cB
l lw(4i).
Key	Description
=
.TH
<Alt-I>	T{
This key is used to toggle insert and overwrite mode. 
T}
<Backspace>	T{
Deletes the last character typed (or the character to the left of
the cursor). If <Tab>'s are inserted as spaces, then pressing <Backspace>
deletes the last space only.
T}
<Del>	T{
The delete key deletes the character under the cursor.
T}
<Ctrl-K>	T{
Deletes the word to the left of the cursor.
T}
<Ctrl-L>	T{
Deletes the word to the right of the cursor.
T}
<Alt-D>	T{
Deletes the current line.
T}
<Alt-K>	T{
Deletes all characters to the right of the cursor on the current line.
T}
<Keypad-minus>	T{
Deletes the current line and copies it to the scrap.
T}
.TE
.H 1 "Cutting and Pasting Text"
.P
Cutting and pasting of text is a way of copying blocks of text from one
part of a buffer to another, or even to copy data from one buffer
to a different one. CRISP has a thing called the '\fIscrap\fR'. The scrap
is a temporary storage area for data which has been cut from a buffer, and
can then be inserted as many times as necessary to some other buffer.
Cutting text is different from deleting text. When text is deleted, the
deleted text cannot be referred to (except by undoing
the deletion which puts it back where it came from). 

Cutting text deletes the original text, but saves it so it can then 
be inserted elsewhere.

When referring to cutting and pasting text, the terms '\fIregion\fR' or
\'\fIanchor\fR's is often used. This is to do with the way in which text to
be cut is specified. A piece of text to be cut, or region, is highlighted
on the screen so that it is clearly visible. To highlight a region, the
user types one of the four main mark commands. This drops an 'anchor';
as the cursor is moved away from the anchor, the text between the point
where the anchor was dropped and the current cursor position is hilighted
showing the text which can be cut or copied.

There are two ways of cutting text to the scrap buffer -- cutting
and copying. Cutting text to the scrap buffer copies the data to the
scrap and then deletes the text which was hilighted; copying does the
same operation without deleting the originally hilighted region.

There are four types of regions -- inclusive, non-inclusive, column and line.
The line type is the most useful and commonly used region type.
It is used to cut and paste whole lines. A column mark is
used to mark a column of text. Inclusive and non-inclusive marks are
almost the same and operate from anywhere within a line to wherever the
cursor is. A non-inclusive mark does not include the character under
the cursor, whereas an inclusive mark does.

CRISP supports multiple scrap buffers. By default, there is a scrap
buffer, referred to as the \fIanonymous\fR scrap buffer. The cut
and paste commands automatically dump their data into this anonymous scrap.
Alternatively the user can specify a named scrap buffer. A named scrap
is like the normal scrap, but allows the user to keep different copies
of data in these temporary buffers. The keys for accessing these
named scraps are described in the table below. When accessing the named
cut/copy/paste commands, the user is prompted for a name for the
scrap. This can be any valid buffer name. Hitting the <Tab> key at these
prompts pops up a window showing the currently defined scrap names.
The popup window allows the user to select a scrap or delete them. 
(The popup window also shows the contents of the first line of the
scraps). Normally there is an entry for the scrap called \f(HBanon\fR. This
scrap is the default anonymous scrap created by CRISP on startup.
Named scrap buffers are created automatically when prompted for by
the user.

When a scrap buffer is selected, it becomes the current default scrap.
The user is not allowed to delete the current scrap, and an error message
will be displayed if you attempt to do this.

.ne 1i
.TS H
center allbox;
cB cB
lw(1.5i) lw(4i).
Key	Description
=
.TH
<Alt-L>	T{
Drops a line marker. When a cut or copy command is issued, whole lines
will be affected in the operation.
T}
<Alt-C>	T{
Drops a column marker. Text falling within a rectangular region from
where the anchor was dropped to the current cursor will be hilighted.
T}
<Alt-M>	T{
Drops an inclusive marker. When a cut or copy command is issued, the character
under the cursor will be included in the operation.
T}
<Alt-A>	T{
Drops a non-inclusive marker. When a cut or copy command is 
issued, the character under the cursor will not be included in the operation.
T}
<Keypad-minus>	T{
If no region is currently hilighted, then the current line is cut
to the scrap buffer. If there is a hilighted region, then the region
is copied to the scrap and deleted.
T}
<Keypad-plus>	T{
If no region is currently hilighted, then the current line is copied
to the scrap buffer. If there is a hilighted region, then the region
is copied to the scrap without being deleted.
T}
<Ins>	T{
Pastes the current contents of the scrap buffer into the current buffer
at the current cursor position. For line-type regions, the lines
are inserted before the current line rather than inserting from
where the cursor is.
T}
<Shift-Keypad-plus>	T{
The hilighted region is appended to the current scrap without replacing it.
T}
<Shift-Keypad-minus>	T{
The hilighted region is appended to the current scrap without replacing it.
The hilighted region is deleted from the original buffer.
T}
<Ctrl-Keypad-plus>	T{
The hilighted region is copied to a named scrap. The user is prompted for
the scrap name. Hit <Tab> to see the current list of named scraps.
T}
<Ctrl-Keypad-minus>	T{
The hilighted region is cut to a named scrap. The user is prompted for
the scrap name. Hit <Tab> to see the current list of named scraps.
T}
<Ctrl-Keypad-Ins>	T{
A named scrap is to be pasted at the current cursor position. The user
is prompted for the name. Hit <Tab> to see the list of named scraps.
T}
<Ctrl-F>	T{
This key is used to reformat a paragraph. Paragraph
formatting is filename dependent. For example, C
programs are justified and formatted inside a comment
box. Formatting comments for other file types may be
used for filling and justifying text. See the section on
word processing functions for more details.
T}
.TE
.H 1 "File and Buffer Manipulation"
.P
Files are always accessed by loading them into a buffer,
e.g. by using the \fH<Alt-E>\fR function. CRISP can keep
multiple files in memory at once, and allow the user to
quickly switch between them. 
.P
CRISP supports a wide variety of automatic mechanisms to aid the
user in case of accidentally damaging files. These mechanisms are:
.DS
	- autosaving
	- automatic backups
	- automatic rebackups
.DE

Autosaving is a mechanism whereby all currently modified buffers are saved
to disk after so many seconds of idle keyboard input (default is 1 minute).
The buffers are saved to files with an at-sign appended and prefixing the
orginal filename, rather than overwriting the original. The at-signs are
used so that the autosave files stand out in a directory and hopefully
avoid conflict with any other files. These autosave files are automatically
deleted when CRISP exits. These files can be used if the system were to 
crash during an editing session.

Automatic backups are provided for when a buffer is saved to disk.
If the BBACKUP environment variable is \fInot\fR set, then editing the
file \f(HBfred.c\fR will cause a file called \f(HBfred.bak\fR to be
created containing the original contents of the file before editing began.
If the BBACKUP variable is defined, then all backup files are collected
in the specified directory. In addition, if the BVERSION environment
variable is set, then CRISP will automatically keep track of more
than one previous version. (BVERSION should contain the number of
backups to maintain). Refer to the configuration manual for more details
of how the backup mechanism works.

Rebackup is a facility whereby backups of files are forced to occur.
Normally CRISP will create a backup of an edited file at the point at
which it is first saved. Thereafter no further backups are made on each
subsequent save. This is so that if you decide to abort the current editing
session, you can then retrieve a copy of the file as it was before the
editing session began. However, this scheme does not work too well if
you stay inside of CRISP for extended periods of time. In this case the
backup which is made by CRISP on the first save may be quite out of date.
The rebackup mechanism causes CRISP to make new backups of files every
2 hours (by default). This means that the latest backup file on disk is
never more than 2 hours out of date. This is useful where you keep making
lots of changes to files, and stay within CRISP all the time.
(Please refer to the section 15 for changing these defaults).
.P
.ne 1.5i
.TS H
center allbox;
cB cB
l lw(4i).
Key	Description
=
.TH
<Alt-B>	T{
Pops up a window containing a list of all the files
currently in memory together with some status
information on each file, e.g. how many lines in the
file, the current line number, the full file name of the
file loaded in the buffer, and also a flag (indicated by
an asterisk) indicating whether the buffer has been modified.
T}
<Alt-E>	T{
Used to edit a file. The user is prompted on the command
line for the name of the file to be edited. Cshell meta
characters are allowed, e.g. \fH~fox/*.[ch]\fR edits all '.h' and '.c' 
files in the home directory of user fox.
Shell environment variables are allowed as well.
Hitting \fH<Tab>\fR pops up a menu of filenames which
the user can select from. (Selecting a directory causes
the popup to show the contents of the directory allowing
the user to walk around the file system before selecting a file).
T}
<Alt-N>	T{
This is used to edit the \fInext\fR buffer in sequence.
CRISP keeps buffers sorted in alphabetical order.
T}
<Alt-P>	T{
Edits the previous file whose filename alphabetically
precedes the file name of the current file.
T}
<Ctrl-P>	T{
Edits the previous file edited in the current window.
T}
<Alt-W>	T{
Write the contents of the current buffer away to disk
(creating backups as necessary).
T}
<Alt-R>	T{
This is used to read the contents of a file into the
current buffer just before the current line.
T}
<Alt-O>	T{
This is used to change the name of the file associated
with the current buffer. For example, if the user edits
the file \fHfred.txt\fR (using the \fH<Alt-E>\fR
command), then changes
the filename to \fHfox.txt\fR, then when the buffer is
saved (via \fH<Alt-W>\fR), the buffer will be written to
\fHfox.txt\fR and
NOT \fHfred.txt\fR.
T}
T{
<Ctrl-X>
.br
<Alt-X>
T}	T{
Used to exit CRISP. The user is prompted if any buffers
have been modified but not saved before allowing the
user to exit. The <Ctrl-X> key is an alias for <Alt-X> so that if
CRISP is run without having been set up properly you can still exit from
it. If this happens to you, you may need to type 'y' after hitting
<Ctrl-X> in case of the exit prompt asking about changed buffers.
T}
<Ctrl-W>	T{
Toggles the backup file flag. Normally when files are saved a backup of
the previous contents is kept. When this command is executed, the creation
of backups is turned off. This command acts as a toggle, turning
on and off alternately the backup creation flag.
T}
.TE
.H 1 "Window Manipulation"
.P
A window is an area of the screen, through which part of
a buffer may be viewed. All windows on screen have a
buffer \fIattached\fR to them, meaning that the buffer
is visible in the window.
Windows are useful for viewing more than one file at the
same time, or different parts of the same file.
.P
Windows can be displayed in any position on the screen,
and can overlap as necessary. (The user interface acts
as a limitation in the ability to arbitrarily lay out windows).
A buffer may be attached to more than one window, in
which case each window can be set up to view a different
part of the buffer.
.P
CRISP supports two forms of windows - tiled and
overlapping. Tiled windows are windows which do not
overlap or obscure each other. Initially CRISP starts up
with a single window which occupies the whole of the
screen.
Tiled windows can be split horizontally or vertically,
thus at all times the entire screen contains a window
mapping a buffer.
.P
Overlapped windows, or popups, are usually used in a
pop-up mode, e.g. the buffer list macros pops up a
window onto the screen which obscures any windows
sitting behind it. When the macro has terminated the
window is destroyed and the windows behind it are
refreshed.
.P
Each window maintains an independent cursor onto the
buffer below it. Any changes to a buffer made in one
window are displayed in the other windows displaying the
same part of the same buffer.

.TS H
center allbox;
cB cB
l lw(4i).
Key	Description
=
.TH
<F1>	T{
Used to select a different window. User is prompted to
\fIpoint\fR to the window required, using one of the
four arrow keys. If you type \fH<F1>\fR again, then the
\fInext\fR window is selected. (The definition is
\fInext\fR is fuzzy, but if you keep pressing \fH<F1>\fR
then eventually you will get to the desired window).
T}
<F2>	T{
This key allows the user to move the boundary between
two windows on the screen. The windows must abut each
other totally. User is prompted to point to the boundary
of the current window which is to be moved, and then
uses the arrow keys to move the boundary. The screen is
redrawn as the boundary is moved.
T}
<F3>	T{
This key is used to \fIsplit\fR the current window in
two equal sizes -- either horizontally or vertically.
T}
<F4>	T{
This is used to delete a boundary between two windows
and \fImerge\fR them together. 
T}
T{
<Shift-Up arrow>
.br
<Shift-Down arrow>
.br
<Shift-Left arrow>
.br
<Shift-Right arrow>
T}	T{
These keys are not available on all keyboard mappings
and act as a shorthand for moving into another window as
an alternative to using the \fH<F1>\fR key.
T}
.TE
.H 1 "Searching and Replacing Text"
.P
CRISP offers standard facilities for searching and replacing text.
The replacing of text (known as translating) searches for the text
and prompts the user for a number of actions, allowing the user to interactively
change each matching string.
.P
When searching for text, CRISP offers a full set of regular expression
matching characters. These allow the user to select patterns to match
against rather than literal occurrences of text.
.P
A number of options are available for controlling searches:
.DL
.LI
Regular expression matching. (Default is enabled).
.LI
Case Sensitivity. (Default is case sensitive searches enabled).
.LI
Block selection. (Default is Off).
.LI
Syntax mode. (Default is CRISP).
.LE
.P
Instead of prompting the user on every search, the user
can set up permanent defaults. These defaults remain
until the end of the editing session or until they are
changed again. They are not currently saved as part of
the users saved state. To change these options, use the \fH<Ctrl-O>\fR
key and select the \f(HBSearching\fR entry from the popup.
.P
Regular expression matching indicates whether certain
characters have special meaning when performing
searches, e.g. to match beginnings of lines or wild
cards. The following sections explains the facilities
available for matching regular expressions.
The default is that regular expressions are enabled, and
the user should be careful when trying to find
non-alphanumeric sequences, because many of these
characters are special, e.g. $ matches the end of the line.
.P
Case sensitivity indicates whether the case of letters
in the search string are significant. For example, the
string \f(CWfred\fR will not match the string
\f(CWFRED\fR under normal circumstances. Setting case
sensitive to Off will allow these strings to match.
.P
Block selection controls whether searches are limited to
the currently hilighted block. Normally searches extend
from the current cursor position to the end of file.
When block selection is enabled, CRISP will not look
outside of the hilighted region for a matching string.
.P
Syntax mode controls the style of syntax used for
regular expressions. CRISP supports two styles of
regular expressions -- those that are compatible with
standard Unix utilities, and those that are compatible
with the BRIEF editor. Refer to the next section for
more details on regular expressions.
.P
.TS H
center allbox ;
cB cB
l lw(4i).
Key	Description
=
.TH
T{
<F5>
.br
<Alt-S>
T}	T{
Searches for a string. The user is prompted for the string to search for.
The string is searched for in the forwards direction.
T}
T{
<Alt-F5>
.br
<Alt-Y>
T}	T{
Searches for a string in the backwards direction, i.e. the immediately
preceding occurrence of the string before the cursor.
T}
T{
<Shift-F5>,
.br
<Keypad-5>
T}	T{
This searches for the next occurrence of a string in either the forwards
or backwards direction, depending on the last search.
T}
T{
<F6>
.br
<Alt-T>
T}	T{
Performs a translate in the forwards direction.
Prompts the user for a string to search for and a string to replace
it with. For each matched occurrence of the string the user is prompted
whether to change or not. In addition, the following options are
available:
.VL 9
.LI Global
Change all occurrences without prompting for them.
.LI One
Translates the currently hilighted string and aborts
the translation command.
.LI Top
Move current line to top of window to make it
easier to see whats coming next.
.LI Undo
Back up to the last translated string and undo it.
.LE
T}
<Alt-F6>	T{
Performs a translate in the backwards direction.
T}
<Shift-F6>	T{
Repeats the last translation in the same direction.
T}
<Ctrl-F5>	T{
This command toggles the case sensitivity flag. When turned off, lower
case characters will match against upper case and vice versa. The default
is for case sensitivity to be turned on.
T}
<Ctrl-F6>	T{
This command toggles the state of regular expression matching. By
default regular expression matching is on. When turned off, all
characters match literally.
T}
<Ctrl-^>	T{
This function can be used to find matching brackets.
Place the cursor on a bracket (square, curly or round),
and CRISP moves the cursor to the matching bracket, or
beeps if it cannot find one.
T}
.TE
.H 1 "Recording keystrokes (keyboard macros)"
.P
CRISP supports a facility for recording a sequence of
keystrokes which can then be played back. This feature is useful when
a set of edits is being performed repetitively over a set of lines.
This sort of thing is needed quite often and CRISP supports a feature
called a keyboard macro. There are two main functions which allow
the user to define and playback a keyboard macro.
.P
CRISP allows multiple keyboard macros to be stored in memory. Keyboard
macros can also be saved to a disk file and reloaded, allowing the user
to build up a private collection of simple macros.
.P
A keystroke sequence which is played back is a primitive form of a macro.
Whilst the macro is being learnt, the user can pause the learning of
the macro, e.g. to allow the user to type some variable at a prompt.
The macro can then be resumed. When the macro is played back, it will
pause at the same points, allowing the user some form of manual control
of the operation of the macro.
.P
Keystroke sequences can be stored in files, and CRISP provides
a macro (via the \f(HBkeylib\fR command macro, or the keys described below)
to display the currently loaded macros and save or load new macros to disk.
When the keylib macro is invoked, a popup window is displayed showing the
currently defined macros. If no macros are currently loaded into memory
then the user is prompted to load a macro.
.P
It is advisable when storing personal macros to keep them all together
in a separate directory. This means that you will have less typing
to do when selecting macros. CRISP supports this, and allows the
user to define a directory where all macros are stored. If this directory
path is not defined, then the BBACKUP environment variable will be used,
or failing this, the /tmp directory. (Refer to the configuration
guide for under the section describing the \f(HB.crinit\fR file for
further details).
.P
.TS
allbox;
c c
l lw(4i).
Key	Description
=
<F7>	T{
Starts recording a macro. All characters typed until the next
successive <F7> key are recorded in the macro.
T}
<Shift-F7>	T{
This pauses the recording of keystrokes whilst in learn mode. Press
again to resume learning keystrokes.
T}
<Alt-F7>	T{
Displays a window showing the current keyboard macros, or prompts
user for name of macro to load. Hit <Tab> for list of valid macro
files.
T}
<F8>	T{
The characters stored in the last keyboard macro are played back.
Typing <Alt-U> after hitting <F8> will undo all the effects
of the last playback.
T}
.TE
.P
When CRISP records a keyboard macro, it creates a buffer called
\f(HBKBD-MACRO-nn\fR where 'nn' is used to distinguish different keyboard
macros. This facility is provided if the user wants to concert a
complicated keystroke macro into a private macro, i.e. to save it across
sessions.
.H 1 "Scroll Locking"
.P
Scroll-locking is a facility for keeping the cursor in a fixed position
inside a window. 
If there is only one window on display, then the cursor is locked
into position, so that the window onto the current buffer pans
around the cursor. Normally the cursor is moved until it moves off
of an extremity of the window. When this happens the 'window' pans the 
buffer. With scroll locking enabled, this panning happens all the time
even if the cursor is not at a window edge. 
.P
The other way scroll locking works is if there are two windows on
display. In this case, the two buffers in the windows are scrolled
together. For example, moving the cursor down in one window will cause
the buffer in the other window to be scrolled with it.
This feature is specifically designed to allow two files to be
compared with each other, without the user having to keep switching
windows in order to keep the two files in sync with each other.
.P
Scroll-lock is accessed via the <Keypad-ScrollLock> key. This key acts
as a toggle -- alternately enabling and disabling this feature.
.H 1 "Miscellaneous commands"
.P
There are more functions assigned to keys. Many of these don't fit
nicely into the other categories and are summarized in the table below.
.P
.TS H
allbox;
c c
l lw(4i).
Key	Description
=
.TH
<Tab>	T{
If the current buffer has a hilighted region, then pressing <Tab> will
cause the hilighted region to be indent by one tab stop. If there is
no hilighted region, then <Tab> simply inserts itself.
T}
<Shift-Tab>	T{
If the current buffer has a hilighted region, then it will be unindented
by one tab stop. If there is no highlited region, then the cursor will move
backwards to the previous tab stop.
T}
<Alt-F>	T{
This key brings up the features menu. The features menu is like a table
of contents of functions, which the user may not be aware of. Also new
features get into this table so whenever you use a new version of CRISP
you should examine this table.
T}
<Alt-H>	T{
Brings up the popup help menu.
T}
<Alt-V>	T{
This displays the current version of CRISP on the status line.
T}
<Alt-Z>	T{
This key causes CRISP to temporarily stop execution and execute a sub-shell.
When the user exits the sub-shell, CRISP redraws the screen and continues
execution.
T}
<Ctrl-Z>	T{
On systems that support job-control, this key causes CRISP to be stopped
and the user is returned to the shell. Typing \f(HBfg\fR at the shell prompt
will resume execution. <Ctrl-Z> is preferable to <Alt-Z> on most systems
because it is much quicker than having to start up a new shell.
T}
<Alt-Q>	T{
This key is used to \fIquote\fR the next character. The next key typed
will not be treated as a function key, but instead will be inserted into
the buffer. If the key you type generates several characters, then only
the first character will be quoted. This is normally an <Esc>
character. Note that it is not possible to quote the job control STOP 
character (usually \f(HB<Ctrl-Z>\fR).
T}
<F10>	T{
This key prompts the user on the command line for a command. Any command
can be typed. 
T}
.TE
.H 1 "The Command Line"
.P
CRISP provides many editing facilities. Many of these are accessible
via function-key combinations. However there are more functions than there
are keys on the keyboard. Therefore, many commands are not directly accessible
from function keys or popup windows. In this case, the \fH<F10>\fR
key can be pressed, which causes the user to be prompted
for the name of a command to be input. This prompt
occurs at the bottom of the screen, on the status line.
.P
Many other commands which need to prompt for information
also use the
command line to ask for information. For example,
\fH<Alt-E>\fR prompts for the name of a file to edit.
The command line has a number of features available to
the user to simplify typing in of data and correcting
mistakes. 
.P
CRISP allows the user to edit the input, and allows abbreviations
to be used. The actual abbreviations used is dependent
on the command being executed. Accessing an abbreviation
is accomplished by hitting the \fH<Tab>\fR key. For
example, when requested to type in a filename, hitting
\fH<Tab>\fR causes a popup window to be displayed
listing valid filenames.
.P
The command line also supports a command history, i.e.
previous lines typed in can be recalled by using the
\fH<Up-arrow>\fR and \fH<Down-arrow>\fR keys.
When the user accesses a function which prompts the
user, the last response typed to that prompt is
presented in reverse video, enabling the user to edit
and use the last response (e.g. if it was in error). To
accept the previously offered input, just hit
\fH<Enter>\fR. If the user wants to edit the
information, use the keys described below. If the user
starts typing in a new sequence of characters, then the
highlighted value will be erased.
.P
The table below gives full details on the keys available:
.P
.TS H
center allbox;
cB cB
lfH lw(4i).
Key	Description
=
.TH
<Backspace>	Used to delete previous character.
<End>	Move cursor to end of input text.
<Enter>	Causes CRISP to accept the input.
<Esc>	This is used to cancel the input.
<Home>	Move cursor to start of input text.
<Left>, <Right>	T{
Allows user to move backwards and forwards
along current input.
T}
T{
<Ctrl-Left>,
.br
<Ctrl-Right>
T}	Move left and right one word at a time.
<Up>, <Down>	T{
Allows user to scroll through previous responses to
prompt. This is a command history mechanism.
T}
T{
<Alt-D>
.br
<Ctrl-U>
T}	Delete all characters typed in so far.
<Alt-I>	Toggle between insert and overtype mode.
<Alt-K>	Deletes all characters to the right of the cursor.
<Alt-L>	T{
Recalls the last prompt that was typed by the user. This
is useful if user types in a response to the wrong
question.
T}
<Alt-Q>	T{
Quote next input character. This allows user to type
things like <Tab> and <Esc> as part of the input text.
T}
.TE
.H 1 "Popup Windows"
.P
CRISP provides various popup windows where the user may select options.
Various keys may be used to select and action entries in these menus.
The current entry is always hilighted, moving the cursor will hilight the
selected line. Some menu entries have an arrow at the right of
the window (\f(HB=>\fR). This indicates that a sub-menu is available.
These keystrokes are described below:
.P
.ne 1i
.TS H
allbox;
c c
l lw(4i).
Key	Function
=
.TH
<Up-Arrow>	T{
Moves cursor up one line.
T}
<Down-Arrow>	T{
Move cursor down one line.
T}
<Home>	T{
Moves to the first entry in the list.
T}
<End>	T{
Moves to the last entry in the list.
T}
<Enter>	T{
This selects the current entry and causes the specified
action to be taken.
T}
<Alt-S>	T{
Allows user to search for an entry in the current popup.
Useful when the menu is long and its difficult to find the entry you
are looking for.
T}
<Esc>	T{
Dismisses the popup window. (Should dismiss all popups and take user
back to editing window, but doesn't).
T}
<Keypad-minus>	T{
Dismisses the popup.
T}
<Alt-H>	T{
Used to get context-sensitive help, i.e. dependent on the menu
and current entry.
T}
.TE
.H 1 "Features accessible from popup menus"
.P
CRISP contains many features which are not directly accessible from
the keyboard, but can be accessed via popup menus. These features
tend to be things which are not needed as frequently as the functions
assigned to keystrokes, e.g. case translation, setting margins, etc.
The user can always set up private keyboard assignments to access
these features if they are used frequently. The following
table summarises the main popup displays
which are available. The functionality of these popups is
described in subsequent sections.
.P
.ne 1i
.TS H
allbox;
c c c
l l lw(3i).
Menu	Accessed from	Description
=
.TH
Buffer list	<Alt-B>	T{
This popup menu shows you the names and status of the buffers
which have been created inside CRISP, together with the names of
the files which have been loaded into them.
T}
Features	<Alt-F>	T{
This menu is a kind of table of contents of features available in
CRISP, and is used to access features not available in other menus.
The features are presented in an alphabetic order. The user should
look at the features menu with all new versions of CRISP to see
what new features have been added. If a feature is sufficiently
useful or used frequently, then a keystroke sequence may be assigned to it.
T}
Help	<Alt-H>	T{
On-line help is accessible here. On-line help includes all the
information available in the printed documentation, organised
to make it easy for users to find information of interest. The user
will also find a keyboard summary item which tells the user
what functions are bound to which keys.
T}
Extras menu	<Ctrl-A>	T{
This menu contains features which are needed more frequently than the
functions in the main features menu. This menu is only displayed
if the user pauses after typing <Ctrl-A>. 
T}
Function list	<Ctrl-G>	T{
This is used to get a summary of the functions, structures, or sections
in a file. The list is generated automatically and is dependent
on the file type (i.e. its extension).
T}
Options menu	<Ctrl-O>	T{
This menu is used to configure certain options, e.g. document
options or display options.
T}
.TE

.bp
.H 1 "Customization and the .crinit File"
.P
When CRISP runs, it reads a file in the users home directory, called \fI.crinit\fR. 
This file is a set of lines which define attributes
and properties.
A typical .crinit file looks like this:
.DS
	autoindent: yes
	autosave: 60 120
	colors: black green light-cyan light-yellow light-red red light-green
	hard_tabs: yes
	syntax: crisp
	tabs: .m=4 .cb=4 default=9 
.DE
.P
This file is designed to make it easy for users to personalize certain
attributes about the way CRISP works, without needing to modify the
macros. The .crinit file is a sequence of lines. When CRISP
starts up, it reads each line and looks for a macro called "set_ATTRIBUTE".
If this macro is defined, then it is called with everything after the ":"
character passed as an argument. If the "set_ATTRIBUTE" function does not
exist, it then calls the macro by the name to the left of the colon.
Thus it is quite easy to call any arbitrary macro as long as it takes
either a single argument or no arguments.
.P
This file will be created similarly to the above if no .crinit
file is present the first time CRISP runs.
.P
The following table describes the attributes currently supported and known
to work.
.P
.ne 1i
.TS H
center allbox;
cB cB
lw(1.5i) lw(4i).
Attribute	Description
=
.TH
autoindent	T{
This entry controls whether you wish autoindent turned on or off by
default. To enable autoindenting simply specify the argument 'yes'.
To turn off autoindenting either delete this attribute or set the
argument to 'no'.
T}
autosave	T{
This attribute allows you to enable or disable the autosave feature.
There are two parameters. The first parameter indicates how frequently
all currently modified buffers should be saved to disk (with an alternate
filename rather than overwriting the original file). This timeout is measured
in seconds and defaults to 60. If this is set to zero, then the
autosave feature will be disabled (and also the rebackup facility as well).

The second parameter is used to control the rebackup timeout. The rebackup
timeout is a timeout which is used to control how frequently the backup
flag should be reset for currently edited buffers. Normally when a file
is edited and written away, a backup copy of the file is made only the first
time the buffer is saved. On each subsequent editing session a new backup
will be made. However for users who spend all day inside CRISP and rarely
exit, it may be inadequate to do this form of backing up. The rebackup
flag causes new backups to be made after the designated time period. This
value is measured in minutes and defaults to 120 (two hours).
T}
colors	T{
This attribute maintains your personal color preferences. The
arguments are strings which are passed to the color() macro. It is
best to use the \f(HBsetcolor()\fR command if you wish to change these
colors, as editing the color names will only work if you get the
exact spelling correct.
T}
hard_tabs	T{
This attributes allows you to specify whether you want to use
hard physical tabs inside buffers, or whether you want inserted tabs
to be translated to the appropriate number of spaces.
T}
km_path	T{
This defines a directory where the user can keep personal keyboard
macros. These macros can be loaded, stored and re-executed using the
keylib macro. If you put this entry into your .crinit file then
when you access the keylib macros to load or save keystroke macros, this
path will be placed in the prompt as a default.
T}
load	T{
The load entry allows the user to load and execute a personal
macro file on startup. The argument to load should be the name of
a macro file (with or without the extension). It is better to not
provide a filename extension. For example, if you create a set of
macros in your home directory, e.g. called fox.cr, then your load entry would
be:

	load: fox

The load macro will automatically find the fox.cr file in your home directory
(or in your BPATH), and check to see if it needs compiling. If it does,
it will automatically compile and load the resulting .cm file.
You can put any private key assignments or macro definitions in this file.

Multiple load entries may be specified on multiple lines.
T}
load_abbrev_file	T{
This entry allows you to load up a file of abbreviations. Please read
section on abbreviations in the User Guide for more details about how
to use abbreviations.
T}
print	T{
This option is used to set the name of the command to be used for
printing files (via the <PrtSc> key or 'print' macro). It should be the name
of a command together with any switches that may be needed. If it
is not specified, then the user will be prompted every time a file is printed.
T}
save_state	T{
If this entry is defined, then CRISP will save the window layout
and buffers being edited in every directory that you visit.
If this entry is not present, then you can customise the directories
to which this will be applied.
T}
scrblank	T{
This option is a screen blanker. This is implemented only for
character based terminals. (On a bitmapped screen it has the effect
of blanking the current window only, so it isn't that useful). After
about 10 minutes of inactivity, the screen blank macro is called
which temporarily sets the screen colors to black on black and displays
a logo which moves around the screen after a period of time. Hit any key
to resume your editing session.
T}
syntax	T{
This option specifies whether the forward and backward search macros
should use the CRISP or Unix standard for regular expressions.
The argument should be set to one of 'crisp' or 'unix'.
T}
tabs	T{
This entry allows the user to specify the tab stops for files. The
argument list is a sequence of file extensions followed by an '='
followed by the size of the tab stops. The entry 'default' is used for
all files which are not explicitly mentioned.
T}
.TE
.H 1 Abbreviations
.P
CRISP supports abbreviations when typing in text. An abbreviation is
a short-hand sequence of characters which when typed are mapped
to the full version of the text. For example, you can set
up an abbreviation such as '\f(HBIBM\fR' which when typed gets
mapped to '\f(HBInternational Business Machines\fR'.
.P
Abbreviations work by watching for the <space> character to be hit
and then checking the word to the left of the space against a list
of abbreviations. If a match is found then the word is replaced by
the full text. Note that this works whenever the <space> bar is pressed, even
if the cursor is moved and then the <space> is hit. (In \fIvi(1)\fR,
abbreviations only work if the space character is hit immediately after
typing in the word).
.P
There are two ways to use abbreviations -- as a default when starting up,
and on a per buffer basis for one off abbreviations.
If the attribute "\f(HBload_abbrev_file\fR" is specified in the \f(HB.crinit\fR
initialisation file, then a file of abbreviations can be loaded
automatically on startup. When this is done, the abbreviations will
be available in all buffers and files edited.
.P
The other way is to execute the "\f(HBabbrev\fR" macro from the
command prompt. This macro prompts the user for the abbreviation
and the expansion. (They can be typed on the command line as well).
When an abbreviation is defined this way, it will only be available
in the current buffer (unless the load_abbrev_file attribute was also
specified in the .crinit file).
.P
Abbreviations loaded at startup have a special syntax.
The file is read with one abbreviation per line. For example:
.DS
.ft CW

	IBM:International Business Machines
	PDF:Paul Fox
.ft
.DE
.P
The abbreviation is specified followed by a colon and the remainder
of the line is treated as the expansion.
.P
CRISP does not save abbreviations created during the editing session.
Instead the user will need to edit the abbreviation file and re-run
CRISP for them to take effect (or use the \f(HBabbrev\fR macro).
.TC
