
/* Controller.h
 * 
 *
 * This subclass of Object handles all the user interface actions.
 * 
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to its
 * fitness for any particular use.
 *
 */

#import <objc/Object.h>
#import <sys/param.h>	// for MAXPATHLEN
#import <appkit/Window.h>
#import <appkit/NXSplitView.h>

@interface Controller:Object
{
	id infoPanel;
        id helpPanel;
	id dateField;
	id timeOfDayField;
	id myScrollView;
	id mySplitView;
	id myWindow;
	id myBrowser;
	NXRect windowFrame;
	char textDirectory[MAXPATHLEN];
}

/* Instance Methods */
- appDidInit:sender;
- appWillTerminate:sender;
- help:sender;
- info:sender;

/* Support for splitview */
- initSplitView;
- splitView:sender getMinY:(NXCoord *)minY maxY:(NXCoord *)maxY
  ofSubviewAt:(int)offset;
- splitView:sender 
    resizeSubviews:(const NXSize *)oldSize;


/*  Support for browser  */
- showTextFile:(const char*)filename:(int)column:(const char*)directoryname;


/* Browser target/action method */
- browserHit:sender;

/* Browser Delegate Methods */
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;
- browser:sender loadCell:cell atRow:(int)row inColumn:(int)column;
- (BOOL)browser:sender selectCell:(const char *)title inColumn:(int)column;

/* Window Delegate Methods */
- windowWillClose: sender;
- windowWillResize:sender toSize:(NXSize *)frameSize;

@end
