/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.ResourceUtils;
import com.izforge.izpack.util.file.types.Resource;
import com.izforge.izpack.util.file.types.ResourceFactory;
import java.io.File;
import java.util.Vector;

public class SourceFileScanner
implements ResourceFactory {
    private File destDir;

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) throws Exception {
        return this.restrict(files, srcDir, destDir, mapper, FileUtils.getFileTimestampGranularity());
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) throws Exception {
        this.destDir = destDir;
        Vector<Resource> v = new Vector<Resource>();
        for (String file : files) {
            File src = FileUtils.resolveFile(srcDir, file);
            v.addElement(new Resource(file, src.exists(), src.lastModified(), src.isDirectory()));
        }
        Object[] sourceresources = new Resource[v.size()];
        v.copyInto(sourceresources);
        Resource[] outofdate = ResourceUtils.selectOutOfDateSources((Resource[])sourceresources, mapper, this, granularity);
        String[] result = new String[outofdate.length];
        for (int counter = 0; counter < outofdate.length; ++counter) {
            result[counter] = outofdate[counter].getName();
        }
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) throws Exception {
        return this.restrictAsFiles(files, srcDir, destDir, mapper, FileUtils.getFileTimestampGranularity());
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) throws Exception {
        String[] res = this.restrict(files, srcDir, destDir, mapper, granularity);
        File[] result = new File[res.length];
        for (int i = 0; i < res.length; ++i) {
            result[i] = new File(srcDir, res[i]);
        }
        return result;
    }

    @Override
    public Resource getResource(String name) throws Exception {
        File src = FileUtils.resolveFile(this.destDir, name);
        return new Resource(name, src.exists(), src.lastModified(), src.isDirectory());
    }
}

