unit TemplateDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls;

const
  CR = #13;
  NL = #10;

type
  TTemplateDialog = class(TForm)
    TemplatesListBox: TListBox;
    EditButton: TButton;
    NewButton: TButton;
    RemoveButton: TButton;
    BCancel: TButton;
    Button2: TButton;
    BUp: TButton;
    BDown: TButton;
    procedure EditButtonClick(Sender: TObject);
    procedure NewButtonClick(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TemplatesListBoxDblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BCancelClick(Sender: TObject);
    procedure BUpClick(Sender: TObject);
    procedure BDownClick(Sender: TObject);
  private
    { Private declarations }
    namesback,
    parts1back,
    parts2back : TStringList; // to allow Cancel
  public
    { Public declarations }
    names:  TStringList;   //*PN* moved to public for unmodal dialog
    parts1: TStringList;
    parts2: TStringList;
  end;

var
  TemplateDialog: TTemplateDialog;

implementation

uses EditTemplateDlg, Frame;

{$R *.DFM}

procedure TTemplateDialog.EditButtonClick(Sender: TObject);
begin
  if TemplatesListBox.ItemIndex = -1 then exit;
  EditTemplateDialog.NameEdit.Text := '';
  EditTemplateDialog.Part1Memo.Text := '';
  EditTemplateDialog.Part2Memo.Text := '';
  EditTemplateDialog.NameEdit.Text := names[TemplatesListBox.ItemIndex];
  EditTemplateDialog.Part1Memo.Text := parts1[TemplatesListBox.ItemIndex];
  EditTemplateDialog.Part2Memo.Text := parts2[TemplatesListBox.ItemIndex];
  EditTemplateDialog.ShowModal;
  if EditTemplateDialog.ModalResult = mrOk then
  begin
    names[TemplatesListBox.ItemIndex] := EditTemplateDialog.NameEdit.Text;
    TemplatesListBox.Items[TemplatesListBox.ItemIndex] := EditTemplateDialog.NameEdit.Text;
    parts1[TemplatesListBox.ItemIndex] := EditTemplateDialog.Part1Memo.Text;
    parts2[TemplatesListBox.ItemIndex] := EditTemplateDialog.Part2Memo.Text;
  end;
end;

procedure TTemplateDialog.NewButtonClick(Sender: TObject);
begin
  EditTemplateDialog.NameEdit.Text := '';
  EditTemplateDialog.Part1Memo.Text := '';
  EditTemplateDialog.Part2Memo.Text := '';
  EditTemplateDialog.ShowModal;
  if EditTemplateDialog.ModalResult = mrOk then
  begin
    TemplatesListBox.Items.Add (EditTemplateDialog.NameEdit.Text);
    names.Add  (EditTemplateDialog.NameEdit.Text);
    parts1.Add (EditTemplateDialog.Part1Memo.Text);
    parts2.Add (EditTemplateDialog.Part2Memo.Text);
    EditButton.Enabled := true;
    RemoveButton.Enabled := true;
    TemplatesListBox.ItemIndex := TemplatesListBox.Items.Count - 1;
  end;
end;

procedure TTemplateDialog.RemoveButtonClick(Sender: TObject);
var newItemIndex: integer;
begin
  newItemIndex := TemplatesListBox.ItemIndex;
  if TemplatesListBox.ItemIndex = TemplatesListBox.Items.Count - 1 then
    Dec(newItemIndex);
  if TemplatesListBox.Items.Count = 1 then
    newItemIndex := -1;

  names.Delete (TemplatesListBox.ItemIndex);
  parts1.Delete (TemplatesListBox.ItemIndex);
  parts2.Delete (TemplatesListBox.ItemIndex);
  TemplatesListBox.Items.Delete (TemplatesListBox.ItemIndex);

  TemplatesListBox.ItemIndex := newItemIndex;

  if TemplatesListBox.ItemIndex < 0 then
  begin
    EditButton.Enabled := false;
    RemoveButton.Enabled := false;
  end;
end;

procedure TTemplateDialog.FormCreate(Sender: TObject);
var tplBase  : string;  //*DS* base for template file names
    userTplBase: string; //*DS* remove in future versions
    directory: string;  //*DS*
    tplStream : TFileStream; //*PN*

  function ReadString : string;
  var buffer: PChar;
      sz : integer;
  begin
    tplStream.Read(sz, sizeof(integer));
    buffer := StrAlloc(sz+1);
    FillChar(buffer^, sz+1, 0);
    tplStream.Read(buffer^, sz);
    result := buffer;
    StrDispose(buffer);
  end;

begin
  names := TStringList.Create;
  parts1 := TStringList.Create;
  parts2 := TStringList.Create;
  namesback := TStringList.Create;
  parts1back := TStringList.Create;
  parts2back := TStringList.Create;

  tplBase := ChangeFileExt (FrameForm.iniFileName, '');

  //*DS* dirty patch for network configuration
  // because there may be valid user templates file before a valid ini file
  // remove this in future versions
  userTplBase := ChangeFileExt (FrameForm.userIniFileName, '');
  if FileExists(userTplBase + '.tpl')
  then tplBase := userTplBase;
  // end dirty patch

  //*PN* why not using a complete new file format with only one file?
  if FileExists(tplBase + '.tpl') then
  begin
    tplStream := TFileStream.Create(tplBase + '.tpl', fmOpenRead);
    while tplStream.Position < tplStream.Size - 16 do //4 LWord stringsize min. for 1 templ.
    begin
      names.Add(ReadString);
      parts1.Add(ReadString);
      parts2.Add(ReadString);
      ReadString;           //*PN* placeholder for Shortcuts
    end;
    tplStream.Free;
  end;

  if TemplatesListBox.ItemIndex < 0 then
  begin
    EditButton.Enabled := false;
    RemoveButton.Enabled := false;
  end;
end;


procedure TTemplateDialog.FormDestroy(Sender: TObject);
var tplBase: string; //*DS*
    tplStream : TFileStream; //*PN*
//    anzahl,
    i: integer;

  procedure WriteString(theString: string);
  var buffer: PChar;
      sz: integer;
  begin
    sz := length(theString);
    buffer := PChar(theString);
    tplStream.Write(sz, sizeof(integer));
    tplStream.Write(buffer^, sz);
  end;

begin
  //*DS* Write templates if allowed
  if FrameForm.lockIniFile = false then
  begin
    tplBase := ChangeFileExt (FrameForm.userIniFileName, ''); //*DS*
    //*PN* why not using a complete new file format with only one file?
    tplStream := TFileStream.Create(tplBase + '.tpl', fmCreate);
    for i := 0 to names.Count - 1 do //anzahl - 1 do
    begin
      WriteString(names[i]);
      WriteString(parts1[i]);
      WriteString(parts2[i]);
      WriteString('');           //*PN* placeholder for Shortcuts
    end;
    tplStream.Free;
  end;

  names.Free;
  parts1.Free;
  parts2.Free;
  namesback.Free;
  parts1back.Free;
  parts2back.Free;
end;


procedure TTemplateDialog.TemplatesListBoxDblClick(Sender: TObject);
begin
  EditButtonClick(Sender);
end;


procedure TTemplateDialog.FormShow(Sender: TObject);
begin
  namesback.Assign(names);
  parts1back.Assign(parts1);
  parts2back.Assign(parts2);
  TemplatesListBox.Items := names;
  if TemplatesListBox.Items.Count > 0 then
    TemplatesListBox.ItemIndex := 0;
  EditButton.Enabled := TemplatesListBox.Items.Count > 0;
  RemoveButton.Enabled := TemplatesListBox.Items.Count > 0;
end;

procedure TTemplateDialog.BCancelClick(Sender: TObject);
begin
  names.Assign(namesback);
  parts1.Assign(parts1back);
  parts2.Assign(parts2back);
  ModalResult := mrCancel;
end;

procedure TTemplateDialog.BUpClick(Sender: TObject);
begin
  if TemplatesListBox.ItemIndex > 0 then
  begin
    names.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex - 1);
    parts1.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex - 1);
    parts2.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex - 1);
    TemplatesListBox.Items.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex - 1);
  end;
end;

procedure TTemplateDialog.BDownClick(Sender: TObject);
begin
  if TemplatesListBox.ItemIndex < TemplatesListBox.Items.Count - 1 then
  begin
    names.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex + 1);
    parts1.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex + 1);
    parts2.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex + 1);
    TemplatesListBox.Items.Exchange(TemplatesListBox.ItemIndex, TemplatesListBox.ItemIndex + 1);
  end;
end;

end.
