/*
 *	NET/ROM release 006
 *
 *	This code REQUIRES 1.2.1 or higher/ NET3.029
 *
 *	This module:
 *		This module is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 *	History
 *	NET/ROM 006	Tomi(OH2BNS)	Created this file.
 *
 */

#include <linux/config.h>
#if defined(CONFIG_NETROM) || defined(CONFIG_NETROM_MODULE)
#include <linux/types.h>
#include <linux/timer.h>
#include <net/ax25.h>
#include <linux/skbuff.h>
#include <net/netrom.h>

static struct sk_buff_head loopback_queue;
static struct timer_list loopback_timer;

static void nr_set_loopback_timer(void);

void nr_loopback_init(void)
{
	skb_queue_head_init(&loopback_queue);

	init_timer(&loopback_timer);
}

void nr_loopback_clear(void)
{
	struct sk_buff *skb;

	del_timer(&loopback_timer);

	while ((skb = skb_dequeue(&loopback_queue)) != NULL)
		kfree_skb(skb, FREE_READ);
}

static int nr_loopback_running(void)
{
	return (loopback_timer.prev != NULL || loopback_timer.next != NULL);
}

int nr_loopback_queue(struct sk_buff *skb)
{
	struct sk_buff *skbn;

	skbn = skb_copy(skb, GFP_ATOMIC);

	kfree_skb(skb, FREE_WRITE);

	if (skbn != NULL)
		skb_queue_tail(&loopback_queue, skbn);

	if (!nr_loopback_running())
		nr_set_loopback_timer();

	return 1;
}

static void nr_loopback_timer(unsigned long);

static void nr_set_loopback_timer(void)
{
	del_timer(&loopback_timer);

	loopback_timer.data     = 0;
	loopback_timer.function = &nr_loopback_timer;
	loopback_timer.expires  = jiffies + 10;

	add_timer(&loopback_timer);
}

static void nr_loopback_timer(unsigned long param)
{
	struct sk_buff *skb;
	ax25_address *nr_dest;
	struct device *dev;

	while ((skb = skb_dequeue(&loopback_queue)) != NULL) {
		nr_dest = (ax25_address *)(skb->data + 7);

		if ((dev = nr_dev_get(nr_dest)) == NULL) {
			kfree_skb(skb, FREE_READ);
			continue;
		}

		if (nr_rx_frame(skb, dev) == 0)
			kfree_skb(skb, FREE_READ);
	}
}

#endif
