/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	box.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface OI_box class header
 *
 *	RCSid = "$Id: box.H,v 4.24.1.1 1993/06/01 22:52:59 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_box_H
#define OI_box_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

	// class forward reference declarations
	class OI_mdl_box;

#define	OI_BOX_BORDER_WIDTH	1	/* default border width */

 /* private ctl_bits */
#define			OI_BOX_PAINT_BEVEL	0x1L		/* bevel requires painting */
#define			OI_BOX_INTERIOR		0x2L		/* bevel width => redirected interior box object */
#define			OI_BOX_IN_CONSTRUCTOR	0x4L		/* 1 => in constructor for this object */
#define			OI_BOX_CLICK_EVENTS	0x8L		/* 1 => click events are currently on the object */
#define			OI_BOX_ALIGN_RIGHT	0x10L		/* 1 => alignment loc is right edge */
#define			OI_BOX_NOM_SET		0x20L		/* 1 => nominal size has been specifically set */
#define			OI_BOX_EXPOSE_EVENTS	0x40L		/* 1 => expose events are currently on the object */

	class OI_box : public OI_w_d_tech {
			OI_mdl_box	*mdl_dep ;		/* ptr to model dependent aspects of OI_box object */
			unsigned long	ctl_bits ;		/* object specific control bits */
			OI_d_tech	*frst_fcs;		/* object to get the focus if the focus comes on the box. */
			OI_xy		nom_siz ;		/* nominal size */
			OI_xy		min_siz ;		/* minimum size */
			OI_number	in_my_ctor ;		/* counter for in_my_constructor */
	 protected:
		static	XrmQuark	q_cbExpose ;		/* quark for expose callback */
		static	XrmQuark	q_cbClick ;		/* quark for click callback */
			OI_xy		avail_origin ;		/* origin of available space (pixels), relative to actual origin (0,0) */
			OI_number	btn ;			/* btn # for clicks */
			OI_number	n_click ;		/* # clicks which have occurred */
			Time		tim ;			/* time of last button press/release event */
	 public:
		static	OI_class		*clsp ;		/* ptr to class record */

	 private:
			void		construct(OI_number,OI_number) ;
			void		allow_align_right()		{ ctl_bits |= OI_BOX_ALIGN_RIGHT; }
			void		allow_click_events()		{ ctl_bits |= OI_BOX_CLICK_EVENTS; }
			void		allow_expose_events()		{ ctl_bits |= OI_BOX_EXPOSE_EVENTS; }
			void		allow_interior_box()		{ ctl_bits |= OI_BOX_INTERIOR; }
			void		allow_size_set()		{ ctl_bits |= OI_BOX_NOM_SET; }
			void		clear_in_my_constructor() ;
			void		disallow_align_right()		{ ctl_bits &= ~OI_BOX_ALIGN_RIGHT; }
			void		disallow_click_events()		{ ctl_bits &= ~OI_BOX_CLICK_EVENTS; }
			void		disallow_expose_events()	{ ctl_bits &= ~OI_BOX_EXPOSE_EVENTS; }
			void		disallow_interior_box()		{ ctl_bits &= ~OI_BOX_INTERIOR; }
			OI_bool		in_my_constructor() ;
			OI_bool		is_click_events()		{ return((ctl_bits&OI_BOX_CLICK_EVENTS) ? OI_yes : OI_no); }
			OI_bool		is_expose_events()		{ return((ctl_bits&OI_BOX_EXPOSE_EVENTS) ? OI_yes : OI_no); }
			void		refresh_my_callback(OI_cb_inf*) ;
			void		res_alignment(void *);
			void		res_height(void *);
			void		res_width(void *);
			void		set_in_my_constructor() ;
	 protected:
					OI_box(OI_class *clsp, const char *usr_namp, OI_number w, OI_number h) ;
		/* OI_d_tech overrides */
		virtual	void		configure(const XEvent*,void* =NULL) ;
		virtual	OI_stat		create() ;
		virtual	void		new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_box(const char*,OI_number,OI_number) ;	/* constructor */
					~OI_box() ;
		virtual	OI_number	alignment_loc_x(OI_alignment=OI_alignment_default);
		virtual	OI_d_tech	*associate_parent(OI_d_tech* =NULL) ;
		virtual	void		clone_adjust(OI_d_tech*) ;
//		virtual	void		configure(const XEvent*,void* =NULL) ;
		virtual	void		disable() ;
		virtual	OI_number	default_horz_space();
		virtual	OI_number	default_vert_space();
		friend	void		dmpOI_box(OI_box*) ;	/* diagnostic dump procedure */
			void		disallow_size_set()		{ ctl_bits &= ~OI_BOX_NOM_SET; }
		virtual	void		enable() ;
		static	OI_bool		init(OI_connection*) ;
			OI_box		*interior() ;
		virtual	OI_bool		is_container() ;				/* OI_yes this object can be a container for other objects.*/
			OI_bool		is_interior_box()		{ return(OI_bool)((ctl_bits&OI_BOX_INTERIOR)!=0); }
			OI_bool		is_size_set()			{ return((ctl_bits&OI_BOX_NOM_SET) ? OI_yes : OI_no); }
		virtual	OI_layout_method	*layout_method() ;
		static	OI_box		*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			void		new_alignment(OI_alignment) ;
		virtual	void		new_bkg_pixmap(OI_pixmap *);
			void		new_bvl_width(OI_number) ;
		virtual	void		new_bvl_style(OI_bevel_style);
			void		new_colormap(Colormap c);
			void		new_cursor(Cursor c);
		virtual	void		new_def_horz_space(OI_number);
		virtual	void		new_def_vert_space(OI_number);
//			void		new_font();
		virtual	void		new_geometry(OI_geometry *);
		virtual	void		new_layout(OI_layout, OI_number= -1, OI_number= -1) ;
		virtual	OI_stat		new_outside_size(OI_number, OI_number) ;
		virtual	OI_stat		new_size(OI_number,OI_number);
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
			void		nominal_size_set(OI_number*,OI_number*);
		virtual	void		paint(const XEvent*, void* =NULL) ;
		virtual	void		parent_post_associate(OI_d_tech *);
			void		select(const XEvent*) ;			/* process clicks */
			void		set_nominal_size(OI_number,OI_number) ;
		virtual	OI_stat		set_outside_size(OI_number w, OI_number h);
		virtual	OI_size_constraints	*size_constraints() ;
		virtual	OI_size_constraints	*size_constraints_object() ;
		virtual	OI_d_tech	*val_assoc(OI_d_tech*) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_horz_resize() ;
		virtual	void		allow_vert_resize() ;
		virtual	OI_pixmap	*bkg_pixmap();
		virtual	OI_d_tech	*descendant(const char *strp) ;
		virtual	void		disallow_horz_resize() ;
		virtual	void		disallow_vert_resize() ;
		virtual	OI_d_tech	*first_focus();
		virtual	OI_layout	layout() ;
		virtual	OI_d_tech	*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number	num_props() ;
		virtual	OI_d_tech	*numbered_child(OI_number n) ;
		virtual	void		resume_layout(OI_bool=OI_YES);
		virtual	void		set_click(OI_click_fnp fp, void *argp=NULL) ;
		virtual	void		set_click(OI_callback *objp, OI_click_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_first_focus(OI_d_tech *);
		virtual	OI_stat		set_size(OI_number,OI_number) ;			/* change size of object */
		virtual	OI_number	size_x();
		virtual	OI_number	size_y();
		virtual	void		suspend_layout();
		virtual	OI_d_tech	*subobject(const char *strp) ;
		virtual	OI_d_tech	*subobject(XrmQuark) ;
		virtual	OI_bool		user_layout_ok() ;
		virtual	Window		X_window() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		// For row/column related member functions, refer to documentation for layout methods derived from OI_lm_row_col
		virtual	OI_number	first_column(OI_number r= OI_undefined) ;
		virtual	OI_number	first_row(OI_number c= OI_undefined) ;
		virtual	OI_number	in_column(OI_number c, long x, OI_number r= OI_undefined, OI_number pct=100) ;
		virtual	OI_number	in_row(OI_number r, long y, OI_number c= OI_undefined, OI_number pct=100) ;
		virtual	OI_number	last_column(OI_number r= OI_undefined) ;
		virtual	OI_number	last_row(OI_number c= OI_undefined) ;
		virtual	void		new_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	void		new_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number	next_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number	next_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number	prev_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number	prev_row(OI_number r, OI_number c= OI_undefined) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		OI_alignment		alignment() ;
		virtual	void		avail_loc(OI_number *lxp, OI_number *lyp) ;	/* get upper left corner of available space */
		virtual	OI_number	avail_loc_x() ;					/* ULC of available space in x direction */
		virtual	OI_number	avail_loc_y() ;					/* ULC of available space in y direction */
			void		set_alignment(OI_alignment) ;
		virtual	void		set_avail_loc(OI_number x, OI_number y) ;
		virtual	void		set_avail_loc_x(OI_number x) ;
		virtual	void		set_avail_loc_y(OI_number y) ;
		virtual	void		set_expose(OI_obj_event_fnp fp, void *argp=NULL) ;
		virtual	void		set_expose(OI_callback *objp, OI_obj_event_memfnp mfp, void *argp=NULL) ;
			void		set_minimum_size(OI_number,OI_number) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_box  *oi_create_box(const char*,OI_number,OI_number) ;	/* create simple box object */

#endif /* OI_box_H */
