/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lngsrv.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_lang_server class header
 *
 *	RCSid = "$Id: lngsrv.H,v 4.1.1.1 1993/06/01 22:55:24 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lngsrv_H
#define OI_lngsrv_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

	class OI_lang_server {							/* language server */
			OI_lang_server		*nxtp ;				/* ptr to next language server in list */
			XrmQuark		langq ;				/* quark for language name */
			OI_connection		*conp ;				/* connection server is using */
		 protected:
		virtual	OI_bool			connected() ;
		 public:
						OI_lang_server(XrmQuark lq, OI_connection *cp)	{ nxtp=NULL; langq=lq; conp=cp; }
						OI_lang_server(char *l, OI_connection *cp)
										{ nxtp=NULL; langq=XrmStringToQuark(l); conp=cp;}
			void			set_next(OI_lang_server *sp)	{ nxtp=sp; }
			OI_lang_server		*next()				{ return(nxtp); }
			XrmQuark		language_quark()		{ return(langq); }
			char			*language()			{ return(XrmQuarkToString(langq)); }
		virtual	OI_lang_server		*clone(OI_connection*) ;
		virtual	OI_bool			toggle_state(OI_d_tech*) ;
		virtual	OI_bool			query_state(OI_d_tech*, OI_bool*) ;
		virtual	char			*communicate_to_server(const XEvent*, OI_number*) ;
	} ;

	enum OI_lang_focus {
		OI_lang_focus_none = 0,						/* no language server should be used with object */
		OI_lang_focus_force_conversion = 1,				/* force into conversion mode on focus in */
		OI_lang_focus_force_noconversion = 2,				/* force into noconversion mode on focus in */
		OI_lang_focus_assume_conversion = 3				/* assume conversion mode of language server on focus in */
	} ;

#endif /* OI_lngsrv_H */
