/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	tm.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Translation Manager definitions
 *
 *	RCSid = "$Id: tm.H,v 4.4.1.1 1993/06/01 22:57:05 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_tm_H
#define OI_tm_H

//#include <X11/Xresource.h>
//#include <stdlib.h>

extern void OI_tm_init();
	
	// class forward reference declarations
	class OI_connection;
	class OI_tm_event_seq;
	class OI_tm_event_obj;
	class OI_tm_event;
	class OI_tm_tmevent;
	class OI_tm_action;
	class OI_tm_state;
	class OI_d_tech;

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

	class	OI_tm_event_obj;

	enum	OI_translation_op	{ OI_replace, OI_override, OI_augment, OI_substitute } ;

#define OI_TM_KEEP		0x01		/* don't delete this table */
#define OI_TM_ACCEL		0x02
#define OI_TM_ZERO_EVENTS	0x04		/* this table has events that have a zero event mask */

	class OI_translation_table {
		short unsigned		ref_cnt;		// reference count
		OI_translation_op	op;		
		unsigned short		numEvents;
		unsigned short		eventTableSize;
		OI_tm_event_obj		*eventTable;
		unsigned long		lastEventTime;
		unsigned short		numQuarks;	/* # of entries in quarkTable */
		unsigned short		quarkTableSize;	/*total size of quarkTable */
		XrmQuark*		quarkTable;	/* table of quarkified rhs*/
		unsigned short		numStates;	// number of states in state table
		unsigned short		stateTableSize;	// size of the state table
		OI_tm_state		*stateTable;	// state table
		unsigned long		eventMask;
		short unsigned		flags;
	public:

					OI_translation_table();
					~OI_translation_table();
		void			ref()					{ ref_cnt++; }
		void			deref()					{ if (--ref_cnt <= 0 && !keep()) delete this; }
		char			*accelerator_label();
		char			*mnemonic_label();
		char			*unconvert();
		char			*unconvert_marked();
		char			*dump();
		OI_tm_state		*new_state(unsigned short);
		OI_translation_table	*clone_common();
		OI_translation_table	*clone();
		OI_translation_table	*clone_with_object(OI_d_tech *);
		void			set_operation(OI_translation_op newop)	{ op = newop; }
		OI_translation_op	operation()				{ return (op); }
		void			add_event_seq(OI_tm_event_seq *);
		int			get_event_index(OI_tm_event_seq *);
		short unsigned		num_quarks()				{ return (numQuarks); }
		XrmQuark		quark_table(short unsigned i)		{ return (quarkTable[i]); }
		short unsigned		save_quark(XrmQuark);
		short unsigned		num_events()				{ return (numEvents); }
		OI_tm_event_obj		*event_table(short unsigned i) ;
		short unsigned		num_states()				{ return (numStates); }
		OI_tm_state		*state_table(short unsigned i) ;
		void			set_event_mask(unsigned long m)		{ eventMask = m; }
		unsigned long		event_mask()				{ return (eventMask); }
		int			match_event(OI_connection *, OI_tm_tmevent *);
		void			merge(OI_translation_table *, OI_bool, OI_d_tech * = NULL);
		void			substitute(OI_translation_table *, OI_d_tech *);
		void			substitute_states(OI_translation_table *, OI_tm_state *, OI_tm_state *, OI_d_tech *);
		void			set_keep()				{ flags |= OI_TM_KEEP; }
		void			unset_keep()				{ flags &= ~OI_TM_KEEP; }
		OI_bool			keep()					{ return ((flags&OI_TM_KEEP)?OI_yes:OI_no); }
		void			set_accelerator()			{ flags |= OI_TM_ACCEL; }
		OI_bool			accelerator()				{ return ((flags&OI_TM_ACCEL)?OI_yes:OI_no); }
		void			allow_zero_events()			{ flags |= OI_TM_ZERO_EVENTS; }
		OI_bool			is_zero_events()			{ return ((flags&OI_TM_ZERO_EVENTS)?OI_yes:OI_no); }
	};

	extern	OI_translation_table	*OI_parse_translation_table(const char*, OI_bool=OI_NO);
	extern	OI_translation_table	*OI_merge_translations(OI_translation_op, OI_translation_table*, OI_translation_table*,
								OI_d_tech* =NULL, OI_d_tech* =NULL);

#endif /* OI_tm_H */
