/*
 * sa_bitstream.h
 * 
 * This file was automatically generated by flavorc
 * from the source file:
 *     'sa_bitstream.fl'
 *
 * For information on flavorc, visit the Flavor Web site at:
 *     http://www.ee.columbia.edu/flavor
 *
 * -- Do not edit by hand --
 *
 */

/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#ifndef _sa_bitstream_h_
#define _sa_bitstream_h_

// Maximum size of parsable arrays
static const int _F_SIZE = 64;

// Temporary variable for parse sizes
// (to preserve order or parse and init evaluations)
static int _F_parse;

// Temporary variables for ID parsing
static int         _F_i_id;
static float       _F_f_id;
static double      _F_d_id;
static long double _F_ld_id;
// Bitstream error reporting function
void flerror(char *s);


class sa_symbol {
public:
    unsigned int sym;

    sa_symbol(int i) {
      sym = i;
    }

    sa_symbol() { sym  = 0; }
    

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        sym = _F_bs.getbits(16);
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(sym, 16);
        return _F_ret;
    }
};

class sym_name {
public:
    unsigned int length;
    char name[_F_SIZE];

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        length = _F_bs.getbits(4);
        int _F_name_dim0, _F_name_dim0_end;
        _F_name_dim0_end = length;
        for (_F_name_dim0 = 0; _F_name_dim0 < _F_name_dim0_end; _F_name_dim0++) {
            name[_F_name_dim0] = _F_bs.getbits(8);
        }
 name[length] = 0; 
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(length, 4);
        int _F_name_dim0, _F_name_dim0_end;
        _F_name_dim0_end = length;
        for (_F_name_dim0 = 0; _F_name_dim0 < _F_name_dim0_end; _F_name_dim0++) {
            _F_bs.putbits(name[_F_name_dim0], 8);
        }
        return _F_ret;
    }
};

#define _F_SIZE 8192


class sa_symtable {
public:
    unsigned int length;
    sym_name name[_F_SIZE];


  public: sa_symtable() {
  length = 0;
  }
  
  public: sa_symbol add(char *text) {
    int i= 0;
    while (i < length && strcmp((const char *)name[i].name,text)) i++;
    if (i == length) {
      strcpy((char *)name[length].name,text);
      name[length].length = strlen(text);
      length++;
    }
    sa_symbol sym(i);
    return sym;
  }

  public: char *ref(sa_symbol s) {
    int i;
    char *st;
    
    if (this)
      for (i=0;i!=length;i++)
	if (i == s.sym)
	  return name[i].name;
    
    st = new char[40];
    sprintf(st,"s%d",s.sym);
    
    return st;
  }
  
  

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        length = _F_bs.getbits(16);
        int _F_name_dim0, _F_name_dim0_end;
        _F_name_dim0_end = length;
        for (_F_name_dim0 = 0; _F_name_dim0 < _F_name_dim0_end; _F_name_dim0++) {
            _F_ret += name[_F_name_dim0].get(_F_bs);
        }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(length, 16);
        int _F_name_dim0, _F_name_dim0_end;
        _F_name_dim0_end = length;
        for (_F_name_dim0 = 0; _F_name_dim0 < _F_name_dim0_end; _F_name_dim0++) {
            _F_ret += name[_F_name_dim0].put(_F_bs);
        }
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 64


class orch_token {
public:
    int done;
    unsigned int token;
    sa_symbol sym;
    float val;
    unsigned int ival;
    int length;
    char str[_F_SIZE];

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        token = _F_bs.getbits(8);
        switch (token)
            {
            case 240:
                _F_ret += sym.get(_F_bs);
                break;
            case 242:
                val = _F_bs.getfloat();
                break;
            case 241:
                ival = _F_bs.getbits(32);
                break;
            case 243:
                length = _F_bs.getbits(8);
                int _F_str_dim0, _F_str_dim0_end;
                _F_str_dim0_end = length;
                for (_F_str_dim0 = 0; _F_str_dim0 < _F_str_dim0_end; _F_str_dim0++) {
                    str[_F_str_dim0] = _F_bs.getbits(8);
                }
                break;
            case 255:
                done=1;
                break;
            }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(token, 8);
        switch (token)
            {
            case 240:
                _F_ret += sym.put(_F_bs);
                break;
            case 242:
                _F_bs.putfloat(val);
                break;
            case 241:
                _F_bs.putbits(ival, 32);
                break;
            case 243:
                _F_bs.putbits(length, 8);
                int _F_str_dim0, _F_str_dim0_end;
                _F_str_dim0_end = length;
                for (_F_str_dim0 = 0; _F_str_dim0 < _F_str_dim0_end; _F_str_dim0++) {
                    _F_bs.putbits(str[_F_str_dim0], 8);
                }
                break;
            case 255:
                done=1;
                break;
            }
        return _F_ret;
    }
};

#define _F_SIZE 8192


class orc_file {
public:
    unsigned int length;
    orch_token data[_F_SIZE];

  orc_file() { length = 0; }
  void add(orch_token ot) { data[length++] = ot; }
  

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        length = _F_bs.getbits(16);
        int _F_data_dim0, _F_data_dim0_end;
        _F_data_dim0_end = length;
        for (_F_data_dim0 = 0; _F_data_dim0 < _F_data_dim0_end; _F_data_dim0++) {
            _F_ret += data[_F_data_dim0].get(_F_bs);
        }
 printf("got orc file.\n"); 
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(length, 16);
        int _F_data_dim0, _F_data_dim0_end;
        _F_data_dim0_end = length;
        for (_F_data_dim0 = 0; _F_data_dim0 < _F_data_dim0_end; _F_data_dim0++) {
            _F_ret += data[_F_data_dim0].put(_F_bs);
        }
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 64


class instr_event {
public:
    unsigned int has_label;
    sa_symbol label;
    sa_symbol iname_sym;
    float dur;
    unsigned int num_pf;
    float pf[_F_SIZE];

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        has_label = _F_bs.getbits(1);
        if (has_label)
            _F_ret += label.get(_F_bs);
        _F_ret += iname_sym.get(_F_bs);
        dur = _F_bs.getfloat();
        num_pf = _F_bs.getbits(8);
        int _F_pf_dim0, _F_pf_dim0_end;
        _F_pf_dim0_end = num_pf;
        for (_F_pf_dim0 = 0; _F_pf_dim0 < _F_pf_dim0_end; _F_pf_dim0++) {
            pf[_F_pf_dim0] = _F_bs.getfloat();
        }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(has_label, 1);
        if (has_label)
            _F_ret += label.put(_F_bs);
        _F_ret += iname_sym.put(_F_bs);
        _F_bs.putfloat(dur);
        _F_bs.putbits(num_pf, 8);
        int _F_pf_dim0, _F_pf_dim0_end;
        _F_pf_dim0_end = num_pf;
        for (_F_pf_dim0 = 0; _F_pf_dim0 < _F_pf_dim0_end; _F_pf_dim0++) {
            _F_bs.putfloat(pf[_F_pf_dim0]);
        }
        return _F_ret;
    }
};

class control_event {
public:
    unsigned int has_label;
    sa_symbol label;
    sa_symbol varsym;
    float value;

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        has_label = _F_bs.getbits(1);
        if (has_label)
            _F_ret += label.get(_F_bs);
        _F_ret += varsym.get(_F_bs);
        value = _F_bs.getfloat();
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(has_label, 1);
        if (has_label)
            _F_ret += label.put(_F_bs);
        _F_ret += varsym.put(_F_bs);
        _F_bs.putfloat(value);
        return _F_ret;
    }
};

class table_event {
public:
    sa_symbol tname;
    unsigned int tgen;
    unsigned int refers_to_sample;
    sa_symbol table_sym;
    unsigned int num_pf;
    float pf[_F_SIZE];

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_ret += tname.get(_F_bs);
        tgen = _F_bs.getbits(8);
        refers_to_sample = _F_bs.getbits(1);
        if (refers_to_sample)
            _F_ret += table_sym.get(_F_bs);
        num_pf = _F_bs.getbits(16);
        int _F_pf_dim0, _F_pf_dim0_end;
        _F_pf_dim0_end = num_pf;
        for (_F_pf_dim0 = 0; _F_pf_dim0 < _F_pf_dim0_end; _F_pf_dim0++) {
            pf[_F_pf_dim0] = _F_bs.getfloat();
        }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_ret += tname.put(_F_bs);
        _F_bs.putbits(tgen, 8);
        _F_bs.putbits(refers_to_sample, 1);
        if (refers_to_sample)
            _F_ret += table_sym.put(_F_bs);
        _F_bs.putbits(num_pf, 16);
        int _F_pf_dim0, _F_pf_dim0_end;
        _F_pf_dim0_end = num_pf;
        for (_F_pf_dim0 = 0; _F_pf_dim0 < _F_pf_dim0_end; _F_pf_dim0++) {
            _F_bs.putfloat(pf[_F_pf_dim0]);
        }
        return _F_ret;
    }
};

class tempo_event {
public:
    float tempo;

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        tempo = _F_bs.getfloat();
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putfloat(tempo);
        return _F_ret;
    }
};

class end_event {
public:
    unsigned int end;

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        end = _F_bs.getbits(1);
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(end, 1);
        return _F_ret;
    }
};

class score_line {
public:
    float time;
    unsigned int type;
    instr_event inst;
    control_event control;
    table_event table;
    tempo_event tempo;
    end_event end;

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        time = _F_bs.getfloat();
        type = _F_bs.getbits(3);
        switch (type)
            {
            case 0:
                _F_ret += inst.get(_F_bs);
                break;
            case 1:
                _F_ret += control.get(_F_bs);
                break;
            case 2:
                _F_ret += table.get(_F_bs);
                break;
            case 3:
                _F_ret += tempo.get(_F_bs);
                break;
            case 4:
                _F_ret += end.get(_F_bs);
                break;
            }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putfloat(time);
        _F_bs.putbits(type, 3);
        switch (type)
            {
            case 0:
                _F_ret += inst.put(_F_bs);
                break;
            case 1:
                _F_ret += control.put(_F_bs);
                break;
            case 2:
                _F_ret += table.put(_F_bs);
                break;
            case 3:
                _F_ret += tempo.put(_F_bs);
                break;
            case 4:
                _F_ret += end.put(_F_bs);
                break;
            }
        return _F_ret;
    }
};

#define _F_SIZE 8192


class score_file {
public:
    unsigned int num_lines;
    score_line *lines[_F_SIZE];

public: score_file() { num_lines = 0; }
  public: void add(score_line *s) {
    lines[num_lines++] = s;
  }
  

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        num_lines = _F_bs.getbits(20);
        int _F_lines_dim0, _F_lines_dim0_end;
        _F_lines_dim0_end = num_lines;
        for (_F_lines_dim0 = 0; _F_lines_dim0 < _F_lines_dim0_end; _F_lines_dim0++) {
          lines[_F_lines_dim0] = new score_line;
            _F_ret += lines[_F_lines_dim0]->get(_F_bs);
        }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(num_lines, 20);
        int _F_lines_dim0, _F_lines_dim0_end;
        _F_lines_dim0_end = num_lines;
        for (_F_lines_dim0 = 0; _F_lines_dim0 < _F_lines_dim0_end; _F_lines_dim0++) {
            _F_ret += lines[_F_lines_dim0]->put(_F_bs);
        }
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 64


class midi_event {
public:

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        return _F_ret;
    }
};

class midi_file {
public:
    unsigned int length;
    unsigned int data[_F_SIZE];

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        length = _F_bs.getbits(20);
        int _F_data_dim0, _F_data_dim0_end;
        _F_data_dim0_end = length;
        for (_F_data_dim0 = 0; _F_data_dim0 < _F_data_dim0_end; _F_data_dim0++) {
            data[_F_data_dim0] = _F_bs.getbits(8);
        }
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_bs.putbits(length, 20);
        int _F_data_dim0, _F_data_dim0_end;
        _F_data_dim0_end = length;
        for (_F_data_dim0 = 0; _F_data_dim0 < _F_data_dim0_end; _F_data_dim0++) {
            _F_bs.putbits(data[_F_data_dim0], 8);
        }
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 1000000


class sample {
public:
    sa_symbol sample_name_sym;
 char fn[20]; 
    unsigned int length;
    unsigned int has_srate;
    unsigned int srate;
    unsigned int has_loop;
    unsigned int loopstart;
    unsigned int loopend;
    unsigned int has_base;
    float basecps;
    unsigned int float_sample;
    float fs_data[_F_SIZE];
    int s_data[_F_SIZE];
 public: void save(); 

    public: virtual int get(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_ret += sample_name_sym.get(_F_bs);
        length = _F_bs.getbits(24);
        has_srate = _F_bs.getbits(1);
        if (has_srate)
            srate = _F_bs.getbits(17);
        has_loop = _F_bs.getbits(1);
        if (has_loop)
            {
                loopstart = _F_bs.getbits(24);
                loopend = _F_bs.getbits(24);
            }
        has_base = _F_bs.getbits(1);
        if (has_base)
            basecps = _F_bs.getfloat();
        float_sample = _F_bs.getbits(1);
        if (float_sample)
            {
                int _F_fs_data_dim0, _F_fs_data_dim0_end;
                _F_bs.align(8);
                _F_fs_data_dim0_end = length;
                for (_F_fs_data_dim0 = 0; _F_fs_data_dim0 < _F_fs_data_dim0_end; _F_fs_data_dim0++) {
                    fs_data[_F_fs_data_dim0] = _F_bs.getfloat();
                }
            }
        else
            {
                int _F_s_data_dim0, _F_s_data_dim0_end;
                _F_bs.align(8);
                _F_s_data_dim0_end = length;
                for (_F_s_data_dim0 = 0; _F_s_data_dim0 < _F_s_data_dim0_end; _F_s_data_dim0++) {
                    s_data[_F_s_data_dim0] = _F_bs.getbits(16);
                }
            }
 save(); 
        return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0;
        _F_ret += sample_name_sym.put(_F_bs);
        _F_bs.putbits(length, 24);
        _F_bs.putbits(has_srate, 1);
        if (has_srate)
            _F_bs.putbits(srate, 17);
        _F_bs.putbits(has_loop, 1);
        if (has_loop)
            {
                _F_bs.putbits(loopstart, 24);
                _F_bs.putbits(loopend, 24);
            }
        _F_bs.putbits(has_base, 1);
        if (has_base)
            _F_bs.putfloat(basecps);
        _F_bs.putbits(float_sample, 1);
        if (float_sample)
            {
                int _F_fs_data_dim0, _F_fs_data_dim0_end;
                _F_bs.align(8);
                _F_fs_data_dim0_end = length;
                for (_F_fs_data_dim0 = 0; _F_fs_data_dim0 < _F_fs_data_dim0_end; _F_fs_data_dim0++) {
                    _F_bs.putfloat(fs_data[_F_fs_data_dim0]);
                }
            }
        else
            {
                int _F_s_data_dim0, _F_s_data_dim0_end;
                _F_bs.align(8);
                _F_s_data_dim0_end = length;
                for (_F_s_data_dim0 = 0; _F_s_data_dim0 < _F_s_data_dim0_end; _F_s_data_dim0++) {
                    _F_bs.putbits(s_data[_F_s_data_dim0], 16);
                }
            }
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 1500000
class soundfont {
public:

  int size;
  char data[_F_SIZE];
  
    public: virtual int get(Bitstream& _F_bs) {
      int i;
      int _F_ret = 0;
      char fn[80];
      FILE *fp;

      size = _F_bs.getbits(24);
      for (i=0;i!=size;i++)
	data[i] = _F_bs.getbits(8);

      sprintf(fn,"%s%c%s",cmd.temp,DIRSEP,"temp.sbf");
      fp = fopen(fn,"w");
      for (i=0;i!=size;i++)
	fputc(data[i],fp);
      fclose(fp);

      cmd.has_sbf = 1;
      return _F_ret;
    }

    public: virtual int put(Bitstream& _F_bs) {
        int _F_ret=0,i;

	_F_bs.putbits(size,24);
	for (i=0;i!=size;i++)
	  _F_bs.putbits(data[i],8);
        return _F_ret;
    }
};

#undef _F_SIZE
#define _F_SIZE 64


class bit_data {
  public:
  int num_orc, num_sco, has_sym;
  orc_file *all_orc[20];
  score_file *all_score[20];

  void add_orc(orc_file *o) {
    all_orc[num_orc++] = o;
  }

  void add_score(score_file *s) {
    all_score[num_sco++] = s;
  }
} all;
 

class SA_streaminfo {
public:
    unsigned int SA_magicnum;
    unsigned int more_data;
    unsigned int chunk_type;
    orc_file *orc;
    score_file *score;
    midi_file *SMF;
    sample *samp;
    sa_symtable *sym;
    soundfont *SFB;


public: virtual int get(Bitstream& _F_bs) {
    int _F_ret=0;
    SA_magicnum = _F_bs.getbits(10);
    if (SA_magicnum != 0) {
        flerror("Const value mismatch for 'SA_magicnum'\n");
        _F_ret++;
    }
    more_data = _F_bs.getbits(1);
    if (more_data != 1) {
        flerror("Const value mismatch for 'more_data'\n");
        _F_ret++;
    }
    while (more_data)
        {
            chunk_type = _F_bs.getbits(3);
            switch (chunk_type)
                {
                case 0:
                    orc = new orc_file;
                    _F_ret += orc->get(_F_bs);
                    all.add_orc(orc); 
                    break;
                case 1:
                    score = new score_file;
                    _F_ret += score->get(_F_bs);
                    all.add_score(score); 
                    break;
                case 2:
                    SMF = new midi_file;
                    _F_ret += SMF->get(_F_bs);
                    break;
                case 3:
                  samp = new sample;
                  _F_ret += samp->get(_F_bs);
                  break;
                case 4:
                  SFB = new soundfont;
                  _F_ret += SFB->get(_F_bs);
                  break;
                case 5:
                  sym = new sa_symtable;
                  _F_ret += sym->get(_F_bs);
                  all.has_sym = 1; 
                  break;
                }
            more_data = _F_bs.getbits(1);
        }
    return _F_ret;
}

public: virtual int put(Bitstream& _F_bs) {
    int _F_ret=0;
    _F_parse = 10;
    SA_magicnum = 0;
    _F_bs.putbits(SA_magicnum, _F_parse);
    _F_parse = 1;
    more_data = 1;
    _F_bs.putbits(more_data, _F_parse);
    while (more_data)
        {
            _F_bs.putbits(chunk_type, 3);
            switch (chunk_type)
                {
                case 0:
                    _F_ret += orc->put(_F_bs);
                    break;
                case 1:
                    _F_ret += score->put(_F_bs);
                    break;
                case 2:
                    _F_ret += SMF->put(_F_bs);
                    break;
                case 3:
                    _F_ret += samp->put(_F_bs);
                    break;
                case 4:
                    _F_ret += SFB->put(_F_bs);
                    break;
                case 5:
                    _F_ret += sym->put(_F_bs);
                    break;
                }
            _F_bs.putbits(more_data, 1);
        }
    return _F_ret;
}
};

class SA_stream {
public:
unsigned int end_of_session;
unsigned int event_type;
score_line score_ev;
sample samp;
midi_event midi_ev;

public: virtual int get(Bitstream& _F_bs) {
int _F_ret=0;
end_of_session = _F_bs.getbits(1);
while ((!end_of_session))
    {
        event_type = _F_bs.getbits(2);
        switch (event_type)
            {
            case 0:
                _F_ret += score_ev.get(_F_bs);
                break;
            case 1:
                _F_ret += midi_ev.get(_F_bs);
                break;
            case 2:
                _F_ret += samp.get(_F_bs);
                break;
            }
        end_of_session = _F_bs.getbits(1);
    }
return _F_ret;
}

public: virtual int put(Bitstream& _F_bs) {
int _F_ret=0;
_F_bs.putbits(end_of_session, 1);
while ((!end_of_session))
    {
        _F_bs.putbits(event_type, 2);
        switch (event_type)
            {
            case 0:
                _F_ret += score_ev.put(_F_bs);
                break;
            case 1:
                _F_ret += midi_ev.put(_F_bs);
                break;
            case 2:
                _F_ret += samp.put(_F_bs);
                break;
            }
        _F_bs.putbits(end_of_session, 1);
    }
return _F_ret;
}
};

int samp_table[1024],samp_ct = 0;

void sample::save() {
  AIF_STRUCT *out;
  short outbuf[1024];
  long pvb[16];
  int pvl = 0,ct,i,j,tot=0;
  
  samp_table[samp_ct++] = sample_name_sym.sym;
  sprintf(fn,"%s%csamp_%d.aif",cmd.temp,DIRSEP,sample_name_sym.sym);

  out = aifNew();
  pvb[pvl++] = AIF_P_SAMPRATE; pvb[pvl++] = srate;
  pvb[pvl++] = AIF_P_CHANNELS; pvb[pvl++] = 1;
  pvb[pvl++] = AIF_P_SAMPSIZE; pvb[pvl++] = 16;
  pvb[pvl++] = AIF_P_FILETYPE; pvb[pvl++] = AIF_FT_AIFF;
  
  aifSetParams(out,pvb,pvl);
  aifOpenWrite(out,fn,UNK_LEN);

  for (i=0;i<=length / 1024;i++) {
    ct = MIN(1024,length-i*1024);
    for (j=0;j!=ct;j++)
      if (float_sample)
	outbuf[j] = (short)(fs_data[i*1024+j] * 32767);
      else
	outbuf[j] = s_data[i*1024+j];
    aifWriteFrames(out,outbuf,ct);
    tot += ct;
  }
  aifClose(out);
  printf("Wrote %d samples to '%s'.\n",tot,fn);
}


#endif /* ! _sa_bitstream_h_ */
