/* $Id: saol_interp.h,v 1.5 1997/11/20 18:37:03 eds Exp $ */
/* $Log: saol_interp.h,v $
 * Revision 1.5  1997/11/20  18:37:03  eds
 * SASBF integration.
 *
 * Revision 1.4  1997/11/15 00:43:20  luked
 * This is the result of the manual merge from the vendor branch for the
 * release tagged Fribourg_after_integration. I (brian) have probably lost
 * some history, but oh well.
 *
 * This contains the integration work by Eric Scheirer (MIT).
 *
 * Revision 1.4  1997/11/05  20:11:27  eds
 * Added tablemaps.
 *
 * Revision 1.3  1997/11/05  15:00:58  eds
 * Added vector parameters/return values/operators.
 *
 * Revision 1.2  1997/10/03  15:11:13  eds
 * Added sfsynth support.
 * */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#ifndef _SAOL_INTERP_H

#define _SAOL_INTERP_H

#include "saol.h"

typedef struct {
  double *d;
  char *name;
  long size;
  int srate;
  long loop, loopend;
  double base;
} table_storage;

typedef double asig_frame;

typedef struct {
  double val;
  table_storage *table;
  /*  asig_frame *asig; */
} frameval;

typedef struct child_cx_list_struct {
  expr *ref;
  struct context_struct *cx;
  struct child_cx_list_struct *next;
} child_cx_list;


typedef struct actparam_struct {
  double val;
  char *ref;
  table_storage *t;
} actparam;

typedef struct context_struct {
  frameval *framevals;     /* the values and/or pointers for this frame */
  symtable *localvars;      /* the local symbol table */
  double *outval;           /* output values */
  struct instr_handle_struct *instr;      /* the instance handle for this context */
  struct opval_struct *cop_storage;        /* extra storage for a core opcode */
  struct SynthParams *sfstorage;	/* storage for sfsynth */
  int sfVoiceCnt;					/* number of sf voices running */
  int asample_ptr; 
  int inchan;
  int channel, preset, midibank;
  sa_decoder *sa;    /* the decoder this context is a part of */
} context;

typedef struct opval_struct {
  void *local;
  void *dyn;
} opval;

void runtime(char *s);
double eval_block(context *cx,block *b, long rate);
double eval_expr(context **cx, double *val, expr *p, long rate);
double eval_opcode(context *cx, double *val, expr *p, long rate);
double eval_oparray(context *cx, double *val, expr *p, long rate);

void push_context(context *cx, long rate);
void pop_context(context *cx, long rate);

context *new_context(sa_decoder *sa,instr_decl *id, int inchan);
context *get_child_context(context *cx, expr *p); 
context *new_child_context(context *cx, expr *p); 
frameval *new_frameval(double val, table_storage *table, asig_frame *asig); 
frameval *get_frameval(context *cx, expr *p, int index); 
void set_frameval(context *cx, expr *p, int index, frameval *val); 
table_storage *resolve_tablemap(context *cx, expr *p, long rate);

table_storage *make_table(context *cx, tabledef *td);
/* actparam *make_varargs_list(actparam_list *p, context *cx);*/
asig_frame *make_asig_frame(int ksmps);
void set_var_value(context *cx, expr *p, int index, double val);
void set_var_value_byname(context *cx, char *vname, int index, double val);
double get_var_value(context *cx, expr *p, int index); 

table_storage *gen_table(char *gen,actparam *pf,int);

struct instr_handle_struct 
    *new_instr_instance(sa_decoder *sa,
		char *iname, double *pf,
		int inchan);
void add_default_host_vars(struct instr_handle_struct *h);
void add_imported_host_vars(struct instr_handle_struct *h);
void run_itime(instr_decl *id, context *cx);
void run_katime(instr_decl *id, context *cx, long rate);
void set_asample_ptr(context *cx, int i); 

extern int ksmps;

#endif
