/*

This software module was originally developed by 

Mike Guzewicz (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/

     /*********************************************************************
     
     sfe_sfnav.h
     
     
     
     *********************************************************************/


/*****************************************************************************
*  @(#)sfnav.h	1.1 12:06:33 3/15/95 12:06:37
* 
* Filename: sfnav.h
*
* Description: The SoundFont Navigator
*
*******************************************************************************
*/

#ifndef __SFNAV_H
#define __SFNAV_H


/////////////////////////////
//        Includes         //
/////////////////////////////

#include "sfe_datatype.h"
#include "sfe_sfdata.h"
#include "sfe_hydra.h"

/////////////////////////////
//         Defines         //
/////////////////////////////

#define MAX_SAMPLES             4   // The max number of layers for a preset
#define SF_N_MEMBERS           58  // The number of SoundFont data items
#define MAX_SOUND_FONTS        10  // The max number of simultaneous SFB's

/////////////////////////////
//      Constants          //
/////////////////////////////

/////////////////////////////
//        Typedefs         //
/////////////////////////////

/////////////////////////////
//        Classes          //
/////////////////////////////

class SoundFontNavigator 
{
  public:
    SoundFontNavigator(void);
    ~SoundFontNavigator(void);

    void        Reset(void);
    void        Navigate(WORD wSFID, WORD wKey, WORD wVel);
    WORD        GetNOsc(void)  { return (wOsc);          }
    sfData*     GetSFPtr(void) { return (&(sfVector[0])); }
    void        GetHydraFont(HydraClass* pHydra);
    HydraClass* SetHydraFont(HydraClass* pHydra);
    WORD        GetSFNum(WORD wBank, BYTE byPatch, WORD* pwSFID);

  private:

    void        ProcessSampleLinks(void);
    void        AddSoundFonts(sfData *, sfData *);
    HydraClass    *phfNav;
    WORD          wOsc;                 // # of Osc's used for Preset
    sfData        sfPresetData;          // The preset global layer data
    sfData        sfInstData;            // The instrument global data
    sfData        sfCurrPreset;          // The current preset layer data
    sfData        sfVector[MAX_SAMPLES];  // Specific data for an oscillator
    WORD          shdrIndexLinks[MAX_SAMPLES];
    WORD          nextOscLinkCheck;
    BYTE          linkFound[MAX_SAMPLES];

};



#endif //  __SFNAV_H

