#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine NDC (XC, YC, NC, NumCrv)


*******************************************************************
*                                                                 *
*   Subroutine Normalized_Device_Coordinates                      *
*                                                                 *
*      Converts the clipped object, stored in XC & YC, from       *
*      world coordinates to normalized device coordinates.        *
*      The arrays will then be used to map the object to the      *
*      desired device coordinates.                                *
*                                                                 *
*      Normalized coordinates are between 0.0 and 1.0 , thus      *
*      making it easier to map the points to any set of de-       *
*      vice coordinates.                                          *
*                                                                 *
*******************************************************************


        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Integer NumCrv, NC(NumCrv), I, J
        Real    XC(maxC,num), YC(maxC,num)


*       (* Using the window and viewport limits, the
*          XC & YC arrays are mapped into normalized
*          coordinates, (0.0 to 1.0).
        DO 100 J = 1, NumCrv
          DO 200 I = 1, NC(J)
            XC(I,J) = (XC(I,J) - WXmin)/(WXmax - WXmin)
            YC(I,J) = (YC(I,J) - WYmin)/(WYmax - WYmin)
  200     CONTINUE
  100   CONTINUE

        RETURN
        END
