/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  d_array.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




//------------------------------------------------------------------------------
// _d_array 
//------------------------------------------------------------------------------ 

#ifndef DARRAYH
#define DARRAYH

#ifndef RBTREEH 
#include <LEDA/rb_tree.h> 
#endif


#define d_array_body(itype,etype) : public rb_tree {\
\
etype init;\
rb_tree_node* iterator;\
\
itype name2(itype,X1);\
etype name2(etype,X2);\
\
int  cmp(GenPtr x, GenPtr y) const\
                          { return compare(ACCESS1(itype,x),ACCESS1(itype,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(itype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(etype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS1(itype,x));  }\
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS2(etype,x));  }\
\
public:\
\
etype&  operator[](itype y) { rb_tree_node* i=lookup(Convert(y));\
                              if (i==nil) i=insert(Convert(y),Convert(init));\
                              return ACCESS2(etype,info(i)); }\
/*\
etype   operator[](itype y) const\
                            { rb_tree_node* i=lookup(Convert(y));\
                              if (i==nil) return init;\
                              else return ACCESS2(etype,info(i)); }\
*/\
bool defined(itype y)  const { return (lookup(Convert(y))!=nil); }\
void init_iterator()         { iterator = first_item(); }\
bool next_index(itype& y)    { if (iterator==0) return false;\
                               else { y = ACCESS1(itype,key(iterator));\
                                      iterator = next_item(iterator);\
                                      return true; } \
                              }\
\
 _d_array(itype,etype)() {};\
 _d_array(itype,etype)(etype i) { init=i; }\
\
 _d_array(itype,etype)(const _d_array(itype,etype)& A) : rb_tree((rb_tree&) A)\
 { init=A.init; }\
\
 _d_array(itype,etype)& operator=(const _d_array(itype,etype)& A)\
 { rb_tree::operator=((rb_tree&)A); init=A.init; return *this; }\
\
~_d_array(itype,etype)()        { clear(); };\
} ;


#ifdef __TEMPLATES__
#define _d_array(I,E) d_array
template<class I, class E> class d_array d_array_body(I,E)

#else
#define _d_array(I,E) name3(I,E,d_array)
#define d_array(I,E) name3(I,E,d_array)
#define d_arraydeclare2(I,E) class d_array(I,E) d_array_body(I,E)

#endif


#define forall_defined(i,A)  for ((A).init_iterator(); (A).next_index(i); )


#endif
