/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  prio1.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef PRIO_H
#define PRIO_H


#include <LEDA/f_heap.h>


typedef f_heap_item pq_item;

#define prio(ktype,itype) name3(itype,ktype,prio)


#define priodeclare2(ktype,itype)\
\
class prio(ktype,itype)  : public f_heap\
{\
ktype name2(ktype,X1);\
itype name2(itype,X2);\
\
virtual int  cmp(GenPtr x, GenPtr y) const\
                     { return compare(ACCESS2(itype,x),ACCESS2(itype,y)); }\
virtual void clear_key(GenPtr& x)   const { Clear(ACCESS2(itype,x)); }\
virtual void clear_inf(GenPtr& x)   const { Clear(ACCESS1(ktype,x)); }\
virtual void copy_key(GenPtr& x)    const { x=Copy(ACCESS2(itype,x)); }\
virtual void copy_inf(GenPtr& x)    const { x=Copy(ACCESS1(ktype,x)); }\
virtual void print_key(GenPtr& x)   const { Print(ACCESS2(itype,x)); }\
virtual void print_inf(GenPtr& x)   const { Print(ACCESS1(ktype,x)); }\
\
public:\
\
virtual pq_item insert(ktype k,itype i) { return f_heap::insert(Convert(i),Convert(k));}\
virtual pq_item find_min()        const { return f_heap::find_min();}\
virtual ktype   del_min()   { ktype x = key(find_min()); f_heap::del_min(); return x; }\
virtual ktype key(pq_item x)      const { return ACCESS1(ktype,f_heap::inf(x)); }\
virtual itype inf(pq_item x)      const { return ACCESS2(itype,f_heap::key(x)); }\
virtual void change_key(pq_item x, ktype k) { f_heap::change_inf(x,Convert(k)); }\
virtual void decrease_inf(pq_item x,itype i){ f_heap::decrease_key(x,Convert(i)); }\
virtual void del_item(pq_item x)            { f_heap::del_item(x); }\
\
virtual int  size()    const { return f_heap::size(); }\
virtual bool empty()   const { return (size()==0) ? true : false; }\
\
virtual pq_item first_item()          const { return f_heap::first_item(); }\
virtual pq_item next_item(pq_item it) const { return f_heap::next_item(it); }\
\
virtual prio(ktype,itype)& operator=(const prio(ktype,itype)& Q) { return (prio(ktype,itype)&)f_heap::operator=((f_heap&)Q); }\
\
 prio(ktype,itype)()  {}\
 prio(ktype,itype)(const prio(ktype,itype)& Q) : f_heap((f_heap&)Q)  {}\
~prio(ktype,itype)()  { f_heap::clear(); }\
};

#define forall_pq_items(i,Q) for(i = (Q).first_item(); i; i=(Q).next_item(i))



#define PRIO_ITEM(T) name2(T,_item)

#define PRIO(ktype,itype,impl) name4(itype,ktype,impl,PRIO)


#define PRIOdeclare3(ktype,itype,impl)\
\
class PRIO(ktype,itype,impl) : public prio(ktype,itype), public impl\
{\
ktype name2(ktype,X1);\
itype name2(itype,X2);\
\
int  cmp(GenPtr x, GenPtr y) const\
                         { cout << "COMPARE\n"; int b =  compare(ACCESS2(itype,x),ACCESS2(itype,y));\
                           return (b==0) ? int(x)-int(y) : b;}\
void clear_key(GenPtr& x)   const { Clear(ACCESS2(itype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS1(ktype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS2(itype,x)); }\
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS1(ktype,x)); }\
void print_key(GenPtr& x)   const { Print(ACCESS2(itype,x)); }\
void print_inf(GenPtr& x)   const { Print(ACCESS1(ktype,x)); }\
\
public:\
\
pq_item insert(ktype k,itype i) { return pq_item(impl::insert(Convert(i),Convert(k)));}\
\
pq_item find_min()   const { return pq_item(impl::find_min());}\
\
ktype del_min()            { pq_item it = find_min(); ktype x = key(it);\
                             del_item(it); return x; }\
\
ktype key(pq_item x) const { return ACCESS1(ktype,impl::inf(PRIO_ITEM(impl)(x)));}\
itype inf(pq_item x) const { return ACCESS2(itype,impl::key(PRIO_ITEM(impl)(x)));}\
\
void  change_key(pq_item x, ktype k)\
                           { impl::change_inf(PRIO_ITEM(impl)(x),Convert(k)); }\
\
void  decrease_inf(pq_item x,itype i)\
                           { impl::decrease_key(PRIO_ITEM(impl)(x),Convert(i));}\
\
void  del_item(pq_item x)  { impl::del_item(PRIO_ITEM(impl)(x)); }\
\
int   size()  const        { return impl::size(); }\
bool  empty() const        { return (size()==0) ? true : false; }\
\
pq_item first_item()          const { return pq_item(impl::first_item()); }\
pq_item next_item(pq_item it) const { return pq_item(impl::next_item(PRIO_ITEM(impl)(it))); }\
\
prio(ktype,itype)& operator=(const prio(ktype,itype)& Q)\
{  return (PRIO(ktype,itype,impl)&)impl::operator=(*(impl*)&Q); }\
\
PRIO(ktype,itype,impl)(const PRIO(ktype,itype,impl)& Q):impl(Q)  {}\
\
PRIO(ktype,itype,impl)()  {}\
\
~PRIO(ktype,itype,impl)()  { impl::clear(); }\
};



//------------------------------------------------------------------------------
// Bounded Priority Queues
//------------------------------------------------------------------------------


#define B_PRIO_ITEM(T) name2(T,_item)

#define B_PRIO(ktype,impl) name3(ktype,impl,B_PRIO)


#define B_PRIOdeclare2(ktype,impl)\
\
class B_PRIO(ktype,impl) : public prio(ktype,int), public impl\
{\
\
ktype name2(ktype,X);\
\
int  cmp(GenPtr x, GenPtr y) const\
                               { return int(x) - int(y); }\
void print_inf(GenPtr& x)   const { Print(int(x)); }\
void print_key(GenPtr& x)   const { Print(ACCESS(ktype,x));}\
void clear_key(GenPtr& x)   const { Clear(ACCESS(ktype,x));}\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS(ktype,x)); }\
\
public:\
\
pq_item insert(ktype k,int i) { return pq_item(impl::insert(Convert(k),i));}\
\
pq_item find_min()   const { return pq_item(impl::find_min());}\
\
ktype del_min()            { return ACCESS(ktype,impl::del_min()); }\
\
ktype key(pq_item x) const { return ACCESS(ktype,impl::key(B_PRIO_ITEM(impl)(x))); }\
int   inf(pq_item x) const { return impl::inf(B_PRIO_ITEM(impl)(x));}\
\
void  change_key(pq_item x, ktype k)\
                           { impl::change_key(B_PRIO_ITEM(impl)(x),Convert(k)); }\
\
void  decrease_inf(pq_item x, int i)\
                           { impl::decrease_inf(B_PRIO_ITEM(impl)(x),i);}\
\
void  del_item(pq_item x)  { impl::del_item(B_PRIO_ITEM(impl)(x)); }\
\
int   size()  const        { return impl::size(); }\
bool  empty() const        { return (size()==0) ? true : false; }\
\
 B_PRIO(ktype,impl)(int N) : impl(N) {}\
~B_PRIO(ktype,impl)()                { impl::clear(); }\
};


#endif
