/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  set.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef SETH
#define SETH

//------------------------------------------------------------------------------
// set             
//------------------------------------------------------------------------------

#include <LEDA/basic.h>

#ifndef RBTREEH 
#include <LEDA/rb_tree.h>
#endif

#define set(type) name2(type,set)

#define setdeclare(type)\
\
class set(type) : public rb_tree {\
\
rb_tree_node* iterator;\
type name2(type,X);\
\
int  cmp(GenPtr x, GenPtr y) const\
                           { return compare(ACCESS(type,x),ACCESS(type,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS(type,x));   }\
void copy_key(GenPtr& x)    const { x = Copy(ACCESS(type,x));}\
\
public:\
void insert(type y)         { rb_tree::insert(Convert(y),0); }\
void del(type y)            { rb_tree::del(Convert(y)); }\
bool member(type y)   const { return (rb_tree::lookup(Convert(y))!=nil); }\
type choose() const { return ACCESS(type,rb_tree::key(rb_tree::min())); }\
\
void init_iterator()       { iterator = rb_tree::first_item(); }\
bool next_element(type& y) { if (iterator==0) return false;\
                                else { y = ACCESS(type,rb_tree::key(iterator));\
                                       iterator=rb_tree::next_item(iterator);\
                                       return true; } \
                               }\
\
 set(type)& operator=(const set(type)& S)\
 { rb_tree::operator=((rb_tree&) S); return *this; }\
\
 set(type)() {}\
 set(type)(const set(type)& S) : rb_tree((rb_tree&) S) {}\
~set(type)() { clear(); }\
} ;

#endif

