#ifndef DOUBLEFFT_H
#define DOUBLEFFT_H
#pragma once

/*
 *	Double Precision FFT server
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)DoubleFFT.h	2.2	9/18/89
 */

#include "DComplexFFT.h"
     
/*

This class does fourier transforms involving a real sequence.  It is
derived from class DComplexFFTServer.

Let V(j), j=0,1,...,2N-1 be a 2N points long real sequence.  Its
transform will be complex conjugate even.  That is, C(n) ==
conj(C(-n)) or C(n) == conj(C(2N-n)).

The routine fourier() returns the lower half of this complex conjugate
even sequence, that is C(n), n=0,..,N.  The upper half can be
recovered from the relationship C(n) == C(2N-n).  Note that the
requirement that the length of the original sequence be 2N means that
V must have an even number of points.  The resulting complex conjugate
even sequence C(n) will have N + 1 complex points, for a total of 2N+2
points.  The extra two points are the imaginary parts of C(0) and
C(N).  Both are always zero.  The transform calculated is:

                2N-1
         C(n) = sum V(j) exp(-pi * n * j * I / 2N); n=0,...,2N-1
                j=0

Given the lower half of C(n), the routine ifourier() calculates the
Inverse Fourier transform (IDFT):

                2N-1
         V(j) = sum C(n) exp( pi * n * j * I / 2N); j=0,...,2N-1
                n=0

Note that the transform is not normalized: calling fourier(), followed
by ifourier() will leave the series multiplied by 2N.  

The server is set up to do a transform for a specified N.  This can
either be specified at construction time, by using functionw
setOrder(), or (the easiest!) let it figure it out for itself from
the length of the sequence handed to it.  If the series length
changes, it will automagically reconfigure.

*/

class DoubleFFTServer : public DComplexFFTServer{
  unsigned		server_N;
  DComplexVec		roots_of_1;
  DComplexVec		conjroots_of_1;
protected:
  void			checkEven(int);
public:
  DoubleFFTServer();
  DoubleFFTServer(unsigned oforder);
  DoubleFFTServer(const DoubleFFTServer&);

  void			operator=(const DoubleFFTServer&);

  unsigned		order()	{return server_N;}
  void			setOrder(unsigned); // Set new server_N;

  /***********  TRANSFORMS ***********/
  // Returns DFT of a real sequence, which is a conjugate even sequence:
  DComplexVec		fourier(const DoubleVec&);
  // Returns IDFT of a complex conjugate even sequence, which is a real sequence:
  DoubleVec		ifourier(const DComplexVec& v);
};

#endif
