#ifndef DEFS_H
#define DEFS_H
#pragma once

/*
 *	Common definitions
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)vdefs.h	2.2	9/26/89
 */

#include "compiler.h"

class istream;
class ostream;

// If debugging: do not use inlines (unless using v2.0 compiler)
// and activate bounds checking
#ifdef DEBUG
#ifdef __ATT2__
#define Inline inline
#else
#define Inline static
#endif
#define BOUNDS_CHECK 1
#else
#define Inline inline
#endif

#ifdef __ATT1__
overload rint;
extern double rint(double);	// AT&T left this out of math.h
#endif


// GNU overloads these in math.h
#if !defined(__GNUG__) && NEEDS_OVERLOAD
overload abs;
overload acos;
overload acosh;
overload asin;
overload asinh;
overload atan2;
overload atan;
overload atanh;
overload ceil;
overload cos;
overload cosh;
overload exp;
overload floor;
overload gamma;
overload hypot;
overload log10;
overload log;
overload pow;
overload sin;
overload sinh;
overload sqrt;
overload tan;
overload tanh;
#endif

#if NEEDS_OVERLOAD
// Special math functions:
overload ABSOLUTE;
overload cumsum;
overload delta;
overload determinant;
overload dot;
overload expandConjugateEven;
overload expandConjugateOdd;
overload expandEven;
overload expandOdd;
overload inverse;
overload max;
overload mean;
overload min;
overload prod;
overload reverse;
overload rint;
overload rootsOfOne;
overload solve;
overload sum;
overload transpose;
overload trunc;
overload variance;
#endif

#define nil     0
#define NL	"\n"

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define Double	double
#define Float	float
#define Int	int

typedef double	(*mathFunTy)(double);
typedef int	fortran_int;
typedef int	fileDescTy;

extern Cdecl double fabs(double);

inline double	ABSOLUTE(double a)	{return fabs(a);}	//Can use coprocessor
inline double	max(double a, double b) {return a>b? a : b;}
inline double	min(double a, double b) {return a<b? a : b;}

inline int	ABSOLUTE(int a)		{return a<0? -a : a;}
inline int	max(int a, int b)	{return a>b? a : b;}
inline int	min(int a, int b)	{return a<b? a : b;}

enum Severity {WARNING, DEFAULT, FATAL};
void		RWerror(Severity);
void		RWnote(const char* routine, const char* comment);

overload RWstoreID, RWreadID;
void RWreadBin(fileDescTy&,void*,unsigned,const char*);
void RWstoreBin(fileDescTy&,const void*,unsigned,const char*);
void RWstoreID(ostream&,const char*,const char*);
void RWstoreID(fileDescTy&,const char*,const char*);
void RWreadID(istream&,const char*,const char*);
void RWreadID(fileDescTy&,const char*,const char*);

#ifdef __ATT1__
// Necessary so cfront mungs the function names properly.  Otherwise,
// it is unpredictable which type gets which name.
extern void cumsum();
extern void delta();
extern void determinant();
extern void dot();
extern void inverse();
extern void prod();
extern void reverse();
extern void solve();
extern void sum();
extern void transpose();
extern void variance();
#endif

#endif
