c   imsl routine name   - vbla=dscal                                    vbdj0010
c
c-----------------------------------------------------------------------
c
c   computer            - vax/double
c
c   latest revision     - january 1, 1978
c
c   purpose             - compute a double precision constant
c                           times a double precision vector
c
c   usage               - call dscal (n,da,dx,incx)
c
c   arguments    n      - length of vector x. (input)
c                da     - double precision scalar. (input)
c                dx     - double precision vector of length n*incx.
c                           (input/output)
c                           dscal replaces x(i) with da*x(i) for
c                           i=1,...,n.
c                           x(i) refers to a specific element of dx.
c                           see incx argument description.
c                incx   - displacement between elements of dx. (input)
c                           x(i) is defined to be dx(1+(i-1)*incx).
c                           incx must be greater than zero.
c
c   precision/hardware  - double/all
c
c   reqd. imsl routines - none required
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   copyright           - 1978 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
      subroutine dscal  (n,da,dx,incx)
c
c                                  specifications for arguments
      double precision   da,dx(1)
      integer            n,incx
c                                  specifications for local variables
      integer            i,m,mp1,ns
c                                  first executable statement
      if (n.le.0) return
      if (incx.eq.1) go to 10
c                                  code for increments not equal to 1.
      ns = n*incx
      do 5 i=1,ns,incx
         dx(i) = da*dx(i)
    5 continue
      return
c                                  code for increments equal to 1.
c                                    clean-up loop so remaining vector
c                                    length is a multiple of 5.
   10 m = n-(n/5)*5
      if (m.eq.0) go to 20
      do 15 i=1,m
         dx(i) = da*dx(i)
   15 continue
      if (n.lt.5) return
   20 mp1 = m+1
      do 25 i=mp1,n,5
         dx(i) = da*dx(i)
         dx(i+1) = da*dx(i+1)
         dx(i+2) = da*dx(i+2)
         dx(i+3) = da*dx(i+3)
         dx(i+4) = da*dx(i+4)
   25 continue
      return
      end
