#include <rw/DComplexFFT.h>
#include <rw/DCosineFFT.h>
#include <rw/Timer.h>

// This program is designed to test the difference in speed
// between cosine transforms and full complex transforms.
// It also serves as an example of using the FFT servers.

main()
{
  unsigned N, nit;

  cout << "Give N: ";
  cin >> N;

  cout << "Give number of iterations: ";
  cin >>nit;

  DoubleVec veven(N+1);		// The test series
  for(int i = 0; i<=N; i++) veven(i) = i;

  DComplexVec vfull(expandEven(veven));	// Make a complex version

  DComplexFFTServer cserver;	// Make the two servers
  DoubleCosineServer cosserver;

  /**************** Cosine transforms ***************/
  DoubleVec inveven;		// Results go here
  Timer t1;
  t1.mark("Start cosine transforms");

  for(int j = 0; j<nit; j++) inveven = cosserver.cosine(veven);
  t1.mark("Done with cosine transforms");

  cout <<"Cosine timing info:\n"<<t1<<NL;

  /**************** Complex transforms ***************/
  DComplexVec inv;
  Timer t2;
  t2.mark("Start full transforms");

  for(j = 0; j<nit; j++) inv = cserver.fourier(vfull);
  t2.mark("Done with full transforms");

  cout << "Complex timing info:\n"<<t2<<NL;
}
