/*
 *	Test program for <T> precision LU decomposition
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xludtest.cc	2.2	9/26/89
 */

#include "rw/<A>LUDecomp.h"
#include <stream.h>
extern Cdecl void exit(int);

<T> testdata[] = {-3.0, 2.0, 1.0, 8.0, -7.0, 9.0, 5.0, 4.0, -6.0};
<T> testrhs[] = {6.0, 9.0, 1.0};

main()
{
  cout << "\n*************** Test LU decomposition ***************\n";
  cout << "\n**** Test inverse ****\n";

  <A>GEMatrix testmat(testdata, 3, 3);

  cout << NL << "testmat:\n" << testmat <<NL;

  cout << NL << "inverse(testmat):\n" << inverse(testmat)<<NL;

  <T>Vec rhs(testrhs, 3);
  cout << NL << "rhs:\n" << rhs <<NL;

  <T>Vec soln = solve(testmat, rhs);
  cout << NL << "solution:\n" << soln <<NL;

  <T>Vec ckrhs = testmat.product(soln);
  cout << NL << "Verification of solution (should match rhs):\n" << ckrhs <<NL;

  exit(0);
}
