      SUBROUTINE PLTHM(N,MARK,TURN,EXT,INTER,INCID,KPRINT,PTEXT,LENGTH,
     &                 FACT,TAUMIN,TAUMAX)
C*    Begin Prologue PLTHM
      INTEGER N,MARK,TURN,EXT,INTER,INCID(N),KPRINT,LENGTH
      REAL FACT,TAUMIN,TAUMAX
      CHARACTER*20 PTEXT
C
C---------------------------------------------------------------------
C
C*  Title
C
C         (PLO)T (Hom)otopy.
C          Routine to be used in connection with the continuation
C          routine ALCON1 or ALCON2.
C
C*  Written by        P. Kunkel, L. Weimann
C*  Purpose           Plot bifurcation diagrams computed by ALCON1 or
C                     ALCON2.
C*  Method            Uses standard CALCOMP software
C*  Category          F4 - Parameter Dependent Nonlinear Equation 
C                          Systems
C*  Keywords          Numerical pathfollowing, Homotopy Method
C*  Version           0.9
C*  Revision          September 1985
C*  Latest Change     January 1991
C*  Library           CodeLib
C*  Code              Fortran 77, Double Precision
C*  Environment       Standard Fortran 77 environment on PC's,
C                     workstations and hosts.
C*  Copyright     (c) Konrad Zuse Zentrum fuer
C                     Informationstechnik Berlin
C                     Heilbronner Str. 10, D-1000 Berlin 31
C                     phone 0049+30+89604-0,
C                     telefax 0049+30+89604-125
C*  Contact           Lutz Weimann
C                     ZIB, Numerical Software Development
C                     phone: 0049+30+89604-185 ;
C                     e-mail:
C                     RFC822 notation: weimann@sc.zib-berlin.de
C                     X.400: C=de;A=dbp;P=zib-berlin;OU=sc;S=Weimann
C
C  ---------------------------------------------------------------
C
C* Licence
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time.
C    In any case you should not deliver this code without a special
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C* Warranty
C    This code has been tested up to a certain level. Defects and
C    weaknesses, which may be included in the code, do not establish
C    any warranties by ZIB. ZIB does not take over any liabilities
C    which may follow from aquisition or application of this code.
C
C* Software status
C    This code is under partial care of ZIB and belongs to ZIB
C    software class 2.
C
C     ------------------------------------------------------------
C
C  PARAMETERS
C
C  N       NUMBER OF COMPONENTS  (MAXIMUM VALUE ALLOWED BY DIMENSION  99
C  MARK    MARKING OF INTERNAL POINTS (ITYP=0-2)
C            0  NO MARKING
C            1  MARKING OF BIFURCATION POINTS
C            2  MARKING OF ALL INTERNAL POINTS
C  TURN    MARKING OF TURNING POINTS  (ITYP=3)
C            0  NO MARKING
C            1  MARKING OF TURNING POINTS
C  EXT     MARKING OF EXTERNAL POINTS (ITYP=5)
C            0  NO MARKING
C            1  MARKING OF EXTERNAL POINTS
C  INTER   INTERPOLATION
C            0  LINEAR
C            1  CUBIC HERMITE
C  INCID   INCIDENCE VECTOR MONITORING WHICH COMPONENTS HAVE TO BE PLOTT
C            0  NO PLOTTING OF COMPONENT
C            1  COMPONENT IS TO BE PLOTTED
C  KPRINT  PRINTING OF INTERPOLATION VARIABLES
C            0  NO PRINTING
C            1  PRINTING
C  PTEXT   TEXT TO BE PLOTTED  (CHARACTER VARIABLE - MAXIMUM NUMBER OF
C          CHARACTERS  20)
C  LENGTH  NUMBER OF CHARACTERS OF TEXT
C  FACT    DECREASING (INCREASING) FACTOR FOR THE WHOLE PICTURE
C+ TAUMIN  MINIMUM TAU-VALUE TO BE PLOTTED (LEFT MARGIN VALUE)
C+ TAUMAX  MAXIMUM TAU-VALUE TO BE PLOTTED (RIGHT MARGIN VALUE)
C
C+ NOTE: IF TAUMIN .GE. TAUMAX IS SPECIFIED, TAUMIN AND TAUMAX WILL
C+       BE DETERMINED FROM THE EXTREMAL VALUES OF THE DATA READ
C+       FROM UNIT UDIAG
C
C  TYPES OF POINTS DISTINGUISHED BY PLTHM
C  THE TYPES 0-3 ARE USED BY ALL ALCON ROUTINES
C  THE TYPES 0-4 REQUIRE INFORMATION AS SUPPORTED BY THE ALCON ROUTINES
C  THE TYPES 5-6 ONLY REQUIRE VALUES (X,TAU)
C  THE TYPE  7   IS USED BY ALCONB
C
C  ITYP=0  STANDARD POINT       SYMBOL  3
C  ITYP=1  BIFURCATION POINT    SYMBOL  6
C  ITYP=2  OFFSET               SYMBOL  3
C  ITYP=3  TURNING POINT        SYMBOL  5
C  ITYP=4  INTERPOLATION POINT  NO SYMBOL
C  ITYP=5  EXTERNAL POINT       SYMBOL  4
C  ITYP=6  SCALING POINT        NO SYMBOL
C  ITYP=7  B-POINT              SYMBOL  5
C          STABLE B-POINT   ADD SYMBOL  1
C
C
C  COMMONS
C
C  COMMON /UNIT/ UPR,UDIAG
C    FILE UNITS
C    - UPR     PRINT UNIT (STANDARD UNIT 6)
C    - UDIAG   PLOT DATA UNIT (STANDARD UNIT 2)
C              DISC FILE WITH CARD IMAGE  TO BE DECLARED BY THE USER
C  COMMON /PLTR/ UPLTR
C    PLOTTER
C    - UPLTR   TYPE OF PLOTTER  (NOTE THAT PLOT SOFTWARE DEPENDS
C              ON THE PRESENT INSTALLATION  THEREFORE SOME PLOT COMMANDS
C              MAY NEED ADAPTATION TO THE PARTICULAR SITUATION)
C              (STANDARD PLOTTER 0)
C  COMMON /DATS/ SIGMA,THR,LMODE
C    REAL CONSTANTS
C    - SIGMA   PLOT ACCURACY (STANDARD VALUE 0.01)
C    - THR     THRESHOLD FOR SWITCHING TO LINEAR INTERPOLATION
C              IN CASE OF CUBIC HERMITE INTERPOLATION BEING NOT
C              SUITED IN THE CORRESPONDING INTERVAL
C              (NOTE THAT FOR EACH INTERPOLATION INSTRUCTION
C              THERE IS DATA SUCH THAT THAT KIND OF INTERPOLATION
C              IS NOT SATISFACTORY)
C              (STANDARD VALUE 0.5)
C    LOGICAL CONSTANTS
C    - LMODE   LOGARITHMIC SCALE FOR STATE VARIABLES
C              (STANDARD IS .FALSE.)
C
C
C  PLOT SOFTWARE
C
C  PLOTS    INITIALIZATION OF PLOT  OPENING OF PLOT FILE
C  PNUMAT   NEW ORIGIN
C  FINIM    NEW ORIGIN
C  RAHMEN   PLOTTING OF A BOX
C  AXIS2    PLOTTING OF AN AXIS
C  SYMBL4   PLOTTING OF A SYMBOL OR TEXT STRING
C  NUMBER   PLOTTING OF A NUMBER
C  PLOT     MOVING TO A POINT WITH PEN UP OR DOWN
C  FINTRA   CLOSING OF PLOT FILE
C
C---------------------------------------------------------------------
C*    End Prologue
      DIMENSION X(999),XW(999),DX(999)
      INTEGER IPLTN,I, TEXT(5)
      INTEGER UPR,UDIAG
      INTEGER UPLTR
      REAL XPORG,YPORG,XSZ
      LOGICAL LMODE,INIT,NOREST,INBOX
      COMMON /UNIT/ UPR,UDIAG
      COMMON /PLTR/ UPLTR
      COMMON /DATS/ SIGMA,THR,LMODE
      CALL ZITEXT(1,IBL,'    ')
      SMALL = 1.0E-5
      SMALIN = 1.0E0 / SMALL
      CALL ZITEXT(5,TEXT,PTEXT)
      N1=N+1
      IPLTN = 1
      DO 10,I=1,N
10    IPLTN = IPLTN+INCID(I)
      XSZ = (INT((IPLTN-1)/3)+1)*21.0 + 4.0
      CALL PLOTRS(XSZ,73.0,UPLTR)
      ICLOSE=1
      CALL FACTR2(FACT)
C     CALL PNUMAT(0.,0.,NB,12.5,-3.)
      SIGMAX=0.
      XPORG = 4.0
      YPORG = 4.0
      NOREST=.FALSE.
      IF (TAUMAX.LE.TAUMIN) NOREST=.TRUE.
C  LOOP OVER ALL COMPONENTS
      DO 5000 I=1,N
      IF (INCID(I).EQ.0) GOTO 5000
      INIT=.FALSE.
C  LOOP OVER ALL DATA
      DO 1099 J=1,9999
      READ(UDIAG,80001,END=1999) ITYP,IB,IF,IS,SIG0
      IF (ITYP.LE.4)
     &   READ(UDIAG,80002) (X(L),L=1,N1),(DX(L),L=1,N1),(XW(L),L=1,N1)
      IF (ITYP.GE.5)
     &   READ(UDIAG,80002) (X(L),L=1,N1)
      TAU=X(N1)
C  COMPUTE SCALING MINIMUM AND MAXIMUM
      IF ( NOREST ) GOTO 1000
      IF ( TAU.LT.TAUMIN .OR. TAU.GT.TAUMAX ) GOTO 1099
1000  JQ=J
      IF (LMODE) THEN
      DO 1001 L=1,N
      X(L)=ALOG10(X(L))
1001  CONTINUE
      END IF
      IF (ITYP.NE.7) IHOM=IB
      IF (INIT) GOTO 1002
      TAUMX2=TAU
      TAUMN2=TAU
      XIMAX=X(I)
      XIMIN=X(I)
      INIT=.TRUE.
1002  CONTINUE
      XIMIN=AMIN1(XIMIN,X(I))
      XIMAX=AMAX1(XIMAX,X(I))
      TAUMN2=AMIN1(TAUMN2,TAU)
      TAUMX2=AMAX1(TAUMX2,TAU)
      SIGMAX=AMAX1(SIGMAX,SIG0)
1099  CONTINUE
1999  CONTINUE
      TAUMIN = TAUMN2
      TAUMAX = TAUMX2
      BACKSPACE UDIAG
      BACKSPACE UDIAG
      REWIND UDIAG
      DELTAX=.1*(XIMAX-XIMIN)
      DELTAT=.1*(TAUMX2-TAUMN2)
C  SKIP NONVARYING COMPONENTS
      IF (DELTAX.EQ.0.) GOTO 5000
C  PLOT BOX AND AXISES
C     CALL FINIM(16.,0.)
      CALL PLORG(XPORG,YPORG)
      CALL RAHMEN(-1.2,-1.2,11.,11.)
      CALL AXIS2(0.,0.,'TAU',-3,10.,0.,TAUMN2,DELTAT)
      CALL AXIS2(0.,0.,' ',1,-10.,90.,XIMIN,DELTAX)
      CALL SYMBL4(-0.75,5.,.35,90.,'X',1)
      IF (LMODE) CALL SYMBL4(-2.,3.5,.35,90.,'LOG',3)
      FI=FLOAT(I)
      CALL NUMBRF(-0.6,5.35,.21,FI,90.,-1)
      LENGTH=MIN0(LENGTH,20)
      XPQ=10.-.5*FLOAT(LENGTH)
      YPQ=11.5
      IF (LENGTH.GT.0) CALL SYMBL4(XPQ,YPQ,.5,0.,TEXT,LENGTH)
C  LOOP OVER ALL DATA
      DO 3099 J=1,9999
      READ(UDIAG,80001,END=3999) ITYP,IB,IF,IS,SIG0
      IF (J.EQ.1) IHOMA=IHOM
      IF (ITYP.NE.7) IHOM=IB
C  REENTRY IN READ
3001  CONTINUE
      IF (ITYP.LE.4)
     &   READ(UDIAG,80002) (X(L),L=1,N1),(DX(L),L=1,N1),(XW(L),L=1,N1)
      IF (ITYP.GE.5)
     &   READ(UDIAG,80002) (X(L),L=1,N1)
      TAU=X(N1)
      IF (LMODE) THEN
      DO 3002 L=1,N
      X(L)=ALOG10(X(L))
3002  CONTINUE
      END IF
C  NO DRAWING TO NEW OFFSET
      IF (ITYP.EQ.2) GOTO 3040
C  ONLY MARKING FOR EXTERNAL POINT OR B-POINT
      IF (ITYP.EQ.5 .OR. ITYP.EQ.7) GOTO 3051
C  SKIP SCALING VALUES
      IF (ITYP.EQ.6) GOTO 3099
C  SET VALUES FOR END OF INTERVAL
      X1=X(IHOMA)
      IF (IHOMA.EQ.N1) X1=(X1-TAUMN2)/DELTAT
      IF (IHOMA.NE.N1) X1=(X1-XIMIN)/DELTAX
      F1=(X(I)-XIMIN)/DELTAX
      F1H=(TAU-TAUMN2)/DELTAT
      F1P=DX(I)/DX(IHOMA)*XW(I)/XW(IHOMA)/DELTAX
      IF (IHOMA.EQ.N1) F1P=F1P*DELTAT
      IF (IHOMA.NE.N1) F1P=F1P*DELTAX
      F1PH=DX(N1)/DX(IHOMA)*XW(N1)/XW(IHOMA)/DELTAT
      IF (IHOMA.EQ.N1) F1PH=F1PH*DELTAT
      IF (IHOMA.NE.N1) F1PH=F1PH*DELTAX
      IF (.NOT.INBOX .AND. (F1H.LT.0.0 .OR. F1H.GT.10.0) ) GOTO 3040
C  SET VALUES FOR INTERPOLATING FUNCTION
      H=X1-X0
      A=2.*(F0-F1)+H*(F0P+F1P)
      B=-3.*(F0-F1)-H*(2.*F0P+F1P)
      C=H*F0P
      AH=2.*(F0H-F1H)+H*(F0PH+F1PH)
      BH=-3.*(F0H-F1H)-H*(2.*F0PH+F1PH)
      CH=H*F0PH
C  SKIP IN CASE OF ZERO STEP
      IF (H.EQ.0.D0) GOTO 3039
C  ESTIMATE NUMBER OF PLOT POINTS
      HMAX=ABS(H)
      IF (A.EQ.0. .AND. B.EQ.0.) GOTO 3011
      HMAX=SQRT(8.*SIGMA/AMAX1(ABS(6.*A+2.*B),ABS(2.*B)))
3011  CONTINUE
      IF (AH.EQ.0. .AND. BH.EQ.0.) GOTO 3012
      HMAX=AMIN1(HMAX,SQRT(8.*SIGMA/AMAX1(ABS(6.*AH+2.*BH),ABS(2.*BH))))
3012  CONTINUE
C  TRY ANOTHER PARAMETRIZATION IN CASE OF HIGH CURVATURE
      IF (IHOM.EQ.IHOMA .OR. AMAX1(ABS(A),ABS(AH)).LT.THR) GOTO 3029
      ITYP=2
      ICO=0
3021  BACKSPACE UDIAG
      READ(UDIAG,80003) IHS
      IF (IHS.NE.IBL) ICO=ICO+1
      IF (ICO.EQ.2) GOTO 3001
      BACKSPACE UDIAG
      GOTO 3021
3029  CONTINUE
      IPOINT=INT(ABS(H)/HMAX)+3
      IF (LMODE .OR. INTER.EQ.0 .OR. ABS(A).GT.THR .OR. ABS(AH).GT.THR)
     &   IPOINT=1
      IF (KPRINT.EQ.1)
     &   WRITE(UPR,60001) IHOMA,X0,X1,F0,F1,F0P,F1P,F0H,F1H,F0PH,F1PH,
     &   A,B,C,AH,BH,CH,IPOINT
      HPOINT=H/FLOAT(IPOINT)
C  PLOT INTERPOLATION FUNCTION
      DO 3031 IP=1,IPOINT
      Z=IP*HPOINT/H
      XP=FLOAT(INT((F0H+Z*(CH+Z*(BH+Z*AH)))*SMALIN))*SMALL
      YP=F0+Z*(C+Z*(B+Z*A))
      IF (XP.GE.0.0 .AND. XP.LE.10.0) THEN
         IF (INBOX) THEN
            CALL PLOTR(XP,YP,2)
         ELSE
            CALL PLOTR(XP,YP,3)
            INBOX=.TRUE.
         ENDIF
      ELSE
         INBOX=.FALSE.
      ENDIF
3031  CONTINUE
3039  CONTINUE
C  MARKING OF INTERNAL POINTS
      IF (ITYP.EQ.0 .AND. MARK.EQ.2) CALL SYMBL4(XP,YP,.21,0.,3,-1)
      IF (ITYP.EQ.1 .AND. MARK.GE.1) CALL SYMBL4(XP,YP,.21,0.,6,-1)
      IF (ITYP.EQ.3 .AND. TURN.EQ.1) CALL SYMBL4(XP,YP,.21,0.,5,-1)
      CALL PLOTR(XP,YP,3)
3040  CONTINUE
      XP=FLOAT(INT((TAU-TAUMN2)/DELTAT*SMALIN))*SMALL
      YP=(X(I)-XIMIN)/DELTAX
      IF (ITYP.NE.2 .AND. IHOM.EQ.IHOMA) GOTO 3041
C  SET VALUES FOR BEGINNING OF INTERVAL
      X0=X(IHOM)
      IF (IHOM.EQ.N1) X0=(X0-TAUMN2)/DELTAT
      IF (IHOM.NE.N1) X0=(X0-XIMIN)/DELTAX
      F0=(X(I)-XIMIN)/DELTAX
      F0H=(TAU-TAUMN2)/DELTAT
      F0P=DX(I)/DX(IHOM)*XW(I)/XW(IHOM)/DELTAX
      IF (IHOM.EQ.N1) F0P=F0P*DELTAT
      IF (IHOM.NE.N1) F0P=F0P*DELTAX
      F0PH=DX(N1)/DX(IHOM)*XW(N1)/XW(IHOM)/DELTAT
      IF (IHOM.EQ.N1) F0PH=F0PH*DELTAT
      IF (IHOM.NE.N1) F0PH=F0PH*DELTAX
      GOTO 3042
3041  CONTINUE
C  BEGIN NEW BRANCH
      X0=X1
      F0=F1
      F0H=F1H
      F0P=F1P
      F0PH=F1PH
3042  CONTINUE
      IHOMA=IHOM
      IF (XP.GE.0.0 .AND. XP.LE.10.0) THEN
         IF (ITYP.LE.2 .AND. MARK.EQ.2) CALL SYMBL4(XP,YP,.21,0.,3,-1)
         CALL PLOTR(XP,YP,3)
         INBOX=.TRUE.
      ELSE
         INBOX=.FALSE.
      ENDIF
      GOTO 3099
C  MARKING OF EXTERNAL POINTS
3051  CONTINUE
      IF ( TAU.LT.TAUMIN .OR. TAU.GT.TAUMAX ) GOTO 3099
      XPQ=(TAU-TAUMN2)/DELTAT
      YPQ=(X(I)-XIMIN)/DELTAX
      IF (ITYP.EQ.5 .AND. EXT.EQ.1) CALL SYMBL4(XPQ,YPQ,.21,0.,4,-1)
      IF (ITYP.EQ.7) THEN
      XPQ=XPQ-0.21*FLOAT(IF)-0.03
      YPQ=YPQ-0.1
      IF (IB.LT.0) CALL SYMBL4(XPQ,YPQ,.14,0.,'-',1)
      IF (IB.EQ.0) CALL SYMBL4(XPQ,YPQ,.14,0.,'0',1)
      IF (IB.GT.0) CALL SYMBL4(XPQ,YPQ,.14,0.,'+',1)
      END IF
      CALL PLOTR(XP,YP,3)
3099  CONTINUE
3999  CONTINUE
      BACKSPACE UDIAG
      BACKSPACE UDIAG
      REWIND UDIAG
      IF ( UPLTR .EQ. -1230 ) THEN
        YPORG = YPORG + 21.0
        IF ( YPORG .GE. 58.0 ) THEN
          XPORG = XPORG +21.0
          YPORG =4.0
        ENDIF
      ELSE
        CALL FINTRA
        ICLOSE=0
        IF (I.NE.N) THEN
           WRITE (6,81001)
           READ (5,81002) DMYCHR
           CALL PLOTRS(XSZ,73.0,UPLTR)
           ICLOSE=1
           CALL FACTR2(FACT)
        ENDIF
      ENDIF
5000  CONTINUE
      IF (SIGMAX.EQ.0.) GOTO 9000
      IF (UPLTR.NE.-1230) THEN
         WRITE (6,81001)
         READ (5,81002) DMYCHR
         CALL PLOTRS(XSZ,73.0,UPLTR)
         ICLOSE=1
         CALL FACTR2(FACT)
      ENDIF
      DELTAS=.1*SIGMAX
C     CALL FINIM(16.,0.)
      CALL PLORG(XPORG,YPORG)
      CALL RAHMEN(-3.,-3.,15.,15.)
      CALL AXIS2(0.,0.,'TAU',-3,10.,0.,TAUMN2,DELTAT)
      CALL AXIS2(0.,0.,'SIGMA',5,-10.,90.,0.,DELTAS)
      DO 5020 J=1,9999
      READ(UDIAG,80001,END=9000) ITYP,IB,IF,IS,SIG0
      IF (ITYP.LE.4)
     &   READ(UDIAG,80002) (X(L),L=1,N1),(DX(L),L=1,N1),(XW(L),L=1,N1)
      IF (ITYP.GE.5)
     &   READ(UDIAG,80002) (X(L),L=1,N1)
      TAU=X(N1)
      IF (TAU.LT.TAUMIN .OR. TAU.GT.TAUMAX) GOTO 5020
      IF (ITYP.NE.7) GOTO 5020
      IF (IB.EQ.0) GOTO 5020
      XP=FLOAT(INT((TAU-TAUMN2)/DELTAT*SMALIN))*SMALL
      YP=SIG0/DELTAS
      CALL PLOTR(XP,0.,3)
      CALL PLOTR(XP,10.,2)
      CALL PLOTR(XP,YP,3)
      XPQ=XP+0.3*FLOAT(IF)
      CALL PLOTR(XPQ,YP,2)
      CALL SYMBL4(XP,YP,.21,0.,5,-1)
      IF (IS.EQ.1) CALL SYMBL4(XP,YP,.21,0.,1,-1)
      XPQ=XP-0.21*FLOAT(IF)-0.03
      YPQ=YP-0.1
      IF (IB.LT.0) CALL SYMBL4(XPQ,YPQ,.14,0.,'-',1)
      IF (IB.GT.0) CALL SYMBL4(XPQ,YPQ,.14,0.,'+',1)
5020  CONTINUE
9000  CONTINUE
      IF (ICLOSE.EQ.1) CALL FINTRA
      STOP
60001 FORMAT('0IHOM',I12/' X0  ',D12.3,'   X1  ',D12.3/
     1   ' F0  ',D12.3,'   F1  ',D12.3/
     2   ' F0P ',D12.3,'   F1P ',D12.3/
     3   ' F0H ',D12.3,'   F1H ',D12.3/
     4   ' F0HP',D12.3,'   F1HP',D12.3/
     5   ' A   ',D12.3,'   B   ',D12.3,'   C   ',D12.3/
     6   ' AH  ',D12.3,'   BH  ',D12.3,'   CH  ',D12.3/,' IP  ',I12)
80001 FORMAT(I1,3I4,E18.10)
80002 FORMAT(4E18.10)
80003 FORMAT(A1)
81001 FORMAT(' CLEAR SCREEN AND ENTER SOME CHAR FOR NEXT PICTURE')
81002 FORMAT(A1)
      END
      BLOCK DATA
      INTEGER UPR,UDIAG
      INTEGER UPLTR
      LOGICAL LMODE
      COMMON /UNIT/ UPR,UDIAG
      COMMON /PLTR/ UPLTR
      COMMON /DATS/ SIGMA,THR,LMODE
      DATA UPR/6/,UDIAG/2/
      DATA UPLTR/0/
      DATA SIGMA/0.01/,THR/0.5/,LMODE/.FALSE./
      END
C
C   PLOT RELATIVE (RELATED TO XORG,YORG)
C
      SUBROUTINE PLOTR(X,Y,ITYP)
      REAL X,Y,XORG,YORG,XH,YH,XYFACT
      INTEGER ITYP
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XH = X+XORG
      YH = Y+YORG
      CALL PLOT(XH,YH,ITYP)
      RETURN
      END
C
C   INITIALIZE PLOT-RELATIVE ROUTINES
C
      SUBROUTINE PLOTRS(XMAX,YMAX,IPAR)
      REAL XMAX,YMAX,XORG,YORG,XHMAX,YHMAX,XYFACT
      INTEGER IPAR,IHPAR
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XORG = 0.0
      YORG = 0.0
      XYFACT = 1.0
      XHMAX = XMAX
      YHMAX = YMAX
      IHPAR=IABS(IPAR)
      IF ( IHPAR .EQ. 2648 ) THEN
C  HP2648A
        XHMAX = MIN( XHMAX, 25.4 )
        YHMAX = MIN( YHMAX, 12.7 )
      ELSE IF ( IHPAR .EQ. 40121 ) THEN
C  IBM PC COMPATIBLE WITH CGA
        XHMAX = MIN( XHMAX, 21.5 )
        YHMAX = MIN( YHMAX, 16.1 )
      ELSE IF ( IHPAR .EQ. 40122 ) THEN
C  IBM PC COMPATIBLE WITH EGA
        XHMAX = MIN( XHMAX, 21.5 )
        YHMAX = MIN( YHMAX, 16.1 )
      ELSE IF ( IHPAR .EQ. 1230 ) THEN
C  BENSON 1230 PEN PLOTTER
        XHMAX = MIN( XHMAX, 150.0 )
        YHMAX = MIN( YHMAX,  73.0 )
      ELSE IF ( IHPAR .EQ. 5232 ) THEN
C  BENSON 5232 PIXEL PLOTTER
        XHMAX = MIN( XHMAX,  36.9 )
        YHMAX = MIN( YHMAX,  25.4 )
      ELSE IF ( IHPAR .EQ. 3279 ) THEN
C  IBM 3279 GRAPHIC TERMINAL
        XHMAX = MIN( XHMAX,  24.6 )
        YHMAX = MIN( YHMAX,  17.5 )
      ELSE IF ( IHPAR .EQ. 101 .OR. IHPAR .EQ. 103 )THEN
C  POSTSCRIPT FILE A4 (NORMAL)
        XHMAX = MIN( XHMAX,  18.8 )
        YHMAX = MIN( YHMAX,  27.5 )
      ELSE IF ( IHPAR .EQ. 102 .OR. IHPAR .EQ. 104 ) THEN
C  POSTSCRIPT FILE A4 (TURNED)
        XHMAX = MIN( XHMAX,  27.5 )
        YHMAX = MIN( YHMAX,  18.8 )
      ELSE IF ( IHPAR .EQ. 74754) THEN
C  HP7475 A4
        XHMAX = MIN( XHMAX,  27.4 )
        YHMAX = MIN( YHMAX,  19.2 )
      ELSE IF ( IHPAR .EQ. 74753) THEN
C  HP7475 A3
        XHMAX = MIN( XHMAX,  40.2 )
        YHMAX = MIN( YHMAX,  27.4 )
      ELSE IF ( IHPAR .GE. 3100 .AND. IHPAR .LE. 3211 ) THEN
C  ANY SUN WORKSTATION
        XHMAX = MIN( XHMAX,  29.3 )
        YHMAX = MIN( YHMAX,  22.5 )
      ELSE IF ( IPAR.GT.0 .AND. IPAR.LE.99 ) THEN
C  METAFILE
        XHMAX = MIN( XHMAX,  29.3 )
        YHMAX = MIN( YHMAX,  22.5 )
      ENDIF
C
      IHPAR=IPAR
      CALL PLOTS(XHMAX,YHMAX,IHPAR)
      RETURN
      END
C
C   SET NEW ORIGIN
C
      SUBROUTINE PLORG(X,Y)
      REAL X,Y,XORG,YORG,XYFACT
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XORG = X
      YORG = Y
      RETURN
      END
C
C   DRAW A BOX
C
      SUBROUTINE RAHMEN(XMIN,YMIN,XMAX,YMAX)
      REAL XMIN,YMIN,XMAX,YMAX,XORG,YORG,XHMIN,XHMAX,YHMIN,YHMAX,XYFACT
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XHMIN = XMIN+XORG
      XHMAX = XMAX+XORG
      YHMIN = YMIN+YORG
      YHMAX = YMAX+YORG
      CALL PLOT(XHMIN,YHMIN,3)
      CALL PLOT(XHMAX,YHMIN,2)
      CALL PLOT(XHMAX,YHMAX,2)
      CALL PLOT(XHMIN,YHMAX,2)
      CALL PLOT(XHMIN,YHMIN,2)
      RETURN
      END
C
C   DRAW AN AXIS
C
      SUBROUTINE AXIS2(XSTRT,YSTRT,TEXT,TXTLEN,AXLEN,ANGLE,AXMIN,AXSTEP)
      REAL XSTRT,YSTRT,XORG,YORG,XHSTRT,YHSTRT,AXLEN,ANGLE,AXMIN,AXSTEP,
     &     XYFACT
      INTEGER TXTLEN,ITEXT(20)
      CHARACTER*80 TEXT
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XHSTRT = XSTRT+XORG
      YHSTRT = YSTRT+YORG
      CALL ZITEXT(20,ITEXT,TEXT)
      CALL AXIS(XHSTRT,YHSTRT,ITEXT,TXTLEN,AXLEN,ANGLE,AXMIN,AXSTEP)
      RETURN
      END
C
C   DRAW A SYMBOL
C
      SUBROUTINE SYMBL4(XSTRT,YSTRT,HEIGHT,ANGLE,TEXT,TXTLEN)
      REAL XSTRT,YSTRT,XORG,YORG,XHSTRT,YHSTRT,ANGLE,HEIGHT,XYFACT,
     &     HHEIGH
      INTEGER TXTLEN,ITEXT(20)
      CHARACTER*80 TEXT
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XHSTRT = XSTRT+XORG
      YHSTRT = YSTRT+YORG
      HHEIGH = HEIGHT*XYFACT
      CALL ZITEXT(20,ITEXT,TEXT)
      CALL SYMBOL(XHSTRT,YHSTRT,HHEIGH,ITEXT,ANGLE,TXTLEN)
      RETURN
      END
C
C   PLOT A NUMBER
C
      SUBROUTINE NUMBRF(XSTRT,YSTRT,HEIGHT,NBR,ANGLE,NTYP)
      REAL XSTRT,YSTRT,XORG,YORG,XHSTRT,YHSTRT,ANGLE,HEIGHT,XYFACT,
     &     NBR,NTYP,HHEIGH
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XHSTRT = XSTRT+XORG
      YHSTRT = YSTRT+YORG
      HHEIGH = HEIGHT*XYFACT
      CALL NUMBER(XHSTRT,YHSTRT,HHEIGH,NBR,ANGLE,NTYP)
      RETURN
      END
C
C   SET FACTOR FOR X AND Y
C
      SUBROUTINE FACTR2(FACT)
      REAL FACT,XORG,YORG,XYFACT
      COMMON /PLSTAT/ XORG,YORG,XYFACT
      XYFACT = FACT
      CALL FACTOR(XYFACT)
      RETURN
      END
C
C   CLOSE PLOTFILE
C
      SUBROUTINE FINTRA
      CALL PLOT( 0.0, 0.0, 999)
      RETURN
      END
      SUBROUTINE ZITEXT(IANZ,ITEXT,TEXT)
      INTEGER IANZ,ITEXT(IANZ)
      CHARACTER*(*) TEXT
      DO 10 I=1,IANZ
        ITEXT(I)=0
        DO 11 J=1,4
          IH = 4*(I-1)+J
          ITEXT(I)=ITEXT(I)+ICHAR(TEXT(IH:IH))*256**(4-J)
11      CONTINUE
10    CONTINUE
      RETURN
      END
