      PROGRAM MAINBQ
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     ------------------------------------------------------------
C
C     Testexample for BVPLSQ: Herrmann/Berndt.
C
C*  Purpose           Testexample for code BVPLSQ
C*  Version           0.6 (Test Version)
C*  Revision          January 1991
C*  Latest Change     January 1991
C*  Library           CodeLib
C*  Code              Fortran 77, Double Precision
C*  Environment       Standard Fortran 77 environment on PC's,
C                     workstations and hosts.
C
C     ------------------------------------------------------------
C
      DIMENSION Y(2,21),X(21),RW(600),IW(20)
      COMMON /WERT/ ALAM,PI
      COMMON /COUNT/ NSTEP,NFCN
      EXTERNAL F,BC,DIFEX1
      INTEGER I2W(1),NI2W
      NI2W=1
C
      PI=4.D0*DATAN(1.D0)
      NFCN=0
C
C  SET SHOOTING NODES
      DO 1 J=1,20
1     X(J)=DBLE(J-1)*0.050D0
      X(21)=1.D0
C
C  SET ODE DIMENSION AND NUMBER OF NODES
      N=2
      NBC=2
      M=21
C
C  SET INITIAL GUESS FOR TRAJECTORY
      DO 10 J=1,M
      Y(1,J)=0.D0
10    Y(2,J)=0.D0
C
      ALAM=100.D0
      A=ALAM
      WRITE(6,92) ALAM
92    FORMAT(///'0*************   ALAM  ***************',F6.2/)
      ALAM=ALAM*ALAM
C
C  SET REMAINING INPUT PARAMETERS FOR BVPLSQ
C  ERROR TOLERANCE
      EPS=1.D-6
C  MAXIMUM NUMBER OF ITERATIONS
      ITMAX=1
C  PRINT PARAMETER
      IPRINT=1
C  PARAMETER INDICATING THE PROBLEM TO BE SOLVED IS LINEAR OR NONLINEAR
      NONLIN=0
C  DIMENSION OF REAL WORKSPACE PROVIDED
      NRW=600
C  DIMENSION OF INTEGER WORKSPACE PROVIDED
      NIW=20
C
      WRITE(6,780)
 780  FORMAT('0***********   DIFEX1   ********************************')
C
      CALL BVPLSQ (F,BC,DIFEX1,N,NBC,M,X,Y,EPS,ITMAX,
     @                    IPRINT,NONLIN,NRW,RW,NIW,IW,NI2W,I2W)
C
      WRITE(6,800)NFCN
800    FORMAT(//,' FEV: ',I7)
      STOP
      END
C
      SUBROUTINE F(X,Y,DY)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C  PROBLEM: HERMANN/BERNDT REFERENCE: RWPM:  A MULTIPLE SHOOTING CODE
      DIMENSION Y(2),DY(2)
      COMMON /WERT/ ALAM,PI
      XH=PI*X
      PI2=PI*PI
      PI2=2.D0*PI2
      CSQ=DCOS(XH)
      CSQ=CSQ*CSQ
      CS1=DCOS(XH+XH)
      CS1=PI2*CS1
      DY(1)=Y(2)
      DY(2)=ALAM*(Y(1)+CSQ)+CS1
      RETURN
      END
C
      SUBROUTINE BC (YA,YB,R)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C  PROBLEM: HERMANN/BERNDT
      DIMENSION YA(2),YB(2),R(2)
      COMMON /W/ A
      R(1)=YA(1)
      R(2)=YB(1)
      RETURN
      END
C
