/*****
 *
 *
 * File: cellscr.h
 *
 * Cellular automata simulator
 * Includes, definitions, and variable declarations/definitions.
 *
 *
 *****/


/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



/*****
 *
 * Includes
 *
 *****/

#include <pixrect/pixrect_hs.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <varargs.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "cell.def"
/* #include "cell.param" */


/*****
 *
 * Defines
 *
 *****/

#define POP_DISP_LEN 32
#define pan_lmargin 10
#define pan_lvalue 70
#define pan_2nd_lmargin 100
#define pan_2nd_lvalue 160
#define pan_hspace 100
#define pan_tmargin 10
#define pan_vspace 20
#define pan_ncols 2
#define NUM_MSGS 8
#define pan_small_hspace 80
#define pan_small_ncols 3

#define MODE_EDIT	0
#define MODE_PROBE	1
#define MODE_PLANEEDIT	2

/* colormap stuff */
#define CLEN 8				/* length in bits of one color value */
#define CMASK 0xFF			/* mask of CLEN bits */
#define CMAPLEN 256			/* length of colormap */



/*****
 *
 * Typedefs
 *
 *****/

typedef unsigned char ((*func_ptr)());
typedef unsigned char byte;


/*****
 *
 * Functions callable from the control panel
 *
 *****/

/*** Run menu ***/
extern int
    run_proc(), skip_run_proc(), bound_run_proc(), sb_run_proc(),
    screenful_proc(), step_proc(), skip_proc(), run_local_proc(),
    step_local_proc();

/*** Defaults menu ***/
int
    toggle_save_in_image_dir_proc(), toggle_save_images_compressed(),
    toggle_auto_image_change_proc(), toggle_save_in_LT_dir_proc(),
    toggle_save_LT_compressed(), toggle_auto_nhood_change_proc(),
    toggle_save_in_cmap_dir_proc(), FB_toggle(), Sun_disp_toggle();

extern int
    set_image_dir(), set_table_dir(), set_fcn_dir(), set_cmap_dir(),
    CM_change_host(),
    CM_change_port(), CM_change_delay_proc(), CM_disp_interval_proc(),
    CM_image_dir_proc(), CM_fcn_dir_proc(), CM_LT_dir_proc(),
    CM_set_zoom(), CM_set_pan(),
    change_stuff_proc(), change_image_size_proc(), chdir_proc();
    

/*** Image menu ***/
extern int
    iload(), isave_proc(), iload_resize(), isave_resize(),
    isave_raster(), iload_CAM6(), isave_CAM6(), ienter(), iclear(),
    iswap(), icopy(), iinvert();

/*** Rules menu ***/
extern int
    load_rule(), tsave_proc(), tclear_proc(), talter(),
    tgenerate(), lambda_proc(), lambda_step_proc(),
    rho_proc(), edit_parm1(), edit_parm2();
int
    tsymmetry();

/*** Buffer menu ***/
extern int
    bload(), bsave(), bswap(), bxor(), bor(), band();

/*** Clear menu ***/
extern int
    clear_proc(), CM_clear(), zero_proc();

/*** Learn menu ***/
extern int
    learn_proc();

/*** Set menu ***/
extern int
    set_proc();

/*** Zoom menu ***/
extern int
    zoom_proc(), magnify_proc();

/*** Closeup menu ***/
extern int
    closeup_proc();

/*** Zoom in & out menus */
extern int
    zoom_in_proc(), zoom_out_proc();

/*** Draw menu ***/
extern int
    quick_random_proc(), general_random_proc(), horiz_line_proc(),
    vert_line_proc(), arb_line_proc(), hollow_circ_proc(), shaded_circ_proc();

/*** Color menu ***/
int
    cmap_load(), cmap_save_proc(), cmap_alter();

/*** Planes menu ***/
int
    plane_reset_proc(), plane_display_proc();
extern int
    pclear(), pinvert();

/*** CM menu ***/
extern int
    CM_connect(), CM_send_image(), CM_get_image_proc(), CM_send_LT(),
    CM_send_cmap(), CM_disconnect(), CM_load_image_proc(),
    CM_load_rule_proc(), CM_quick_random_proc(), CM_general_random_proc();

/*** Sequence menu ***/
extern int
    sequence1_proc(), sequence2_proc(), sequence3_proc(), sequence4_proc(),
    sequence5_proc();

/*** Quit menu ***/
int
    quit_proc();

/*** Shift buttons ***/
extern int
    right_proc(), left_proc(), up_proc(), down_proc(), shift_proc();


/*****
 *
 * Various external functions
 *
 *****/
extern int
    CM_set_displays(),
    add_sequence(),
    expand_fname();


/*****
 *
 * External variables
 *
 *****/

extern byte
    save_images_compressed, save_LT_compressed;

extern byte
    *ca;

extern struct pixrect
    *ca_handle;

extern int
    stime,
    closeup, side, MAXSIZE, xstart, ystart, table_symmetry, mag,
    save_in_image_dir, save_in_LT_dir, save_in_cmap_dir,
    use_FB, use_Sun_disp, blackwhite, saved_mag_factor,
    use_CM, drawing, function, saved_xinc, saved_yinc,
    CM_zoom, CM_delay, CM_panx, CM_pany;

extern short
    AMASK, ABASE, NHOOD, B, S, L, R, stop_on_mode, setting_sequence;

extern unsigned short
    CM_port;

extern char
    saved_rule_file[], saved_image_file[], Image_dir[], Table_dir[],
    Fcn_dir[], Cmap_dir[], CM_hostname[], CM_image_dir[], CM_fcn_dir[],
    CM_LT_dir[];

 

/*****
 *
 * Local routines
 *
 *****/

static int
    defaults_image_menu_proc(), defaults_rule_menu_proc(),
    defaults_cmap_menu_proc(), defaults_CM_menu_proc(),
    mode_proc(), stop_on_proc(), screen_event_proc(),
    do_first_item_proc(), button_event_proc(), menu_notify_proc();
int
    display_image();	/* well, this is visible to other modules as well */

static int
    def_im_popup_proc(), def_rule_popup_proc(), def_cmap_popup_proc(),
    def_CM_popup_proc();
static void
    def_im_done_proc(), def_rule_done_proc(), def_cmap_done_proc(),
    def_CM_done_proc(), CM_send_zoom_proc(), CM_send_panx_proc(),
    CM_send_pany_proc();

/*****
 *
 * Local variables
 *
 *****/

static Frame
    frame, popup, def_im_popup, def_rule_popup, def_cmap_popup, def_CM_popup;

static Canvas
    canvas;

static Pixwin
    *pw, *window_pw, *panel_pw;

static struct pixrect
    *tmpmag = NULL;

static Panel
    panel, pop_panel, def_im_panel, def_rule_panel, def_cmap_panel,
    def_CM_panel;

static Panel_item
    defaults_button, pan_time, pan_pos, pan_state, pan_planes, pan_mode,
    pan_msg[NUM_MSGS], pan_stop_on, pop_input,
    def_im_save_item, def_im_compress_item, def_im_imagedir_item,
    def_im_autochange_item,
    def_rule_save_item, def_rule_compress_item, def_rule_tabledir_item,
    def_rule_fcndir_item, def_rule_autochange_item,
    def_cmap_save_item, def_cmap_compress_item, def_cmap_cmapdir_item,
    def_CM_host_item, def_CM_port_item, def_CM_rundelay_item,
    def_CM_display_item, def_CM_imagedir_item, def_CM_fcndir_item,
    def_CM_LTdir_item, def_CM_zoom_item, def_CM_panx_item, def_CM_pany_item;

static Panel_setting
    return_proc();

static Menu
    rules_menu, defaults_menu, image_menu, CM_menu,
    defaults_image_menu, defaults_rule_menu, defaults_fcn_menu,
    defaults_cmap_menu, defaults_CM_menu, edit_menu, probe_menu,
    planeedit_menu;

static Inputmask
    frame_mask, panel_mask, canvas_mask;

static int
    saved_cmap_entry = 0, curr_color = 1, msg_line = 0, curr_planemask = 1,
    screen_mode = MODE_EDIT, prow = 0, pcol = 0,
    color[CMAPLEN], color2[CMAPLEN], rule_shown;

static char
    saved_display_mask[BUFLEN],
    saved_cmap_file[BUFLEN],
    cmap_name[BUFLEN], cmap_name2[BUFLEN], cmap_name3[BUFLEN],
    buf1[BUFLEN], buf2[BUFLEN];

byte save_cmap_compressed;

static Icon icon;



static byte
    red[CMAPLEN], green[CMAPLEN], blue[CMAPLEN];



/*****
 *
 * Variables visible to other modules (globals)
 *
 *****/

int
    auto_nhood_change, auto_image_change;


/*****
 *
 * Really ugly SunView stuff
 *
 *****/

static short icon_image[] = {
#include "cell.icon"
};
mpr_static(icon_pixrect, 64, 64, 1, icon_image);

Cursor  cursor;				/* cursor variables */
static short cursor_image[] = {
    0x0000, 0x0000, 0x0000, 0x1818, 0x1818, 0x0660, 0x0660, 0x0180,
    0x0180, 0x0660, 0x0660, 0x1818, 0x1818, 0x0000, 0x0000, 0x0000
};
mpr_static(cursor_pixrect, 16, 16, 1, cursor_image);


static short texture_images[CMAPLEN][16] = {
    {
#include "t0.cursor"
    }, {
#include "t1.cursor"
    }, {
#include "t2.cursor"
    }, {
#include "t3.cursor"
    }, {
#include "t4.cursor"
    }, {
#include "t5.cursor"
    }, {
#include "t6.cursor"
    }, {
#include "t7.cursor"
    }, {
#include "t8.cursor"
    }, {
#include "t9.cursor"
    }, {
#include "t10.cursor"
    }, {
#include "t11.cursor"
    }, {
#include "t12.cursor"
    }, {
#include "t13.cursor"
    }, {
#include "t14.cursor"
    }, {
#include "t15.cursor"
    }
};

struct mpr_data data[CMAPLEN] = {
    {mpr_linebytes(16,1), (short *)texture_images[0], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[1], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[2], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[3], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[4], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[5], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[6], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[7], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[8], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[9], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[10], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[11], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[12], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[13], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[14], {0, 0}, 0, 0},
    {mpr_linebytes(16,1), (short *)texture_images[15], {0, 0}, 0, 0}
};


static struct pixrect textures_pr[CMAPLEN] = {
    {&mem_ops, 16, 16, 1, (caddr_t)&data[0]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[1]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[2]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[3]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[4]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[5]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[6]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[7]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[8]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[9]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[10]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[11]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[12]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[13]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[14]},
    {&mem_ops, 16, 16, 1, (caddr_t)&data[15]}
};
    

#define two_item_cycle(panel, label, string1, string2, x, y) \
   panel_create_item(panel,\
   PANEL_CYCLE, PANEL_LABEL_STRING, label,\
   PANEL_CHOICE_STRINGS, string1, string2, 0,\
   PANEL_ITEM_X, ATTR_COL(x), PANEL_ITEM_Y, ATTR_ROW(y),\
   0);

