#line 1/*ACE 4 0145 */
/*
 * this Source text originates from Dirk Haun and
 * was further developed by Holger Weets
 */
#ifdef SOZOBON
#include <gemfast.h>
#include <errno.h>

/*
 * AV-Meldungen
 */
#define AV_PROTOKOLL        0x4700
#define AV_SENDKEY          0x4710
#define VA_START            0x4711
#define AV_STARTPROG        0x4722
#define VA_PROGSTART        0x4723
#define AV_ACCWINDOPEN      0x4724
#define VA_DRAGACCWIND      0x4725
#define AV_ACCWINDCLOSED    0x4726
#define  Pexec(mode,prog,tail,env) gemdos(75,mode,prog,tail,env)

extern int _argc;
extern char **_argv;
_main()
{
	_exit(main(_argc, _argv));
}
#else
/* Pure-C */
#include <aes.h>
#include <tos.h>
#include <errors.h>
#include <vaproto.h>
#endif


int main(argc, argv)
int argc;
char **argv;
{
	int event, viewer, gl_apid, open, msg[8];
	int ret;
	int d, buf[8];
	char cmd[150], *p;

start:
	ret=0;
	if (argc==2) {
		if ((gl_apid=appl_init())<0)
			return(ENSMEM);

		/*
		 * ACC search: ST-Guide, 1stGuide and 1stView in this
		 * order
		 */
		viewer=appl_find("ST-GUIDE");
		if (viewer<0) viewer=appl_find("1STGUIDE");
		if (viewer<0) viewer=appl_find("1STVIEW ");
		if (viewer<0)
			ret=EFILNF;                     // No ACC installed
		else {

			/*
			 * Message for ACC to work on
			 */
			msg[0]=VA_START;
			msg[1]=gl_apid;
			msg[2]=0;
			*(char **)&msg[3] = argv[1];    // Command
			msg[5]=0; msg[6]=0; msg[7]=0;

			/*
			 * ACC activate
			 */
			appl_write(viewer,16,msg);

			/*
			 * wait, until ACC opens, or timeout
			 */
			do {
				event = evnt_multi(MU_TIMER|MU_MESAG,
									0, 0, 0,
									0,0,0,0,0,
									0,0,0,0,0,
									buf, 2000, 0,
									&d, &d, &d, &d, &d, &d);
				if (event & MU_TIMER) break;
			} while (buf[0] != AV_ACCWINDOPEN);

			/*
			 * wenn Timeout, dann haben wir
			 * hier nichts mehr zu tun
			 */
			if (event & MU_TIMER)
				ret=EFILNF;
			else {

				/*
				 * ACC ist now open. Also count how many
				 * windows are still open, and abort,
				 * as soon as the last one is closed
				 */
				open=1;
				do {
					event = evnt_multi(MU_MESAG,
										0, 0, 0,
										0,0,0,0,0,
										0,0,0,0,0,
										buf, 0, 0,
										&d, &d, &d, &d, &d, &d);
					if (event & MU_MESAG) {
						if (buf[0] == AV_ACCWINDCLOSED)
							/* one window fewer */
							open--;
						else if (buf[0] == AV_ACCWINDOPEN)
							/* one window more */
							open++;
						else if (buf[0] == AV_STARTPROG) {
							/*
							 * Program may be started:
							 *
							 * Command line to call programm
							 * initialise
							 */
							p = *(char **)&buf[5];
							if (p) {
								strcpy(cmd+1, p);
								*cmd = strlen(p);
							}
							else {
								*cmd = 0;
							}
							/*
							 * Here we must determine whether,
							 * we're dealing with a TOS 
							 * or GEM Application...
							 */
							shel_write(1, 1, 1, *(char **)&buf[3], cmd);
							open = 0;

							/*
							 * this pleases me better,
							 * luft aber bei mir nicht
							 * (ACC was not closed)
							 * How come?
							 */
#                           if 0
								appl_exit();
								ret = Pexec(0, *(char **)&buf[3],
											cmd,
											0L);
								return(ret);
#                           endif
						}
					}
				} while (open>0);
			}
		}
		appl_exit();
	}
	else
		ret=ENMFIL;
	return(ret);
}
