/**************************************************/
/*                                                */
/*  H E L P F I L E - D E C O M P I L E R  V 1.0  */
/*                                                */
/*  Headerfile HELP_RC.H                          */
/*                                                */
/*  Author: Volker Reichel                        */
/*         Bhlstrae 8                           */
/*         7507 Pfinztal 2                        */
/*                                                */
/*  Last change: 31.01.1992                       */
/**************************************************/


/*---------- General constants----------------*/
#define EOS        0x00
#define CR         0x0d
#define LF         0x0a
#define ESC_CHR    0x1d
#define BACKSLASH  '\\'

/*---------- For the output of messages -------*/
#define TO_SCREEN   0x01
#define TO_LOG      0x02
#define TO_ALL      (TO_SCREEN + TO_LOG)

#define NO_RAM          0
#define ILL_OPT         1
#define LOG_OPN_ERR     2
#define HLP_NF          3
#define NO_HF           4
#define HDR_SIZE_ERR    5
#define RD_SENS_TAB     6
#define RD_CAPS_TAB     7
#define RD_SCR_TAB      8
#define RD_SCR_ERR      9
#define RD_STR_TAB      10
#define RD_STR_ERR      11
#define RD_IDX          12
#define RD_IDX_ERR      13
#define SET_ATTR        14
#define SET_LINK        15
#define DECOMP          16
#define DECOMP_ERR      17
#define F_CREAT_ERR     18
#define FINAL           19
#define SCR_CNT         20
#define IDX_WARN        21
#define WR_NAME_TAB     22
#define WR_LINK_TAB     23
#define LINK_HEAD       24
#define LINK_CNT        25
#define ILL_CODE        26
#define ABORT           27
#define GLB_REF         28
#define NAME_TAB_HEAD   29
#define NAME_CNT        30
#define OPTION          31
#define MAKETEXT        32
#define HELP_RC1        33
#define HELP_RC2        34
#define HELP_RC3        35

#define BOLD_ON         "\033E"
#define BOLD_OFF        "\033F"
#define FORM_FEED       "\f"

/*------ Constants for memory allocation ---------*/
#define TXTBUFSIZE      0x8000L
#define MAXCODEDSIZE    0x4000L

/*------ Constants for the decoding process ------*/
#define CHAR_DIR   0x0C
#define STR_TABLE  0x0E

/*-------- HC-version-dependent constants --------*/
#define INDEX_SCR   1   /* 2nd entry ScreenTab    */
#define HC_VERS "H2.0"  /* Help compiler version  */
#define INDEX_CNT   27  /* Entries in INDEX       */

/*----------- Attributes of a name ---------------*/
#define SCR_NAME    0             /* ScreenName   */
#define CAP_SENS    1 /* Caps/l.c. discrimination */ 
#define SENSITIVE   2   /* No discrimination      */
#define LINK        3     /* is a \link-name      */
#define ATTR_CNT    4   /* Number of attributes   */

/*--------- Types of search-word tables ----------*/
#define CAP_TABLE   0
#define SENS_TABLE  1

/*------ Header structure of a help-file ---------*/

#define HEADER_SIZE  0x30  /* Length of header    */

typedef struct {
  long scr_tab_size; /* Length of screen table    */
  long str_offset;   /* String-table start        */
  long str_size;              /* Length in bytes  */
  UBYTE char_table[12];  /* Most common character */
  long caps_offset;    /* Start capsens-Table     */
  long caps_size;             /* Length in Bytes  */
  long caps_cnt;           /* No. of search-words */
  long sens_offset;    /* Start sensitive-Tab.    */
  long sens_size;             /* Length in bytes  */
  long sens_cnt;           /* No. of search-words */
} HLPHDR;


/*--------- Description of an Index entry --------*/
typedef UWORD 
SUB_IDX_ENTRY;

/*----------- Description of a name --------------*/
typedef struct name_entry {
  UWORD scr_code;       /* Index-Code ScreenTab   */
  UBYTE name_attr;      /* Attribute of the name  */
  char  *name;          /* The name itself        */
  UWORD link_index;     /* link-Index ScreenTab   */
  struct name_entry *next;        /* Follower     */
} NAME_ENTRY;

/*--------- Structure of the Keyword-Tables ---------*/
typedef struct {
  ULONG pos;  /* Word-start for current position+pos */
  UWORD code;       /* Word has this coding          */
} SRCHKEY_ENTRY;
 
/*------------------ End of HELP_RC.H ---------------*/
