 
 (* -----------------------------------------------------
#Modula Compiler  /4.0 /  fuer Atari  V#144
#-----------------------------------------------------
 
#File mc2: Input/Output Routinen
 
#29. 9.85  hey  Anpassung an GDOS 1.3
#17.10.85       Konstante PhysBlk1 gibt Anzahl Header-Blocks in Textfiles an;
2Auswertung von AutoCommand, ErrorFile
#20.10.85       Auswahl des Textfiles durch FileSelect
#21.02.86       mehr Platz reserviert in LoadDef
#22.02.86       Neuordnung der Texte
#26.02.86       ESC bei CodeOutputVol-Angabe bricht ab;
2CodeName nach Run-Command ohne Suffix uebergeben;
2Ruecksetzen von CnSufx und DnSufx fuer jede CompUnit neu
2(zur Tarnung in Clockstart!)
#27.02.86       Textnamen an Editor ohne Suffix uebergeben
#05.03.86       Default CodeVolume mit Namesplit gewinnen (GetSource);
2'.Text' als Default Suffix fuer Textfiles (OpFile)
3und Protokollfiles (OpenProt);
2Suche nach Textfiles beim Oeffnen (Open).
#07.03.86  TT   myfnlen auf 81, zwei mal statt LSL.W # 5 -> MULU #mylnlen+1
#23.03.86  TT   '...what text' -> '...which text'
#15.04.86       Text- und Definitionsmodule werden ReadOnly geoeffnet
#24.10.86  TT   8 Byte-Header wird nicht mehr erzeugt
#30.10.86       symbolische Fehlernummern, SyntaxErr nimmt negative
2Nummern MOD 256
#03.02.87  TT   MOVEM-Listen gendert und mehr...
#30.03.87  TT   Stop bei IO-Error, wenn keine Shell da; Include-Namen
2werden vollst. gerettet (80 Zeichen); Stripoptions korrig;
2ARGCV nicht mehr importiert.
#08.05.87  TT   Warning-Funktion impl.; RELOAD korrigiert pTxt...; FetchLine
2neu; Variablen-Protokoll (alles aus 'GepardIO')
#24.05.87  TT   'TextName' wird bei include/exclude aktualisiert
#26.06.87  TT   In Loaddef wird Dadr nicht mehr verndert, da schon in InitImp
2gesetzt.
#01.07.87  TT   IOERR zeigt Dateinamen an, OPEN sucht Dateien.
#04.07.87       in Fehlermeldungen wird fr '#' die StringVar 'BadID'
4substituiert; neue VAR BadID
#18.07.87  TT   Verschiedene Pathlisten fr Impl/Defn/Source; bei 'OPEN'
2wird immer gesucht, auch der Sourcename; Date/Time-Ausgaben
2wieder drin; Default Output-Volume ist immer erster Path
2in den Pathlists; Options mit '-' statt ';', '-O' fr
2outVol-Bestimmung.
#30.08.87  TT   c/i/dnSufx-Werte werden aus ShellMsg-Vars geholt
#27.10.87  jm   Atari: LoadDef erwartet und prft Namensfeld im DefModul
3(ab DefLayout 4)
#03.11.87  TT   Uses-Option geht wieder (makeName: D0-Abfrage erw.)
#16.11.87  jm   Auswertung von -Q als Kommandooption (= $Q+) ist
3schon drin (woher blo?)!
2bergabe von Zeile/Spalte an Editor vorbereitet:
3Zeile wird in TxtLine gezhlt und bei Include gerettet;
3Spalte wird aus Textpos. (A2) und pTxtLin-Pointer
3errechnet und nach TxtCol geschrieben (ErrorEntry).
3Zeile und Spalte zhlt ab Eins!
2Vor dem Buffer (BufDummy) steht jetzt CR & LF
3(erlaubt einheitliches Berechnen der SpaltenNr)
#17.11.87  jm   Ausgabe der Seriennummer
#15.12.87  jm   Seriennummer jetzt mit SerLead-Kennung
#22.12.87  TT   Text-I/O ber FileBase statt TextWindows, Ausgaberoutinen
3aus ConstEx hierher geholt
#03.01.88  TT   ForceAsk-Variable, damit kein infinite scanning
#16.01.88  TT   ProtLine kommt wieder mit zu grossen Zeilen klar.
#09.04.88  TT   Meldung, wenn 68020 Assembler.
#15.05.88  TT   In Definitionsmodulen sind wieder REAL-Consts mglich
2(LoadDef prft nur unteres Nibble v. Modulkennung).
#02.06.88  TT   Compiler kann Text auch im RAM bergeben werden. Dann sind
2includes nicht erlaubt (Abbruch mit Exitcode=4). (Siehe
2Var. 'fileMode').
#03.07.88  TT   LibFiles verwendet; "Illg. Pointer-Var" in TextWindows
2kommt nicht mehr bei Comp-Start (Window wurde nicht bei
2TermProcess richtig geschlossen)
#05.07.88  TT   LibFiles in Conditionals
#14.07.88  TT   closeIO-Aufruf nun ber ProcessTerm
#15.12.88  jm   ProtID (wie ProtVar, aber nur ID-Ausgabe. Kann alle
4benamsten IDs aus dem Baum verarbeiten)
#01.01.89       Versionsabgleich TT - jm, Version 3.6j
#13.05.89  TT   $U-Option berarbeitet - hat nun auch Vorrang vor Library
#12.07.89  TT   InOutBase.CloseWdw wird nur noch einmal am Ende aufgerufen.
#25.07.89  TT   GetNextLine f. singleLineMode neu; StripOptions verndert:
4Optionen werden nun mit '-', '+' o. '/' eingeleitet.
4'/L<name>' bestimmt nun Library.
#09.08.89  TT   Sourcename wird auch bei Text im RAM in den Code bernommen
#19.08.89  TT   DefLibName wird nicht gesucht; aus ShellMsg importiert.
#16.09.89  TT   Def-Module werden ggf. dekomprimiert.
#20.06.90  TT   SyntaxErr zeigt nun immer auf Beginn des zuletzt
2geholten Symbols
#09.07.90  TT   1/3 Gre des Textpuffers in der Konstante 'blocklen'; nun
2werden immer zwei Drittel des Puffers verschoben und nur
2jeweils eins nachgeladen.
#18.08.90  TT   ShellPath wird ggf. bei Protfile eingesetzt
#13.09.90  TT   UseFormat wird nun auch bei bergabe in Cmdline ausgewertet;
2Wird der gesamte Options-Wert als Long bergeben, wird
2IMMER UseFormat gesetzt, d.h, diese bergabeform ist nicht
2allg. anwendbar, weil normalerweise UseFormat unberhrt
2bleibt, solange kein $F vorkommt.
#09.11.90  TT   IEEE-Format nun mit "/F" in Cmdline bestimmbar
#15.03.91  TT   "source lines" werden nun nicht mehr zu kurz ausgegeben.
#14.07.91  TT   ID-Stack-Gre per Option "/In" festlegbar. Default: 2KB
#-----------------------------------------------------
 *)
 
 
 CONST
&fnlen = 80;      (* Laenge von FileName-Strings an GDOS *)
$myfnlen = 80;      (* Laenge der FileNames auf FNStack *)
#blocklen = 1024;    (* Ein Drittel des Textpuffers in Byte *)
 
"txtLSize = 264;
 
 TYPE Str132 = ARRAY [0..txtLSize-1] OF CHAR;
%Str127 = ARRAY [0..126] OF CHAR;
 
%tLinePtr = POINTER TO CHAR;
%LinePtrProc = PROCEDURE (): tLinePtr;
 
 VAR
&bufferStart: ADDRESS;
(bufferRes: ADDRESS;
)doOutput: BOOLEAN; (* FALSE: Keinen Bildschirm I/O ! *)
)fileMode: BOOLEAN; (* FALSE: Text im RAM v. Editor bergeben *)
#singleLineMode: BOOLEAN; (* TRUE: Zeilen sind von auen verkettet *)
#singleLineProc: LinePtrProc;
 
 (*
)bufDummy: word;     (* TextBuffer; Dummy fuer fuehrendes CR *)
+buffer: ARRAY [0..$1FF] OF word;
*buffer1: ARRAY [0..$1FF] OF word;
+bufres: ARRAY [0..$1FF] OF word;
+bufend: word;     (* muss bleiben ! Hlt normlwse. EOF ! *)
 *)
 
-eot : BOOLEAN;
,flen,             (* dieser Wert mu global erhalten bleiben! *)
+flen3,             (* lokaler Wert *)
+flen2 : LONGCARD;  (* lokaler Wert *)
*byread : LONGCARD;
 
'
'tmpOutVol,
*outVol,
'srcVolume,            (* source input volume *)
&implVolume,            (* impl output volume *)
'modVolume,            (* code output volume *)
&defnvolume: String;    (* defn output volume *)
&usesVolume: String;    (* volume, wenn $U-Option verwendet *)
)useSufx,            (* Suffix v. $E-Option *)
*dnSufx,            (* Suffix fuer DefModule *)
*inSufx,            (* Suffix fuer ImpModule *)
*cnSufx: ARRAY [0..3] OF CHAR;(* Suffix fr PrgModule mit 0C am Ende!*)
 
+pfile,            (* protfile *)
+dfile,            (* defn/codefile *)
+tfile: File;      (* textfile *)
 
-lib: BOOLEAN;
*deflib: LibFiles.LibFile;
(libentry: LibFiles.LibEntry;
)codebeg,
)codeend: address;   (* ZW end of codefile *)
*txtptr: address;   (* ZW fuer A2 *)
,dend,            (* ZW EndAdr des DefModul *)
,dadr: address;   (* ZW LadeAdr fuer DefModul *)
 
(questVol,
(ForceAsk,
'OpenError: boolean;   (* ZW fuer Open-Ergebnis *)
)
)fnstack: array [0..15] of string;
,fnsp: integer;   (* filename stack pointer *)
)
%txtOfsStack: array [0..15] of LONGCARD;
%linenostack: array [0..15] of cardinal;
'linenoptr: integer;   (* TextOffset / linenumber stack pointer *)
(
(inclevel: cardinal;
)inclptr: address;
)inclstk: array [0..31] of word;
)
)foundit: boolean;   (* Ergebnis von FileSearch *)
+paths: PathList;
)
'outoptstr,            (* String fr Options-Ausgabe *)
)LineBuf: Str132;    (* Eingaben v. Benutzer f. GetLine / ProtLine *)
*Comlin: POINTER TO Str127;
(startblk: cardinal;  (* erster gebufferter Block *)
/c: char;
-ior: Integer;   (* ZW fuer IOResult *)
 
+pname,            (* Name des ProtokollFiles *)
+cName,            (* Name von Code/DefnModulen *)
*c2Name,            (* Name von Code/DefnModulen *)
)libName,            (* Name von Libdatei *)
%currentText: String;    (* Name des gerade uebersetzten Files *)
'isInclude: boolean;   (* Flag fuer Open *)
+csize: LONGCARD;  (* Lnge des erzeugten Codes *)
 
*RelAdr: longcard;  (* rel. Adresse im Protokoll *)
(pcolumns: cardinal;  (* Anzahl Spalten fuer ProtokollFile *)
*nowStr: String;    (* fuer Protokoll-Titel *)
)seconds: cardinal;
+Today: Date;
'StartTime,
(StopTime,
-Now: Time;
)
*strVal: BOOLEAN;
*strPos: CARDINAL;
+strP2: INTEGER;
)
/i: CARDINAL;
)
(IOResult: Integer;
 
*errtxt: String;
.dr:CARDINAL;
 
#debugProcAddr: ADDRESS;
(TreeBase,
'DisplaySP: LONGCARD;
&LoSysStack,
&HiSysStack: ADDRESS;
-wsp: MemArea;
(tCarrier: TermCarrier;
%secondEnter: BOOLEAN;
 
 
 (*$l-*)
 
 VAR Errorfilename : String;
 
 PROCEDURE Write(c:CHAR);
"BEGIN
$ASSEMBLER
&MOVE    -(A3),D0
&TST     doOutput
&BEQ     noout
&MOVE    D0,(A3)+
&MOVE.L  InOutBase.Write,A0
&JMP     (A0)
$noout
$END
"END Write;
 
 PROCEDURE Read (VAR c:CHAR);
"BEGIN
$ASSEMBLER
&MOVE.L  -(A3),D0
&TST     doOutput
&BEQ     noout
&MOVE.L  D0,(A3)+
&MOVE.L  InOutBase.Read,A0
&JMP     (A0)
$noout
$END
"END Read;
 
 PROCEDURE WriteLn;
"BEGIN
$ASSEMBLER
&TST     doOutput
&BEQ     noout
&MOVE.L  InOutBase.WriteLn,A0
&JMP     (A0)
$noout
$END
"END WriteLn;
 
 PROCEDURE WriteString(c:ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
&MOVE    -(A3),D0
&MOVE.L  -(A3),D1
&TST     doOutput
&BEQ     noout
&MOVE.L  D1,(A3)+
&MOVE    D0,(A3)+
&MOVE.L  InOutBase.WriteString,A0
&JMP     (A0)
$noout
$END
"END WriteString;
 
 PROCEDURE ReadString(VAR c:ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
&MOVE    -(A3),D0
&MOVE.L  -(A3),D1
&TST     doOutput
&BEQ     noout
&MOVE.L  D1,(A3)+
&MOVE    D0,(A3)+
&MOVE.L  InOutBase.ReadString,A0
&JMP     (A0)
$noout
$END
"END ReadString;
 
 
 (*$l+ === Zuerst die reinen Modula-Prozeduren *)
 
 PROCEDURE writeLCard (lc:Longcard; n:CARDINAL);
"BEGIN
$WriteString (CardToStr(lc,n))
"END writeLCard;
 
 PROCEDURE conc (a,b:ARRAY OF CHAR):String;
"VAR c:String;
"BEGIN
$FastStrings.Concat (a,b,c);
$RETURN c
"END conc;
 
 PROCEDURE cop (VAR a:ARRAY OF CHAR; p,l:CARDINAL):Str132;
"VAR c:Str132;
"BEGIN
$FastStrings.Copy (a,p,l,c);
$RETURN c
"END cop;
 
 PROCEDURE StripOptions (VAR s: ARRAY OF CHAR; init: BOOLEAN);
 
"(* Optionen im String suchen, entfernen und auswerten
#*
#* 'init' = TRUE: Aufruf ganz zu Beginn, z.B. fr '/'-Optionen
#*
#* Alle Options werden mit einem Leerzeichen und dann +, - oder /
#* eingeleitet.
#* Options mit '-' oder '+' werden genau auf die entsprechenden
#*  Meta-Commands im Source (*$..*) abgebildet,
#* andere beginnen mit '/'.
#* '/<Zahl>' bernimmt den Wert in das OPTIONS-Longword
#*)
 
"VAR ch, modeCh,
+optCh: char;
'optString: String;
'wordStart,
/p: cardinal;
-eol: BOOLEAN;
/l: LONGCARD;
 
"PROCEDURE getCh (): BOOLEAN;
$BEGIN
&IF p > HIGH (s) THEN
(eol:= TRUE
&ELSIF NOT eol THEN
(ch:= s[p];
(INC (p);
(eol:= ch = 0C
&END;
&RETURN NOT eol
$END getCh;
 
"PROCEDURE getNoSpc (): BOOLEAN;
$BEGIN
&RETURN getCh () AND (ch > ' ');
$END getNoSpc;
 
"PROCEDURE getSpc (): BOOLEAN;
$BEGIN
&RETURN getCh () AND (ch <= ' ');
$END getSpc;
 
"PROCEDURE getWord ();
$BEGIN
&optString:= '';
&WHILE getNoSpc () DO
(FastStrings.Append (ch, optString);
&END;
$END getWord;
"
"PROCEDURE optstrout (REF s: ARRAY OF CHAR);
$BEGIN
&FastStrings.Append (' ', outoptstr);
&FastStrings.Append (s, outoptstr);
&FastStrings.Append (optString, outoptstr);
$END optstrout;
$
"BEGIN
$eol:= FALSE;
$p:= 0;
$LOOP
&REPEAT wordStart:= p UNTIL NOT getSpc ();
&IF eol THEN EXIT END;
&modeCh:= ch;
&getWord;
&IF (modeCh = "/") OR
&(NOT init AND ((modeCh = '-') OR (modeCh = '+')) ) THEN
(FastStrings.Delete (s, wordStart, p-wordStart);
(p:= wordStart;
(OptCh := cap (optString[0]);
(IF    modeCh = '+' THEN
*IF OptCh # 'Q' THEN optstrout ('+') END;
*ASSEMBLER
0MOVE.B  optCh(A6),D1
0SUBI.B  #64,D1
0BCS     ign
0CMPI.B  #31,D1
0BHI     ign
0CMPI.B  #6,D1
0BNE     noF
0; Bei +F UseFormat auf IEEE setzen
0MOVE    #1,GlobalUseFormat
.noF
0MOVE.L  OptToSetVar,D0
0BSET    D1,D0
0MOVE.L  D0,OptToSetVar
.ign
*END
(ELSIF modeCh = '-' THEN
*optstrout ('-');
*ASSEMBLER
0MOVE.B  optCh(A6),D1
0SUBI.B  #64,D1
0BCS     ign2
0CMPI.B  #31,D1
0BHI     ign2
0CMPI.B  #6,D1
0BNE     noF2
0; Bei -F UseFormat auf MM2 setzen
0CLR     GlobalUseFormat
.noF2
0MOVE.L  OptToSetVar,D0
0MOVE.L  OptToClrVar,D2
0BCLR    D1,D0
0BCLR    D1,D2
0MOVE.L  D0,OptToSetVar
0MOVE.L  D2,OptToClrVar
.ign2
*END
(ELSE
*(* Option mit '/' *)
*Delete (optstring, 0, 1, strVal);
*IF optCh='F' THEN (* IEEE-Format *)
,optstrout ('/F');
,GlobalUseFormat:= 2
*ELSIF optCh='A' THEN (* DATA-Puffergre *)
,strPos:= 0;
,l:= StrToLCard (optString,strPos,strVal);
,IF l >= 100 THEN DataLen:= l END
*ELSIF optCh='>' THEN (* mind. freizuhaltender Speicher *)
,strPos:= 0;
,l:= StrToLCard (optString,strPos,strVal);
,IF l >= 8192 THEN DynSpace:= l END
*ELSIF optCh='<' THEN (* max. zu belegender Speicher *)
,strPos:= 0;
,l:= StrToLCard (optString,strPos,strVal);
,IF l >= 64000 THEN MaxSpace:= l END
*ELSIF optCh='D' THEN (* debug procedure *)
,GetProcAddr (optString, debugProcAddr);
*ELSIF optCh='S' THEN
,HaltOnError:= TRUE
*ELSIF optCh='O' THEN
,optstrout ('Out:');
,FastStrings.Assign (optString, outVol);
*ELSIF optCh='L' THEN
,optstrout ('Lib:');
,FastStrings.Assign (optString, libName)
*ELSIF optCh='P' THEN
,optstrout ('Prot:');
,IF length (OptString) # 0 THEN pname:= optString END;
,ProtFile:= true
*ELSIF optCh='C' THEN
,strPos:= 0;
,p:= StrToCard (optString,strPos,strVal);
,IF p >= 40 THEN pcolumns:= p END
*ELSIF optCh='I' THEN
,strPos:= 0;
,l:= StrToLCard (optString,strPos,strVal);
,IF l > 2000 THEN IDStkSize:= l END
*ELSIF init & (optCh='Q') THEN
,doOutput:= FALSE;
*ELSIF init & (optCh='@') THEN
,(* Textpuffer vom Gepard-Editor im RAM *)
,strPos:= 0;
,bufferStart:= StrToLCard (optString,strPos,strVal);
,bufferRes:= $7FFFFFFF;
,IF strVal THEN
.fileMode:= FALSE;
.singleLineMode:= FALSE;
,END
*ELSIF init & (optCh='^') THEN
,(* Text kommt zeilenweise *)
,strPos:= 0;
,singleLineProc:= LinePtrProc (StrToLCard (optString,strPos,strVal));
,IF strVal THEN
.bufferStart:= 3L;
.bufferRes:= $7FFFFFFF;
.singleLineMode:= TRUE;
.fileMode:= FALSE
,END;
*ELSE
,strPos:= 0;
,l:= StrToLCard (optString,strPos,strVal);
,IF strVal THEN
.(* '/<Zahl>': Options-Wert (f. Scanning) direkt bernehmen *)
.ASSEMBLER
0CLR.L   OptToClrVar
0MOVE.L  l(A6),D0
0MOVE.L  D0,OptToSetVar
0; UseFormat auch setzen
0BTST    #6,D0
0SNE     D0
0ANDI    #1,D0
0MOVE    D0,GlobalUseFormat
.END
,END;
*END;
(END
&END;
$END;
"END StripOptions;
 
 PROCEDURE showError (VAR s:ARRAY OF CHAR);
"BEGIN
$IF (debugProcAddr # NIL) OR (~Active AND doOutput) THEN
&WriteLn;
&WriteString (s);
&WriteLn;
&WriteString ('Press a key...');
&IF debugProcAddr # NIL THEN
(WriteString (" ('D' to debug)");
&END;
&Read (c);
&IF debugProcAddr # NIL THEN
(IF CAP (c) # 'D' THEN debugProcAddr:= NIL END
&END
$END;
"END showError;
 
 PROCEDURE FindStr (REF text: ARRAY OF CHAR; start: ADDRESS; len: LONGCARD;
3VAR addr: ADDRESS): BOOLEAN;
"VAR found: BOOLEAN;
"BEGIN
$found:= FALSE;
$addr:= NIL;
$ASSEMBLER
(MOVE.L  start(A6),A1
(MOVE.L  len(A6),D1
(MOVE.L  text(A6),A0
(MOVE.B  (A0)+,D2
(BNE     los
(BRA     ende
%l1 SWAP    D1
%l2 CMP.B   (A1)+,D2
$los DBEQ    D1,l2
(BEQ     f1
(SWAP    D1
(DBRA    D1,l1
(BRA     ende
%f1 MOVE.L  A1,A2
(MOVE.W  text+4(A6),D0
(BEQ     hurra
(SUBQ    #1,D0
%f2 MOVE.B  (A0)+,D2
(BEQ     hurra
(CMP.B   (A1)+,D2
(DBNE    D0,f2
(BEQ     hurra
(MOVE.L  A2,A1
(MOVE.L  text(A6),A0
(MOVE.B  (A0)+,D2
(BRA     los
&hurra
(MOVE.L  start(A6),A0
(ADDA.L  len(A6),A0
(CMPA.L  A0,A1
(BHI     ende
(ADDQ    #1,found(A6)
(MOVE.L  addr(A6),A0
(SUBQ.L  #1,A2
(MOVE.L  A2,(A0)
&ende
$END;
$RETURN found
"END FindStr;
"
 
 (*$l- === Ab hier nur noch Link Off ! *)
 
 
 PROCEDURE ioerr;
#(* mit IO Error abbrechen; Fehler in ior *)
 BEGIN
"ASSEMBLER
(MOVE.L  EVALSTK,A3
"END;
"Files.GetStateMsg (ior,errtxt);
"ErrorMsg := conc ('I/O error: ',errtxt);
"foundit:=FALSE;
"IF State (tfile)<0 THEN
$errtxt:=CurrentText;
$foundit:=TRUE
"ELSIF State (dfile)<0 THEN
$Files.GetFileName (dfile,errtxt);
$IF errtxt[0] = 0C THEN
&FastStrings.Assign (cname, errtxt)
$END;
$foundit:=TRUE
"END;
"IF foundit & (errtxt[0] # 0C) THEN
$ErrorMsg:= conc (ErrorMsg,conc (', File: ',errtxt))
"END;
"Files.ResetState (tfile);
"Files.Close (tfile);
"Files.ResetState (dfile);
"Files.Remove (dfile);
"showError (ErrorMsg);
"TermProcess (2);
 END ioerr;
 
 
 PROCEDURE FetchLine;
"(* holt Zeile von (A2)+ nach (A0), ohne fhrende Spaces
%markiert Zeichen invers, wenn A2=D3
%A0 = ^Destination
%D2 = maximale Laenge (Abbruch nach Ueberschreiten)
%(A2,D0,D1)
"*)
 BEGIN ASSEMBLER
(CLR      D1
(SUBQ     #5,D2     ; wg. Ctrl-Zeichen
 !PF5    MOVE.B   (A2)+,D0
(BEQ      pf4
(CMPI.B   #SPC,D0
(BEQ      PF5       ;fuehrende Spaces weg
(CMPI.B   #DLE,D0
(BNE      PF1
(MOVE.B   (A2)+,D0
(SUBI.B   #$20+2,D0
(EXT.W    D0
(ADD.W    D0,TextCol     ; TextCol bei DLE korrigieren
(BRA      PF5
 pf4     TST.W    singleLineMode
(BEQ      pf5
(BRA      pf2
 Pf1     CMPI.B   #$D,D0
(BEQ      PF2
(CMPA.L   D3,A2
(BNE      noMark
(MOVE.B   #27,(A0)+
(MOVE.B   #'p',(A0)+
(MOVE.B   D0,(A0)+
(MOVE.B   #27,(A0)+
(MOVE.B   #'q',(A0)+
(ADDQ.W   #5,D1
(BRA      PF0
 noMark  MOVE.B   D0,(A0)+
(ADDQ.W   #1,D1
 PF0     MOVE.B   (A2)+,D0
(CMP      D2,D1
(BCS      PF1       ;D1 < D2
 !PF2    CMPA.L   D3,A2
(BNE      noMark2
(MOVE.B   #27,(A0)+
(MOVE.B   #'p',(A0)+
(MOVE.B   D0,(A0)+
(MOVE.B   #27,(A0)+
(MOVE.B   #'q',(A0)+
 noMark2 CLR.B    (A0)+
&END
 END FetchLine;
 
 
 PROCEDURE ErrorEntry;
"BEGIN
$ASSEMBLER
(; A1 & A6 hier nicht zerstren!
(MOVE.L  A1,TreeBase
(MOVE.L  A6,DisplaySP
(
(CMPI    #rEOInp,D5
(BNE     noComm
(TST.W   cmtLine
(BEQ     noComm
(
(MOVE.W  cmtCol,TextCol
(MOVE    cmtLine,TextLine
(CLR.B   errTxt
(BRA.W   cont
(
 noComm  TST.B   DoingAsm
(BEQ     noAsm
(
(MOVE.B  OprndCnt,D3
(SUBQ.B  #1,D3
(BCS     mne
(BEQ     op1
(SUBQ.B  #1,D3
(BEQ     op2
(MOVE.L  pTxtOp3,A2     ; Text-^ fr Operand 3
(BRA     warn
 op2     MOVE.L  pTxtOp2,A2     ; Text-^ fr Operand 2
(BRA     warn
 op1     MOVE.L  pTxtOp1,A2     ; Text-^ fr Operand 1
(BRA     warn
 mne     MOVE.L  pTxtMne,A2     ; Text-^ fr Mnemonic
 warn    MOVE.L  A2,pLastSym
(MOVE.L  pTxtLin2,pTxtLin
(MOVE.L  TxtLine2,TxtLine
(
&noAsm
(; da A2 ggf. in die Pampa zeigt, nehmen wir nun immer den
(; letzten GetSbl-Ptr.
(MOVE.L  pLastSym,A2
(
(MOVE.L  A2,D1
(SUB.L   pTxtLin,D1
(ADDQ    #1,D1
(MOVE.W  D1,TextCol
(MOVE    TxtLine,TextLine
(
(MOVE.L  A2,D3           ; Textpos. des Fehlers
(ADDQ.L  #1,D3
(MOVE.L  pTxtLin,A2      ; hier steht die Zeile
(LEA     errTxt,A0       ; hier soll sie hin
(MOVEQ   #75,D2          ; hchstens 75 Zeichen holen
(JSR     fetchLine       ; ! Korrgiert ggf. TextCol, wenn DLE drin
(
&cont
(TST     TextCol
(BGT     nnull
&null
(MOVE.W  #1,TextCol
&nnull
$END
"END ErrorEntry;
 
 (*
 PROCEDURE getNumb (var i:Convert.GetInfo);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A1
(SUBQ.L  #1,byread
(BPL     cont
(CLR.B   Convert.Getinfo.ch(A1)
(RTS
&cont
(MOVE.L  code,A0
(MOVE.B  (A0)+,Convert.Getinfo.ch(A1)
(ADDQ.L  #1,code
$END
"END getNumb;
 *)
 
 PROCEDURE syntaxerr;
#(* Fehler ans System melden,
&FehlerNr in D5 *)
 BEGIN
"ASSEMBLER
(TST.W   D5
(BPL     isPos
(AND.W   #255,D5
&isPos
(MOVE.W  D5,errornr
(
(TAS     secondEnter
(BNE     is2
(JSR     ErrorEntry
((* der VerifyWholeTree-Aufruf sollte feststellen, ob der akt. Fehler
)* wg. eines Fehlers im Baum auftrat. Das geht leider nicht so einfach,
)* weil u.U. der Fehler gemeldet wird, whrend gerade ein neuer
)* ID eingetragen wird, aber noch nicht vollst. ausgefllt wurde.
)* Dann steht u.U. noch Mll drin.
(CMPI    #rTree,errornr
(BEQ     is2
(JSR     VerifyWholeTree
(*)
#is2: MOVE.L  EVALSTK,A3
"END;
"Files.ResetState (tfile);
"Files.Close (tfile);
"Files.ResetState (dfile);
"Files.Remove (dfile);
"IF ErrorNr # 0 THEN
$(* kein scanning *)
$
$IF debugProcAddr # NIL THEN
&Write (27C); Write ('E'); (* clr scrn *)
$END;
$
$writeln; writeln;
$writestring (errTxt);
$writeln;
$
$(* Fehlermsg suchen in ErrorMsg-Datei *)
$dr:=0;
$
$SearchFile (ErrListFile,SrcPaths,fromStart,foundit,errtxt);
$Files.Open (tfile,errtxt,readOnly);
$IF State (tfile) >= 0 THEN
&ReadBytes (tfile,Header,symtre-Header,byread);
&Files.close (tfile);
$ELSE
&byread:= 0
$END;
$errtxt:= CardToStr (errornr,0);
$FastStrings.Append (':', errtxt);
$(* Suche nach "<errno>:" *)
$IF (byread # 0L) & (FindStr (errtxt, Header, byread, comlin)) THEN
&FastStrings.Assign (comlin^, errtxt);
&strP2:= Pos (CHR(13), errtxt, 0);
&IF strP2 >= 0 THEN errtxt[strP2]:= 0C END;
&Delete (errtxt, 0, Pos (':', errtxt, 0)+2, strVal); (* ': ' lschen *)
&FastStrings.Assign (errTxt,errormsg);
$ELSE
&errormsg := conc ('Compile error ', CardToStr (errornr,0))
$END;
$IF BadId [0] # 0C THEN
&strP2 := pos ('#', ErrorMsg, 0);
&IF strP2 >= 0 THEN
(Delete (ErrorMsg, strP2, 1, strVal);
(FastStrings.Insert (BadID, strP2, ErrorMsg)
&ELSE
(FastStrings.Append (' (', ErrorMsg);
(FastStrings.Append (BadId, ErrorMsg);
(FastStrings.Append (')', ErrorMsg);
&END;
$END;
$
$IF (debugProcAddr # NIL) OR ~Active THEN
&errormsg := conc (errormsg,conc (' in line ', CardToStr (TxtLine,0)) );
&errormsg := conc (errormsg,conc (', column ', CardToStr (TextCol,0)) );
$END;
$
$IF ProtFile THEN
&Text.writeln (pfile);
&Text.writestring (pfile, '>>> ');
&Text.writestring (pfile, errormsg);
&Text.writeln (pfile);
&Files.Close (pfile);
&ProtFile := false
$END;
$
$showError (ErrorMsg);
$
$IF debugProcAddr # NIL THEN
&ASSEMBLER
(MOVE.L  TreeBase,A1
(MOVE.L  DisplaySP,A0
(MOVE.L  RStkPtr,D0
(MOVE.L  debugProcAddr,A2
(JSR     (A2)
&END
$END;
$
$TermProcess (3)
"ELSE
$TermProcess (0) (* Scan erfolgreich *)
"END
 END syntaxerr;
 
 
 PROCEDURE crout;
"(* CR ausgeben *)
 BEGIN ASSEMBLER
(MOVEM.L A0-A6/D1-D7,-(A7)
(MOVE.L  EVALSTK,A3
(JSR     WRITELN
(MOVEM.L (A7)+,A0-A6/D1-D7
&END
 END crout;
(
(
 PROCEDURE byteout;
#(* D0 als ASCII ausgeben *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
(MOVE.B  D0,(A3)+
(ADDQ.L  #1,A3
(JSR     WRITE
(MOVEM.L (A7)+,D1-A6
&END
 END byteout;
 
 PROCEDURE prtlong;
#(* D1.long dezimal ausgeben *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
(MOVE.L  D1,(A3)+
(MOVE.W  #7,(A3)+
(JSR     WRITELCARD
(MOVEM.L (A7)+,D1-A6
&END
 END prtlong;
 
 PROCEDURE PRTSPC;
 BEGIN
 ASSEMBLER
%MOVEQ   #SPC,D0
%JMP     BYTEOUT
 END
 END PRTSPC;
 
 PROCEDURE strout;
#(* String in A0 ausgeben, MaxLen vorher in D0, danach Len in D0 *)
 BEGIN ASSEMBLER
(MOVEM.L D1-D2/A1-A2,-(A7)
(MOVE.L  EVALSTK,A3
(CLR     D1
(MOVE.L  A0,-(A7)
 ERR02   CMP     D1,D0
(BEQ     ERR01
(TST.B   (A0)+
(BEQ     ERR01
(ADDQ    #1,D1
(BRA     ERR02
 ERR01   MOVE.L  (A7),D2
(MOVE.L  D2,(A3)+
(SUBA.L  D2,A0
(MOVE.W  A0,-(A7)
(TST     D1
(BEQ     E3
(SUBQ    #1,D1
 E3      MOVE.W  D1,(A3)+
(JSR     WriteString
(MOVE.W  (A7)+,D0
(MOVE.L  (A7)+,A0
(MOVEM.L (A7)+,D1/D2/A1/A2
&END
 END strout;
 
 
 VAR  DECNUM: ARRAY [0..5] OF CHAR;
 
 PROCEDURE PRTDEC;
 BEGIN
 ASSEMBLER
)LEA     DECNUM,A0
)MOVE.L  #$20202020,(A0)
)MOVE.W  #$2000,4(A0)
)MOVEQ   #4,D2
 !PRTDEC1 DIVU    #10,D1
)SWAP    D1
)ORI.B   #'0',D1
)MOVE.B  D1,0(A0,D2.W)
)CLR.W   D1
)SWAP    D1
)DBEQ    D2,PRTDEC1
)MOVEQ   #-1,D0
)JMP     strout
 END
 END PRTDEC;
 
 
 PROCEDURE ERR;
 BEGIN
 ASSEMBLER
)JSR     CROUT
)JSR     CROUT
)JMP     PRTSTR
 END
 END ERR;
 
 
 PROCEDURE PRTSTR;
 BEGIN ASSEMBLER
(MOVE.L  (A7)+,A0
(MOVEQ   #-1,D0
(JSR     strOut
(ADDA.W  D0,A0
(MOVE.W  A0,D1
(BTST    #0,D1
(BEQ     ERR03
(ADDQ.L  #1,A0
 ERR03   MOVE.L  A0,-(A7)
&END
 END PRTSTR;
 
 PROCEDURE PRTID;
 BEGIN
 ASSEMBLER
)MOVE.W  OPTIONS,D0
)BTST    #1,D0         ;Q
)BNE     PRTID4        ;QUIET COMPILE
)JSR     CROUT
)MOVEQ   #14,D0
)JSR     strout
)SUB     #15,D0
)NEG     D0
)LEA     spcs(PC),A0
)JSR     strout
)MOVEQ   #'/',D0
)JSR     BYTEOUT
)MOVE.L  A1,D1
)ADD.L   TRESPC,D1
)SUB.L   A4,D1
)JSR     PRTLONG
)JSR     PRTSTR
)ACZ     ' bytes/'
)SYNC
)JSR     CROUT
)MOVEQ   #'<',D0
)JSR     BYTEOUT
)CLR.L   D1
)MOVE.W  LINE,D1
)JSR     PRTDEC
)MOVEQ   #'>',D0
)JMP     BYTEOUT
 spcs     ASC     '                '
 !PRTID4
 END
 END PRTID;
 
 
 PROCEDURE SUELZ;
 BEGIN
 ASSEMBLER
)JSR     CROUT
)JSR     CROUT
)JSR     PRTSPC
)CLR.L   D1
)MOVE.W  LINE,D1
)JSR     PRTDEC
)JSR     PRTSTR
)ACZ     ' source lines, '
)SYNC
)MOVE.L  A4,D1
)SUB.L   Header,D1
)JSR     PRTLONG
)JSR     PRTSTR
)ACZ     ' bytes of code'
)SYNC
)JMP     CROUT
 END
 END SUELZ;
 
 
 PROCEDURE getfn;
#(* FileName vom FnStack nach (A5)+ bringen.
&FN bleibt auch auf FnStack!
&(D0,A0,A5)
#*)
 BEGIN ASSEMBLER
(MOVE.W  FNsp,D0
(MULU    #myfnlen,D0     ;FileName is xx byte lang!
(LEA     FNSTACK,A0
(ADDA.W  D0,A0
(MOVEQ   #myfnlen-1,D0
 !LP     MOVE.B  (A0)+,(A5)+
(DBEQ    D0,LP
&END
 END getfn;
 
 
 PROCEDURE pullfn;
#(* 'vergisst' FileName vom FnStack *)
 BEGIN
"dec (fnsp)
 END pullfn;
 
(
 PROCEDURE FetchString;
"(* holt String von (A2)+ nach (A0),
%bricht bei Kommentarende ab!
%A0 = ^Destination
%D0 = zusaetzliches terminierendes Zeichen
%D2 = maximale Laenge (Abbruch nach Ueberschreiten)
%D1 := Laenge des Strings in char
%A2 := ^erstes nicht in den String uebernommenes Zeichen
%(D0, A2)
"*)
 BEGIN ASSEMBLER
(CLR.W    D1
(MOVE.B   D0,-(A7)  ;termChar
 !PF5    MOVE.B   (A2)+,D0
(CMPI.B   #SPC,D0
(BEQ      PF5       ;fuehrende Spaces weg
 !PF1    CMPI.B   #SPC,D0
(BLS      PF2       ;danach: spc/ctrl sind Endmarke
(CMPI.B   #$FE,D0   ;  ebenso $FE, $FF
(BCC      PF2
(CMPI.B   #',',D0   ;  und "," auch
(BEQ      PF2
(CMP.B    (A7),D0   ;  oder unser termChar
(BEQ      PF2
(CMPI.B   #'*',D0   ;  oder '*' mit folg. ')'
(BNE      PF4
(CMPI.B   #')',(A2)
(BEQ      PF2
 PF4     MOVE.B   D0,0(A0,D1.W)
(ADDQ.W   #1,D1
(MOVE.B   (A2)+,D0
(CMP.B    D2,D1
(BCS      PF1       ;D1 < D2
 !PF2    CMP.B    D2,D1
(BCC      PF3       ;D1 >= D2
(CLR.B    0(A0,D1.W)
 PF3     SUBQ.L   #1,A2
(ADDQ.L   #2,A7
&END
 END FetchString;
 
 PROCEDURE pushFN;
 (* holt FileName aus dem Text auf FnStack *)
 BEGIN ASSEMBLER
(MOVE.W   FNsp,D0
(ADDQ.W   #1,D0
(CMP.W    #15,D0
(BLS      OK
(MOVE     #rIncOv,D5
(JMP      SYNTAXERR
 !OK     MOVE.W   D0,FNsp
(MULU     #myfnlen,D0     ;xx byte FileNames
(LEA      FNSTACK,A0
(ADDA.W   D0,A0     ;Adresse auf FnStack
(MOVEQ    #myfnlen,D2 ; erlaubte Lnge. Mit Path und Suffix
(CLR.W    D0        ;kein Abbruchzeichen
(JSR      FetchString
&END
 END pushFN;
 
 PROCEDURE pullLineNo;
 BEGIN ASSEMBLER
(SUBQ    #1,LineNoPTR
(MOVE.W  LineNoPTR,D0
(ASL     #1,D0
(LEA     LineNoSTACK,A0
(MOVE    0(A0,D0.W),TxtLine
(ASL     #1,D0
(LEA     txtOfsStack,A0
(MOVE.L  0(A0,D0.W),TextOffset
&END
 END pullLineNo;
 
 PROCEDURE pushLineNo;
 BEGIN ASSEMBLER
(MOVE.W   lineNoPTR,D0
(ADDQ.W   #1,D0
(CMP.W    #15,D0
(BLS      OK
(MOVE     #rIncOv,D5
(JMP      SYNTAXERR
 !OK     MOVE.W   D0,lineNoPTR
(SUBQ.W   #1,D0
(ASL      #1,D0
(LEA      lineNoSTACK,A0
(MOVE     TxtLine,0(A0,D0.W)
(CLR.W    TxtLine
(ASL      #1,D0
(LEA      txtOfsStack,A0
(MOVE.L   TextOffset,0(A0,D0.W)
(CLR.L    TextOffset
&END
 END pushLineNo;
 
 
 PROCEDURE makename2;
#(* FileName von ID-Stack auf (A5).. bringen. (bleibt auf IDStack!)
&D5.B: Modul-Typ  (bestimmt den Suffix) (D0/D1, A0/A5),
&ist D5.B=0, wird gesamter Name ohne Suffix kopiert,
&ist Bit 15 in D5 gesetzt, wird ggf. useSufx benutzt, sonst nicht *)
 BEGIN ASSEMBLER
(;Prefix wird nicht mehr kopiert!
(JSR     LOOKID
(MOVEQ   #8,D2
(TST.B   D5
(BNE     wSuf
(MOVEQ   #80,D2
 wSuf    MOVE.L  A5,-(A7)
(CLR.W   D0        ;Name kopieren
 !MN4    MOVE.B  (A0)+,D1
(BEQ     MN5
(MOVE.B  D1,(A5)+
(ADDQ.B  #1,D0
(CMP.B   D2,D0
(BNE     MN4
 !MN5    CLR.B   (A5)
(TST.B   D5
(BEQ     noSuf
(MOVE.B  #'.',(A5)+
(TST.W   D5        ;Name f. csave?
(BPL     noCsave
(TST.B   useSufx   ;dann ggf. $E-Option verwenden
(BNE     eopt
 noCsave CMPI.B  #3,D5     ;DefModul?
(BEQ     MN6
(LEA     INSUFX,A0
(CMPI.B  #2,D5     ;ImpModul?
(BEQ     MN8
(LEA     CNSUFX,A0
(BRA     MN8
 eopt    LEA     useSufx,A0
(BRA     MN8
 !MN6    LEA     DNSUFX,A0 ;Suffix kopieren
 !MN8    MOVE.B  (A0)+,(A5)+
(BNE     mn8
 nosuf   MOVEA.L (A7)+,A5
"END
 END makename2;
 
 
 PROCEDURE close;
#(* Textfile schliessen, setzt Modula-Umgebung voraus *)
 BEGIN
"Files.ResetState (tfile);
"Files.Close (tfile);
"IOR := State (tfile);
"IF ior < 0 THEN
$ASSEMBLER
&MOVE.L  A3,EVALSTK
&JMP     IOERR
$END
"END
 END close;
 
 
 PROCEDURE Fread;
 BEGIN ASSEMBLER
(; D0: blocknr.
(MOVE.L  D1,-(A7)
(CLR     EOT
(MULU    #blocklen,D0    ; Anzahl Zeichen zu lesen
(MOVE    StartBlk,D1     ; 1. Block im Puffer
(ADDQ    #3,D1           ; D1: letzter Block + 1
(MULU    #blocklen,D1    ; Anzahl Zeichen, die inges. im File erwartet.
(SUB.L   flen,D1         ; Ist sie grer/gleich als fileLength ?
(BCS     noEof           ; Nein
(; EOF-Flag setzen, verbleibende Lnge auf Heap
(MOVE    #1,EOT
(SUB.L   D1,D0           ; die brigen Byte nicht laden
(BCC     NOEOF
(CLR.L   D0              ; Wir sind schon lngst am Ende !
 noEof   TST.L   D0
(BEQ     noRd
(MOVE.L  tfile,(A3)+
(MOVE.L  A0,(A3)+        ; Pufferadr.
(MOVE.L  D0,(A3)+
(MOVE.L  #byread,(A3)+
(JSR     ReadBytes
(MOVE.L  tfile,(A3)+
(JSR     State
(MOVE    -(A3),D0
(EXT.L   D0
(BMI     noRd
(MOVE.L  byread,D0
 noRd    MOVE.L  (A7)+,D1
(TST.L   D0
&END
 END Fread;
 
 
 PROCEDURE GetNextLine;
((* Setzt A2 auf nchsten Zeilenanfang, am Textende zeigt A2 auf EOF *)
"BEGIN
$ASSEMBLER
(MOVEM.L D1/D2/A0/A1/A3,-(A7)
(MOVE.L  singleLineProc,A0
(MOVE.L  EvalStk,A3
(JSR     (A0)
(MOVE.L  -(A3),A2
(ADDQ.L  #1,TextOffset         ; hochzhlen, um nderung zu kennzeichnen
(MOVEM.L (A7)+,D1/D2/A0/A1/A3
$END
"END GetNextLine;
 
 
 PROCEDURE open;
 
#(* Textfile oeffnen und erste Blocks einlesen,
&Name steht auf fnstack; setzt STARTBLK.
&Setzt Modula-Umgebung voraus!
&
&Setzt a2 := bufferStart
&
&D0 = "Print FileName to Screen"
&Ergebnis: D0 # 0 --> not found *)
 
 BEGIN ASSEMBLER
*MOVE.W  D0,isInclude
*LEA     currentText,A5
*JSR     GETFN
(END;
(paths:= SrcPaths;
(SearchFile (currenttext,paths,fromStart,foundit,currentText);
(fnStack [fnSp] := currentText;
(IF isInclude THEN
*writeln; writestring ('File ');
*writestring (currentText); Write (' ')
(END;
(Files.Open (tfile,currenttext, readOnly);
(IOResult := State(tfile);
(IF IOresult = 0 THEN
*FastStrings.Assign (currentText, TextName);
*flen := FileSize (tfile);
*IOResult := State(tfile)
(END;
(ASSEMBLER
(TST.W   IORESULT
(BMI.L   ERR0
(CLR     STARTBLK
(MOVEQ   #3,D0        ;alle drei Drittel lesen
(MOVE.L  bufferStart,A0
(ADDQ.L  #2,A0
(JSR     Fread
(MOVE.L  D0,D1
(BMI     freadnok
(CLR     D0
!freadnok
(MOVE    D0,IOResult
(BMI     Err0
(MOVE.L  bufferStart,A0
(MOVE.B  #EOF,2(A0,D1.W)
(TST     EOT
(BEQ     NoEOF
(JSR     CLOSE
 !NOEOF  MOVE.L  bufferStart,A2
(MOVE.B  #cr,(A2)
(MOVE.B  #lf,1(A2)
(CLR.W   D0
(RTS
 !ERR0   MOVEQ   #1,D0
&END
 END open;
 
 
 VAR     question: String; (* Parameter fuer OpFile *)
*SerVar: Cardinal;
 
 PROCEDURE OpFile;
 
"(* TextNamen erfragen und File oeffnen,
%setzt Modula-Umgebung voraus          *)
 
 BEGIN
"ASSEMBLER
*BRA    cont
$ser   DC.W   SerLead0, SerVal0   ;Seriennummer mu immer hinter
$cont  MOVE.W ser+2(pc),SerVar    ; der SerLead-Kennung stehen!
"END;
 
"OpenError := FALSE;
"LineBuf:= ''; questVol:= FALSE;
 
"Write (27C); Write (5C); (* Ctrl-E: Enhanced Output *)
"WriteString('Modula-2 Compiler ');
"writeLCard (CompilerVersion, 0);
"Write ('.');
"writeLCard (CompilerSubVersion, 0);
"IF LENGTH (internalVersion) > 0 THEN
$WriteString(internalVersion);
"END;
"(*$?~MAC: WriteString(' for Atari ST/TT'); *)
"(*$? MAC: WriteString(' for Apple Macintosh'); *)
"WriteString(' / Serial no. ');
"WriteString (CardToStr (SerVar, 0));
"WriteLn;
"(*$? Asm20:
$WriteString('Including 68020 & 68881 Assembler');
$WriteLn;
"*)
"WriteString('Copyright  [1985..1994]  Jrgen Mller, Thomas Tempelmann');
"WriteLn;
 
"ASSEMBLER
$CLR.W   TxtLine      ;Zeile innerhalb des Textfiles
$CLR.L   TextOffset   ;Offset innerhalb des Textfiles
"END;
 
"REPEAT
$FastStrings.Assign (comlin^, LineBuf);
$StripOptions (LineBuf, FALSE);
$IF OpenError OR (Length (LineBuf)=0) OR ForceAsk THEN
&IF NOT questVol THEN
(WriteLn;
(questVol:= TRUE;
&END;
&WriteString(question);
&Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
&ReadString(LineBuf);
&WriteLn;
&Write (27C); Write (5C); (* Ctrl-E: Enhanced Output *)
&IF length (LineBuf) = 0 THEN
(TermProcess (1)
&END;
&StripOptions (LineBuf, FALSE);
$END;
$Strings.EatSpaces (LineBuf);
$FastStrings.Assign (LineBuf,fnStack [fnSp]);
$IF fileMode THEN
&ASSEMBLER
(CLR.W   D0            ;hier bitte keinen FileName ausgeben
(JSR     OPEN
(MOVE.L  A2,txtPtr     ;A2 zeigt auf TextAnfang
(MOVE.W  D0,OpenError
&END;
$ELSE
&FastStrings.Assign (LineBuf, TextName);
&IF singleLineMode THEN
(ASSEMBLER
0JSR     GetNextLine
 
0; aus HandleCR:
0ADDQ.W  #1,txtLINE       ;ZEILEN im akt. Text ZAEHLEN
0MOVE.L  A2,pTxtLin
0
0MOVE.L  A2,txtPtr     ;A2 zeigt auf TextAnfang
0MOVE    #1,EOT
0CLR     OpenError
(END
&ELSE
(ASSEMBLER
0MOVE.L  bufferStart,A2
0
0; aus HandleCR:
0ADDQ.W  #1,txtLINE       ;ZEILEN im akt. Text ZAEHLEN
0MOVE.L  A2,pTxtLin
0
0MOVE.L  A2,txtPtr     ;A2 zeigt auf TextAnfang
0MOVE    #1,EOT
0CLR     OpenError
(END
&END
$END;
"UNTIL NOT OpenError OR NOT doOutput;
"FileNames.SplitPath ( TextName, srcVolume, c2name(*dummy*) );
"IF outoptstr[0] # '' THEN
$WriteLn;
$WriteString ('Directives:');
$WriteString (outoptstr);
$WriteLn;
"END
 END OpFile;
 
 
 PROCEDURE GetSourceName;
"(* Source-FileName und Destination Volume holen *)
 BEGIN  ASSEMBLER
*MOVEM.L D1-A1/A3-A6,-(A7)
*MOVE.L  EVALSTK,A3
(END;
(question := ' Compile which text? ';
(OpFile;
(ForceAsk:= TRUE;
(WriteLn;
(WriteString ('Compiling '); WriteString (currenttext); WriteLn;
(Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
(ASSEMBLER
*MOVE.L  A3,EVALSTK
*MOVE.L  txtPtr,A2
*MOVEM.L (A7)+,D1-A1/A3-A6
(END
 END GetSourceName;
 
 
 PROCEDURE GetSearchName;
"
"(* FileName fuer Runtime-Fehlersuche holen *)
 
 BEGIN  ASSEMBLER
*MOVEM.L D1-A1/A3-A6,-(A7)
*MOVE.L  EVALSTK,A3
(END;
(question := ' Scan which text? ';
(OpFile;
(ForceAsk:= TRUE;
(WriteLn;
(WriteString ('Scanning '); WriteString (currenttext); WriteLn;
(Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
(ASSEMBLER
*MOVE.L  A3,EVALSTK
*MOVE.L  txtPtr,A2
*MOVEM.L (A7)+,D1-A1/A3-A6
(END
 END GetSearchName;
 
 
 PROCEDURE csave;
"(* Save Codefile; Name ist auf ID-Stack.  *)
 BEGIN ASSEMBLER
(MOVE.L  Header,D0
(SUBQ.L  #8,D0         ; wegen "MM2Code" davor
(MOVE.L  D0,CODEBEG
(MOVE.L  A4,D1
(SUB.L   D0,D1
(MOVE.L  D1,csize
(MOVE.L  A4,CODEEND
(MOVEM.L D2-A6,-(A7)
(MOVE.L  EVALSTK,A3
(; cname (Dateiname) erstellen
(MOVE.W  IPFLAG,D5    ;Modul-Typ
(ORI     #$8000,D5    ;$E-Option zulassen
(LEA     cname,A5
(JSR     MAKENAME2
(
(; ShellMsg.ModuleName erstellen
(CLR     D5            ; kein Suffix
(LEA     ModuleName,A5
(JSR     MAKENAME2
(
(END;
(IF doOutput AND questVol THEN
*WriteLn;
*WriteString ('Output-volume? ');
*ReadString (outVol)
(END;
(IF outVol[0] = 0C THEN
*CASE ipflag OF
,1: tmpOutVol:= modVolume|
,2: tmpOutVol:= implVolume|
,3: tmpOutVol:= defnVolume
*END
(ELSE
*tmpOutVol:= outVol
(END;
(FileNames.ValidatePath (tmpOutVol);
(IF tmpOutVol[0] = 0C THEN
*FastStrings.Assign (srcVolume, tmpOutVol);
*(*
,IF tmpOutVol[0] = 0C THEN
.tmpOutVol:= '?' (* Damit wird dann der Fileselektor aufgerufen *)
,END
**)
(END;
(FastStrings.Insert (tmpOutVol, 0, cname);
(MakeFullName (cname,FALSE,strval);
(WriteLn;
(WriteString ('Writing to file: ');
(WriteString (cname);
(WriteLn;
(Files.Create (dfile,cname,writeOnly,replaceOld);
(IOResult := State (dfile);
(ASSEMBLER
(TST.W   IORESULT
(BMI     ERR0
(
(MOVE.L  dfile,(A3)+     ;File-Ptr
(MOVE.L  CODEBEG,A0
(MOVE.L  codeend,D0
(SUB.L   A0,D0      ;Laenge in bytes
(MOVE.L  A0,(A3)+
(MOVE.L  D0,(A3)+
(JSR     writeBytes
(MOVE.L  dfile,(A3)+     ;File-Ptr
(JSR     State
(MOVE.W  -(A3),D0
(MOVE    D0,IOResult
(BMI     ERR0
(
(MOVE.L  #dfile,(A3)+
(JSR     Files.close
(MOVE.L  dfile,(A3)+     ;File-Ptr
(JSR     State
(MOVE    -(A3),IOResult
(
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D2-A6
(TST.W   IORESULT
(BMI     ERR0
(RTS
(
 !ERR0   MOVE.W  IOResult,-(A7)
(JSR     CLOSE
(MOVE.L  A3,EVALSTK
(MOVE.W  (A7)+,IOR
(JMP     IOERR
&END;
 END csave;
 
 
 PROCEDURE reload;               (* Buffer nachladen *)
 BEGIN ASSEMBLER
(MOVE.L  D0,-(A7)
(MOVE.L  A0,-(A7)
 
(MOVE.L  bufferStart,A0
(ADDQ.L  #2,A0
(; Die letzten 2 Drittel zum Beginn schieben.
(MOVE.W  #(blocklen * 2 DIV 16) - 1,D0
(MOVE.L  A1,-(A7)
(LEA     blocklen(A0),A1
 !RL1    MOVE.L  (A1)+,(A0)+
(MOVE.L  (A1)+,(A0)+
(MOVE.L  (A1)+,(A0)+
(MOVE.L  (A1)+,(A0)+
(DBF     D0,RL1
(MOVE.L  (A7)+,A1
(MOVE.L  #blocklen,D1
(ADD.L   D1,TextOffset
(SUBA.L  D1,A2
(SUB.L   D1,pTxtMne      ; Text-Pointer fr den Assembler
(SUB.L   D1,pTxtOp1
(SUB.L   D1,pTxtOp2
(SUB.L   D1,pTxtOp3
(SUB.L   D1,pTxtLin
(SUB.L   D1,pTxtLin2
(SUB.L   D1,pLastSym
(MOVE.L  LINEPTR,D0
(BEQ     RL3
(SUB.L   D1,D0
(MOVE.L  D0,LINEPTR
 !RL3
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
 
(ADDQ.W  #1,STARTBLK
(MOVEQ   #1,D0          ;ein Drittel lesen
(MOVE.L  bufferStart,A0
(ADDA.W  #(blocklen*2)+2,A0
(JSR     Fread
(BMI     freadnok
(MOVE    D0,D1
(CLR     D0
#freadnok
(MOVE    D0,IOResult
(MOVE.L  bufferStart,A0
(ADDA.W  #(blocklen*2)+2,A0
(MOVE.B  #EOF,0(A0,D1.W)
(
(TST     EOT
(BEQ     notEof
(MOVE    IOResult,-(A7)
(JSR     CLOSE
(MOVE    (A7)+,IOResult
 !NOTEOF MOVEM.L (A7)+,D1-A6
(MOVE.L  (A7)+,A0
(MOVE.L  (A7)+,D0
(TST     IOResult
(BPL     ok
(MOVE.W  IORESULT,IOR
(JMP     IOERR
 ok
&END
 END reload;
 
 
 PROCEDURE exclude;
#(* Include-Option beenden *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
(TST.W   fileMode
(BEQ     closed
(MOVE.L  #tfile,(A3)+
(JSR     Files.close
(MOVE.L  tfile,(A3)+
(JSR     State
(MOVE    -(A3),IOResult
(BMI.L   ERR0
 closed  SUBQ.W  #1,INCLEVEL
(BPL     OK
(TST.W   ENDMOD    ;bereits Modul-Ende gefunden?
(BNE     E
(MOVE.L  bufferStart,A2
(ADDQ.L  #2,A2     ;Fehlerposition wenigstens in den Text setzen
(MOVE    #rEOInp,D5
(JMP     SYNTAXERR ;'unexpected end of input'
 !E      NOT.W   ENDTEXT
(BRA.L   DONE
 !OK     JSR     PULLFN   ;Namen des beendeten Files vergessen
(LEA     currentText,A5
(JSR     GETFN
(JSR     PullLineNo
&END;
&FastStrings.Assign (currentText, TextName);
&writeln; writestring ('File '); writestring (currentText); Write (' ');
&Files.Open (tfile,currenttext, readOnly);
&IOResult := State(tfile);
&IF IOresult = 0 THEN
(flen := FileSize (tfile);
(IOResult := State(tfile)
&END;
&ASSEMBLER
(TST.W   IORESULT
(BMI.L   ERR0
(
(MOVE.L  tfile,(A3)+
(MOVE.L  INCLPTR,A0
(MOVE.W  (A0),D0      ;Rel. Block ('StartBlk')
(MULU    #blocklen,D0
(MOVE.L  D0,(A3)+
(CLR     (A3)+
(JSR     Seek
(MOVE.L  tfile,(A3)+
(JSR     State
(MOVE    -(A3),IOResult
(BMI.L   ERR0
(
(MOVE.L  INCLPTR,A0
(MOVE.W  (A0)+,STARTBLK
(MOVE.L  bufferStart,A2
(ADDQ.L  #2,A2
(ADDA.W  (A0)+,A2
(MOVE.L  A2,TXTPTR
(MOVE.L  A0,INCLPTR
(MOVEQ   #3,D0        ;alle drei Drittel lesen
(MOVE.L  bufferStart,A0
(ADDQ.L  #2,A0
(JSR     Fread
(BMI     ERR2
(MOVE.L  bufferStart,A0
(MOVE.B  #EOF,2(A0,D0.W)
(CLR     IOResult
(
(TST     EOT
(BEQ     done
(JSR     CLOSE
 !DONE   MOVEM.L (A7)+,D1-A6
(MOVE.L  TXTPTR,A2
(RTS
 !ERR2   MOVE.W  D0,IORESULT
 !ERR0   MOVE.W  IORESULT,IOR
(JSR     CLOSE
(MOVEM.L (A7)+,D1-A6
(JMP     IOERR
&END
 END exclude;
 
 
 PROCEDURE LoadDef;
"(*
#*   ----------------------------------
#*   Definitions-Modul laden, Format pruefen
#*   ----------------------------------
#*
#*     (D0-D5)
#*
#*     TOId = Modul-Name, bleibt da!
#*     Dadr = Lade-Adresse
#*
#*     A0 := StartAdr des Moduls
#*     Zero-Flag := "Modul gefunden"
#*)
 BEGIN  ASSEMBLER
)MOVEM.L D1-A6,-(A7)
)MOVE.L  EVALSTK,A3
)MOVEQ   #3,D5            ;DefMod Suffix
)LEA     cname,A5
)JSR     MakeName2
'END;
'ASSEMBLER
)MOVE.L  options,D0
)BTST    #17,D0
)BNE.L   quiet3
)END;
+Write (27C); Write (5C); (* Ctrl-E: Enhanced Output *)
+writeln;
+writestring ('Importing ');
)ASSEMBLER
'!quiet3
'END;
'
'lib:= FALSE; flen2:= 0;
'IF usesVolume[0] # 0C THEN (* $U-Option aktiv *)
)FileNames.ValidatePath (usesVolume);
)FileNames.ConcatPath(usesVolume,cname,c2name);
)MakeFullName (c2name,TRUE,strval);
)Files.Open (dfile,c2name, readOnly);
)IOResult := State(dfile);
)IF IOresult = 0 THEN
+ASSEMBLER
-MOVE.L  options,D0
-BTST    #17,D0
-BNE.L   quiet
-END;
/writestring (c2name);
/Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
-ASSEMBLER
+!quiet
+END;
+flen2 := FileSize (dfile);
)END;
'END;
'
'IF flen2 = 0L THEN
 
)LibFiles.LookUp (deflib, cname, libentry, IOResult);
)IF IOResult >= 0 THEN
+lib:= TRUE;
+flen2:= libentry.size;
+Seek (deflib.f, libentry.start, fromBegin);
+IOResult := State(deflib.f);
+dfile:= File (NIL);
+ASSEMBLER
-MOVE.L  options,D0
-BTST    #17,D0
-BNE.L   quiet2
-END;
/WriteString (libname);
/Write (':');
/writestring (libentry.name);
/Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
-ASSEMBLER
+!quiet2
+END;
)ELSE
)
+paths:= DefPaths;
+SearchFile (cname,paths,fromStart,foundit,cname);
+ASSEMBLER
-MOVE.L  options,D0
-BTST    #17,D0
-BNE.L   quiet4
-END;
/writestring (cname);
/Write (27C); Write (6C); (* Ctrl-F: Enhanced Output off *)
-ASSEMBLER
+!quiet4
+END;
+Files.Open (dfile,cname, readOnly);
+IOResult := State(dfile);
+IF IOresult = 0 THEN
-flen2 := FileSize (dfile);
+END;
)END;
'END; (* IF flen2 > 0 *)
 
'ASSEMBLER
)TST.W   IORESULT
)BMI.L   error0
 
)MOVE.L  dfile,-(A7)
)TST     lib
)BEQ     notlib
)LEA     deflib,A0
)MOVE.L  deflib.f(A0),(A7)
'notlib
)MOVE.L  (A7),(A3)+
)MOVE.L  flen2,D0
)ADD.L   DADR,D0
)MOVE.L  D0,DEND     ;EndAdr des DefModuls
)MOVE.L  DADR,(A3)+  ;Buffer Address
)MOVE.L  flen2,(A3)+
)MOVE.L  #byread,(A3)+
)JSR     ReadBytes
)MOVE.L  (A7)+,(A3)+
)JSR     State
)MOVE    -(A3),D0
)EXT.L   D0
)BMI     freadnok
'freadok
)CLR     D0
'freadnok
)MOVE    D0,IOResult
)MOVE.W  IORESULT,IOR
 
)TST     lib
)BNE     noclose
)MOVE.L  #DFILE,(A3)+
)JSR     Files.close
'noclose
)MOVEM.L (A7)+,D1-A6
 
)TST.W   IOR
)BMI.L   ende1
 
)MOVE.L  A1,D0
)ADD.L   TRESPC,D0
)SUBI.L  #$800,D0      ;noch Platz unterm Baum?
)CMP.L   DEND,D0
)BGT     OK1
 
 errImpOv MOVE    #rImpOv,D5
)JMP     SYNTAXERR    ; Fehler: kein Platz mehr zum Importieren
 
); geladenes DefMod prfen
 
 !OK1     MOVE.L  DADR,A0
)CMPI.L  #$4D4D3243,(A0)+        ; "MM2C"
)BNE.W   noDefMod
)CMPI.L  #$6F6D7000,(A0)+        ; "omp"
)BNE.W   noCompr
 
); Modul dekomprimieren
 
)MOVEM.L D1-A6,-(A7)
)MOVE.L  EVALSTK,A3
)END;
+Compressions.GetInfo (dadr+8L, i, flen3);
)ASSEMBLER
)MOVEM.L (A7)+,D1-A6
 
)MOVE.L  A1,D1
)ADD.L   TRESPC,D1
)SUBI.L  #$800,D1      ;noch Platz unterm Baum?
)MOVE.L  DEND,D0
)ADD.L   flen3,D0
)CMP.L   D0,D1
)BLS     errImpOv
 
)MOVEM.L D1-A6,-(A7)
)MOVE.L  EVALSTK,A3
)
'again
)END;
+Compressions.Decode (dadr+8L, flen2-8L, dend, flen3, strVal);
+ASSEMBLER
0MOVE.W  D1,strPos
+END;
+IF strVal THEN
-Copy (dend, flen3, dadr);
+ELSE
-IF strPos = 1 THEN
/BadId:= 'Decode: Speicher?!';
-ELSIF strPos = 2 THEN
/BadId:= 'Decode: Format?!';
-ELSIF strPos = 3 THEN
/BadId:= 'Decode: Lnge?!';
-ELSIF strPos = 4 THEN
/BadId:= 'Decode: Kennung?!';
-ELSE
/BadId:= 'Decode?!';
-END;
-ASSEMBLER
1MOVE   #rIntEr,D5
1JMP    SYNTAXERR
-END
+END;
)ASSEMBLER
)MOVEM.L (A7)+,D1-A6
)TST     strVal
)BEQ.W   noDefMod
 
)MOVE.L  flen3,D0
)ADD.L   DADR,D0
)MOVE.L  D0,DEND     ;EndAdr des DefModuls
 
)MOVE.L  A1,D1
)ADD.L   TRESPC,D1
)SUBI.L  #$800,D1      ;noch Platz unterm Baum?
)CMP.L   D0,D1
)BLS     errImpOv
 
 noCompr  MOVE.L  DADR,A0
)CMPI.L  #$4D4D3243,(A0)+        ; "MM2C"
)BNE     noDefMod
)CMPI.L  #$6F646500,(A0)+        ; "ode"
)BNE     noDefMod
)MOVE.B  1(A0),D0
)ANDI.B  #$F,D0
)CMPI.B  #3,D0         ;DefMod?
)BEQ     OK2
 noDefMod MOVE    #rBdFrm,D5
)JMP     SYNTAXERR
 !OK2     CMPI.B  #5,(A0)       ;(DLAYOUT) aktuelles DefMod-Format?
)BCC     OK5
)MOVE    #rBdLay,D5
)JMP     SYNTAXERR
 ok5      MOVEM.L A0/A5,-(A7)
)MOVE.L  A0,A5         ;Zeiger auf Namensfeld bereitstellen
)ADDA.L  22(A0),A5
)JSR     LookID        ;Name des DefMod aus IMPORT-Anweisung
)MOVE.L  Options,D3
 CheckId1 MOVE.B  (A0)+,D0
)MOVE.B  (A5),D1
)EOR.B   D0,D1
)BEQ     CheckOk
)BTST    #3,D3
)BNE     diff          ;Case Sensitive
)AND.B   #$DF,D1
)BNE     diff          ;Abweichung
 CheckOk  OR.B    (A5)+,D0
)BNE     CheckId1
)MOVEM.L (A7)+,A0/A5
)BRA     ende1
 diff     MOVEM.L (A7)+,A0/A5
)RTS
 
 error0   ;Fehlerausgang bei IO-Error
)MOVEM.L (A7)+,D1-A6
 ende1
"END
 END LOADDEF;
 
 
 PROCEDURE include;
#(* Include-Option ausfuehren *)
 BEGIN  ASSEMBLER
*TST.W   fileMode
*BNE     ok2
*MOVE.L  EVALSTK,A3
*MOVE    #4,(A3)+
*JMP     TermProcess
 ok2       ADDQ.W  #1,INCLEVEL
*CMPI.W  #15,INCLEVEL  ;OUT OF STACK SPACE?
*BLS     OK
*MOVE    #rIncOv,D5
*JMP     SYNTAXERR
 !OK       MOVE.L  INCLPTR,A0    ;INCL STACK PTR
*MOVE.L  A2,D0
*SUB.L   bufferStart,D0
*SUBQ.L  #2,D0
*MOVE.L  D0,D1
*DIVU    #BLOCKLEN,D1
*ADD.W   STARTBLK,D1   ;jetzt aktueller Block
*MOVE.W  D1,D0
*SWAP    D1            ;Byte-Offset im Block
*MOVE.W  D1,-(A0)
*MOVE.W  D0,-(A0)
*MOVE.L  A0,INCLPTR
*MOVEM.L D1-A1/A3-A6,-(A7)
*MOVE.L  EVALSTK,A3
*JSR     CLOSE         ;TextFile schliessen
*MOVEQ   #1,D0         ;mit Ausgabe des FileName
*JSR     OPEN          ;neues TextFile oeffnen
*MOVE.L  A3,EVALSTK
*MOVEM.L (A7)+,D1-A1/A3-A6
*TST.W   D0
*BNE     ERR0
*JMP     PushLineNo
 !ERR0     MOVE.W  IORESULT,IOR
*JMP     IOERR
(END
 END Include;
 
 PROCEDURE OpenProt;
"(* ProtokollFile eroeffnen *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
&END;
&ReplaceHome (pname);
&Files.Create (pfile, pname, writeSeqTxt, replaceOld);
&IF State (pfile) # 0 THEN
(ProtFile := false;
&ELSE
(Now:= CurrentTime();
(Today:= CurrentDate();
(Text.Writestring (pfile, 'Modula-2 Compiler');
((*$? Asm20:
*Text.Writestring (pfile, '/ 68020 & 68881 Assembler');
(*)
(Text.Writestring (pfile, version);
(Text.Writestring (pfile, ' for Atari ST/TT');
(Text.Writestring (pfile, '          ');
(TimeConvert.DateToText (Today,'',nowStr);
(Text.Writestring (pfile, nowstr);
(Text.Writestring (pfile, '   ');
(TimeConvert.TimeToText (Now,'',nowStr);
(Text.Writestring (pfile, nowstr);
(Text.Writeln (pfile); Text.Writeln (pfile);
(Protfile := true
&END;
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D1-A6
&END
 END OpenProt;
 
 
 PROCEDURE CloseProt;
"(* ProtokollFile schliessen *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
&END;
&IF ProtFile THEN
(Files.Close (pfile);
(ProtFile := false;
&END;
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D1-A6
&END
 END CloseProt;
 
 
 PROCEDURE ProtLine;
"(* Zeile ins ProtokollFile uebernehmen
"
%A2 = ^Textzeile
%D0 = rel. Adresse im CodeFile (0 = keine gueltige Adr)
*
%(A0,D0) *)
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  D0,RelAdr
(MOVE.L  EVALSTK,A3
(LEA     LineBuf,A5
(MOVE    #txtLSize-1,D1  ; SIZE (LineBuf) !!!
 !lp     MOVE.B  (A2)+,D0        ;TextZeile in String uebernehmen
(BNE     notnull
(TST.W   singleLineMode
(BEQ     lp
(BRA     ende
 lpdle   MOVEQ   #0,D0
(MOVE.B  (A2)+,D0
(SUBI.B  #$21,D0
(BCS     lp
 lpdl2   MOVE.B  #' ',(A5)+
(DBRA    D0,lpdl2
(BRA     lp
 notnull CMP.B   #lf,D0
(BEQ     lp
(CMP.B   #cr,D0
(BEQ     ende
(CMP.B   #eof,D0
(BEQ     ende
(CMP.B   #dle,D0
(BEQ     lpdle
(MOVE.B  D0,(A5)+
(DBRA    D1,lp
(BRA     ende0
 !ende   CLR.B   (A5)+
 ende0
&END;
&NumberIO.Writecard (pfile, line, 5);
&NumberIO.Writecard (pfile, global, 3);
&IF RelAdr # 0L THEN
(Text.Writestring (pfile, '  ');
(Text.WriteString (pfile, LHexToStr( reladr, 6) );
(Text.Writestring (pfile, '  ');
&ELSE
(Text.Writestring (pfile, '  D        ');
&END;
&Text.Writestring (pfile, cop (LineBuf, 0, pcolumns-20));
&Text.Writeln (pfile);
&WHILE length (LineBuf) > pcolumns-20 DO
(LineBuf := cop (LineBuf, pcolumns-20, 255);
(Text.Writestring (pfile, '                   ');
(Text.Writestring (pfile, cop (LineBuf, 0, pcolumns-20));
(Text.Writeln (pfile);
&END;
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D1-A6
&END
 END ProtLine;
 
 PROCEDURE ProtID;
"(* ID ins ProtokollFile schreiben
"
%A1 = ^Object-Baum
%D4 = ^Variablen-Eintrag
"*)
 BEGIN ASSEMBLER
(MOVEM.L D0-A6,-(A7)
(MOVE.L  EVALSTK,A3
(MOVEQ   #1,D7
(LEA     LineBuf,A5
(; Namen holen
 !TP1    SUBQ.L  #1,D4
(MOVE.B  -8(A1,D4.L),D0
(CMP.B   #$FE,D0
(BCC     TP2
(MOVE.B  D0,(A5)+
(BRA     TP1
 !TP2    CLR.B   (A5)+
&END;
&Text.writestring (pfile,LineBuf);
&Text.writeln (pfile);
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D0-A6
&END
 END ProtID;
 
 PROCEDURE ProtVar;
"(* Variable ins ProtokollFile schreiben
"
%A1 = ^Object-Baum
%D4 = ^Variablen-Eintrag
"*)
 BEGIN ASSEMBLER
(MOVEM.L D0-A6,-(A7)
(MOVE.L  EVALSTK,A3
(MOVEQ   #1,D7
(MOVE.L  -14(A1,D2.L),RelAdr
(LEA     LineBuf,A5
(; Namen holen
 !TP1    SUBQ.L  #1,D4
(MOVE.B  -8(A1,D4.L),D0
(CMP.B   #$FE,D0
(BCC     TP2
(MOVE.B  D0,(A5)+
(BRA     TP1
 !TP2    CLR.B   (A5)+
&END;
&Text.writestring (pfile,'          ');
&Text.WriteString (pfile, LHexToStr( reladr, 6) );
&Text.writestring (pfile,'  ');
&Text.writestring (pfile,LineBuf);
&Text.writeln (pfile);
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D0-A6
&END
 END ProtVar;
 
 PROCEDURE ProtVarStart;
"BEGIN
$ASSEMBLER
(MOVEM.L D0-A6,-(A7)
(MOVE.L  EVALSTK,A3
(MOVEQ   #1,D7
$END;
$Text.writeln (pfile);
$Text.writeln (pfile);
$Text.writestring (pfile,'Global variables:');
$Text.writeln (pfile);
$Text.writeln (pfile);
$ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D0-A6
$END
 END ProtVarStart;
 
 
 PROCEDURE ClockStop;
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
&END;
&StopTime:= CurrentTime();
&IF stoptime.hour < starttime.hour THEN
(inc (stoptime.hour, 24)
&END;
&seconds :=  3600 * (stoptime.hour - starttime.hour)
1+  60 * (stoptime.minute - starttime.minute)
1+       (stoptime.second - starttime.second);
&ASSEMBLER
(MOVE.L  A3,EVALSTK
(MOVEM.L (A7)+,D1-A6
&END
 END ClockStop;
 
 PROCEDURE ClockStart;
 
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
&END;
&FastStrings.Assign (DefSfx,dnSufx);
&FastStrings.Assign (ImpSfx,inSufx);
&FastStrings.Assign (ModSfx,cnSufx);
&useSufx:= '';
&FastStrings.Assign (DefOutPath, defnVolume);
&FastStrings.Assign (ImpOutPath, implVolume);
&FastStrings.Assign (ModOutPath, modVolume);
&usesVolume:= '';
&StartTime:= CurrentTime();
&Today:= CurrentDate();
&ASSEMBLER
(MOVEM.L (A7)+,D1-A6
&END
 END ClockStart;
 
 
 VAR ioClosed: BOOLEAN;
 
 PROCEDURE CloseIO; (* Deinit f. CompIO, wird nach 'Comp' aufgerufen *)
"BEGIN
$ASSEMBLER
(SUBA.W  #100,A7
(ADDA.W  #100,A3
(CMPA.L  A3,A7
(BLS     ERROR
(CMPA.L  LoSysStack,A3
(BCS     ERROR
(CMPA.L  HiSysStack,A7
(BLS     OK
&ERROR
(BREAK
(MOVE.L  LoSysStack,A3
(MOVE.L  HiSysStack,A7
%OK ADDA.W  #100,A7
(SUBA.W  #100,A3
$END;
$IF ~ioClosed THEN
&LibFiles.CloseLib (deflib);
&IF doOutput THEN
(InOutBase.CloseWdw;
&END;
&ioClosed:= TRUE
$END
"END CloseIO;
 
 
 PROCEDURE OpenIO; (* Init f. CompIO, wird vor 'Comp' aufgerufen *)
"BEGIN
$inclevel := 0;
$fnsp     := 0;
$lineNoPtr:= 0;
$fileMode:= TRUE;
$singleLineMode:= FALSE;
$doOutput:= TRUE;
$outVol:= '';
$pcolumns:= 999;
$pname:= '';
$ProtFile:= FALSE;
$FastStrings.Assign (DefLibName, libName);
$GetBasePageAddr (comlin);
$ASSEMBLER
(lea     inclstk,a0
(adda.w  #64,a0
(move.l  a0,inclptr
(
(MOVE.L  comlin,A0
(ADDA.W  #128,A0
(CLR     D0
(MOVE.B  (A0)+,D0
(MOVE.L  A0,comlin
(CLR.B   0(A0,D0.W)
$END;
$outoptstr:= '';
$IDStkSize:= 2048;
$StripOptions (comlin^, TRUE);
$IF fileMode THEN
&Allocate (bufferStart, 3 * blocklen + 4);
&IF bufferStart = NIL THEN
(TermProcess (-39) (* out of mem *)
&END;
&bufferRes:= bufferStart + 2 * blocklen + 2
$END;
$IF doOutput THEN
&InOutBase.OpenWdw (76,20)
$END;
$HomePath:= ShellPath;
$ReplaceHome (libName);
$Directory.MakeFullPath (libName, ior);
$LibFiles.OpenLib (deflib, libName, ior);
$wsp.bottom:= NIL;
$CatchProcessTerm (tCarrier, CloseIO, wsp);
$ioClosed:= FALSE
"END OpenIO;
 
 
 PROCEDURE Statistics;
 BEGIN ASSEMBLER
(MOVEM.L D1-A6,-(A7)
(MOVE.L  EVALSTK,A3
&END;
&Text.Writeln (pfile);
&
&Text.Writestring (pfile, 'Source text length      :');
&NumberIO.Writecard   (pfile, line, 10);
&Text.Writestring (pfile, ' lines'); Text.Writeln (pfile);
&
&Text.Writestring (pfile, 'Code file length        :');
&NumberIO.Writecard  (pfile, csize, 10);
&Text.Writestring (pfile, ' bytes'); Text.Writeln (pfile);
&
&if seconds # 0 then
(Text.Writestring (pfile, 'Compilation time        :');
(NumberIO.Writecard   (pfile, seconds, 10);
(Text.Writestring (pfile, ' seconds'); Text.Writeln (pfile);
(
(Text.Writestring (pfile, 'Compilation rate        :');
(NumberIO.Writecard   (pfile, line div seconds, 10);
(Text.Writestring (pfile, ' lines/second'); Text.Writeln (pfile);
&
(case seconds mod 5 of
*0: lineBuf := 'Population of Zimbabwe  :   7700000 people' |
*1: lineBuf := "ASH's phone number      :     06221 300002" |
*2: lineBuf := 'Electron mass           :       511 KeV' |
*3: lineBuf := '57862 * 851 bananas     :  49240562 bananas' |
*4: lineBuf := 'Great movie             :      2001' |
(end;
(Text.Writestring (pfile, lineBuf); Text.Writeln (pfile)
&end;
&
&Text.Writeln (pfile);
&
&ASSEMBLER
(MOVEM.L (A7)+,D1-A6
&END
 END Statistics;
 
(* $0000BD59$0000A691$FFFA9829$0000A6A8$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$000035C5$FFFAB0E6$0000D7E5$FFFAB0E6$00004C4E$FFFAB0E6$FFF6B0E0$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$00009380$FFECE157$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$FFFAB0E6$00003315T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000035DB$000035C5$00003323$00003315$0000343B$00003456$00003466$000033AE$00003449$FFE2FA4A$00003422$00003430$000034BB$000034C9$00003323$000032EB*)
