 DEFINITION MODULE MM2Comp;
 (*$Z-*)
 
 FROM SYSTEM IMPORT ADDRESS, WORD, LONGWORD;
 
 CONST
$(* Festlegung der Rechnerkonfiguration:
'------------------------------------
'Konstanten fr bedingte Compilierung, zur Unterscheidung einer
'Gepard- und einer Atari-Version. Die neueren Compiler-Versionen
'untersttzen nur noch die Atari-Konfiguration - bei zuknftigen
'nderungen knnen die folgenden Werte also ignoriert werden! *)
%
'Atari  = TRUE;
'Gepard = FALSE;
'RunGep = FALSE;
(RunST = TRUE;
(
$(* Implementationskonstanten:
'--------------------------
'Nur die maximale Set-Gre wird exportiert. Diese mssen die Expression-
'Routinen z.Z. kennen, um entsprechend groe Puffer zum Aufbau von
'Set-Konstanten anzulegen. *)
$
$maxSet    =   65536;                  (* max SetLaenge (bits) *)
$(*
&maxSetW   = CARDINAL(maxSet DIV 16L); (* max. Setlaenge (words) *)
$*)
%
$(* Seriennummern und Prfzahlen dazu:
'----------------------------------
'Z.Z. erfolgt die Prfung einer der eingetragenen Seriennummern innerhalb
'der Expression-Auswertung. (Kann zunchst entfallen.)
'Dazu werden die folgenden Werte bentigt: *)
&
&SerVal0 = $4711;   (* Defaulteintrag fr Seriennummer *)
&SerVal1 = $1ADE;   (* verschlsselt nach Verfahren 1 *)
&SerCnt1 = 38;      (* Iterationszahl-1 fr Schlssel 1 *)
%SerLead0 = $0641;   (* fhrende Kennung fr Seriennummern *)
%SerLead1 = $343C;   (*   willkrliche 68000-Opcodes, *)
#SerOffset1 = $2302;   (*   willkrliche 68000-Opcodes, *)
 
$(* Symbolnummern:
'--------------
'Spezielle Symbolnummern, die von GetSbl (s.u.) geliefert werden.
'StrConst: Stringkonstanten in '' oder " ". Werden in den Puffer
1<StrBuf> (s.u.) umkopiert, Char-Zahl in <StrLen>.
'NumConst: numerische Konstanten. Behandlung etwas irregulr: <GetSbl>
1holt NICHT das Symbol (die Zahl) aus dem Text; das bleibt
1dem Aufrufer berlassen. (Knnte jederzeit umgestellt werden.)
'SymAnd, SymOr, SymNot: die drei reservierten Worte AND, OR, NOT kriegen
1eine Extrawurst, weil sie auch als Assembler-Symbole benutzt
1werden.
'
'Alle anderen Symbolnummern haben keine symbolischen Namen
'(schade eigentlich!)                                        *)
'
%NumConst =     $FE;     (* Ziffer, num. Konstante folgt *)
%StrConst =     $FF;     (* Stringkonstante in ' oder " *)
%SymAnd   =     124;     (* AND *)
%SymOr    =     125;     (* OR  *)
%SymNot   =     175;     (* NOT *)
 
 
$(* Accu *)
 
 CONST AccuSize = 8;
 
 VAR
%Accu:WORD;   (* Sign & Exponent - s1..m1 gleichzeitig fuer Long-Konstanten *)
#AccuM1:WORD;   (* Mantisse 1.Wort -     m1 gleichzeitig fuer Word-Konstanten *)
"AccuS14:WORD;   (* Mantisse 2.Wort *)
"AccuM14:WORD;   (* Mantisse 3.Wort *)
 
"AccuPtr:ADDRESS; (* Ptr auf Accu/Datum *)
 
$(* Zeiger auf die Standardtypen:
'-----------------------------
'sind gedacht zur Erzeugung von Ergebnistypen (die immer in Form solcher
'Zeiger geliefert werden) in Expressions. Alle Zeiger sind relativ
'zur Baumwurzel, und natrlich sind wieder alle Werte negativ.
'
'Die Initialisierung dieser Pointer geschieht in IMPORT.ImPseud   *)
 
%IntPtr: ADDRESS;  (* LongInt *)
$RealPtr: ADDRESS;  (* Real (8 Byte) *)
$CardPtr: ADDRESS;  (* LongCard *)
$CharPtr: ADDRESS;  (* Char *)
$BoolPtr: ADDRESS;  (* Boolean *)
$SIntPtr: ADDRESS;  (* ShortInt *)
#SCardPtr: ADDRESS;  (* ShortCard *)
#SBothTyp: ADDRESS;  (* SHORTINT oder SHORTCARD (0 <= x <= MaxInt) *)
$BothTyp: ADDRESS;  (* LongInt oder LongCard (0L <= x <= MaxLInt) *)
$BSetPtr: ADDRESS;  (* BITSET *)
$ProcPtr: ADDRESS;  (* PROC *)
&ZZTyp: ADDRESS;  (* (MinLInt <= x <= MaxLCard) *)
#SRealPtr: ADDRESS;  (* ShortReal (4 Byte) *)
%IntRel: ADDRESS;  (* INTEGER (Relay auf SHORT/LONGINT) *)
$CardRel: ADDRESS;  (* CARDINAL (Relay auf SHORT/LONGCARD) *)
$FrwdTyp: ADDRESS;  (* hierauf zeigen noch ungelste Proc-/Pointer-Typen *)
&SSTyp: ADDRESS;  (* SS *)
$BytIPtr: ADDRESS;  (* signed Byte *)
#UndefTyp: ADDRESS;  (* strukt. Konstante *)
%StrPtr: ADDRESS;  (* String-Literal - ab V4.3 identisch mit SSTyp *)
 
 
%Header: ADDRESS;    (* ^ Anfang des erzeugten Moduls (Modulkopf) *)
"CodeStart: ADDRESS;    (* ^ erzeugten Code-Beginn (hinter Decl-Teil) *)
$DataLen: LONGCARD;   (* vorgegebene Lnge des DATA-Puffers *)
"DataStart: LONGCARD;   (* Start des DATA-Puffers *)
$DataEnd: LONGCARD;   (* Ende des DATA-Puffers *)
$DataPtr: LONGCARD;   (* ^ in DATA-Puffer *)
%TreSpc: ADDRESS;    (* ^ aktuelles Ende des ID-Baums, relativ zur
<Baumwurzel. Negativ! (Baum 'hngt kopfber') *)
$EvalStk: ADDRESS;    (* Zwischenspeicher zum Retten von A3, das im
<Compiler langfristig anders belegt ist. *)
 
%StrLen: CARDINAL;   (* nach <GetSbl>: Char-Zahl des Strings in <StrBuf> *)
%STRBUF: ARRAY [1..256(*MaxStrLen*)] OF CHAR;
9(* nach <GetSbl>: Puffer fuer Stringkonstante *)
&
&Tiefe: CARDINAL;   (* nach <GetSbl>, <LocalSearch>: Anzahl der Scope-
<Ebenen, die durchsucht wurden, bevor das Symbol
<gefunden wurde (Tiefe=0: aktuelles lokales Scope,
<grere Tiefen, wenn weiter auen)             *)
 
%Global: CARDINAL;   (* Tiefe des akt. Blocks *)
 
$Options: LONGWORD;   (* aktueller Zustand der Compileroptionen.
<bit1 = 'A' .. bit26 = 'Z'; 0 = '-', 1 = '+'.
<Beachte: Andere Bit-Anordnung als in BitSets! *)
 
#Peephole: LONGCARD;   (* Enthlt speziell kodierte Informationen ber die
<VORLETZTE erzeugte Codesequenz (die LETZTE ist in
<D7 kodiert), um evtl. Optimierung zu ermglichen. *)
 
#TextOffset: LONGCARD; (* fr Expr-Modul: Offset des Textes im Puffer;
<wird von 'reload' hochgesetzt.                *)
 
!StackReserve: LONGCARD; (* geforderte Platzreserve fr Stackcheck *)
 
&ROScope: CARDINAL; (* Anzahl Read-Only Scopes * (-4) *)
%
$WithScope: BOOLEAN;  (* TRUE: Wir sind in einem WITH (f. Assembler) *)
 
%A3Offset: LONGINT;  (* Offset zu Start-A3 in Body jeder einzelnen Proc *)
%A7Offset: LONGINT;  (* Offset zu Start-A7 in Body jeder einzelnen Proc *)
!StatLinkOffs: CARDINAL; (* Offset zu ParReg, bei dem der Outer FramePtr liegt*)
'ParReg: CARDINAL; (* Reg fr Zugriff auf formale Parms (A3/A5/A6/A7) *)
'VarReg: CARDINAL; (* Reg fr Zugriff auf lok. Vars (A3/A5/A6/A7) *)
 
(BadId: ARRAY [0..89] OF CHAR; (* Wird bei "#" in Error-Msg eingesetzt *)
 
&AsmMode: BOOLEAN;     (* TRUE, wenn ASSEMBLER-Scope *)
 
"HaltOnError: BOOLEAN;         (* wird ber "/S" in Cmdline gesetzt *)
 
"OptimizeForSpeeed: BOOLEAN;
 
 (*
!* Real-Format-Behandlung
!*)
 
 TYPE FPUType = (softReal, externalFPU, internalFPU);
 
 PROCEDURE fpu (): FPUType;
"(* Liefert einen der drei Werte. *)
 PROCEDURE RealConstIsUsed;
"(* Aufzurufen, wenn eine Real-Konstante benutzt wird *)
 PROCEDURE IEEERuntimeCall;
"(* Aufzurufen, wenn FPU-spezifischer Code benutzt wird (auch 881-Code!) *)
 
 
$(* Untersttzung eines LONGWORD-Stacks,
'------------------------------------
'der vor allem zum Zwischenspeichern von Typ-Zeigern verwendet wird
'(und aus historischen Grnden 'Integer-Stack' heit).
'Alle Routinen erwarten/liefern das Ergebnis in D0 und verndern A0.   *)
 
 PROCEDURE PullInt ();
 PROCEDURE PushInt ();
 PROCEDURE LookInt ();   (* liefert TopOtStack; der Wert bleibt auf dem Stack *)
 
 
$(* Scanner und verwandte Funktionen:
'---------------------------------         *)
 
 PROCEDURE GetSbl ();
$(* Nchstes Symbol aus dem Text holen.
'Liefert Symbolnummer in D3; setzt Textzeiger A2 weiter.
'D0..D6, A0, A2 werden verndert.                     *)
 
 PROCEDURE SameSbl ();
$(* Zuletzt gelesenes Symbol noch einmal in D3 abliefern *)
 
 PROCEDURE FetNoSp ();
$(* Nchstes Zeichen nach D2 holen, White Space berlesen *)
 
 PROCEDURE GetLPar ();
$(* IF GetSbl ()  # LinkeKlammer THEN SyntaxErr ('( expected') END *)
 
 PROCEDURE GetRPar ();
$(* IF SameSbl () # RechteKlammer THEN SyntaxErr (') expected') END *)
 
 PROCEDURE SyntaxErr ();
%(* Bricht Compilerlauf ab und meldet Syntaxfehler.
(bergabe der Fehlernummer in D5.                *)
(
(
$(* Suchen im Symbolbaum:
'---------------------
'<LocalSearch> durchsucht einen lokalen Baum (speziell sind das auch
'die Feldnamen eines Records).
'
'Parameter:
'D2.L Zeiger auf die Baumwurzel (relativ zu A1.L, negativ)
'A2.L Zeiger auf ID im Textpuffer
'D1.B erstes Zeichen des IDs
'
'Ergebnisse:
'Carry Clear, wenn ID gefunden. Dann:
)A2.L zeigt im Textpuffer hinter den ID
)D2.L Zeiger auf den Eintrag im Baum (relativ zu A1,
0MOVE.W -2(A1,D2.L) holt das Kennungswort)
'Carry Set, wenn nicht gefunden. Dann
)A2.L zeigt auf erstes Zeichen des ID im Textpuffer.    *)
 
 PROCEDURE LocalSearch ();
 
 PROCEDURE TreSrc ();
$(* Tree-Search.
%* A2: Pointer auf String (null-terminiert), D2: erstes Zeichen
%* Returns: D3.W: itemNr, D2.L: Pointer in Baum
%*)
 
$(* Codeerzeugung fr Prozeduraufrufe:
'---------------------------------- *)
'
 
 PROCEDURE CSP ();
$(* Call System Procedure:
'Aufruf einer Prozedur aus dem Runtime-Modul. Die Prozeduren werden
'ber laufende Nummern bezeichnet, die jeweils in D3.W zu bergeben
'ist. Hier wird nur der Aufruf selbst erzeugt (JSR.L) und der Eintrag
'in die Link-Kette vorgenommen; ggf. ntige Parameterbergaben sind
'vorher vom Aufrufer zu erledigen.
'Liste der Standardprozeduren gibt's handschriftlich.            *)
 
 (*
 PROCEDURE CUP ();
 *)
$(* Call User Procedure:
'Aufruf einer Benutzer-deklarierten Prozedur. Erzeugt die Bereitstellung
'des StatLinks (Zeiger auf das nchstuere sichtbare Scope) und den
'Aufruf (JSR.L fr globale, BSR.W fr lokale Prozeduren).
'
'Parameter:
'D2.L:  Zeiger auf Prozedureintrag im Baum (A1-relativ)
'Tiefe: Scope-Entfernung der Prozedur vom Aufrufer
.(wird von <GetSbl> zum Prozedurnamen mitgeliefert)
.
'verndert D0, A4                                         *)
 
 
$(* Vorwrtsreferenzen in Kontrollstrukturen:
'-----------------------------------------
'Wird exportiert, da die Auswertung von Bool'schen Ausdrcken
'(Shortcut Evaluation bei AND, OR) diese Funktionen bentigt.    *)
 
 PROCEDURE ForwardRef ();
$(* legt momentane Position des Code-Zeigers auf dem Integer-Stack ab,
'schreibt 0.W in den Code. (Als vorlufige Entfernung eines Bcc.W,
'dessen Argument spter nachzutragen ist.) Verndert D0, A0.      *)
'
 PROCEDURE ToHere ();
$(* Interpretiert D2.L als Code-Position und trgt an dieser Position
'die Entfernung zur aktuellen Position des Code-Zeigers (als Wort)
'ein. Verndert D1, A0.                                            *)
 
 
$(* Codeerzeugung: Peephole-Optimierung
'-----------------------------------
'Um aufeinanderfolgende MOVEs zu verhindern, die einen Wert hin- und
'herkopieren, wird der jeweils letzte erzeugte MOVE-Befehl durch eine
'Kodierung in D7 beschrieben. Bevor ein weiterer MOVE erzeugt wird,
'wird kontrolliert, ob er die Daten des vorigen Befehls weitertrans-
'portiert.
'
'Nur wenn dies der Fall ist, wird <MoveCut> aufgerufen. Parameter:
'D0.W: Opcode, der ohne 'Optimierung' zu erzeugen wre.
'D7.L: Informationen ber den letzten erzeugten Code.
'
'Da dieser Mechanismus vermutlich nicht weiterbenutzt wird, spare ich
'mir zunchst die Details der Kodierung etc.                      *)
'
 PROCEDURE MoveCut ();
 
 
$(* Kompatibilittsprfung:
'-----------------------
'berprft, ob zwei Typen im Wirth'schen Sinn 'kompatibel' sind
'(identisch oder ADDRESS<>LONGCARD, Pointer<>ADDRESS,
'BothTyp<>Int/Card, oder Subranges mit kompatiblen Basistypen).
'
'Alle drei Routinen liefern das Ergebnis im Zero-Flag (EQ = "kompatibel"),
'und erwarten zwei zu vergleichenden Typ-Zeiger - diese aber aus
'verschiedenen Quellen:                                   *)
'
 PROCEDURE compat ();
$(* beide Typ-Zeiger auf dem Integer-Stack *)
 
 PROCEDURE compatR ();
$(* ein Typ-Zeiger auf dem Integer-Stack, der andere in D2 *)
$
 PROCEDURE compatRR ();
$(* ein Typ-Zeiger in D0, der andere in D2 *)
 
 PROCEDURE AsComp20;
$(* Src in D2, Dest in D0. Return: Errorcode in D1 *)
 
$(* Auswertung eines Statement-Blocks:
'---------------------------------- *)
 
 PROCEDURE StatSeq;
 
$(* Auswertung von Konstanten (literale & benannte)
'----------------------------------------------- *)
 
 PROCEDURE ConFact;
 
$(* der eigentliche Compiliervorgang:
'--------------------------------- *)
 
 PROCEDURE Compile ();
 
 END MM2Comp.
 
  
(* $FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF57DE3$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$FFF46839$00000FD4T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000FB6$00000FF3$00000FD4$00000FB1$00001165$000010CE$FFD4CCEF$000010EE$00001121$000010C7$000010FE$00001131$00001154$0000115D$0000193B$000012BF*)
