 MODULE FPU;
 (*$N+,L-,M-*)
 
 (*
!* Austesten der SFP004-Befehle
!*)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SFP004 IMPORT FPUInit, FPUError;
 
 CONST   fpstat  =  $fffa40;       (* Response word of MC68881 read *)
(fpstatlo=  $fffa41;
(fpctrl  =  $fffa42;       (* Control  word of MC68881 write *)
(fpcmd   =  $fffa4a;       (* Command  word of MC68881 write *)
(fpcond  =  $fffa4e;       (* Condition word of MC68881 write *)
(fpop    =  $fffa50;       (* Operand  long of MC68881 read/write *)
(fpregsel=  $fffa54;       (* register select long read *)
(A2stat  =  -1;            (* Response word of MC68881 read *)
(A2ctrl  =  1;             (* Control  word of MC68881 write *)
(A2cmd   =  9;             (* Command  word of MC68881 write *)
(A2cond  =  $D;            (* Condition word of MC68881 write *)
(A2op    =  $F;            (* Operand  long of MC68881 read/write *)
(A2regsel=  $13;           (* register select long read *)
 
 PROCEDURE @FP7M;
"BEGIN
$ASSEMBLER
(MOVEA.W #$FA41,A2
(; FMOVEM.X <static list>,-(A7)
(MOVE.W  D0,A2cmd(A2)
(TST.B   (A2)
 DoDlE   CMPI.B  #$0C,(A2)
(BNE     error
(MOVE.L  (A7)+,D0        ; save return-address
(TST.W   A2regsel(A2)
(MOVEA.W #$FA50,A2
 again   SUBQ.L  #8,A7
(MOVE.L  (A2),-(A7)
(MOVE.L  (A2),4(A7)
(MOVE.L  (A2),8(A7)
(CMPI.B  #2,-$F(A2)
(BNE     again
(MOVE.L  D0,A2
(JMP     (A2)
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
$END
"END @FP7M;
 
 PROCEDURE @FG7M;
"BEGIN
$ASSEMBLER
(MOVEA.W #$FA41,A2
(; FMOVEM.X (A7)+,<static list>
(MOVE.W  D0,A2cmd(A2)
(TST.B   (A2)
 DoDlE   CMPI.B  #$0C,(A2)
(BNE     error
(MOVE.L  (A7)+,D0        ; save return-address
(TST.W   A2regsel(A2)
(MOVEA.W #$FA50,A2
 again   MOVE.L  (A7)+,(A2)
(MOVE.L  (A7)+,(A2)
(MOVE.L  (A7)+,(A2)
(CMPI.B  #2,-$F(A2)
(BNE     again
(MOVE.L  D0,A2
(JMP     (A2)
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
$END
"END @FG7M;
 
 BEGIN
"FPUInit;
"ASSEMBLER
(BREAK
(MOVE.W  #$E003,D0
(JSR     @FP7M
(MOVE.W  #$D0C0,D0
(JSR     @FG7M
(MOVE.W  #$E003,D0
(JSR     @FP7M
(MOVE.W  #$D0C0,D0
(JSR     @FG7M
"END
 END FPU.
 
(* $FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$0000043C$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$FFEE9940$000007FCT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000460$0000043C$FFEEEBBC$00000659$000007D5$000007C4$00000820$00000828$0000080C$000007FC$00000844$00000830$FFEEEBBC$000007FC$0000083B$FFEEEBBC*)
