 
 (* Benchmark AG Version 1.2  vom  06.09.88
#
#Vorschlag von Arnd Beiner
#
#Version fr MM2
#
#ACHTUNG: Stacksize auf mind. 32 KB einstellen!
,Und Ctrl-C in Shell abschalten
 *)
 
 MODULE MM2Bench;
 
 (*$S-,R-*)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, ADR;
 
 IMPORT GEMDOSIO; (*$E MOS *)
 IMPORT InOut;
 
 FROM SysUtil1 IMPORT SuperPeek;
 
 IMPORT Convert, StrConv;
 
 FROM FastStrings IMPORT Append, Concat, Length, Assign, Compare;
 
 IMPORT MathLib0;
 
 IMPORT Text, NumberIO, Files;
 
 
 VAR
"StartTime : LONGCARD;
"Hz200 : LONGCARD;
"dummy: CARDINAL;
"dummyL: LONGCARD;
 
 
"PROCEDURE Start;
"BEGIN
$SuperPeek (1210L, StartTime);
"END Start;
 
"PROCEDURE Stop() : LONGCARD;
"BEGIN
$SuperPeek (1210L, Hz200);
$RETURN (Hz200-StartTime) DIV 2;
"END Stop;
 
 
"PROCEDURE Test(Theme : ARRAY OF CHAR; Bench : PROC);
"VAR t: LONGCARD;
"BEGIN
$InOut.WriteString(Theme);
$Start;
$Bench;
$t:= Stop();
$InOut.WriteCard(t DIV 100,8);
$InOut.Write ('.');
$InOut.WriteLNum (t MOD 100,10,2,'0');
$InOut.WriteLn;
"END Test;
 
"PROCEDURE IntMathShort;
"VAR
$x,y,i : CARDINAL;
 
"BEGIN
$x := 0;
$FOR i:=0 TO 20000 DO
&y := 3;
&x := x + (y*y-y) DIV y;
&INC(y);
$END;
$dummy := x+y;
"END IntMathShort;
 
 
"PROCEDURE IntMathLong;
"VAR
$x,y : LONGCARD;
$i : CARDINAL;
$
"BEGIN
$x := 0;
$FOR i:=0 TO 20000 DO
&y := 3;
&x := x + (y*y-y) DIV y;
&INC(y);
$END;
$dummyL:= x+y;
"END IntMathLong;
 
"PROCEDURE RealMathShort;
"VAR
$x : REAL;
$y : REAL;
$i : CARDINAL;
 
"BEGIN
$x := 0.0;
$FOR i:=0 TO 15000 DO
&y := 3.0;
&x := x + (y*y-y) / y;
&y := y+SHORT (1.0);
$END;
"END RealMathShort;
 
"PROCEDURE RealMathLong;
"VAR
$x : LONGREAL;
$y : LONGREAL;
$i : CARDINAL;
 
"BEGIN
$x := 0.0;
$FOR i:=0 TO 15000 DO
&y := 3.0;
&x := x + (y*y-y) / y;
&y := y+1.0;
$END;
"END RealMathLong;
"
"PROCEDURE TriglogShort;
"VAR
$i : INTEGER;
$x,y : REAL;
$
"BEGIN
$x := 0.0;
$FOR i:=1 TO 1000 DO
&y := 9.9;
&x := x+SHORT(MathLib0.sin(MathLib0.arctan(MathLib0.cos(MathLib0.ln(y)))));
&y := y+1.0;
$END;
"END TriglogShort;
"
"PROCEDURE TriglogLong;
"VAR
$i : INTEGER;
$x,y : LONGREAL;
$
"BEGIN
$x := 0.0;
$FOR i:=1 TO 1000 DO
&y := 9.9;
&x := x+MathLib0.sin(MathLib0.arctan(MathLib0.cos(MathLib0.ln(y))));
&y := y+1.0;
$END;
"END TriglogLong;
 
 
"PROCEDURE While;
"VAR
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&WHILE i<10000 DO
(INC(i);
&END;
$END;
"END While;
"
"PROCEDURE Repeat;
"VAR
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&REPEAT
(INC(i);
&UNTIL i=10000;
$END;
"END Repeat;
"
"PROCEDURE Loop;
"VAR
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&LOOP
(INC(i);
(IF i=10000 THEN EXIT; END;
&END;
$END;
"END Loop;
 
"PROCEDURE For;
"VAR
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
&END;
$END;
"END For;
"
"
"PROCEDURE ArrayAccess;
"VAR
$a : ARRAY [1..10000] OF INTEGER;
$i,j : INTEGER;
 
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
(a[i] := 0;
&END;
$END;
$dummy := a[7];
"END ArrayAccess;
"
"
"PROCEDURE RecordAccess;
"VAR
$r : RECORD
*a : INTEGER;
*b : INTEGER;
(END;
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
(r.a := 1;
(r.b := 1;
&END;
$END;
$dummy := r.a;
"END RecordAccess;
"
"
"PROCEDURE RecordArray;
"VAR
$a : ARRAY [0..2000] OF RECORD
>u : INTEGER;
>v : CHAR;
>w : LONGINT;
<END;
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=0 TO 2000 DO
(a[i].u := 10;
(a[i].v := "a";
(a[i].w := 10;
&END;
$END;
$dummy := a[7].u;
"END RecordArray;
"
"
"PROCEDURE RecordArrayWith;
"VAR
$a : ARRAY [0..2000] OF RECORD
>u : INTEGER;
>v : CHAR;
>w : LONGINT;
<END;
$i,j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=0 TO 2000 DO
(WITH a[i] DO
*u := 10;
*v := "a";
*w := 10;
(END;
&END;
$END;
$dummy := a[7].u;
"END RecordArrayWith;
"
"PROCEDURE WriteToFile;
"VAR
$str : Files.File;
$i : INTEGER;
$
"BEGIN
$Files.Create(str,"F:\TESTFILE.TXT",Files.writeSeqTxt,Files.replaceOld);
$FOR i:=1 TO 1000 DO
&Text.Write(str,"a");
&Text.WriteString(str,"Test");
&Text.WriteLn (str);
&NumberIO.WriteInt(str,10,3);
&Text.WriteLn (str);
&NumberIO.WriteReal(str,1.0,5,2);
&Text.WriteLn (str);
$END;
$Files.Close(str);
"END WriteToFile;
 
 
"PROCEDURE ReadFromFile;
"VAR
$str : Files.File;
$i : INTEGER;
$ch : CHAR;
$s : ARRAY [0..80] OF CHAR;
$int : INTEGER;
$r : LONGREAL;
$ok: BOOLEAN;
"BEGIN
$Files.Open(str,"F:\TESTFILE.TXT",Files.readSeqTxt);
$FOR i:=1 TO 1000 DO
&Text.Read(str,ch);
&Text.ReadString(str,s);
&Text.ReadLn (str);
&NumberIO.ReadInt(str,int,ok);
&Text.ReadLn (str);
&NumberIO.ReadLReal(str,r,ok);
&Text.ReadLn (str);
$END;
$Files.Close(str);
"END ReadFromFile;
 
"PROCEDURE ParameterPassing;
"VAR
$x : INTEGER;
$a,b,c : INTEGER;
$d,e : LONGINT;
$f,g : CHAR;
$h,i : LONGREAL;
$
$
$PROCEDURE fewval(a,b : INTEGER);
$BEGIN
$END fewval;
$
$
$PROCEDURE fewvar(VAR a,b : INTEGER);
$BEGIN
$END fewvar;
$
$
$PROCEDURE manyval(a,b,c : INTEGER; d,e : LONGINT;
6f,g : CHAR; h,i : LONGREAL);
$BEGIN
$END manyval;
$
$
$PROCEDURE manyvar(VAR a,b,c : INTEGER; VAR d,e : LONGINT;
6VAR f,g : CHAR; VAR h,i : LONGREAL);
$BEGIN
$END manyvar;
$
*
"BEGIN
$a := 1;
$b := 1;
$c := 1;
$d := 1;
$e := 1;
$f := "a";
$g := "b";
$h := 1.1;
$i := 1.1;
$FOR x:=0 TO 25000 DO
&fewval(1,1);    (* constant values *)
&fewval(a,b);
&manyval(1,1,1,1,1,"a","a",1.1,1.1);       (* constant values *)
&manyval(a,b,c,d,e,f,g,h,i);
&fewvar(a,b);
&manyvar(a,b,c,d,e,f,g,h,i);
$END;
"END ParameterPassing;
 
"
"PROCEDURE StructurePassing;
"TYPE
$rec = RECORD
,a : INTEGER;
,b : CHAR;
,c : LONGINT;
,d : REAL;
*END;
$
%shortarray = ARRAY [0..7] OF CHAR;
%longarray = ARRAY [0..19] OF CHAR;
$
"VAR
$r : rec;
$s : shortarray;
$l : longarray;
$i : INTEGER;
$
$PROCEDURE P(r1,r2,r3 : rec; s1,s2 : shortarray; l1 : longarray);
$BEGIN
$END P;
%
"BEGIN
$FOR i:=1 TO 25000 DO
&P(r,r,r,s,s,l);
$END;
"END StructurePassing;
 
"PROCEDURE ConversionCheck;
"VAR
$i : CARDINAL;
$c,pos : CARDINAL;
$lc : LONGCARD;
$r : REAL;
$str : ARRAY [0..80] OF CHAR;
$Ok : BOOLEAN;
 
"BEGIN
$c := 1;
$lc := 1D;
$r := 1.1;
$FOR i:=1 TO 2000 DO
&Convert.ConvCard(c,2,str);
&pos:= 0;
&c:= StrConv.StrToCard(str,pos,Ok);
&Convert.ConvCard(lc,2,str);
&pos:= 0;
&lc:= StrConv.StrToLCard(str,pos,Ok);
&Convert.ConvReal(r,4,2,str);
&pos:= 0;
&r:= StrConv.StrToReal(str,pos,Ok);
$END;
"END ConversionCheck;
 
 
"PROCEDURE StringCheck;
"VAR
$i,x : CARDINAL;
$s1,s2,s3 : ARRAY [0..80] OF CHAR;
$
"BEGIN
$s1 := "Benchmarks don't lie,";
$s2 := "But Liars do benchmarking.";
$FOR i:=1 TO 2000 DO
&Assign(s1,s3);
&Append(s2,s3);
&x := Length(s3);
&x := INTEGER(Compare(s1,s2));
$END;
"END StringCheck;
 
 
 (* nun mit Reg-Vars *)
 
"PROCEDURE rIntMathShort;
"VAR
$(*$Reg*)x,(*$Reg*)y,(*$Reg*)i : CARDINAL;
 
"BEGIN
$x := 0;
$FOR i:=0 TO 20000 DO
&y := 3;
&x := x + (y*y-y) DIV y;
&INC(y);
$END;
$dummy := x+y;
"END rIntMathShort;
 
 
"PROCEDURE rIntMathLong;
"VAR
$(*$Reg*)x,(*$Reg*)y : LONGCARD;
$(*$Reg*)i : CARDINAL;
$
"BEGIN
$x := 0;
$FOR i:=0 TO 20000 DO
&y := 3;
&x := x + (y*y-y) DIV y;
&INC(y);
$END;
$dummyL:= x+y;
"END rIntMathLong;
 
 
"PROCEDURE rWhile;
"VAR
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&WHILE i<10000 DO
(INC(i);
&END;
$END;
"END rWhile;
"
"PROCEDURE rRepeat;
"VAR
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&REPEAT
(INC(i);
&UNTIL i=10000;
$END;
"END rRepeat;
"
"PROCEDURE rLoop;
"VAR
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&i := 0;
&LOOP
(INC(i);
(IF i=10000 THEN EXIT; END;
&END;
$END;
"END rLoop;
 
"PROCEDURE rFor;
"VAR
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
&END;
$END;
"END rFor;
"
"
"PROCEDURE rArrayAccess;
"VAR
$a : ARRAY [1..10000] OF INTEGER;
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
(a[i] := 0;
&END;
$END;
$dummy := a[7];
"END rArrayAccess;
"
"
"PROCEDURE rRecordAccess;
"VAR
$r : RECORD
*a : INTEGER;
*b : INTEGER;
(END;
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=1 TO 10000 DO
(r.a := 1;
(r.b := 1;
&END;
$END;
$dummy := r.a;
"END rRecordAccess;
"
"
"PROCEDURE rRecordArray;
"VAR
$a : ARRAY [0..2000] OF RECORD
>u : INTEGER;
>v : CHAR;
>w : LONGINT;
<END;
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=0 TO 2000 DO
(a[i].u := 10;
(a[i].v := "a";
(a[i].w := 10;
&END;
$END;
$dummy := a[7].u;
"END rRecordArray;
"
"
"PROCEDURE rRecordArrayWith;
"VAR
$a : ARRAY [0..2000] OF RECORD
>u : INTEGER;
>v : CHAR;
>w : LONGINT;
<END;
$(*$Reg*)i,(*$Reg*)j : INTEGER;
$
"BEGIN
$FOR j:=1 TO 10 DO
&FOR i:=0 TO 2000 DO
(WITH a[i] DO
*u := 10;
*v := "a";
*w := 10;
(END;
&END;
$END;
$dummy := a[7].u;
"END rRecordArrayWith;
 
"PROCEDURE rParameterPassing;
"VAR
$(*$Reg*)x : INTEGER;
$(*$Reg*)d,(*$Reg*)e : LONGINT;
$a,b,(*$Reg*)c : INTEGER;
$(*$Reg*)f,(*$Reg*)g : CHAR;
$h,i : LONGREAL;
$
$
$PROCEDURE fewval(a,b : INTEGER);
$BEGIN
$END fewval;
$
$
$PROCEDURE fewvar(VAR a,b : INTEGER);
$BEGIN
$END fewvar;
$
$
$PROCEDURE manyval(a,b,c : INTEGER; d,e : LONGINT;
6f,g : CHAR; h,i : LONGREAL );
$BEGIN
$END manyval;
$
$
$PROCEDURE manyvar(VAR a,b,c : INTEGER; VAR d,e : LONGINT;
6VAR f,g : CHAR; VAR h,i : LONGREAL);
$BEGIN
$END manyvar;
$
*
"BEGIN
$a := 1;
$b := 1;
$c := 1;
$d := 1;
$e := 1;
$f := "a";
$g := "b";
$h := 1.1;
$i := 1.1;
$FOR x:=0 TO 25000 DO
&fewval(1,1);    (* constant values *)
&fewval(a,b);
&manyval(1,1,1,1,1,"a","a",1.1,1.1);       (* constant values *)
&manyval(a,b,c,d,e,f,g,h,i);
&fewvar(a,b);
$END;
"END rParameterPassing;
 
 
 VAR ch: CHAR;
 
 BEGIN
"InOut.WriteString ('Output file? ');
"InOut.OpenOutput ('TXT');
"InOut.WriteLn;
"InOut.WriteString("Benchmark AG Version 1.2 for Megamax Modula-2 V4.0");
"InOut.WriteLn;
"
"InOut.WriteString("--------------------------------------------------");
"InOut.WriteLn;
"(*
"Test("Intmath short   :",IntMathShort);
"Test("Intmath long    :",IntMathLong);
"*)
"Test("Realmath short  :",RealMathShort);
"Test("Realmath long   :",RealMathLong);
"Test("Triglog short   :",TriglogShort);
"Test("Triglog long    :",TriglogLong);
"(*
"Test("FOR             :",For);
"Test("LOOP            :",Loop);
"Test("REPEAT          :",Repeat);
"Test("WHILE           :",While);
"Test("ArrayAccess     :",ArrayAccess);
"Test("RecordAccess    :",RecordAccess);
"Test("RecordArray     :",RecordArray);
"Test("RecordArrayWith :",RecordArrayWith);
"Test("WriteToFile     :",WriteToFile);
"Test("ReadFromFile    :",ReadFromFile);
"Test("Pass Parameters :",ParameterPassing);
"Test("Pass Structures :",StructurePassing);
"Test("Conversions     :",ConversionCheck);
"Test("Strings         :",StringCheck);
"*)
"
"(*
"InOut.WriteString("-- mit Register - Optimierung --------------------");
"InOut.WriteLn;
"
"Test("Intmath short   :",rIntMathShort);
"Test("Intmath long    :",rIntMathLong);
"Test("FOR             :",rFor);
"Test("LOOP            :",rLoop);
"Test("REPEAT          :",rRepeat);
"Test("WHILE           :",rWhile);
"Test("ArrayAccess     :",rArrayAccess);
"Test("RecordAccess    :",rRecordAccess);
"Test("RecordArray     :",rRecordArray);
"Test("RecordArrayWith :",rRecordArrayWith);
"Test("Pass Parameters :",rParameterPassing);
"*)
"
"InOut.WriteString("--------------------------------------------------");
"InOut.WriteLn;
"InOut.CloseOutput
 END MM2Bench.
 
(* $FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$000010B9$FFE77EA6$00002E41$FFE77EA6$000010B4$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$FFE77EA6$000010B9T.......T.......T..T....T.......T.......T.......T.......T.......T.......T.......$000018C0$0000284F$000028A7$00002954$00002B91$00002BF8$00002C4D$00002BF8$00002B99$00002DBF$00001290$000010B9$00001A8D$000018C0$00002762$00001A8D*)
