 IMPLEMENTATION MODULE EasyGEM1;
 (*$R-*)
 (*$Y- wichtig, damit jeder Proze seine eigenen Vars hat! *)
 
 (*  System              : Megamax Modula-2 (MOS 2.0)
!*  Autor & Copyright   : Thomas Tempelmann
!*  Vertrieb            : Application Systems Heidelberg
!*  Version             : 1.0
!*
!* 03.11.90 TT  SelectFile: wenn ABBRUCH gewhlt, bleibt 's' leer
!* 07.12.90 TT  $Y-
!* 08.12.90 TT  nderung vom 3.11. wieder weg.
!* 17.12.90 TT  SelectFile: GemInit immer, aber GemHandle wird gerettet
!* 19.02.91 TT  SelectFile: GemHandle wird nun korrekt gerettet/restauriert
!* 27.03.91 TT  SelectFile: Bei "Abbruch" liefert 'ok' wieder FALSE
!*)
 
 FROM MOSGlobals IMPORT SfxStr, FileStr;
 
 FROM AESMisc IMPORT ShellEnvironment, ReadScrapDir, WriteScrapDir;
 
 IMPORT MOSGlobals, Directory, Strings, FastStrings, FileNames, GEMEnv,
'PathEnv;
 
 
 CONST ClipEnv  = 'CLIPBRD';
&ClipName = '\CLIPBRD';
 
 
 PROCEDURE SelectFile (titel: ARRAY OF CHAR;
6VAR s: ARRAY OF CHAR; VAR ok: BOOLEAN);
"VAR oldGemHdl: GEMEnv.GemHandle;
&ok2: BOOLEAN;
&ior: INTEGER;
&path: ARRAY [0..127] OF CHAR;
&name, dummy: ARRAY [0..11] OF CHAR;
"BEGIN
$oldGemHdl:= GEMEnv.CurrGemHandle ();
$GEMEnv.InitApplication (ok);
$IF ok THEN
&FileNames.SplitPath (s, path, name);
&IF path[0] # 0C THEN
(FastStrings.Assign (path, SelectMask)
&END;
&Directory.MakeFullPath (SelectMask, ior);
&IF ior < 0 THEN
(Directory.GetDefaultPath (SelectMask);
&END;
&IF Strings.Length (FileNames.FileName (SelectMask)) = 0 THEN
(Strings.Append ('*.*', SelectMask, ok);
&END;
&PathEnv.SelectFile (titel, SelectMask, name, ok);
&IF ok THEN
(FileNames.SplitPath (SelectMask, s, dummy);
(FastStrings.Append (name, s);
&END;
&GEMEnv.ExitApplication;
&GEMEnv.SetCurrGemHandle (oldGemHdl, ok2)
$END;
"END SelectFile;
 
 
 VAR ok: BOOLEAN;
 
 PROCEDURE getPath (VAR name: ARRAY OF CHAR; createNew: BOOLEAN): BOOLEAN;
 
"VAR res: INTEGER;
&drvs: MOSGlobals.DriveSet;
&drv: [MOSGlobals.drvA..MOSGlobals.drvP];
 
"PROCEDURE makeDir (): BOOLEAN;
$BEGIN
&IF NOT Directory.PathExists (FileNames.PathValidated (name)) THEN
(IF createNew THEN
*Directory.CreateDir (name, res);
*RETURN res >= 0
(ELSE
*RETURN FALSE
(END
&END;
&RETURN TRUE
$END makeDir;
 
"PROCEDURE makeDirOnDrv (drv: MOSGlobals.Drive): BOOLEAN;
$BEGIN
&Strings.Concat (FileNames.DriveToStr (drv), ClipName, name, ok);
&RETURN makeDir ()
$END makeDirOnDrv;
 
"BEGIN
$ReadScrapDir (name);
$IF name [0] = 0C THEN
&ShellEnvironment (ClipEnv, name);
$END;
$IF (name [0] # 0C) AND makeDir () THEN
&RETURN TRUE
$END;
$drvs:= Directory.DrivesOnline ();
$FOR drv:= MOSGlobals.drvC TO MOSGlobals.drvP DO
&IF drv IN drvs THEN
(IF makeDirOnDrv (drv) THEN
*RETURN TRUE
(END
&END
$END;
$RETURN makeDirOnDrv (MOSGlobals.drvA)
"END getPath;
 
 PROCEDURE MakeScrapName (suffix: SfxStr; VAR name: ARRAY OF CHAR);
"BEGIN
$IF getPath (name, TRUE) THEN
&FileNames.ValidatePath (name);
&WriteScrapDir (name);
&Strings.Append ('SCRAP.', name, ok);
&Strings.Append (suffix, name, ok);
$ELSE
&name [0]:= 0C;
&WriteScrapDir ('');
$END;
"END MakeScrapName;
 
 
 (*$J-*)
 PROCEDURE delete (REF path: ARRAY OF CHAR; entry: Directory.DirEntry): BOOLEAN;
 (*$J=*)
"VAR res: INTEGER;
"BEGIN
$Directory.Delete (FileNames.PathConc (path, entry.name), res);
$RETURN res >= 0
"END delete;
 
 PROCEDURE ClearScrap;
"VAR res: INTEGER;
"VAR name: FileStr;
"BEGIN
$IF getPath (name, FALSE) THEN
&FileNames.ValidatePath (name);
&WriteScrapDir (name);
&Strings.Append ('SCRAP.*', name, ok);
&Directory.DirQuery (name, Directory.QueryFiles, delete, res);
$END
"END ClearScrap;
 
 END EasyGEM1.
 
(* $00000749$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFEA1AAE$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$FFE9F4E3$00000291T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFF2415C$00000291$FFF2415C$00000426$00000706$0000024F$00000291$0000026F$00000291$000004E4$FFF2415C$00000404$000004B5$0000024F$00000259$FFF2415C*)
