 IMPLEMENTATION MODULE FastGEM0;(*Y+*)
 
 
 (*  --------------------------------------------------------------------------
!*  System-Version: MOS 1.1
!*  --------------------------------------------------------------------------
!*  Version       : 0.01
!*  --------------------------------------------------------------------------
!*  Text-Version  : V#0008
!*  --------------------------------------------------------------------------
!*  Modul-Holder  : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Copyright July 1988 by Manuel Chakravarty
!*  Vertriebsrechte fr ATARI ST unter MEGAMAX Modula-2
!*                  liegen bei Application Systems Heidelberg
!*  --------------------------------------------------------------------------
!*  MCH : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Datum    Autor  Version  Bemerkung (Arbeitsbericht)
!*
!*  14.08.89 MCH    V0.01    Urversion; 'CopyOpaque' impl. + def.
!*  --------------------------------------------------------------------------
!*  Modul-Beschreibung:
!*
!*  Dies Modul stellt eine schnelle Kopierfunktion fr beliebige Bildschirm-
!*  bereiche zur Verfgung.
!*
!*  --------------------------------------------------------------------------
!*)
 
 (*  =========== ZU TUN: ==============
!*
!*  -- berprfen, ob die Routinen immer VDI aufrufen, wenn die ASM-Routine
!*     versagt.
!*
!*  =========== DOCU: ================
!*
!*)
 
 
 FROM SYSTEM     IMPORT ASSEMBLER, BYTE, ADDRESS;
 
 FROM GrafBase   IMPORT Rectangle, BitOperation, PtrMemFormDef, MemFormDef,
7GetBlitterMode, GetScreen;
 
 FROM GEMEnv     IMPORT DeviceHandle;
 
 IMPORT VDIRasters;
 
 
 TABLE.W masks:  $FFFF, $7FFF, $3FFF, $1FFF,     (*  Tabelle fr 'copyOpaque'  *)
0$0FFF, $07FF, $03FF, $01FF,
0$00FF, $007F, $003F, $001F,
0$000F, $0007, $0003, $0001;
0
((*    wortbreite, planes  *)            (*  Bildschirmauflsungen  *)
(
(rez:     80,      4,        (*  Low-Res  *)
180,      2,        (*  Mid-Res  *)
140,      1;        (*  High-Res  *)
(
 PROCEDURE CopyOpaque (dev        : DeviceHandle;
6sourceMem,
6destMem    : PtrMemFormDef;
6sourceFrame,
6destFrame  : Rectangle;
6mode       : BitOperation);
6
"VAR   screenAddr      : ADDRESS;
(words, planes   : CARDINAL;
(wordAlign       : BYTE;
 
"PROCEDURE longCopy;
"
$(*$L-*)
$BEGIN
&ASSEMBLER
(TST.W   sourceFrame.w(A6)
(BPL     ok1
(CLR.W   sourceFrame.w(A6)
 ok1
(TST.W   sourceFrame.h(A6)
(BPL     ok2
(CLR.W   sourceFrame.h(A6)
 ok2
 
(MOVEM.L D3-D7/A3-A5,-(A7)
(
(MOVE.W  planes(A6),A3   ; Anzahl Randwrter links -> A3
(MOVE.W  A3,A4           ; Anzahl Randwrter rechts -> A4
(
(MOVE.W  sourceFrame.x(A6),D0
(MOVE.W  D0,D2
(ANDI.W  #$F,D0
(MOVE.W  #16,D7
(SUB.W   D0,D7
(MOVE.W  D7,-(A7)        ; Anzahl linke Randbits merken (Stack)
(ADD.W   D0,D0
(LEA     masks,A0
(MOVE.L  A0,A1
(ADDA.W  D0,A0
(MOVE.W  (A0),D1         ; Linke Kopiermaske -> D1
(MOVE.W  D1,D3
(NOT.W   D3              ; Linke negierte Kopiermaske -> D3
(
(ADD.W   sourceFrame.w(A6),D2
(ANDI.W  #$F,D2
(MOVE.W  D2,-(A7)        ; Anzahl rechte Randbits merken (Stack)
(ADD.W   D2,D2
(ADDA.W  D2,A1
(MOVE.W  (A1),D4         ; Rechte negierte Kopiermaske -> D4
(MOVE.W  D4,D2
(NOT.W   D2              ; Rechte Kopiermaske -> D2
(BNE     c
(CLR.W   (A7)            ; Keine rechten Randbits merken
(MOVE.W  #0,A4           ; Rechts ist Wortgrenze => Keine Maske ntig
 c
(
(MOVE.W  sourceFrame.w(A6),D0
(SUB.W   (A7)+,D0        ; Randbits abziehen
(SUB.W   (A7)+,D0
(BPL     c2
(AND.W   D2,D1
(OR.W    D4,D3
(MOVE.W  #0,A4
(CLR.W   D0
 c2
(LSR.W   #4,D0
(MULU.W  planes(A6),D0
(MOVE.W  D0,D7
(ADD.W   A3,D7
(ADD.W   A4,D7
(MOVE.W  words(A6),A5
(SUBA.W  D7,A5
(ADDA.W  A5,A5           ; Zeilenoffset in Byte -> A5
(MOVE.W  D7,-(A7)        ; Anzahl pro Zeile zu kopierende Words -> Stack
(LSR.W   #1,D0
(SCS     wordAlign(A6)   ; wordAlign-Flag -> 'wordAlign'
(MOVE.W  D0,A2           ; Anzahl Longs pro Zeile -> A2
(
(MOVE.W  sourceFrame.h(A6),D5    ; Anzahl Zeilen -> D5
(
(;       Startaddressenberechnung
(
(MOVE.W  sourceFrame.y(A6),D0
(MULU.W  words(A6),D0
(ADD.W   D0,D0
(MOVEQ   #0,D7
(MOVE.L  D7,A0
(MOVE.W  D0,A0
(MOVE.W  sourceFrame.x(A6),D0
(LSR.W   #3,D0
(AND.W   #$FE,D0
(ADDA.W  D0,A0
(ADDA.L  screenAddr(A6),A0       ; sourceAddr -> A0
(
(MOVE.W  destFrame.y(A6),D0
(MULU.W  words(A6),D0
(ADD.W   D0,D0
(MOVEQ   #0,D7
(MOVE.L  D7,A1
(MOVE.W  D0,A1
(MOVE.W  destFrame.x(A6),D0
(LSR.W   #3,D0
(AND.W   #$FE,D0
(ADDA.W  D0,A1
(ADDA.L  screenAddr(A6),A1       ; destAddr -> A1
(
(CMPA.L  A0,A1
(BCS.W   forward
(
(;       --- Kopie RCKWRTS ---
(
(MOVE.W  sourceFrame.h(A6),D0
(SUBQ.W  #1,D0
(MULU.W  words(A6),D0
(ADD.W   (A7)+,D0        ; Anzahl zu kopierende Wrter pro Zeile add.
(ADD.W   D0,D0
(ADDA.W  D0,A0
(ADDA.W  D0,A1
(
(BRA     startBack       ; Start Kopierschleife (rckwrts)
 lBack
(MOVE.W  A4,D0           ; Start rechte Maske
(BRA     sBRight
 lBRight
(MOVE.W  -(A1),D6
(AND.W   D4,D6
(MOVE.W  -(A0),D7
(AND.W   D2,D7
(OR.W    D6,D7
(MOVE.W  D7,(A1)
 sBRight
(DBF     D0,lBRight
(
(TST.B   wordAlign(A6)   ; Start Align
(BEQ     noAlignB
(MOVE.W  -(A0),-(A1)
 noAlignB
 
(MOVE.W  A2,D0           ; Start kopiere Longs
(BRA     sBLongs
 lBLongs
(MOVE.L  -(A0),-(A1)
 sBLongs
(DBF     D0,lBLongs
(
(MOVE.W  A3,D0           ; Start linke Maske
(BRA     sBLeft
 lBLeft
(MOVE.W  -(A1),D6
(AND.W   D3,D6
(MOVE.W  -(A0),D7
(AND.W   D1,D7
(OR.W    D6,D7
(MOVE.W  D7,(A1)
 sBLeft
(DBF     D0,lBLeft
 
(SUBA.W  A5,A0           ; Addr. der nchsten Zeile ermittlen
(SUBA.W  A5,A1
 startBack
(DBF     D5,lBack
(
(BRA     ende
(
(;       --- Kopie VORWRTS ---
(
 forward
(ADDQ.L  #2,A7           ; A7 bereinigen
(BRA     startFore       ; Start Kopierschleife (vorwrts)
 lFore
(MOVE.W  A3,D0           ; Start linke Maske
(BRA     sFLeft
 lFLeft
(MOVE.W  (A1),D6
(AND.W   D3,D6
(MOVE.W  (A0)+,D7
(AND.W   D1,D7
(OR.W    D6,D7
(MOVE.W  D7,(A1)+
 sFLeft
(DBF     D0,lFLeft
(
(TST.B   wordAlign(A6)   ; Start Align
(BEQ     noAlignF
(MOVE.W  (A0)+,(A1)+
 noAlignF
 
(MOVE.W  A2,D0           ; Start kopiere Longs
(BRA     sFLongs
 lFLongs
(MOVE.L  (A0)+,(A1)+
 sFLongs
(DBF     D0,lFLongs
(
(MOVE.W  A4,D0           ; Start linke Maske
(BRA     sFRight
 lFRight
(MOVE.W  (A1),D6
(AND.W   D4,D6
(MOVE.W  (A0)+,D7
(AND.W   D2,D7
(OR.W    D6,D7
(MOVE.W  D7,(A1)+
 sFRight
(DBF     D0,lFRight
 
(ADDA.W  A5,A0           ; Addr. der nchsten Zeile ermittlen
(ADDA.W  A5,A1
 startFore
(DBF     D5,lFore
(
 ende
(MOVEM.L (A7)+,D3-D7/A3-A5
&END;
$END longCopy;
$(*$L=*)
 
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     GetBlitterMode
(MOVE.W  (A7)+,D0
(AND.W   (A7)+,D0
(BNE     vdiCopy         ; Springe, falls Blitter vorhanden + aktiv
(
(MOVE.W  mode(A6),D0
(CMP.W   #onlyS,D0
(BNE     vdiCopy         ; Springe, falls kein replace-mode
(
(MOVE.L  sourceMem(A6),A0
(MOVE.L  MemFormDef.start(A0),D0
(MOVE.L  destMem(A6),A0
(CMP.L   MemFormDef.start(A0),D0
(BEQ     cont
#
 vdiCopy
$END;
$VDIRasters.CopyOpaque (dev, sourceMem,destMem, sourceFrame, destFrame,
;mode);
$ASSEMBLER
(BRA     ende
"
 cont
(TST.L   D0
(BNE     mfdbValid
(
(;       Bildschirmaddresse und die Breite einer Scanzeile ermitteln
(
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     GetScreen
(
(MOVE.W  (A7)+,D0
(LSL.W   #2,D0
(LEA     rez,A0
(ADDA.W  D0,A0
(MOVE.W  (A0)+,words(A6)
(MOVE.W  (A0),planes(A6)
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,screenAddr(A6)
(BRA     cont3
(
(;       Werte aus MFDB bernehmen
(
 mfdbValid
(MOVE.L  D0,screenAddr(A6)
(MOVE.W  MemFormDef.words(A0),words(A6)
(MOVE.W  MemFormDef.planes(A0),planes(A6)
(
 cont3
(MOVE.W  sourceFrame.x(A6),D0
(ANDI.W  #$F,D0
(MOVE.W  destFrame.x(A6),D1
(ANDI.W  #$F,D1
(CMP.W   D0,D1
(BNE     vdiCopy
(CMPI.W  #1,planes(A6)
(BNE     vdiCopy
(BSR     longCopy
(
 ende
$END;
"END CopyOpaque;
 
 
 END FastGEM0.
  
(* $FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$00001CBF$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$FFEC9B95$00000027T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000006B7$00001CAF$000006FA$00000020$FFEC88E0$00002066$0000063D$000005E1$00000027$00002056$00002043$00000703$00000885$00000896$000006FA$0000064B*)
