 IMPLEMENTATION MODULE GEMBase;(*$Y+*)
 
 (*  --------------------------------------------------------------------------
!*  System-Version: MOS 2.2
!*  --------------------------------------------------------------------------
!*  Version       : 1.0
!*  --------------------------------------------------------------------------
!*  Text-Version  : V#0024
!*  --------------------------------------------------------------------------
!*  Modul-Holder  : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Copyright July 1988 by Manuel Chakravarty
!*  Vertriebsrechte fr ATARI ST unter MEGAMAX Modula-2
!*                  liegen bei Application Systems Heidelberg
!*  --------------------------------------------------------------------------
!*  MCH : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Datum    Autor  Version  Bemerkung (Arbeitsbericht)
!*
!*  01.04.90 MCH    1.0      Creation; Decls + 'GetPBs', 'VDIHandle, 'CallVDI',
!*                           'CallAES' def. + impl.
!*  --------------------------------------------------------------------------
!*  Modul-Beschreibung:
!*
!*  Dieses Modul soll das Programmieren von VDI- und AES-Aufrufen gestatten,
!*  die die GEM-Library umgehen. Die Namen wurden soweit mglich direkt von
!*  entsprechenden C-Bindings bernommen und deshalb sollte es unter zur
!*  Hilfe nahme entsprechender GEM-Literatur mglich sein dieses Modul ohne
!*  groe Erklrungen, die diesen Rahmen sprengen wrden zu benutzen.
!*
!*  --------------------------------------------------------------------------
!*)
 
 
 FROM    SYSTEM          IMPORT ASSEMBLER, ADDRESS;
 
 FROM    MOSGlobals      IMPORT IllegalPointer;
 
 FROM    GEMEnv          IMPORT GemHandle, DeviceHandle;
 
 IMPORT  GEMShare;
 
 (*$I GEMOps.ICL  *)
 
 
 (*  Abfrageroutinen  *)
 
 PROCEDURE GetPBs (gemHdl: GemHandle; VAR vdipb: VDIPB; VAR aespb: AESPB);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
$
(;  'aespb' lschen (fr Fehlerausgang) + 'ADR (aespb) -> A2
(;
(MOVE.L  -(A3), A0
(MOVE.L  A0, A2
(MOVEQ   #5, D0
 loop1
(CLR.L   (A0)+
(DBF     D0, loop1
(
(;  'vdipb' lschen (fr Fehlerausgang) + 'ADR (vdipb) -> A1
(;
(MOVE.L  -(A3), A0
(MOVE.L  A0, A1
(MOVEQ   #4, D0
 loop2
(CLR.L   (A0)+
(DBF     D0, loop2
(
(;  berprfe ob 'gemHdl' o.k. ist + 'gemhdl' -> A0
(;
(MOVE.L  -(A3), D0
(BCLR    #0, D0
(BNE     ende            ;  LSB gesetzt => illegales handle
(TST.L   D0
(BEQ     ende            ;  'gemHdl = NoGemHandle' => illegales handle
(MOVE.L  D0, A0
(
(;  berprfe magic number
(;
(MOVE.W  cb.MAGIC(A0), D0
(CMP.W   #cbMagic, D0
(BEQ     ok
(TRAP    #noErrorTrap
(DC.W    IllegalPointer - $4000
(BRA     ende
 
(;  kopiere VDI- und AES-Parameterblock
(;
 ok
(PEA     (A0)
(LEA     cb.VDIPB(A0), A0
(MOVEQ   #4, D0
 loop3
(MOVE.L  (A0)+, (A1)+
(DBF     D0, loop3
(MOVE.L  (A7)+, A0
(LEA     cb.AESPB(A0), A0
(MOVEQ   #5, D0
 loop4
(MOVE.L  (A0)+, (A2)+
(DBF     D0, loop4
 ende
$END;
"END GetPBs;
"(*$L=*)
"
 (*$J-*)
 PROCEDURE VDIHandle (dev: DeviceHandle): INTEGER;
 (*$J=*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3), D0
(AND.W   #-2, D0                  ; Addr. mu gerade sein
(MOVE.L  D0, A0
(CMPA.L  #NIL, A0
(BNE     cont
(CLR.W   (A3)+
(BRA     ende
 cont
(MOVE.W  device.magic(A0), D0
(CMP.W   #deviceMagic, D0
(BEQ     cont2
(TRAP    #noErrorTrap
(DC.W    IllegalPointer - $4000
(CLR.W   (A3)+
(BRA     ende
 cont2
(MOVE.W  device.handle(A0), (A3)+
 ende
$END;
"END VDIHandle;
"(*$L=*)
"
 
 (*  Aufrufroutinen  *)
 
 PROCEDURE CallVDI (ptrpb: PtrVDIPB);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  A0,D1
(MOVE.L  #VDICode,D0
(TRAP    #GEMTrap
$END;
"END CallVDI;
"(*$L=*)
"
 PROCEDURE CallAES (ptrpb: PtrAESPB);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3), A0
(MOVE.L  A0,D1
(MOVE.W  #AESCode,D0
(TRAP    #GEMTrap
$END;
"END CallAES;
"(*$L=*)
"
 END GEMBase.
 
  
(* $FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$00000ED8$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$FFEC55E7$00000023T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000027$00000D56$FFEC55E7$00000D56$00000C67$00000E30$00000778$0000045D$00000404$00000B38$00000BB6$FFEC557B$0000079B$000007F4$00000C3F$0000080E*)
