 
 (*  Atari-Editor
!*------------------------------------------------------------------------------
!* Copyright 1986-1990 by Thomas Tempelmann
!*------------------------------------------------------------------------------
!* TT:  Thomas Tempelmann, Schusterwolfstr.13, 81241 Mnchen, Tel.089/8347394
!* H:  Wilfried Hbner, Hohenzollernstr. 8B, D-1000 Berlin 39
!* HSK: Hannes Krohn, Kreuzstr. 35, Karlsruhe
!*------------------------------------------------------------------------------
!* 0.0: H.-J. Himmerder  :23.02.85: Grundversion
!* 1.0: TT  :27.06.86: bernahme des Gepard-Editors 2.p
!* 1.1: TT  :27.07.86: Load/Save impl.
!* 1.2: TT  :06.09.86: Cleantext schneller, Aufruf nach Load/Save
!* 1.3: TT  :23.10.86: Infoblock in Kommentarzeile; Saveinfo nur,
!*                     wenn er beim Laden schon da war.
!* 1.4: TT  :25.10.86: Tabs werden richtig erkannt (-> "")
!* 1.5: TT  :27.10.86: Hoffentlich kein Addr-Err mehr bei save
!* 1.6: TT  :02.03.87: Zeilennummern nun +1; Bei Frames wird
!*                     'saveInfo' gerettet; C(op F(ile raus;
!*                     HardCopy korrig.; Cursor wird bei Pos-
!*                     bergabe in ArgV[2] positioniert.
!* 1.7: TT  :03.03.87: Quit: X und C, TextPos vor CleanText gesetzt
!* 1.8: TT  :04.03.87: CleanText jetzt endlich richtig; F7/F8.
!* 1.9: TT  :09.05.87: Save erkennt Disk full
!* 2.0: TT  :25.07.87: Umstellung als MOS-Modul
!* 2.1: TT  :29.08.87: Nach Q, S, Return kein extra Zeichen am Textende
!* 2.2: TT  :14.09.87: FileSearch immer
!* 2.3: TT  :04.11.87: Code-Optimierungen
!* 2.4: TT  :25.12.87: ArgV-Auswertung erneuert
!* 2.5: TT  :25.01.88: In ArgV[3] wird die Spalte jetzt 0-based erwartet
!* 2.6: TT  :11.04.88: Luft auch in Farbe.
!* 2.6: TT  :13.04.88: Farben werden gerettet.
!* 2.7: TT  :15.04.88: VOR Scrn-Rckschaltung wird auf VBL gewartet.
!* 2.8: TT  :18.04.88: Startup-Msg gendert, TextName wird auch bei QN gesetzt.
!* 2.9: TT  :02.06.88: Cleantext erkennt overflow; SaveText lscht File, wenn
!*                     Schreibfehler; Compiler wird mit F5 gestartet - Achtung:
!*                     Wenn Fehler in Include-File, wird der Text nicht geladen
!*                     DLEChar v. $E auf $10 korrigiert.
!* 2.A: TT  :24.07.88: GotoLine hngt nicht, wenn Zeile = 0.
!* 2.B: TT  :10.08.88: Ausgabe beschleunigt; Farb-Auswahl nun ok; InsKey/DelKey
!*                     alternativ fr Insert-/Delete-Modus; Tabs werden bei F3
!*                     initialisiert.
!*           16.08.88: Ctrl-left/right f. SOLn/EOLn
!* 2.C       10.09.88: Farbausgabe: ClearEndOfLine korrigiert
!* 2.C+ H  :16.04.89: FileSelectBox (readOnly) eingebaut. Textcursor kann mit
!*                     Maus versetzt werden. Scrolling durch Mausbettigung
!*                     an den vertikalen Bildschirmrndern.
!* 2.D  TT   19.04.89: FileSelect-Box auch bei Schreiboperationen; Pfadname
!*                     in FS enthlt auch Laufwerksbuchstabe; SaveText liefert
!*                     FALSE bei Schreibfehler -> Text geht nicht mehr bei 'QU'
!*                     verloren; CmdLineAway prft auch Mausklick; '.TXT' wird
!*                     nicht mehr automatisch angefgt; Tab-Weite kann in
!*                     'ET' bestimmt werden; Quick-Save-Option; Backup-Name
!*                     wird richtig gebildet; Ctrl-Z bei Save zw. Textende und
!*                     Info-Line.
!* 2.E  TT   23.04.89: GetPath fgt ggf. '\' an Pfad an, damit es keine Probleme
!*                     mit altem Directories-Modul gibt; FileSelect zeigt Frage
!*                     an; Mauskontrolle berarbeitet (WaitForKey); kein Absturz
!*                     wenn 'Overflow' in GetFile; Nach L(ook kann mit J(ump -
!*                     an Ursprungsstelle zurckgesprungen werden; Kein Hnger
!*                     bei Delete ber Textanfang/-ende; TabLeft jetzt mit
!*                     Ctrl- oder Shift-Tab; ScrollUp/Down mit Ctrl-Up/Down;
!*                     Hardcopy wieder drin.
!*      TT   28.04.89: Bei F3 wird neue Frame-Nr wieder aktualisiert
!* 2.F  TT   14.05.89: Wenn von niedriger auf mittl. Auflsung umgeschaltet
!*                     werden mu, wird kein GEM (Maus, FileSelect) verwendet
!*      TT   22.05.89: Kein Hnger, wenn Ctrl-Z erstes Zeichen im Text
!* 2.G  TT   25.05.89: Ctrl-Z wird nicht am Textende erzeugt, wenn kein
!*                      <Save Info-line>.
!* 2.H  HSK  13.11.88: Mit F6 wird in .DEF-Files nach dem Identifier unter dem
!*                     Cursor gesucht, das entsprechende .D-File geladen und
!*                     der Cursor auf den Identifier positioniert.
!*                     Mit 'FindWord' wird der vollst. Name gesucht, sonst nach
!*                     dessen Anfang.
!*      TT   09.07.89: Laden eines leeren Textes gibt keinen Absturz mehr.
!*                     Leereingabe mit [ OK ] bei Fileselect sucht nicht mehr.
!*                     Dateifehler als Text (bisher Nr).
!* 2.I  TT   17.07.89: F6 geht auch bei M2LIB.DEF
!* 2.J  TT   25.07.89: CallCompiler bergibt neue Options f. Compiler 3.6p
!*      TT   06.08.89: Enter-Taste nun direction-unabhngig (immer runter);
!*                     Compiler-Name nun 'MM2Comp'
!* 2.H  TT   08.08.89: Datum der Source wird ggf. nach Comp-Aufruf neu gesetzt;
!*                     Maus-Kontrolle gendert, damit bei FormAlert die Maus
!*                     sichtbar ist.
!*      TT   10.08.89: "Save editor info-line" defaultmig nun auf FALSE;
!*                     '' wird auch als Alpha-Zeichen erkannt.
!*      TT   15.08.89: Maus-Kontrolle nochmals gendert (TRUE bei ShowCursor)
!*      TT   19.08.89: DefLibName importiert, wird nicht mehr gesucht
!*      TT   20.08.89: Quit mit Make, Make-Exec
!* 2.I  TT   13.09.89: F6 sollte nun auch mit LibFiles gehen
!* 2.J  TT   14.12.89: nderungen an Shortkeys
!*      TT   11.01.90: F6 findet nun alle Items, auch Rec-Felder & Enum-Elems;
!*                     Environment: X setzt Cursor immer an Textbeginn
!*      TT   17.01.90: Compilername wird aus ShellMsg importiert
!* 2.K  TT   13.03.90: Bei Enlarge-Fehler hoffentlich kein Bus-Error mehr
!*      TT   09.05.90: F6 sucht bei Modulnamen nicht mehr weiter im gefundenen
!*                     Source; CompV4-Anpassung; F6 benutzt 'ReplaceHome'. 
!* 2.L  TT   15.07.90: Enlarge wird nun korrekt aufgerufen.
!* 2.M  TT   20.08.90: Sollte nun bei Autoswitch-Overscan auf normal schalten;
!*                     MoveText und Find/Replace schneller.
!* 2.N  TT   15.09.90: Mgl. Buserrors bei FindDefFile abgefangen. F6 kommt
!*                     wieder mit Records klar.
!* 2.O  TT   18.09.90: Overscan-Switch korrigiert.
!* 2.P  TT   09.10.90: Luft auch mit TT
!* 2.Q  TT   14.11.90: FileSelector wird versuchsweise auch bei Auflsungs-
!*                     wechsel bei ST & TT verwendet (s. InitScreen).
!* 2.R  TT   03.12.90: Return-Taste wieder Direction-abhngig (a.Adjust,Delete).
!*      TT   11.12.90: Bei leerem Dateinamen beim Start kommt keine Fehlermeld.
!*      TT   19.04.91: Erkennt auch einzelne LF als Zeilentrenner
!* 2.S  TT   20.10.91: Bei DelMode mit Return-Taste und Direction=up kein
!*                     Hnger mehr bei oberster Zeile.
!*      TT   15.02.93: Der Puffer belegt nur noch 2/3 des freien MaxMem,
!*                     mind. jedoch 32K. StopEditor: erst Screenmode zurck,
!*                     dann ExitGem (damit Redraw bei MultiTOS klappt?).
!*                     MenuBar(NIL) vor InitEditor.
!* 2.T  TT   21.11.93: SetScreen-Aufruf ("Setrez") am Ende nur, wenn's auch am
!*                     Anfang aufgerufen wurde (Vorschlag v. G.Castan wg. STE).
!*                     MouseControl-Aufruf zu Beginn wg. MultiTOS.
!*                     Tastenabfrage per MultiEvent.
!* 2.T  TT   10.12.93: GetInfo: Falls kein DLE im 1. Byte des Textes, wird auch
!*                     die Info am Ende verworfen (wg. D.Steins Editor)
!*           11.01.94: Maus wird nur noch ber GrafMouse ein-/ausgeschaltet.
!*           17.01.94: Bei neuen Texten wird im tag "=" ptrEnd gespeichert. Dies
!*                     wird von nun an als Kriterium benutzt, ob die Infoline
!*                     gltig ist. ber tag[';'] wird Cursorpos. beim Speichern
!*                     gemerkt und beim Laden sofort wieder angesprungen.
!* 2.U  TT   06.02.94: Shift-/Ctrl-Cursor vertauscht.
!*)
 
 
 MODULE GEP_ED; (*$C-,R-,Q+,M-,G+ (Dezimale Char-Konst.) *)
 
 (* ED1.ICL *)
 FROM EasyGEM0 IMPORT ForceDeskRedraw;
 FROM GrafBase IMPORT Point, Rectangle;
 FROM GEMGlobals IMPORT TEffectSet, msbut1, MbuttonSet, TextEffect,
0GemChar, FillType, SpecialKeySet;
 FROM AESEvents IMPORT MultiEvent, lookForEntry, Event, EventSet, MessageBuffer;
 FROM AESGraphics IMPORT MouseForm, GrafMouse;
 FROM VDIInputs IMPORT GetMouseState;
 FROM AESMenus IMPORT MenuBar;
 FROM AESWindows IMPORT MouseControl, UpdateWindow;
 FROM GEMEnv IMPORT RC, DeviceHandle, GemHandle, InitGem,
(GEMVersion, ExitGem, CurrGemHandle;
 FROM Strings IMPORT Empty, Append, Concat, Upper, Pos, Delete, Assign,
(Compare, equal, Insert, PosLen, Length;
 IMPORT Strings;
 FROM StrConv IMPORT CardToStr, LHexToStr, StrToLCard, StrToCard, IntToStr;
 FROM Storage IMPORT Enlarge, ALLOCATE, DEALLOCATE, Inconsistent,
+MemAvail, MemSize, AllAvail;
 FROM StorBase IMPORT FullStorBaseAccess;
 FROM ArgCV IMPORT InitArgCV, PtrArgStr;
 FROM PrgCtrl IMPORT TermProcess;
 FROM PathEnv IMPORT FileSelectProc, SelectFile, NoSelect, ReplaceHome,
+HomeReplaced, HomePath;
 FROM PathCtrl IMPORT PathList, PathEntry;
 FROM Paths IMPORT ListPos, SearchFile;
 FROM ShellMsg IMPORT SrcPaths, TextName, ErrorMsg, TextCol, TextLine, ScanMode,
(MainOutputPath, DefLibName, CodeName, CodeSize, Active, DefPaths,
(StdPaths, ShellPath, CompilerArgs, CompilerParm, DefSfx;
 FROM Files IMPORT File, Access, ReplaceMode, Open, Create, Close,
(GetDateTime, SetDateTime, State, GetStateMsg, ResetState;
 FROM Binary IMPORT ReadBytes, FileSize, WriteBytes, Seek, fromBegin;
 FROM LibFiles IMPORT LibFile, OpenLib, CloseLib, LibQuery, LibEntry;
 FROM FileNames IMPORT SplitName, SplitPath, ConcatPath;
 IMPORT FileNames;
 FROM Directory IMPORT DirEntry, DirQuery, MakeFullPath, GetDefaultPath,
(FileAttrSet;
 FROM Lists IMPORT NextEntry, ResetList, InitList, List;
 FROM Clock IMPORT CurrentDate, CurrentTime, PackDate, PackTime,
(Date, Time, UnpackDate, UnpackTime;
 FROM SysInfo IMPORT Machine;
 FROM TimeConvert IMPORT DateToText, TimeToText;
 IMPORT Block;
 FROM EasyExceptions IMPORT Call, Exception;
 
 FROM Loader IMPORT DefaultStackSize, CallModule, LoaderResults;
 
 CONST   mayCallCompiler = TRUE;  (* Bei FALSE auch Loader-IMPORT entfernen! *)
 
 TYPE  ASCII = SET OF [0C..255C];
 
 CONST   intVersion = 'V#0664';
(Version = '2.U';
 
(infoLen = 624;
(
(DLEoffset = $20;
(DLEchar   = 16C;
(
(ToggleTabKey = 02C;
(ETXKey       = 03C;
(EnterKey     = 13C;
(DELKey       = 05C;
(BSKey        = 04C;
(INSKey       = 01C;
(LeftKey      = 06C;
(RightKey     = 07C;
(WordLeftKey  = 08C;
(WordRightKey = 09C;
(EoLnKey      = 18C;
(SoLnKey      = 19C;
(TabLeftKey   = 10C;
(TabRightKey  = 11C;
(UpKey        = 14C;
(DownKey      = 15C;
(PageUpKey    = 16C;
(PageDownKey  = 17C;
(ClrEoLnKey   = 20C;
(ClrLnKey     = 21C;
(FindDefKey   = 22C;
(ESCKey       = 27C;
(BreakKey     = 'B';
(HelpKey      = 24C;
(OpenFrameKey = 25C;
(CloseFrameKey= 26C;
(HomeKey      = 28C;
(ScrlUpKey    = 29C;
(ScrlDownKey  = 30C;
(CompileKey   = 31C;
 
(CRChar          = 13C;
(LFChar          = 10C;
(BSChar          = 08C;
(ClrScrnChar     = 12C;
(ClrEolnChar     = 01C;
(ClrEoSChar      = 02C;
(Cursoronchar    = 03C;
(Cursoroffchar   = 04C;
(Inverseonchar   = 05C;
(Inverseoffchar  = 06C;
(LeftChar        = 11C;
(HomeChar        = 14C;
(ClrLnChar       = 15C;
(DownChar        = 17C;
(UpChar          = 18C;
 
 TYPE String = ARRAY [0..81] OF CHAR;
%MaxStr = ARRAY [0..255] OF CHAR;
 
 VAR fileName, errMsg, Path1, FName1,
$oldString, newString                                           : String;
$printLine (* Puffer fr Ausgaberoutinen *)                     : MaxStr;
$exitCode, LinesPerChar, PointsPerChar                          : INTEGER;
$maxLine, maxCol, maxColM1, yx, dleWert, ptrXIns, nrOfTabs,
$ptrY, ptrX, ptrLine, ptrCount, workCount, countDefault,dumCard,
$fileD, fileT, filesInMem, sessions, oldShiftMode,
$ErrorNr, CursorX, CursorY, cols, Lines, cmdMode                : CARDINAL;
$bufferStart, bufferH, bufferL, bufferM, ptrStart, ptr, temp,
$ptrEnd, delPtr, lastPtr, hilf, scrPtr, pFont8_8, pFont8_16,
$oldSelect, pScreen, ShortKeyPtr, ColorReg                      : ADDRESS;
$rptf , total, startupTime, keepTime, ErrorPos, flen, ErrLine   : LONGCARD;
$direction, findCase, findSame, findWord, verify, endOfEd, color,
$saved, cmdFlag, infinite, abort, accept, delFlag, insFlag,success,
$forceTab, screenOK, fnOK, makeDLE, autoBack, autoIncVer, strOK,Ok1,
$CursorState, tabMode, Inverse, Inserting, saveInfo, UseGem, rez_changed,
$defFound, leaveDLEonWrite, restoreFileDT, modNameFound, isTT   : BOOLEAN;
$oldconterm, ch                                                 : CHAR;
$tabs: ARRAY [0..40] OF WORD;
$oldColor: ARRAY [0..3] OF CARDINAL;
$DefLibFile: LibFile;
$f: File;
$IOResult,Integ : INTEGER;
$allowed  : ASCII;
$infoBuffer : ARRAY [1..330] OF word;
$fontbuffer : ARRAY [0..$7FF] OF WORD; (* 4 KB fr akt. Font *)
$dev        : DeviceHandle;
$hdl        : GemHandle;
$
$(* folg. 5 Vars mssen hintereinander liegen! *)
$ptrStack : ARRAY [0..15] OF ADDRESS; tags: ARRAY ['0'..'Z'] OF ADDRESS;
$saveStack : ARRAY [0..15] OF ADDRESS; svs2: ARRAY ['0'..'Z'] OF ADDRESS;
$svlptr: ADDRESS;
 
 
 (* TABLE.B ErrorType: 'wwwcccpnpkrrcoooP'; *)
 
 
 (* ED2.ICL *)
 
 (*$l-*)
 PROCEDURE DispChar;
 BEGIN
 ASSEMBLER
 ;
 ; *** Character auf Monitor-Screen darstellen ***
 ; Char in D0.B
 ; (D0/A0/A1)
 ;
*TST.W   color
*BNE     disp8x8
*
*; Font-^ auf richtiges Zeichen bestimmen:
*LEA     fontbuffer,A0
*LSL     #4,D0         ; * 16
*ADDA.W  D0,A0
*; Screenoffset := CursorY * 80 * 16 + CursorX * 1
*MOVE.W  CursorY,D0
*; D0 * 1280
*LSL.W   #8,D0
*MOVE.L  D0,A1
*LSL.W   #2,D0
*ADD.W   A1,D0
*ADD     CursorX,D0
*MOVE.L  pScreen,A1
*ADDA.W  D0,A1
*
*MOVE.B  (A0)+,(A1)
*MOVE.B  (A0)+,0080(A1)
*MOVE.B  (A0)+,0160(A1)
*MOVE.B  (A0)+,0240(A1)
*MOVE.B  (A0)+,0320(A1)
*MOVE.B  (A0)+,0400(A1)
*MOVE.B  (A0)+,0480(A1)
*MOVE.B  (A0)+,0560(A1)
*MOVE.B  (A0)+,0640(A1)
*MOVE.B  (A0)+,0720(A1)
*MOVE.B  (A0)+,0800(A1)
*MOVE.B  (A0)+,0880(A1)
*MOVE.B  (A0)+,0960(A1)
*MOVE.B  (A0)+,1040(A1)
*MOVE.B  (A0)+,1120(A1)
*MOVE.B  (A0)+,1200(A1)
*RTS
 
 disp8x8   ; Font-^ auf richtiges Zeichen bestimmen:
*MOVEM.W D4/D5,-(A7)
*LEA     fontbuffer,A0
*LSL     #3,D0         ; * 8
*ADDA.W  D0,A0
*; Screenoffset := CursorY * 80/160 * 8/16 + CursorX * 1/2
*MOVE.W  CursorY,D0
*; D0 * 1280
*LSL.W   #8,D0
*MOVE    D0,D4
*LSL.W   #2,D0
*ADD.W   D4,D0
*MOVE    CursorX,D4
*MOVE    D4,D5
*ANDI    #$FFFE,D4
*LSL     #1,D4
*ADD     D4,D0
*ANDI    #1,D5
*ADD     D5,D0
*MOVE.L  pScreen,A1
*ADDA.W  D0,A1
*MOVEM.W (A7)+,D4/D5
*
*; beide Planes mssen gesetzt werden
*MOVE.B  (A0) ,(A1)
*MOVE.B  (A0)+,0002(A1)
*MOVE.B  (A0) ,0160(A1)
*MOVE.B  (A0)+,0162(A1)
*MOVE.B  (A0) ,0320(A1)
*MOVE.B  (A0)+,0322(A1)
*MOVE.B  (A0) ,0480(A1)
*MOVE.B  (A0)+,0482(A1)
*MOVE.B  (A0) ,0640(A1)
*MOVE.B  (A0)+,0642(A1)
*MOVE.B  (A0) ,0800(A1)
*MOVE.B  (A0)+,0802(A1)
*MOVE.B  (A0) ,0960(A1)
*MOVE.B  (A0)+,0962(A1)
*MOVE.B  (A0) ,1120(A1)
*MOVE.B  (A0)+,1122(A1)
 END
 END DispChar;
 
 (*$l-*)
 PROCEDURE NextCharMono;
 BEGIN
 ASSEMBLER
(; Font-^ auf richtiges Zeichen bestimmen:
(LEA     fontbuffer,A0
(LSL     #4,D0         ; * 16
(ADDA.W  D0,A0
(ADDQ.L  #1,A1
(MOVE.B  (A0)+,(A1)
(MOVE.B  (A0)+,0080(A1)
(MOVE.B  (A0)+,0160(A1)
(MOVE.B  (A0)+,0240(A1)
(MOVE.B  (A0)+,0320(A1)
(MOVE.B  (A0)+,0400(A1)
(MOVE.B  (A0)+,0480(A1)
(MOVE.B  (A0)+,0560(A1)
(MOVE.B  (A0)+,0640(A1)
(MOVE.B  (A0)+,0720(A1)
(MOVE.B  (A0)+,0800(A1)
(MOVE.B  (A0)+,0880(A1)
(MOVE.B  (A0)+,0960(A1)
(MOVE.B  (A0)+,1040(A1)
(MOVE.B  (A0)+,1120(A1)
(MOVE.B  (A0)+,1200(A1)
 END
 END NextCharMono;
 
 (*$l-*)
 PROCEDURE NextCharColor;
 BEGIN
 ASSEMBLER
(; Font-^ auf richtiges Zeichen bestimmen:
(LEA     fontbuffer,A0
(LSL     #3,D0         ; * 8
(ADDA.W  D0,A0
(MOVE.W  A1,D0
(BTST    #0,D0
(BEQ     even
(ADDQ.L  #3,A1
(BRA     odd0
 even    ADDQ.L  #1,A1
 odd0    MOVE.B  (A0) ,(A1)
(MOVE.B  (A0)+,0002(A1)
(MOVE.B  (A0) ,0160(A1)
(MOVE.B  (A0)+,0162(A1)
(MOVE.B  (A0) ,0320(A1)
(MOVE.B  (A0)+,0322(A1)
(MOVE.B  (A0) ,0480(A1)
(MOVE.B  (A0)+,0482(A1)
(MOVE.B  (A0) ,0640(A1)
(MOVE.B  (A0)+,0642(A1)
(MOVE.B  (A0) ,0800(A1)
(MOVE.B  (A0)+,0802(A1)
(MOVE.B  (A0) ,0960(A1)
(MOVE.B  (A0)+,0962(A1)
(MOVE.B  (A0) ,1120(A1)
(MOVE.B  (A0)+,1122(A1)
 END
 END NextCharColor;
 
 
 (*$l-*)
 PROCEDURE InvertChar;
 BEGIN
 ASSEMBLER
 ;
 ; *** Character auf Monitor-Screen invertieren ***
 ; (D0/A0)
 ;
*TST.W   color
*BNE     disp8x8
 
*MOVE.W  CursorY,D0
*LSL.W   #8,D0
*MOVE.L  D0,A0
*LSL.W   #2,D0
*ADD.W   A0,D0
*ADD     CursorX,D0
*MOVE.L  pScreen,A0
*ADDA.W  D0,A0
*MOVEQ   #-1,D0
*EOR.B   D0,(A0)
*EOR.B   D0,0080(A0)
*EOR.B   D0,0160(A0)
*EOR.B   D0,0240(A0)
*EOR.B   D0,0320(A0)
*EOR.B   D0,0400(A0)
*EOR.B   D0,0480(A0)
*EOR.B   D0,0560(A0)
*EOR.B   D0,0640(A0)
*EOR.B   D0,0720(A0)
*EOR.B   D0,0800(A0)
*EOR.B   D0,0880(A0)
*EOR.B   D0,0960(A0)
*EOR.B   D0,1040(A0)
*EOR.B   D0,1120(A0)
*EOR.B   D0,1200(A0)
*RTS
 
 disp8x8   MOVEM.W D4/D5,-(A7)
*; Screenoffset := CursorY * 80/160 * 8/16 + CursorX * 1/2
*MOVE.W  CursorY,D0
*; D0 * 1280
*LSL.W   #8,D0
*MOVE    D0,D4
*LSL.W   #2,D0
*ADD.W   D4,D0
*MOVE    CursorX,D4
*MOVE    D4,D5
*ANDI    #$FFFE,D4
*LSL     #1,D4
*ADD     D4,D0
*ANDI    #1,D5
*ADD     D5,D0
*MOVE.L  pScreen,A0
*ADDA.W  D0,A0
*MOVEM.W (A7)+,D4/D5
*MOVEQ   #-1,D0
*EOR.B   D0,(A0)
*EOR.B   D0,0002(A0)
*EOR.B   D0,0160(A0)
*EOR.B   D0,0162(A0)
*EOR.B   D0,0320(A0)
*EOR.B   D0,0322(A0)
*EOR.B   D0,0480(A0)
*EOR.B   D0,0482(A0)
*EOR.B   D0,0640(A0)
*EOR.B   D0,0642(A0)
*EOR.B   D0,0800(A0)
*EOR.B   D0,0802(A0)
*EOR.B   D0,0960(A0)
*EOR.B   D0,0962(A0)
*EOR.B   D0,1120(A0)
*EOR.B   D0,1122(A0)
 END
 END InvertChar;
 
 (*$l-*)
 PROCEDURE ScrnCurOff;
 BEGIN
 ASSEMBLER
(; CLR.L   CursorCnt
(TST     CursorState
(BEQ     CurOffE
(JSR     InvertChar
(CLR     CursorState
 CurOffE
 END;
 END ScrnCurOff;
 
 
 (*$L-*)
 PROCEDURE BufferDisp;
 BEGIN
 ASSEMBLER
(DBRA    D3,cont0
(RTS
 cont0   JSR     ScrnCurOff
(CLR     D0
(TST.W   color
(BEQ     mono
(BRA     col
 
 mono2:  CLR     D0
(MOVE.B  (A2)+,D0
(JSR     NextCharMono
(ADDQ.W  #1,CursorX
(DBRA    D3,mono2
(RTS
 mono    MOVE.B  (A2)+,D0
(JSR     DispChar
(ADDQ.W  #1,CursorX
(DBRA    D3,mono2
(RTS
 
 
 color2  CLR     D0
(MOVE.B  (A2)+,D0
(JSR     NextCharColor
(ADDQ.W  #1,CursorX
(DBRA    D3,color2
(RTS
 col     MOVE.B  (A2)+,D0
(JSR     DispChar
(ADDQ.W  #1,CursorX
(DBRA    D3,color2
 END
 END BufferDisp;
 
 (*$L-*)
 PROCEDURE ClearEndOfLine;
 BEGIN
 ASSEMBLER
(MOVE    CursorX,D0
(BTST    #0,D0
(BEQ     clreol
(MOVEQ   #' ',D0
(JSR     DispChar
(ADDQ    #1,CursorX
(BSR     clreol
(SUBQ    #1,CursorX
 ClEolE0 RTS
 
 clreol  TST.W   color
(BNE     disp8x8
 
(MOVE    cols,D0         ; 80
(SUB     CursorX,D0      ; ergibt gerade Anzahl zu lschender Bytes
(BLS     ClEolE0
(LSR     #1,D0           ; Anzahl Words
(SUBQ    #1,D0
(MOVE    D1,-(A7)
(MOVE    D0,-(A7)
(MOVE.W  CursorY,D0
(LSL.W   #8,D0
(MOVE.L  D0,A0
(LSL.W   #2,D0
(ADD.W   A0,D0
(ADD     CursorX,D0      ; ist immer gerade X-Pos.
(MOVE.L  pScreen,A0
(ADDA.W  D0,A0
(MOVE.L  A0,-(A7)
(MOVE    #15,-(A7)       ; Loop-Counter
 l1      MOVE    6(A7),D0
(CLR     D1
 l2      MOVE    D1,(A0)+        ; Eine Raster-Zeile lschen
(DBRA    D0,l2
(ADDI.L  #80,2(A7)
(MOVE.L  2(A7),A0
(SUBQ    #1,(A7)         ; alle 16 Raster-Zeilen lschen
(BCC     l1
(ADDQ.L  #8,A7
(MOVE    (A7)+,D1
 ClEolE1 RTS
 
 disp8x8 MOVE    cols,D0         ; 80
(SUB     CursorX,D0      ; ergibt gerade Anzahl zu lschender Words
(BLS     ClEolE1
(LSR     #1,D0           ; Anzahl Longs
(SUBQ    #1,D0
(MOVE    D4,-(A7)
(MOVE    D0,-(A7)
(; Screenoffset := CursorY * 160 * 8 + CursorX * 2
(MOVE.W  CursorY,D0
(; D0 * 1280
(LSL.W   #8,D0
(MOVE    D0,D4
(LSL.W   #2,D0
(ADD.W   D4,D0
(MOVE    CursorX,D4      ; ist immer gerade X-Pos.
(LSL     #1,D4
(ADD     D4,D0
(MOVE.L  pScreen,A0
(ADDA.W  D0,A0
(MOVE.L  A0,-(A7)
(MOVE    #7,-(A7)        ; Loop-Counter
 l3      MOVE    6(A7),D0
(CLR     D4
 l4      MOVE.L  D4,(A0)+        ; Eine Raster-Zeile lschen
(DBRA    D0,l4
(ADDI.L  #160,2(A7)
(MOVE.L  2(A7),A0
(SUBQ    #1,(A7)         ; alle 8 Raster-Zeilen lschen
(BCC     l3
(ADDQ.L  #8,A7
(MOVE    (A7)+,D4
 END;
 END ClearEndOfLine;
 
 (*$l-*)
 PROCEDURE BufferWrite ( buf : ADDRESS; no : CARDINAL );
 BEGIN
 ASSEMBLER
(MOVEM.L D0/D6/A0/A1/A2,-(A7)
(JSR     ScrnCurOff
(MOVE.W  -(A3),D6
(MOVE.L  -(A3),A2
(BRA.L   cont0
 
 JScrnCurOff
(JMP     ScrnCurOff
 
 InverseOff
(CLR     Inverse
(RTS
 
 InverseOn
(MOVE    #1,Inverse
 ClEolE0 RTS
 
 ClearLine
(MOVE    CursorX,-(A7)
(CLR.W   CursorX
(JSR     ClearEndOfLine
(MOVE    (A7)+,CursorX
(RTS
 
 CursorHome
(CLR.W   CursorX
(CLR.W   CursorY
(RTS
 
 ClearEoL
(JMP     ClearEndOfLine
 
 ClearScrn
(BSR     CursorHome
 
 ClearEoS
(JSR     ClearEndOfLine
(MOVE    CursorX,-(A7)
(MOVE    CursorY,-(A7)
(CLR.W   CursorX
 ClrEosL ADDQ.W  #1,CursorY
(MOVE    CursorY,D0
(CMP     Lines,D0
(BCC     ClrEosE
(JSR     ClearEndOfLine
(BRA     ClrEosL
 ClrEosE MOVE    (A7)+,CursorY
(MOVE    (A7)+,CursorX
 ScrnRTS RTS
(
 ScrollUp
(MOVEM.L D1-D7/A2-A6,-(A7)
(MOVE.L  pScreen,A0
(MOVE.L  A0,A1
(ADDA.W  #1280,A1
(MOVE.W  #640-1,D0
 ScrlUL1 MOVEM.L (A1)+,D1-D7/A2-A6
(MOVEM.L D1-D7/A2-A6,(A0)
(ADDA.W  #48,A0     ; = 12 * 4
(DBRA    D0,ScrlUL1
(MOVEM.L (A7)+,D1-D7/A2-A6
(RTS
(
 ScrollDown
(MOVEM.L D1-D7/A2-A6,-(A7)
(MOVE.L  pScreen,A0
(ADDA.W  #32000,A0
(MOVE.L  A0,A1
(SUBA.W  #1280,A1
(MOVE.W  #640-1,D0
 ScrlDL1 SUBA.W  #48,A1     ; = 12 * 4
(MOVEM.L (A1),D1-D7/A2-A6
(MOVEM.L D1-D7/A2-A6,-(A0)
(DBRA    D0,ScrlDL1
(MOVEM.L (A7)+,D1-D7/A2-A6
(RTS
(
 ScrnCR  CLR.W   CursorX
(
 CursorDown
(ADDQ.W  #1,CursorY
(MOVE    CursorY,D0
(CMP     Lines,D0
(BCS     CurDE
(MOVE.W  Lines,D0
(SUBQ    #1,D0
(MOVE    D0,CursorY
(BSR     ScrollUp
 CurDC   MOVE    CursorX,-(A7)
(CLR.W   CursorX
(JSR     ClearEndOfLine
(MOVE    (A7)+,CursorX
 CurDE   RTS
(
 CursorUp
(SUBQ    #1,CursorY
(BCC     CurDE
(CLR     CursorY
(BSR     ScrollDown
(BRA     CurDC
 (*
 IncCursor
(ADDQ.W  #1,CursorX
 ChkCursor
(MOVE    CursorX,D0
(CMP     cols,D0
(BCS     CurDE
(CLR.W   CursorX
(BRA     CursorDown
 *)
 DecCursor
(SUBQ.W  #1,CursorX
(BCC     ScrnRTS
(MOVE    cols,CursorX
(SUBQ.W  #1,CursorX
(BRA     CursorUp
 
 BackSpace
(BSR     DecCursor
(MOVEQ   #' ',D0
(JMP     DispChar
(
 ScrnCurOn
(; CLR.L   CursorCnt
(; BSR     ChkCursor
(TST     CursorState
(BNE     CurOnE
(JSR     InvertChar
(MOVE    #1,CursorState
 CurOnE  RTS
 
 CtrlOut CMPI    #CRChar,D0
(BEQ     ScrnCR
(CMPI    #BSChar,D0
(BEQ     BackSpace
(CMPI    #LeftChar,D0
(BEQ     DecCursor
(CMPI    #UpChar,D0
(BEQ     CursorUp
(CMPI    #DownChar,D0
(BEQ     CursorDown
(CMPI    #HomeChar,D0
(BEQ     CursorHome
(CMPI    #ClrLnChar,D0
(BEQ     ClearLine
(CMPI    #ClrScrnChar,D0
(BEQ     ClearScrn
(CMPI    #ClrEolnChar,D0
(BEQ     ClearEoL
(CMPI    #ClrEoSChar,D0
(BEQ     ClearEoS
(CMPI    #Cursoronchar,D0
(BEQ     ScrnCurOn
(CMPI    #Cursoroffchar,D0
(BEQ     JScrnCurOff
(CMPI    #Inverseoffchar,D0
(BEQ     InverseOff
(CMPI    #Inverseonchar,D0
(BEQ     InverseOn
(RTS
(
 OutC0   TST     D0
(BEQ     end0
(BSR     CtrlOut
(BRA     cont0
 
 OutC1   JSR     InvertChar
(BRA     OutC2
 
 ScrnOut CLR     D0
(MOVE.B  (A2)+,D0
(CMPI    #' ',D0
(BCS     OutC0
(JSR     DispChar
(TST     Inverse
(BNE     OutC1
 OutC2   ADDQ.W  #1,CursorX
 cont0   DBRA    D6,ScrnOut
 end0    MOVEM.L (A7)+,D0/D6/A0/A1/A2
 END
 END BufferWrite;
 
 (* ED3.ICL *)
 
 (*$L-*)
 PROCEDURE Rename (oldName, newName: ADDRESS): INTEGER;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)     ; newName
(MOVE.L  -(A3),-(A7)     ; oldName
(CLR     -(A7)
(MOVE    #$56,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(TST.L   D0
(BMI     E
(MOVEQ   #0,D0
%E: MOVE    D0,(A3)+
$END
"END Rename;
 
 (*$L-*)
 PROCEDURE FDelete (name: ADDRESS): INTEGER;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$41,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(BMI     E
(MOVEQ   #0,D0
%E: MOVE    D0,(A3)+
$END
"END FDelete;
 
 (*$l+*)
 PROCEDURE GotoXY ( x, y : cardinal );
 BEGIN
"CursorX := x;
"CursorY := y
 END GotoXY;
 
 PROCEDURE Conout ( c: CHAR );
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #2,-(A7)
(MOVE    #3,-(A7)
(TRAP    #13
(ADDQ.L  #6,A7
$END
"END Conout;
"(*$L=*)
 
 (*$l-*)
 PROCEDURE Bell;
 BEGIN
"Conout ( 7C )
 END Bell;
 
 
 PROCEDURE Today (): CARDINAL;
"BEGIN
$RETURN PackDate (CurrentDate ())
"END Today;
 
 PROCEDURE DirTime (): CARDINAL;
"BEGIN
$RETURN PackTime (CurrentTime ())
"END DirTime;
 
 
 (*$l-*)
 PROCEDURE GotoXYd1;             (* GoToXY Highbyte(d1)=Y, Lowbyte(d1)=X *)
 BEGIN
 ASSEMBLER ;rettet nur d1,a0
(movem.l d1/a0,-(a7)
(cmp.b   maxCol,d1
(bls     nopa
(move.b  maxCol,d1
 nopa    move    d1,ptrY
(move.b  d1,ptrX
(clr     (a3)+
(move.b  d1,-1(a3)
(lsr     #8,d1
(move    d1,(a3)+
(jsr     GoToXY
(movem.l (a7)+,d1/a0
 END
 END GotoXYd1;
 
 (*$l-*)
 PROCEDURE ChrOut;               (* Ausgabe eines Zeichens in d0 *)
 BEGIN                           (* mit Aktualisierung der X,Y-Koordinaten *)
 ASSEMBLER ;rettet alle Register
(movem.l d0/d1/d2/d3/d4/d5/d6/a0/A1/A2,-(a7)
(cmpi.b  #' ',d0
(bcc     asciich
(cmpi.b  #CRchar,d0
(bne     ctrl1
 newlin  addq.b  #1,ptrY
(clr.b   ptrX
(moveq   #0,d1
(move.b  ptrY,d1
(cmp.w   maxLine,d1
(bls     doit
(bra     lineup
 ctrl1   cmpi.b  #LeftChar,d0
(beq     ctrl11
(cmpi.b  #BSchar,d0
(bne     ctrl2
 ctrl11  subq.b  #1,ptrX
(bpl     doit
(move.b  maxCol,ptrX
 lineup  subq.b  #1,ptrY
(bpl     doit
(clr.b   ptrY
(bra     doit
 ctrl2   cmpi.b  #ClrScrnChar,d0
(bne     doit
(clr.b   ptrY
(clr.b   ptrX
(bra     doit
 asciich move.b  ptrX,d1
(cmp.b   maxCol,d1
(bcc     newlin
(addq.b  #1,d1
(move.b  d1,ptrX
 doit    lea     printLine,a0
(move.b  d0,(a0)
(move.l  a0,(a3)+
(move    #1,(a3)+
(jsr     BufferWrite
(movem.l (a7)+,d0/d1/d2/d3/d4/d5/d6/a0/A1/A2
 END
 END ChrOut;
 
 (*$l-*)
 PROCEDURE Write(cr: CHAR);             (* dieses Write geht ber ChrOut *)
 BEGIN
 ASSEMBLER
(subq.l #1,a3
(move.b -(a3),d0
(jmp  ChrOut
 END
 END Write;
 
 (*$l-*)
 PROCEDURE WriteLn;                      (* damit x-y-Koord. bekannt *)
 BEGIN
"ASSEMBLER moveq #CRchar,d0 jmp ChrOut END
 END WriteLn;
 
 (*$l-*)
 PROCEDURE ClrLn;                       (* damit x-y-Koord. bekannt *)
 BEGIN
 ASSEMBLER
(moveq   #ClrEOLNchar,d0
(jsr     ChrOut
(jmp     WriteLn
 END
 END ClrLn;
 
 (*$l-*)
 PROCEDURE WriteString(REF s:ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(ADDQ    #1,-2(A3)
(jsr     BufferWrite
(move    cursorX,d1
(move.b  d1,ptrX
(move    cursorY,d1
(move.b  d1,ptrY
 END;
 END WriteString;
 
 
 (*$l+*)
 PROCEDURE WriteLCard(c:LONGCARD);
 BEGIN
"WriteString (CardToStr(c,0))
 END WriteLCard;
 
 
 (*$l+*)
 PROCEDURE PrintError ( errno : INTEGER );
 VAR s: String;
 BEGIN
"writestring('I/O error: ');
"GetStateMsg (errno, s);
"writestring(s);
"writeln;
 END PrintError;
 
 VAR LastKey: GemChar;
$LastMeta: SpecialKeySet;
$buttons: mButtonSet;
$Mousepoint: Point;
$keyBuffered: BOOLEAN;
 
 (*$L+*)
 PROCEDURE LookForKey;
"VAR events: EventSet; clicks: CARDINAL; key: GemChar; keystate: SpecialKeySet;
&mp: Point; msgbuf: MessageBuffer; buts: MButtonSet;
"BEGIN
$MultiEvent (EventSet {keyboard, timer},
00, MButtonSet {}, MButtonSet {},
0lookForEntry, Rectangle{0,0,0,0},
0lookForEntry, Rectangle{0,0,0,0},
0msgbuf, 0, mp, buts, keystate, key, clicks, events);
$IF ~keyBuffered & (keyboard IN events) THEN
&keyBuffered:= TRUE;
&LastKey:= key;
&LastMeta:= keystate
$END
"END LookForKey;
 
 (*$L-*)
 PROCEDURE KeyPressed () : BOOLEAN;
 BEGIN
 ASSEMBLER
(JSR     LookForKey
(TST.L   ShortKeyPtr
(BNE     yes
((*
*MOVE    #2,-(A7)
*MOVE    #1,-(A7)
*TRAP    #13
*ADDQ.L  #4,A7
*TST.W   D0
(*)
(MOVE    keyBuffered,D0
 yes     SNE     D0
(AND     #1,D0
(MOVE    D0,(A3)+
 END
 END KeyPressed;
 
 
 (*$l-*)
 PROCEDURE GetKeyD0;
 BEGIN
 ASSEMBLER
(MOVEM.L D1/D2/A5/A6,-(A7)
 notValid
(TST.L   ShortKeyPtr
(BNE     GetShort
(
(moveq   #CursorOnChar,d0
(jsr     ChrOut
(
((*
*MOVE    #2,-(A7)
*MOVE    #2,-(A7)
*TRAP    #13             ; Get Key
*ADDQ.L  #4,A7
*MOVE.L  D0,-(A7)
*MOVE.B  (A7),D2         ; D2: shift status
*ANDI    #$F,D2          ;     nur shift, ctrl, alt drin lassen
*CLR.B   (A7)
(*)
&waitforkey:
(JSR     LookForKey
(TST     keyBuffered
(BEQ     waitforkey
(CLR     keyBuffered
(move.w  LastKey,D0
(andi    #$FF,D0         ; Char-Code
(swap    D0
(move.b  LastKey,D0      ; Scan-Code
(andi    #$FF,D0
(swap    D0
(MOVE.L  D0,-(A7)
(MOVE.B  LastMeta,D2     ; D2: shift status
(ANDI    #$F,D2          ;     nur shift, ctrl, alt drin lassen
(
(moveq   #CursorOffChar,d0
(jsr     ChrOut
(
(MOVE.L  (A7)+,D0
(
(TST     inserting
(BEQ     cont
(
(LEA     shortKeys(PC),A5
 srch2   MOVE.L  (A5)+,D1
(BEQ     cont
(CMP.L   D0,D1
(BNE     noctrl
(MOVE.L  A5,ShortKeyPtr
(BRA     GetShort
 noctrl  TST.B   (A5)+
(BNE     noctrl
(MOVE    A5,D1
(BTST    #0,D1
(BEQ     srch2
(ADDQ.L  #1,A5
(BRA     srch2
 
 GetShort
(MOVE.L  ShortKeyPtr,A5
(CLR     D0
(MOVE.B  (A5)+,D0
(ADDQ.L  #1,ShortKeyPtr
(TST.B   (A5)
(BNE     ende
(CLR.L   ShortKeyPtr
(BRA     ende
 
 cont    LEA     ctrlkeys(PC),A5
(LEA     keytabend(PC),A6
 srch    CMP.L   2(A5),D0
(BNE     noctrl2
 
(MOVE    (A5),D0
(CMPI    #UpKey,D0
(BEQ     up2
(CMPI    #DownKey,D0
(BEQ     down2
(CMPI    #TabRightKey,D0
(BNE     ende
(TST.B   D2
(BEQ     ende
(MOVEQ   #TabLeftKey,D0
(BRA     ende
 up2     BTST    #2,D2           ; ctrl gedrckt?
(BEQ     ende
(MOVEQ   #ScrlDownKey,D0
(BRA     ende
 down2   BTST    #2,D2           ; ctrl gedrckt?
(BEQ     ende
(MOVEQ   #ScrlUpKey,D0
(BRA     ende
 
 noctrl2 ADDQ.L  #6,A5
(CMPA.L  A6,A5
(BCS     srch
 
(CMPI.L  #' ',D0
(BCS     notValid        ; Controlzeichen nicht direkt zugelassen
 
 ende    MOVEM.L (A7)+,D1/D2/A5/A6
(RTS
(
 ctrlkeys
(DC.W  HelpKey        DC.L $620000L
(DC.W  ESCKey         DC.L $610000L  ; Undo
(DC.W  ETXkey         DC.L $3B0000L  ; F1
(DC.W  SoLnKey        DC.L $4B0034L  ; SHIFT cursor left
(DC.W  EoLnKey        DC.L $4D0036L  ; SHIFT cursor right
(DC.W  WordLeftKey    DC.L $730000L  ; CTRL cursor left
(DC.W  WordRightKey   DC.L $740000L  ; CTRL cursor right
(DC.W  SoLnKey        DC.L $430000L  ; F9
(DC.W  EoLnKey        DC.L $440000L  ; F10
(DC.W  ScrlUpKey      DC.L $410000L  ; F7
(DC.W  ScrlDownKey    DC.L $420000L  ; F8
(DC.W  ESCKey         DC.L $01001BL
(DC.W  ToggleTabKey   DC.L $3C0000L  ; F2
(DC.W  ETXKey         DC.L $72000DL  ; ENTER
(DC.W  EnterKey       DC.L $1C000DL  ; RETURN
(DC.W  DELKey         DC.L $53007FL
(DC.W  BSKey          DC.L $0E0008L
(DC.W  INSKey         DC.L $520000L
(DC.W  LeftKey        DC.L $4B0000L
(DC.W  RightKey       DC.L $4D0000L
(DC.W  UpKey          DC.L $480000L
(DC.W  DownKey        DC.L $500000L
(DC.W  PageUpKey      DC.L $480038L  ; SHIFT cursor up
(DC.W  PageDownKey    DC.L $500032L  ; SHIFT cursor down
(DC.W  TabLeftKey     DC.L $100011L  ; CTRL-Q
(DC.W  TabRightKey    DC.L $0F0009L  ; TAB
(DC.W  OpenFrameKey   DC.L $3D0000L  ; F3
(DC.W  CloseFrameKey  DC.L $3E0000L  ; F4
(DC.W  CompileKey     DC.L $3F0000L  ; F5
(DC.W  HomeKey        DC.L $470000L  ; Clr/Home
(DC.W  FindDefKey     DC.L $400000L  ; F6
 
 keytabend
 
 shortKeys
(DC.L  $300000L  ASC 'BEGIN' DC.B EnterKey ASC '  '
8DC.B EnterKey,LeftKey,LeftKey ASC 'END ;'
8DC.B EnterKey,ETXKey,LeftKey,LeftKey ACZ 'I' SYNC
(DC.L  $170000L  ACZ 'INTEGER' SYNC
(DC.L  $190000L  ACZ 'PROCEDURE ' SYNC
(DC.L  $180000L  ACZ 'BOOLEAN' SYNC
(DC.L  $110000L  ACZ 'WHILE ' SYNC
(DC.L  $120000L  DC.B LeftKey,LeftKey ASC 'END;' DC.B EnterKey,0 SYNC
(DC.L  $130000L  ASC 'REPEAT' DC.B EnterKey ACZ '  ' SYNC
8DC.B EnterKey,LeftKey,LeftKey ASC 'UNTIL ;'
8DC.B ETXKey, UpKey ACZ 'I' SYNC
(DC.L  $2E0000L  ACZ 'CARDINAL' SYNC
(DC.L  $2F0000L  ACZ 'WriteString (' SYNC
(DC.L  $310000L  ASC 'WriteLn;' DC.B EnterKey, 0 SYNC
(DC.L  $1E0000L  ASC 'ASSEMBLER' DC.B EnterKey,TabRightKey,0 SYNC
(DC.L  $1F0000L  ACZ 'String' SYNC
(DC.L  $200000L  ASC 'DO' DC.B EnterKey ASC '  '
8DC.B EnterKey,LeftKey,LeftKey ASC 'END;'
8DC.B ETXKey, UpKey ACZ 'I' SYNC
(DC.L  $210000L  ACZ 'FOR ' SYNC
(DC.L  $260000L  ACZ 'LONGCARD' SYNC
(DC.L  $250000L  ACZ 'LONGINT' SYNC
(DC.L  $2C0000L  ACZ 'ADDRESS' SYNC
(DC.L  $160000L  ACZ 'UNTIL ' SYNC
(DC.L  $140000L  ASC 'THEN' DC.B EnterKey ASC '  '
8DC.B EnterKey,LeftKey,LeftKey ASC 'END;'
8DC.B ETXKey, UpKey ACZ 'I' SYNC
(DC.L  $150000L  ACZ 'FROM SYSTEM IMPORT ' SYNC
(DC.L  $220000L  ASC 'FROM InOut IMPORT Write, WriteLn, WriteString, WriteInt, WriteCard;'
8DC.B EnterKey, 0 SYNC
(DC.L  0
 END
 END GetKeyD0;
 
 PROCEDURE ClrKBDbuffer;
"BEGIN
$WHILE KeyPressed () DO GetKeyD0; ShortKeyPtr := NIL END
"END ClrKBDbuffer;
 
 
 (*$l-*)
 PROCEDURE ChrIn;                        (* d0=Zeichen von Tastatur *)
 BEGIN                                   (* ohne Echo *)
 ASSEMBLER
(clr     accept
(clr     abort
 liest   jsr     GetKeyD0
(cmpi    #ToggleTabKey,d0
(bne     ct10
(moveq   #0,d3
(move.b  ptrX,d3
(move    d3,d1
(lsr     #3,d1
(lea     tabs,A0
(bchg    d3,0(a0,d1.w)
(bne     decr
(addq    #1,nrOfTabs
(bra     tabcmd
 decr    subq    #1,nrOfTabs
 tabcmd  tst     tabMode
(beq     ctende          ;liest
(clr     cmdFlag
(;bra     liest
(bra     ctende
 ct10    cmpi    #ESCkey,d0
(bne     ct11
(move    #1,abort
(bra     ctende
 ct11    cmpi    #ETXkey,d0
(bne     ctende
(move    #1,accept
(;bra     ctende
 ctende
 END
 END ChrIn;
 
 (*$l-*)
 PROCEDURE ReadCh;                       (* ch:=Zeichen vom KBD *)
 BEGIN
 ASSEMBLER
(jsr    ChrIn
(move.b d0,ch
 END
 END ReadCh;
 
 (*$l-*)
 PROCEDURE ErrorWait;
 BEGIN
"ClrKBDbuffer;
"GetKeyD0
 END ErrorWait;
 
 (*$l-*)
 PROCEDURE SuccessFull(id: CARDINAL):BOOLEAN;
 BEGIN
 ASSEMBLER
(tst     IOResult
(bpl     NoErr
(movem.l d0-d6/a0/A1/A2,-(a7)
(move    IOResult,-(a7)
(moveq   #CRchar,d0
(jsr     ChrOut
(moveq   #ClrEOLNchar,d0
(jsr     ChrOut
(moveq   #0,d0
(move    -(a3),d0
 (*
(move.l  d0,(a3)+
(lea     ErrorType,a0
(move.b  0(a0,d0.w),d0
(jsr     ChrOut
(jsr     WriteLCard
(moveq   #':',d0
(jsr     ChrOut
 *)
(move    (a7),(a3)+
(jsr     PrintError
(jsr     Bell
(jsr     ErrorWait
(move    (a7)+,IOResult
(movem.l (a7)+,d0-d6/a0/A1/A2
(clr     (a3)+
(rts
 NoErr   move    #1,-2(a3)
 END
 END SuccessFull;
 
 (*$l-*)
 PROCEDURE Flip(VAR s1,s2:STRING);
 BEGIN                                   (* vertauscht s1 mit s2 *)
 ASSEMBLER
(move.l -(a3),a0
(move.l -(a3),A1
(moveq  #40,d1
 Flipx   move   (a0),d0
(move   (A1),(a0)+
(move   d0,(A1)+
(dbf    d1,Flipx
 END
 END Flip;
 
 (*$l+*)
 PROCEDURE ReadString(VAR str: string);  (* mit Umcodierung *)
"VAR line:STRING;                      (* bei ESC bleibt str erhalten *)
 BEGIN
 ASSEMBLER
*moveq  #0,d1
 readstrw  jsr    ChrIn
*tst    abort
*bne    readabrt
*cmpi.b #' ',d0
*bcs    readctrl
 readnorm  move.b ptrX,d2
*cmp.b  maxColM1,d2
*bhi    readerr
*move.b d0,line(A6,d1.w)
*addq   #1,d1
*jsr    ChrOut
*bra    readstrw
 readctrl  cmpi   #EnterKey,d0
*beq    readcr
*cmpi   #leftKey,d0
*beq    readleft
*cmpi   #bsKey,d0
*beq    readleft
*cmpi   #delKey,d0
*beq    readleft
 readerr   bra    readstrw
 readleft  tst    d1
*ble    readerr
*subq   #1,d1
*moveq  #BSChar,d0
*jsr    ChrOut
*bra    readstrw
 readcr    clr.b  line(A6,d1.w) END; Flip(str,line); ASSEMBLER
 !readabrt jsr    WriteLn
 END
 END ReadString;
 
 
 (*$l-*)
 PROCEDURE Worthy: BOOLEAN;
 BEGIN
 ASSEMBLER
(moveq   #1,d1
(move.l  ptrEnd,d0
(sub.l   ptrStart,d0
(cmpi.l  #4,d0
(bhi     itisw
(moveq   #0,d1
 itisw   move    d1,(a3)+
 END
 END Worthy;
 
 PROCEDURE NormTab;
"BEGIN
$ASSEMBLER
(DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F
(DC.B $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F
(DC.B $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F
(DC.B $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F
(DC.B $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F
(DC.B $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F
(DC.B $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F
(DC.B $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F
(DC.B $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF
(DC.B $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF
(DC.B $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF
(DC.B $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF
(DC.B $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF
(DC.B $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
$END
"END NormTab;
 
 PROCEDURE AlphaNumTab;
"BEGIN
$ASSEMBLER
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0
(DC.B 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1
(DC.B 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
$END
"END AlphaNumTab;
 
 PROCEDURE ShiftTab;
"BEGIN
$ASSEMBLER
(DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','[','\',']','^','_'
(DC.B '`','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','{','|','}','~',''
(DC.B '','','','A','','','','','E','E','E','I','I','I','',''
(DC.B '','','','O','','O','U','U','','','','','','','',''
(DC.B 'A','I','O','U','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(;und gleich darauf noch die Lower-Table
(DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'
(DC.B 'p','q','r','s','t','u','v','w','x','y','z','[','\',']','^','_'
(DC.B '`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'
(DC.B 'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
$END
"END ShiftTab;
 
 (*$l-*)
 PROCEDURE ShiftUp;                      (* kleine Buchstaben => groe *)
 BEGIN
 ASSEMBLER ;operiert auf d0
(cmpi.b #'a',d0
(bcs    shftrts
(cmpi.b #'z',d0
(bls    shiftit
(cmpi.b #132,d0
(beq    ae
(cmpi.b #148,d0
(beq    oe
(cmpi.b #129,d0
(bne    shftrts
(moveq  #154,d0
(rts
 ae      moveq  #142,d0
(rts
 oe      moveq  #153,d0
(rts
 shiftit eori.b #$20,d0
 shftrts
 END
 END ShiftUp;
 
 (*$l-*)
 PROCEDURE AlphaNum;             (* Test, ob d0 ein alphanum. Zeichen enth. *)
 BEGIN                           (* Ergebnis im Z-Flag:1=alphanum *)
 ASSEMBLER
)ANDI #255,D0
)MOVE.L A0,-(A7)
)LEA    AlphaNumTab,A0
)TST.B  0(A0,D0.W)
)MOVE.L (A7)+,A0
 END
 END AlphaNum;
 
 (*$l-*)
 PROCEDURE ClearTabs;
"BEGIN
$ASSEMBLER
(lea     tabs,a0
(moveq   #0,d0
(move.b  maxCol,d0
(addq    #1,d0
(asr     #3,d0
(subq    #1,d0
 cllp    clr.b   (a0)+           ;tabs lschen
(dbf     d0,cllp
$END
"END ClearTabs;
 
 (*$l+*)
 PROCEDURE StandardTabs (n: CARDINAL);
"TYPE ByteSet = SET OF [0..7];
"VAR p: POINTER TO ARRAY [0..80] OF ByteSet; i: CARDINAL;
"BEGIN  (* alle n Zeichen ein Tab *)
$ClearTabs;
$i:= 0;
$p:= ADR (tabs);
$nrOfTabs:= 0;
$WHILE i < cols DO
&INCL (p^[i DIV 8], i MOD 8);
&INC (nrOfTabs);
&INC (i, n)
$END;
"(*
'ASSEMBLER ;benutzt d0,a0
/moveq   #0,d0
/move.b  maxCol,d0
/addq    #1,d0
/asr     #3,d0
/move    d0,nrOfTabs
/lea     tabs,a0
/subq    #1,d0
'tblp    move.b  #$01,(a0)+
/dbf     d0,tblp
'END
"*)
"END StandardTabs;
 
 (*$l-*)
 PROCEDURE CountTabs;
 BEGIN
 ASSEMBLER ;benutzt d0,a0
(moveq   #0,d2
(move.b  maxCol,d2
(move    d2,d1
(addq    #1,d2
(asr     #3,d2
(lea     tabs,a0
(subq    #1,d2
 tblp    move.b  (a0)+,d0
(moveq   #7,d3
 tbcnt   btst    #0,d0
(beq     notset
(addq    #1,d1
 notset  lsr     #1,d0
(dbf     d3,tbcnt
(dbf     d2,tblp
(move    d1,nrOfTabs
 END
 END CountTabs;
 
 (*$l+*)
 PROCEDURE GetTabs(tabString:String);
"VAR step, i, n: CARDINAL;
"BEGIN  (* tabString umwandeln, 'T'=Tabulator, '.'=keiner *)
$i:= 0;
$n:= StrToCard (tabString, i, strok);
$IF (n > 0) AND (n<80) THEN
&StandardTabs (n)
$ELSE
&ASSEMBLER
(JSR     ClearTabs
(lea     tabString(A6),A0
(moveq   #0,d0
(moveq   #0,d1           ;d1=nrOfTabs
(lea     tabs,A1
(moveq   #0,d3           ;d3=Bit-Index
(tst.b   (a0)
(bne     gtloop
(move    #8,(A3)+
(jsr     StandardTabs
(bra     getex
 gtloop  move.b  (a0)+,d0
(beq     gete2
(jsr     ShiftUp
(move    d3,d4
(lsr     #3,d4
(bclr    d3,0(A1,d4.w)
(cmpi.b  #'T',d0
(bne     gtstor
(bset    d3,0(A1,d4.w)
(addq    #1,d1
 gtstor  addq    #1,d3
(bra     gtloop
 gete2   move    d1,nrOfTabs
 getex
&END
$END
"END GetTabs;
 
 (*$l-*)
 PROCEDURE TabSet: BOOLEAN;              (* true, wenn an aktueller  *)
 BEGIN                                   (* Cursorposition ein Tab steht *)
 ASSEMBLER ;benutzt d0,d1,d2,A2
(tst     nrOfTabs
(beq     tabf
(moveq   #0,d1
(move.b  ptrX,d1
(cmp.b   maxColM1,d1
(bgt     tabf
(move    forceTab,d0
(lea     tabs,A2
(move    d1,d2
(lsr     #3,d2
(btst    d1,0(A2,d2.w)
(beq     notab
 tabf    moveq   #1,d0
 notab   move    d0,(a3)+
 END
 END TabSet;
 
 (*$l-*)
 PROCEDURE TabsToStr():String;
 BEGIN
 ASSEMBLER
(lea     tabs,a0
(move.l  a3,A1
(lea     82(A3),A3
(moveq   #0,d0
(move.b  maxCol,d0
(addq    #1,d0
(asr     #3,d0
(subq    #1,d0
 lp1     moveq   #7,d1
(move.b  (a0)+,d2
 lp2     moveq   #'.',d3
(lsr.b   #1,d2
(bcc     push
(moveq   #'T',d3
 push    move.b  d3,(A1)+
(dbf     d1,lp2
(dbf     d0,lp1
(clr.b   (A1)+
 END
 END TabsToStr;
 
 (*$l-*)
 PROCEDURE Yes: BOOLEAN;                 (* true, falls y,Y,j,J eingegeben *)
 BEGIN
 ASSEMBLER
(jsr   ErrorWait
(jsr   ShiftUp
(moveq #1,d1
(cmpi  #'J',d0
(beq   jaret
(cmpi  #'Y',d0
(beq   jaret
(moveq #0,d1
 jaret   move  d1,(a3)+
 END
 END Yes;
 
 (*$l-*)
 PROCEDURE DirKey: BOOLEAN;              (* wertet Tasten zur Richtungs- *)
 BEGIN                                   (* umschaltung aus *)
 ASSEMBLER ;benutzt d0,d1,d2
(moveq  #0,d0
(move.b ch,d0
(move   direction,d1
(moveq  #0,d2
(cmpi.b #'<',d0
(beq    dleft
(cmpi.b #',',d0
(beq    dleft
(cmpi.b #'-',d0          ; '<' ',' '-' fr links
(beq    dleft
(cmpi.b #'>',d0
(beq    dright
(cmpi.b #'.',d0
(beq    dright
(cmpi.b #'+',d0          ; '>' '.' '+' fr rechts
(bne    dexit
 dright  tst    d1
(beq    dexit
(clr    d1
(bra    dstore
 dleft   tst    d1
(bne    dexit
(moveq  #1,d1
 dstore  move   d1,direction
(clr    cmdFlag
(moveq  #1,d2
 dexit   move   d2,(a3)+
 END
 END DirKey;
 
 (*$l-*)
 PROCEDURE ReadUpCh;             (* liest einen Grobuchstaben vom KBD *)
 BEGIN
"ASSEMBLER jsr ChrIn jsr ShiftUp move.b d0,ch END
 END ReadUpCh;
 
 (*$l-*)
 PROCEDURE Rptfx10:BOOLEAN;      (* berechnet Repeatfactor (rptf) *)
 BEGIN                           (* d2 enthlt 1, wenn Zahl gefunden *)
 ASSEMBLER ;benutzt d0,d1,d2,d3
(moveq  #0,d2
(moveq  #0,d3
(move.b ch,d3
(subi.b #'0',d3  ;Low-Bound abziehen
(bcs    rptfex
(cmpi.b #9,d3    ;>9?
(bhi    rptfex
(move.l rptf,d0  ;alten Repeatfactor mal 10 nehmen
(move.l d0,d1
(asl.l  #2,d1
(add.l  d1,d0
(asl.l  #1,d0
(add.l  d3,d0    ;neue Ziffer addieren
(move.l d0,rptf
(moveq  #1,d2    ;d2=1 => es wurde eine Zahl gefunden
 rptfex  move   d2,(a3)+
 END
 END Rptfx10;
 
 (*$l-*)
 PROCEDURE RptfOK;               (* gltiger Repeatfactor ? *)
 BEGIN
 ASSEMBLER ;benutzt d0
(move.l rptf,d0
(bne    ok
(moveq  #1,d0    ;Default=1
 ok      move.l d0,rptf
 END
 END RptfOK;
 
 (*$l-*)
 PROCEDURE Negate(VAR bool:BOOLEAN);
 BEGIN                           (* bool:=NOT bool *)
 ASSEMBLER move.l -(a3),a0 EORI #1,(a0) END
 END Negate;
 
 (*$l-*)
 PROCEDURE Prepare;
 BEGIN
 ASSEMBLER
&(*
(pea     printLine
(;### move.l  (a7),(a3)+
(;### jsr     GetTime
(move.l  (a7)+,a0
(moveq   #0,d0
(move    (a0)+,d0
(mulu    #60,d0
(add     (a0)+,d0
(mulu    #15,d0
(asl.l   #2,d0
(moveq   #0,d1
(move    (a0)+,d1
(add.l   d1,d0
&*) nop
 END
 END Prepare;
 
 (*$l-*)
 PROCEDURE Finish;
 BEGIN
 ASSEMBLER
&(*
(jsr     Prepare
(move.l  d0,d1
(sub.l   startupTime,d0
(bpl     ok
(add.l   #$15180,d0
 ok      move.l  d1,startupTime
(add.l   d0,total
(add.l   d0,keepTime
&*) nop
 END
 END Finish;
 
 (*$l-*)
 PROCEDURE ResetTextOptions;
"BEGIN
$ASSEMBLER
(clr     cmdFlag
(moveq   #16-1+43-1,d0
(lea     ptrStack,a0
%lp clr.l   (a0)+  ;lscht auch tags
(dbf     d0,lp
(move.l  ptr,lastptr
(clr     ptrCount
(clr     fileD
(clr     fileT
(clr     restoreFileDT
(clr     direction
(clr     findSame
(clr     findWord
(clr     findCase
(clr     infinite
(clr     verify
(clr.l   rptf
(move    #1,saved
(clr     autoBack
(clr     autoIncVer
(move    #1,makeDLE
(clr     leaveDLEonWrite
(clr     saveinfo
(move    #8,(A3)+
(jsr     StandardTabs
$END
"END ResetTextOptions;
 
 (*$l-*)
 PROCEDURE GoToPtr;              (* positioniert Cursor auf gespeicherte yx *)
 BEGIN
 ASSEMBLER
(move yx,d1
(jmp  GotoXYd1
 END
 END GoToPtr;
 
 (*$l-*)
 PROCEDURE Home;         (* Cursor nach links oben, Statuszeile lschen *)
 BEGIN
 ASSEMBLER
(clr   d1
(jsr   GotoXYd1
(moveq #ClrEOLNchar,d0
(jmp   ChrOut
 END
 END Home;
 
 (*$l-*)
 PROCEDURE ClrCmdLine;   (* Cursorposition retten, dann Home *)
 BEGIN
 ASSEMBLER
(clr    cmdFlag
(move   ptrY,d0
(move.b ptrX,d0
(move   d0,yx
(jmp    Home
 END
 END ClrCmdLine;
 
 (*$l-*)
 PROCEDURE LineOut;      (* eine Zeile aus Speicher auf Bildschirm bringen *)
 BEGIN                   (* dabei auf Cursorposition achten *)
"ASSEMBLER   ;benutzt d0,d2,d3,d4,d5,d6,a0,A1,A2
,moveq   #0,d3        ;Zhler fr PrintLine / highword=x-pos
,lea     printLine,A2
,moveq   #0,d5
,tst     insflag
,beq.l   LineOut1
,move.b  ptrX,d5
,bra.l   LineOut1
"
"lget      tst     insFlag
,bne     lgetnz       ;bei Insert den Cursor nicht verndern
,cmpa.l  ptr,a0
,bne     lgetnz
,move    ptrY,d0
,move.b  d5,d0
,move    d0,yx
"lgetnz    moveq   #0,d0
,move.b  (a0)+,d0
,bne     lendrts
,tst.b   (a0)
,beq     lendkorr
,subq.l  #1,a0
,
"lendkorr  move.b  d3,ptrX
 
,; move.b  #ClrEOLNchar,0(A2,d3.w)
,; addq.b  #1,d3
,movem.l d1/a0,-(a7)
,jsr     BufferDisp    ;Ausgabe von PrintLine
,jsr     ClearEndOfLine
,movem.l (a7)+,d1/a0
,addq.l  #4,a7       ;verlasse LineOut
"
"lendrts   rts
"
"lput      cmpi.b #CRchar,d0
,beq    lendkorr
,tst    delFlag
,beq    lput1
,cmpa.l delPtr,a0
,bhi    lput1
,cmpa.l ptr,a0
,bls    lput1
,moveq  #' ',d0
"lput1     cmp.b  maxCol,d5
,bgt    lputbad
,move.b d0,0(A2,d3.w)
,addq.b #1,d3
,cmpi.b #$20,d0
,bcs    lputrts
"lputinc   addq.b #1,d5
"lputrts   rts
"lputbad   move.b #'!',-1(A2,d3.w)
,rts
"
"ldlecode  bsr    lget
,move.b d0,d4
,moveq  #' ',d0
,sub.b  d0,d4
,ble    LineOut1
"lspc      bsr    lput
,subq.b #1,d4
,bne    lspc
,
"LineOut1  bsr     lget
,cmpi.b  #DLEchar,d0
,beq     ldlecode
,bsr     lput
,bra     LineOut1
"END
 END LineOut;
 
 (*$l-*)
 PROCEDURE LineSt;       (* positioniert a0 auf Zeilenanfang im Speicher *)
 BEGIN
 ASSEMBLER   ;benutzt d3,a0
 linecr1   move.b -(a0),d3
*beq    lineret1
*cmpi.b #CRchar,d3
*bne    linecr1
 lineret1  addq.l #1,a0
 END
 END LineSt;
 
 (*$l-*)
 PROCEDURE LastCR;       (* positioniert a0 auf vorhergehendes CR *)
((* liefert NE, wenn End of text *)
 BEGIN
 ASSEMBLER
 LastCR1   tst.b  -1(a0)
*beq    lastret1
*cmpi.b #CRchar,-(a0)
*bne    LastCR1
*rts
 lastret1  cmpi.b #1,-1(a0)       ; ergibt immer NE
 END
 END LastCR;
 
 (*$l-*)
 PROCEDURE NextCR;       (* positioniert a0 auf nchstes CR+1 *)
((* liefert NE, wenn End of text *)
 BEGIN
 ASSEMBLER
 luup       cmpa.l ptrEnd,A0
+bcc    error2
+tst.b  (a0)
+beq    error2
+cmpi.b #CRchar,(a0)+
+bne    luup
+rts
 error2     move.l ptrEnd,a0
+subq.l #2,a0
 error      cmpa.l a7,a0     ; liefert NE
 END
 END NextCR;
 
 
 VAR lineNo: LONGCARD;
 
 (*$l-*)
 PROCEDURE CountCR: LONGCARD;    (* zhlt Zeilen=CR's *)
 BEGIN
 ASSEMBLER ;benutzt d0,d1,d2,a0
(clr.l  lineNo
(move.l ptrStart,a0
(move.l ptr,A1
(moveq  #1,d0
(moveq  #CRchar,d2
 lbl     cmpa.l a0,A1
(bne    lbl2
(move.l d0,lineNo
 lbl2    move.b (a0)+,d3
(beq    cntend
(cmp.b  d2,d3
(bne    lbl
(addq.l #1,d0
(bra    lbl
 cntend  move.l d0,(a3)+
 END
 END CountCR;
 
 (*$l+*)
 PROCEDURE conc((*$? CompilerVersion > 3: REF*) a,b:Strings.String): Strings.String;
"VAR s: Strings.String;
"BEGIN
$Concat (a,b,s,strok);
$RETURN s
"END conc;
 
 FORWARD PutCmd(REF k: ARRAY OF CHAR); (* String in Statuszeile drucken *)
 
 (*$l-*)
 PROCEDURE Info;         (* durch '?' ausgelst *)
 BEGIN
"PutCmd(
"conc(conc(conc(conc('used:',           CardToStr(ptrEnd-ptrStart-4L,6)),
1conc(' bytes; free:',   CardToStr(bufferH-ptrEnd,7))),
,conc(conc(' bytes;',         CardToStr(filesInMem,2)),
1conc(' frames;',        CardToStr(CountCR(),5)))),
,conc(' lines; cursor:', CardToStr(lineNo,5))));
"ErrorWait
 END Info;
 
 (*$l-*)
 PROCEDURE FindCursor;           (* bringt Cursor in richtige x-Position *)
 BEGIN                           (* d1 mu yx-Koordinaten enthalten *)
 ASSEMBLER                         (* a0 mu auf Zeilenanfang zeigen *)
(moveq  #0,d3
(move.b (a0),d4
(beq    ma1z
(cmpi.b #DLEchar,d4
(bne    fc1
(addq.l #1,a0
(move.b (a0)+,d3
(subi.b #DLEoffset,d3    ;d3=Space-Count
 fc1     cmp.b  d3,d1
(bls    ma0z
(move.b (a0),d4
(beq    ma1z
(cmpi.b #CRchar,d4
(beq    ma0z
(addq.l #1,a0
(cmpi.b #$20,d4
(bcs    fc1
(addq.b #1,d3
(bra    fc1
 ma1z    subq.l #1,a0
(cmpi.b #dlechar,-1(a0)
(bne    ma0z
(subq.l #1,a0
 ma0z    move.l a0,ptr
(move.b d3,d1
(jmp    GotoXYd1
 END
 END FindCursor;
 
 (*$l-*)
 PROCEDURE ScreenOut;    (* Bildschirm neu schreiben *)
 BEGIN                   (* am Textende letzte Zeile in die letzte  *)
 ASSEMBLER                 (* Bildschirmzeile drucken *)
(move   #1,screenOK
(move.l ptr,a0
(cmpi.b #DLEchar,(a0)
(bne    nodle
(addq.l #1,a0
 nodle   cmpi.b #DLEchar,-1(a0)
(bne    nodleo
(addq.l #1,a0
 nodleo  move.l a0,ptr
(move.l a0,scrPtr
(move   ptrLine,d1
 pcr     cmp    maxLine,d1       ;bis in letzte Bildschirmzeile vorpirschen
(bge    zcr
(jsr    NextCR
(addq   #1,d1
(bra    pcr
 zcr     subq   #1,d1
(beq    korr
(jsr    LastCR           ;wieder zurck, damit Bildschirm immer voll
(bra    zcr
 korr    jsr    LineSt
(move   #$174F,yx
(jsr    GotoXYd1         ; D1 ist 0!
(move   maxLine,d1
 scrn1   jsr    WriteLn
(jsr    LineOut
(subq   #1,d1
(bne    scrn1
(moveq  #0,d0
(move.b yx,d0
(move   d0,ptrLine
(jmp    GoToPtr
 END
 END ScreenOut;
 
 (*$l-*)
 PROCEDURE CenterScreen;         (* Bildschirm schreiben, Cursor in Mitte *)
 BEGIN
 ASSEMBLER
(move   maxLine,d0
(ASR    #1,d0
(move   d0,ptrLine
(jmp    ScreenOut
 END
 END CenterScreen;
 
 (*$l+*)
 PROCEDURE jumpPtr (p: ADDRESS);
"BEGIN
$IF (ptrStart<p) & (p<ptrEnd) THEN
&scrPtr:= ptr;
&ptr:= p;
$END;
$CenterScreen
"END jumpPtr;
 
 (*$l-*)
 PROCEDURE CondScreen(p:PROC);   (* nur wenn Text verndert wurde *)
 BEGIN                           (* p=ScreenOut oder CenterScreen *)
 ASSEMBLER
(move.l -(a3),A1
(tst    screenOK
(beq    doit
(move.l ptr,a0
(cmpi.b #DLEchar,(a0)
(bne    nodle
(addq.l #2,a0
(move.l a0,ptr
 nodle   cmpa.l scrPtr,a0
(beq    finis
 doit    jmp    (A1)
 finis   moveq  #0,d0
(move.b ptrY,d0
(move   d0,ptrLine
 END
 END CondScreen;
 
 
 (*$l-*)
 PROCEDURE ChkLastPtr;           (* zeigt lastPtr ausserhalb des Textes ? *)
 BEGIN
 ASSEMBLER ;benutzt a0,A1
(move.l lastPtr,a0
(move.l ptr,A1
(cmpa.l ptrStart,a0
(bcs    doit
(cmpa.l ptrEnd,a0
(bhi    doit
(move.l a0,A1
 doit    move.l A1,lastPtr
 END
 END ChkLastPtr;
 
 (*$l-*)
 PROCEDURE PushPtr;
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(move    ptrCount,d0
(lea     ptrStack,A1
(move    d0,d1
(subq    #4,d1
(andi    #$3C,d1
(move.l  a0,d2
(sub.l   0(A1,d1.w),d2
(bge     noneg
(neg.l   d2
 noneg   cmpi.l  #8,d2
(bcs     nopush          ;nicht pushen, wenn gleich dem Letzten+-8
(move.l  a0,0(A1,d0.w)
(addq    #4,d0
(andi    #$3C,d0
 nopush  move    d0,ptrCount
 END
 END PushPtr;
 
 (*$l-*)
 PROCEDURE ChkZap: CARDINAL;     (* fr Zap. Prft, ob mehr als 200 *)
 BEGIN                           (* Zeichen gelscht werden, und ob  *)
 ASSEMBLER ;benutzt d0,d1,d3,a0    (* Buffer ausreicht                  *)
(move.l ptr,a0
(move.l lastPtr,d0
(move.l d0,delPtr
(cmp.l  a0,d0
(bhi    zap1
(exg    d0,a0
(move.l d0,delPtr
(move.l a0,ptr
 zap1    sub.l  a0,d0
(move.l bufferH,d1
(sub.l  ptrEnd,d1
(moveq  #2,d3
(cmp.l  d1,d0
(bhi    zap3
(subq   #1,d3
(cmp.l  #200,d0
(bhi    zap3
(subq   #1,d3
 zap3    move   d3,(a3)+
 END
 END ChkZap;
 
 (*$l-*)
 PROCEDURE PutDir;
 BEGIN
 ASSEMBLER
(moveq  #'>',d0
(tst    direction
(beq    pcdir
(moveq  #'<',d0
 pcdir   jmp    ChrOut
 END
 END PutDir;
 
 (*$l+*)
 PROCEDURE PutFrm;
 BEGIN
"WriteLCard (filesInMem);
"Write (' ');
 END PutFrm;
 
 (*$l-*)
 PROCEDURE PutCmd(REF k: ARRAY OF CHAR); (* String in Statuszeile drucken *)
 BEGIN                                   (* ohne Cursorpos. zu verlieren *)
 ASSEMBLER
(clr    cmdFlag
(move   ptrY,d1
(move.b ptrX,d1
(move   d1,-(a7)
(jsr    Home
(moveq  #InverseOnChar,d0
(jsr    ChrOut
(jsr    PutDir
(TST.W  tabmode
(BNE    noFrm
(jsr    PutFrm
 noFrm   jsr    WriteString
 fillup  move   cols,d1
(cmp    CursorX,d1
(bls    filled
(moveq  #' ',d0
(jsr    chrout
(bra    fillup
 filled  moveq  #InverseOffChar,d0
(jsr    ChrOut
(move   (a7)+,d1
(jmp    GotoXYd1
 END
 END PutCmd;
 
 (*$l+*)
 PROCEDURE PutCmdOrTab(k: MAXSTR);
 BEGIN
"IF tabMode THEN
$Assign (TabsToStr(), k, strok);
$Delete (k,0,1,STROK)
"END;
"PutCmd(k)
 END PutCmdOrTab;
 
 (*$l+*)
 PROCEDURE CmdLineAway (checkMouse: BOOLEAN): BOOLEAN;
"(* Statuszeile evtl. erneuern ? *)
"VAR c: CARDINAL;
&buttons: mButtonSet;
&Mousepoint: Point;
"BEGIN
$IF cmdFlag THEN RETURN
&FALSE
$ELSE
&c:= countDefault;
&LOOP
(IF KeyPressed () THEN RETURN FALSE END;
(GetMouseState(dev,MousePoint, buttons); (*hlt Ablauf nicht an *)
(IF checkMouse AND (msbut1 IN buttons) THEN RETURN FALSE END;
(IF c = 0 THEN RETURN TRUE END;
(DEC (c)
&END
$END;
$(*
(ASSEMBLER
0moveq  #0,d0
0tst    cmdFlag
0bne    clart
0move   countDefault,d1
(wait    move   d1,-(a7)
0jsr    KeyPressed
0move   (a7)+,d1
0moveq  #0,d0
0tst    -(a3)
0dbne   d1,wait
0bne    clart
0moveq  #1,d0
(clart   move   d0,(a3)+
(END
$*)
"END CmdLineAway;
 
 (*$l-*)
 PROCEDURE InsCmd;
 BEGIN
"PutCmdOrTab('Insert: /F1/ or /Enter/ accepts, /ESC/ ignores')
 END InsCmd;
 
 (*$l-*)
 PROCEDURE Overflow;
 BEGIN
"ASSEMBLER move.l A2,-(a7) END;
"PutCmd('Buffer overflow');Bell;ErrorWait;
"ASSEMBLER move.l (a7)+,A2 END
 END Overflow;
 
 (*$l-*)
 PROCEDURE Available(bytes:INTEGER):BOOLEAN;
 BEGIN           (* Test, ob noch <bytes> Zeichen eingefgt werden knnen *)
 ASSEMBLER    ;benutzt d1,d2
+moveq  #0,d2
+move   -(a3),d1
+ext.l  d1
+add.l  bufferH,d1
+sub.l  bufferL,d1
+add.l  ptrEnd,d1
+cmp.l  bufferH,d1
+bpl    keinplatz
+cmp.l  bufferL,d1
+bpl    keinplatz
+moveq  #1,d2
 keinplatz  move   d2,(a3)+
 END
 END Available;
 
 (*$l-*)
 PROCEDURE MoveTags(ad:ADDRESS; cnt:LONGINT);
 BEGIN           (* verschiebt die Tags, nachdem der Text verschoben wurde *)
 ASSEMBLER ;benutzt d0,d1,a0,A1,A2
(move.l -(a3),d0
(move.l -(a3),a0
(moveq  #58,d1
(lea    ptrStack,A1      ;tags inbegriffen
(tst.l  d0
(beq    adjrts
(bpl    adjtag
(adda.l d0,a0
 adjtag  move.l (A1)+,A2
(cmpa.l A2,a0
(bhi    noadj
(adda.l d0,A2
(cmpa.l A2,a0
(bls    adjt1
(move.l #0,A2
 adjt1   move.l A2,-4(A1)
 noadj   dbf    d1,adjtag
(move.l lastPtr,A2
(cmpa.l A2,a0
(bhi    adjt2
(adda.l d0,A2
(cmpa.l A2,a0
(bls    adjt2
(move.l a0,A2
 adjt2   move.l A2,lastPtr
 ;'ptr' darf hier nicht verschoben werden, weil das ggf. schon woanders passiert.
 adjrts
 END
 END MoveTags;
 
 (*$l-*)
 PROCEDURE saveTags;
 BEGIN
 ASSEMBLER
(moveq  #58,d1
(lea    saveStack,A0
(lea    ptrStack,A1
 adjtag  move.l (A1)+,(A0)+
(dbf    d1,adjtag
(move.l lastPtr,(A0)+
 END
 END saveTags;
 
 (*$l-*)
 PROCEDURE restoreTags;
 BEGIN
 ASSEMBLER
(moveq  #58,d1
(lea    saveStack,A0
(lea    ptrStack,A1
 adjtag  move.l (A0)+,(A1)+
(dbf    d1,adjtag
(move.l (A0)+,lastPtr
 END
 END restoreTags;
 
 (*$l-*)
 PROCEDURE MoveText(ad:ADDRESS; displace:LONGINT);
 BEGIN           (* verschiebt Text im Speicher ab Adresse ad um displace *)
 ASSEMBLER ;benutzt d0,d1,a0,A1,A2
(move.l -4(a3),d0   ;displace
(move.l -8(a3),A1   ;ad          ! Parameter bleiben auf Stack !
(move.l ptrEnd,a0
(tst.l  d0
(beq    movrts
(clr    saved
(clr    restoreFileDT
(clr    screenOK
(
(lea    0(A1,d0.l),A2
(add.l  d0,ptrEnd
(; A1: source-Start, A2: dest-Start
(MOVE.L  D2,-(A7)
(MOVE.L  A1,(A3)+
(SUBA.L  A1,A0           ;Lnge = ptrEnd - start
(ADDQ.L  #1,A0
(MOVE.L  A0,(A3)+
(MOVE.L  A2,(A3)+
(JSR     Block.Copy
(MOVE.L  (A7)+,D2
 movrts  jmp    MoveTags
 END
 END MoveText;
 
 (*$l-*)
 PROCEDURE BufferToText(copyDLE: BOOLEAN);
 BEGIN                   (* kopiert den Buffer-Inhalt an die Textstelle *)
 ASSEMBLER
*move.l bufferH,d4
*sub.l  bufferL,d4
*bgt    bok1
*beq    bleer1
 bleer     move.l bufferH,bufferL END;
*PutCmd('Buffer bad'); ASSEMBLER
*jsr    Bell
*jsr    ErrorWait
 bleer1    bra    bnix
 bok1      clr    (a3)+
*jsr    Available
*tst    -(a3)
*beq    bleer
*move.l bufferH,d3
*sub.l  bufferL,d3
*ble    bnix
*move.l d3,-(a7)
*move.l ptr,(a3)+
*move.l d3,(a3)+
*jsr    MoveText
*move.l ptr,A1
*move.l bufferH,a0
*move.l (a7)+,d3
 rein      move.b -(a0),(A1)+
*subq.l #1,d3
*bgt    rein
*move.l ptr,a0
*move.l A1,ptr
*tst    -2(a3)         ;copyIt?   bei Insert keinen DLE kopieren
*beq    bnix
*jsr    LineSt
*cmpi.b #DLEchar,(a0)
*bne    bnix
*cmpi.b #DLEchar,-2(A1)
*bne    bnix
*move.b 1(a0),-1(A1)
 bnix      subq.l #2,a3
 END
 END BufferToText;
 
 (*$l-*)
 PROCEDURE DelInBuffer;          (* bei Delete: falls ESC gedrckt wurde *)
 BEGIN
 ASSEMBLER ;benutzt d1,a0,A2
(move.l ptr,d1
(move.l delPtr,a0
(cmp.l  a0,d1
(bcc    lolehi
(exg    a0,d1
 lolehi  move.l bufferH,A2
(cmp.l  a0,d1
(beq    dnixin
 abinb   move.b (a0)+,-(A2)
(cmp.l  a0,d1
(bhi    abinb
 dnixin  move.l A2,bufferL
 END
 END DelInBuffer;
 
 (*$l-*)
 PROCEDURE AbInBuffer;           (* delPtr-ptr in Buffer, dann lschen *)
 BEGIN                           (* egal ob delPtr>ptr oder delPtr<ptr *)
 ASSEMBLER ;benutzt d0,a0,A1
(jsr    DelInBuffer      ;in A2 steht noch bufferL
(move.l ptr,a0
(move.l delPtr,A1
(move.l A1,d0
(sub.l  a0,d0
(bmi    aib1
(exg    A1,a0
(neg.l  d0               ;a0 ist hhere Adresse
 aib1    cmpi.b #DLEchar,-2(a0)  ;letzter mitgelschter DLE-Code
(bne    aib2
(cmpi.b #DLEchar,-2(A1)  ;DLE vor gel. Bereich
(bne    aib2
(move.b -1(a0),-1(A1)    ;DLE-Code kopieren
 aib2    move.l a0,(a3)+
(move.l d0,(a3)+
(jmp    MoveText
 END
 END AbInBuffer;
 
 (* ED4.ICL *)
 
 (*$l-*)
 PROCEDURE IncrementVersion (): Strings.String;
 BEGIN
 ASSEMBLER
(clr.b   (a3)
(lea     80(A3),A3
(move.l  ptrStart,a0
 fndlp   move.b  (a0)+,d0
(beq     xit
(cmpi.b  #'V',d0
(beq     fndV
(cmpi.b  #DLEchar,d0
(bne     fndlp
(addq.l  #1,a0
(bra     fndlp
 fndV    cmpi.b  #'#',(a0)+
(bne     fndlp
(move.l  a0,A1
 fnddig  move.b  (a0)+,d0
(cmpi.b  #'0',d0
(bcs     incr
(cmpi.b  #'9',d0
(bls     fnddig
 incr    subq.l  #1,a0
(lea     -1(a0),A2
 incrlp  move.b  -(a0),d0
(cmpa.l  a0,A1
(bhi     wrt
(clr     saved
(clr     restoreFileDT
(addq.b  #1,d0
(cmpi.b  #'9',d0
(bls     incrxt
(move.b  #'0',(a0)
(bra     incrlp
 incrxt  move.b  d0,(a0)
 wrt     lea     -80(A3),A0
(move.b  #'V',(a0)+
(move.b  #'#',(a0)+
 wrtlp   move.b  (A1)+,(a0)+
(cmpa.l  A1,A2
(bcc     wrtlp
(clr.b   (a0)
 xit
 END
 END IncrementVersion;
 
 (*$l-*)
 PROCEDURE Exchg(ch:CHAR): BOOLEAN;(* ein Zeichen an Textstelle schreiben *)
 BEGIN
 ASSEMBLER ;benutzt d0,a0
(move   -(a3),-(a7)
(move.l ptr,a0
(move.b (a0),d0
(beq    ins0
(cmpi.b #CRchar,d0
(bne    ok
 ins0    moveq  #0,d0
(move   #1,(a3)+
(jsr    Available
(tst    -(a3)
(beq    nonono
(move.l ptr,(a3)+
(move.l #1,(a3)+
(jsr    MoveText
 ok      moveq  #1,d0
(clr    saved
(clr     restoreFileDT
(move.l ptr,a0
(move.b (a7),(a0)+
(move.l a0,ptr
 nonono  move   d0,(a3)+
(addq.l #2,a7
 END
 END Exchg;
 
 (*$l-*)
 PROCEDURE FillIn(ad:ADDRESS; VAR n:STRING); (* String an ad einspeichern *)
 BEGIN
 ASSEMBLER ;benutzt d0,a0,A1
(move.l -(a3),a0
(move.l -(a3),A1
(move.b (a0)+,d0
(beq    nofill
 lbl     move.b d0,(A1)+
(move.b (a0)+,d0
(bne    lbl
(clr    saved
(clr     restoreFileDT
(clr    screenOK
 nofill
 END
 END FillIn;
 
 (*$l-*)
 PROCEDURE Search(): BOOLEAN;      (* findet Auftreten von oldString im Text *)
 BEGIN (* delPtr zeigt auf erstes Zeichen, ptr dahinter *)
 ASSEMBLER    ;benutzt d0-d7,a0-A6
+movem.l d3-d7,-(a7)  ;die movem mssen wg. D6 am Ende getrennt sein!
+movem.l A6/a3/a4,-(a7)
+link   A5,#0
+moveq  #0,d6         ;d6=BOOLEAN-Ergebnis
+lea    oldString,A1
+moveq  #0,d4
+move.b (A1)+,d4      ;d4=Length(oldString)
+beq.l  srchrts
+move.l ptr,a0        ;a0=Text-Pointer
+lea    getplus(pc),A6
+lea    getoldp(pc),a4
+tst    direction     ;true=rckwrts
+beq    dok
+lea    getmin(pc),A6
+lea    getoldm(pc),a4
+adda   d4,A1
 dok        moveq  #0,d0         ;obere Bytes von D0 lschen
+moveq  #0,d3         ;obere Bytes von D3 lschen
+; ** das 1. gesuchte Zeichen auf den Stack **
+lea    NormTab,a3
+lea    anum2(PC),a2
+jsr    (a4)          ;erstes suchzeichen nach D3/D7
+move.l a1,-(A7)
+move   d3,d7
+tst    findCase      ;Case-Sensitivity-Flag
+bne    csens
+lea    ShiftTab,a3
+move.b 0(a3,d3.w),d7 ;upper case
+addi.w #256,d3
+move.b 0(a3,d3.w),d3 ;lower case
+andi   #255,D3
 csens      move.w d7,-(a7)
+move.b d3,(a7)
+tst    findWord
+bne    wsrch
+bra.w  srchneu
 
 ; ***** Ende der Suchvorbereitung *****
 
 getmin     move.b -(a0),d0
+beq.l  srchrts
+cmpi.b #DLEchar,-1(a0)
+bne    getmin1
+subq.l #1,a0
+move.l a0,delPtr
+bra    getmin
 getmin1    rts
 
 getplus    move.b (a0)+,d0
+beq.l  srchrts
+cmpi.b #DLEchar,d0
+bne    getplus1
+addq.l #1,a0
+move.l a0,delPtr
+bra    getplus
 getplus1   rts
 
 getoldm    move.b -(A1),d3
+move.b 0(a3,d3.w),d3 ;upper case
+rts
 getoldp    move.b (A1)+,d3
+move.b 0(a3,d3.w),d3 ;upper case
+rts
 
 ; * wortweise *
 
 wsrch      move.l 2(a7),A1         ;A1=Zeiger in oldString
+move   d4,d5         ;Schleifenzhler
+move.b (a7),d3
+move.b 1(a7),d7
+tst    direction     ;true=rckwrts
+beq    forw3
 
 back3      ; erstmal alle AlphaNums berspringen
+move.b -(a0),d0
+TST.B  0(A2,D0.W)    ;AlphaNum?
+beq    back3         ;ja
+bpl    back4
+tst.b  d0
+bne    back3         ;mu DLE gewesen sein - weiter
+bra.w  srchrts
 back4      ;dies zeichen kann noch bersprungen werden, weil es ja kein
+;alpha-zeichen ist, dahinter suchen wir wortanfang
+move.b -(a0),d0
+TST.B  0(A2,D0.W)    ;AlphaNum?
+beq    back5         ;ja
+bpl    back4
+tst.b  d0
+bne    back4         ;mu DLE gewesen sein - weiter
+bra.w  srchrts
 back5      ;wortanfang - stimmt 1. zeichen?
+cmp.b  d3,d0
+beq.w  found1
+cmp.b  d7,d0
+bne    back3         ;stimmt nicht - wieder zum wortende
+bra.w  found1
 
 forw3      ; erstmal alle AlphaNums berspringen
+move.b (a0)+,d0
+TST.B  0(A2,D0.W)    ;AlphaNum?
+beq    forw3         ;ja - weitersuchen
+bpl    forw2         ;nein
+tst.b  d0
+beq.w  srchrts
+;mu DLE gewesen sein. berspringen und weiter wie nicht-AlphaNum
+addq.l #1,a0
 forw2      ;dies zeichen kann noch bersprungen werden, weil es ja kein
+;alpha-zeichen ist, dahinter suchen wir wortanfang
+move.b (a0)+,d0
+TST.B  0(A2,D0.W)    ;AlphaNum?
+beq    forw5         ;ja -> wortanfang gefunden
+bpl    forw2         ;nein, weiter nach anfang suchen
+tst.b  d0
+beq.w  srchrts
+;mu DLE gewesen sein
+addq.l #1,a0
+bra    forw2
 forw5      ;wortanfang - stimmt 1. zeichen?
+cmp.b  d3,d0
+beq.w  found1
+cmp.b  d7,d0
+bne    forw3         ;stimmt nicht - wieder zum wortende
+bra.w  found1
 
 ; * normal suchen *
 
 srchneu    move.l 2(a7),A1         ;A1=Zeiger in oldString
+move   d4,d5         ;Schleifenzhler
+; ** das 1. Zeichen wird schneller gesucht **
+move.b (a7),d3
+move.b 1(a7),d7
+tst    direction     ;true=rckwrts
+beq    forw1
 back1      ; rckw. suchen
+move.b -(a0),d0
+beq.l  srchrts
+cmp.b  d3,d0
+beq    backfnd
+cmp.b  d7,d0
+bne    back1
 backfnd    cmpi.b #DLEchar,-1(a0)       ; ist ein DLE davor?
+beq    back1                 ; dann haben wir uns geirrt
+bra    found1
 forw1      ; vorw. suchen
+move.b (a0)+,d0
+beq.l  srchrts
+cmp.b  d3,d0
+beq    forwfnd
+cmp.b  d7,d0
+bne    forw1
 forwfnd    cmpi.b #DLEchar,-2(a0)       ; war ein DLE davor?
+beq    forw1                 ; dann haben wir uns geirrt
 
 found1     ; gefunden
+move.l a0,delPtr
+subq   #1,d5
+beq    found2
 
+; jetzt die restlichen Zeichen vergleichen
 srchmore   jsr    (A6)          ;getbyte
+move.b 0(a3,d0.w),d0 ;upper case
+jsr    (a4)          ;getold
+cmp.b  d0,d3
+bne    srchmism
+subq   #1,d5
+bne    srchmore
 
 found2     move.l a0,A1
+tst    findWord
+beq    found3
+move.l delPtr,-(A7)
+jsr    (A6)          ;getbyte
+move.l (A7)+,delPtr
+TST.B  0(A2,D0.W)    ;AlphaNum?
+beq    wsrch         ;ja
 found3     moveq  #1,d6         ;Erfolg
+move.l A1,ptr
+tst    direction     ;true=rckwrts
+bne.w  srchrts
+subq.l #1,delPtr
+bra.w  srchrts
 
 srchmism   move.l delPtr,a0
+tst    findWord
+bne    wsrch
+bra    srchneu
 
 anum2   ; Alphanum-Tab, -1 bei Null und DLE
(DC.B -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0
(DC.B 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
(DC.B 0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1
(DC.B 0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1
(DC.B 0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
(DC.B 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
 
+; Suchende
 
 srchrts    unlk   A5
+movem.l (a7)+,A6/a3/a4
+move   d6,(a3)+
+movem.l (a7)+,d3-d7
 END
 END Search;
 
 (*$l+*)
 PROCEDURE ChkName(VAR n:STRING): BOOLEAN;
"VAR p,l:INTEGER;
 BEGIN           (* evtl. '.TXT' anhngen *)
"Upper(n);
"IF Empty (FileNames.FileName(n)) THEN
$n:=''; RETURN false
"ELSE
$(* dies mu raus, da sonst keine Dateien ohne Suffix geladen werden knnen:
&p := Pos('.',n,0);
&IF p<0 THEN
(Concat(n,'.TXT',n,strok)
&END
$*)
"END;
"RETURN true
 END ChkName;
 
 
 (*$l-*)
 PROCEDURE PutInfo;      (* den infoBlock zum Abspeichern fllen *)
 BEGIN
 ASSEMBLER ;benutzt d0,d1,d2,a0,A1
(
(lea     infobuffer,A1
(move.l  #$0d0a282A,(A1)+
(MOVE.B  #' ',(A1)+
(bra     cont
(
 putlcard
(move.l  d2,(a3)+
(move    #9,(a3)+
(movem.l d0/d1/a0/A1,-(a7)
(jsr     lhextostr
(movem.l (a7)+,d0/d1/a0/A1
(lea     -80(a3),A2
(moveq   #8,d2
 putl1   move.b  (A2)+,(A1)+
(dbra    d2,putl1
(lea     -80(a3),a3
(rts
(
 putch   ori.b   #$80,d0
(move.b  d0,(A1)+
(rts
(
 cont    lea     tags,a0
(move.l  ptrStart,d1
(moveq   #41,d0
 coptag  move.l  (a0)+,d2
(sub.l   d1,d2
(bsr     putlcard
(dbf     d0,coptag
(
(move    findCase,d0
(bsr     putch
(
(move.l  lastPtr,d2
(sub.l   d1,d2
(bsr     putlcard
(
(movem.l d0/d1/a0/A1,-(a7)
(jsr     tabsToStr
(movem.l (a7)+,d0/d1/a0/A1
(lea     -82(a3),a0
(moveq   #79,d0
 coptab  move.b  (a0)+,(A1)+
(dbf     d0,coptab
(lea     -82(a3),a3
(
(lea     ptrStack,a0
(moveq   #15,d0
 ctag2   move.l  (a0)+,d2
(sub.l   d1,d2
(bsr     putlcard
(dbf     d0,ctag2
(
(move    ptrCount,d0
(bsr     putch
(move    autoBack,d0
(bsr     putch
(move    autoIncVer,d0
(move    leaveDLEonWrite,D1
(LSL     #1,D1
(OR      D1,D0
(bsr     putch
(MOVE.L  #$2A290D0A,(A1)+
(moveq   #20,d0
 clrl    move.b  #'.',(A1)+
(dbra    d0,clrl
 END
 END PutInfo;
 
 
 (*$l-*)
 PROCEDURE CleanText;
 BEGIN
 ASSEMBLER
(JSR     savetags
(TST     makeDLE
(BEQ.L   rmdo
 
(; neuer Text, DLE einfgen
 
(; zuerst die Verschiebungen berechnen
 spdo    MOVE.L  ptrStart,A1
(MOVE.L  A1,A2
(MOVE.L  ptrEnd,D2
(SUB.L   A1,D2
(MOVEQ   #0,D3
 
 spdln   MOVEQ   #2,D1
 
 spdcnt  CMPI.B  #' ',(A1)
(BNE     spdmo
(ADDQ.L  #1,A1
(SUBQ.L  #1,D1
(ADDQ.L  #1,A2
(SUBQ.L  #1,D2
(BRA     spdcnt
 
 spdmo   CMPI.B  #DLEchar,(A1)
(BNE     spdmo1
 
(SUBQ.L  #2,D2
(SUBQ.L  #2,D1
(MOVEQ   #0,D3
(ADDQ.L  #2,A1
(ADDQ.L  #2,A2
 
 spdmo1  CMPA.L  bufferL,A2
(BLS     spdmo2
(JSR     overflow
(JMP     restoretags
 spdmo2  MOVE.L  A2,(A3)+
(ADD.L   D1,D3
(MOVE.L  D3,(A3)+
(ADDA.L  D3,A2
(MOVEM.L D1/D2/A1/A2,-(A7)
(JSR     MoveTags
(MOVEM.L (A7)+,D1/D2/A1/A2
(MOVEQ   #0,D3
 spnex   SUBQ.L  #1,D2
(ADDQ.L  #1,A2
(MOVE.B  (A1)+,D0
(CMPI.B  #$0D,D0
(BEQ     spdlx
(CMPI.B  #$0A,D0
(BEQ     spd00
(CMPI.B  #' ',D0
(BNE     sptr
(SUBQ.L  #1,D3
(BRA     spcr
 sptr    MOVEQ   #0,D3
 spcr    TST.L   D2
(BPL     spnex
(
(BRA     spcdo   ; Fertig
(
 spdlx   CMPI.B  #$0A,(A1)
(BNE     spd00
(
(SUBQ.L  #1,D2
(ADDQ.L  #1,A2
(ADDQ.L  #1,A1
(SUBQ.L  #1,D3
 spd00   TST.L   D2
(BPL     spdln
 
(; jetzt den Text hochkopieren
 spcdo   MOVE.L  ptrEnd,A0
(MOVE.L  BufferL,A1
(SUBQ.L  #2,A1
(MOVE.L  A0,D0
(SUB.L   ptrStart,D0
(MOVE.L  D0,D2
(MOVE.L  A1,A2
(SUBA.L  D0,A2
(ADDQ.L  #1,A0
(ADDQ.L  #1,A1
(SWAP    D0
 spcdom1 SWAP    D0
 spcdomv MOVE.B  -(A0),-(A1)
(DBF     D0,spcdomv
(SWAP    D0
(DBF     D0,spcdom1
(
(; zuletzt Zurckkopieren mit Korrektur der Codes
(; D2: Anzahl Source-Bytes
(; A0: Pufferbeginn (dest)
(; A1: Textbeginn (source)
(MOVEQ   #0,D3
 spcdln  MOVEQ   #DLEoffset,D1
(TST.W   D3
(BEQ     spcdcnt
(LEA     -1(A0,D3.W),A0
(MOVE.B  #$0D,(A0)+
(MOVEQ   #0,D3
 spcdcnt CMPI.B  #' ',(A1)
(BNE     spcdmo
(ADDQ.L  #1,A1
(ADDQ.B  #1,D1
(SUBQ.L  #1,D2
(BRA     spcdcnt
 spcdmo  CMPI.B  #DLEchar,(A1)
(BNE     spcdle
(SUBQ.L  #2,D2
(MOVEQ   #0,D3
(ADDQ.L  #1,A1
(MOVE.B  (A1)+,D0
(SUBI.B  #DLEoffset,D0
(BLE     spcdle
(ADD.B   D0,D1
 spcdle  MOVE.B  #DLEchar,(A0)+
(MOVE.B  D1,(A0)+
 spcnex  SUBQ.L  #1,D2
(MOVE.B  (A1)+,D0
(BEQ     spccr
(CMPI.B  #$0A,D0
(BEQ     iscr
(CMPI.B  #$0D,D0
(BNE     notCR
(CMPI.B  #$0A,(A1)
(BNE     isCR
(SUBQ.L  #1,D2
(ADDQ.L  #1,A1
 isCR    MOVEQ   #$0D,D0
 notCR   CMPI.B  #$09,D0
(BNE     notTAB
(MOVEQ   #'',D0
 notTAB  MOVE.B  D0,(A0)+
(CMPI.B  #$0D,D0
(BEQ     spcdlx
(CMPI.B  #' ',D0
(BNE     spctr
(SUBQ.W  #1,D3
(BRA     spccr
 spctr   MOVEQ   #0,D3
 spccr   TST.L   D2
(BGE     spcnex
(TST.W   D3
(BEQ     spce0
(LEA     0(A0,D3.W),A0
(BRA     spce0
 spcdx   TST.W   D3
(BEQ     spce0
(LEA     -1(A0,D3.W),A0
(MOVE.B  #$0D,(A0)+
(MOVEQ   #0,D3
 spce0   CLR.B   (A0)+
(CLR.B   (A0)+
(MOVE.L  A0,ptrEnd
(CLR.B   (A0)+
(CLR.B   (A0)+
(CLR.B   (A0)+
(CLR.B   (A0)+
(RTS
 spcdlx  TST.L   D2
(BGE     spcdln
(BRA     spcdx
 
(; text speichern: DLE lschen
 rmdo    MOVE.L  ptrStart,A1
(MOVE.L  A1,A2
(MOVE.L  ptrEnd,D2
(SUB.L   A1,D2
(MOVEQ   #1,D3
 rldln   ADDQ.L  #1,A2
(MOVE.B  (A1)+,D0
(CMPI.B  #DLEchar,D0
(BNE     rldld
(ADDQ.L  #1,A2
(SUBQ.L  #1,D2
(MOVEQ   #0,D0
(MOVE.B  (A1)+,D0
(SUBI.B  #DLEoffset,D0
(BPL     ok
(MOVEQ   #0,D0
 ok      SUBQ.L  #1,D0
(SUB.L   D3,D0
(CMPA.L  bufferL,A2
(BLS     spdmo3
(JSR     overflow
(JMP     restoretags
 spdmo3  MOVE.L  A2,(A3)+
(MOVE.L  D0,(A3)+
(ADDA.L  D0,A2
(MOVEM.L A1/A2,-(A7)
(JSR     MoveTags
(MOVEM.L (A7)+,A1/A2
(MOVEQ   #0,D3
 rldld   SUBQ.L  #1,D2
(BGE     rldln
(; Fertig mit Tag-Korrektur
(MOVE.L  ptrEnd,A0
(MOVE.L  BufferL,A1
(SUBQ.L  #2,A1
(MOVE.L  A0,D0
(SUB.L   ptrStart,D0
(MOVE.L  D0,D2
(MOVE.L  A1,A2
(SUBA.L  D0,A2
(ADDQ.L  #1,A0
(ADDQ.L  #1,A1
(SWAP    D0
 rmdom1  SWAP    D0
 rmdomv  MOVE.B  -(A0),-(A1)
(DBF     D0,rmdomv
(SWAP    D0
(DBF     D0,rmdom1
 rmdln   MOVE.B  (A1)+,D0
(CMPI.B  #$0D,D0
(BNE     notCR2
(MOVE.B  D0,(A0)+
(MOVEQ   #$0A,D0
 notCR2  CMPI.B  #DLEchar,D0
(BEQ     rmdcnt
(MOVE.B  D0,(A0)+
 rmdld   SUBQ.L  #1,D2
(BGE     rmdln
 rmdx    SUBQ.L  #1,A0
(MOVE.L  A0,ptrEnd
 rmex    RTS
 rmdcnt  MOVE.B  (A1)+,D0
(SUBQ.L  #1,D2
(SUBI.B  #DLEoffset,D0
 rmdspc  BLE     rmdld
(MOVE.B  #' ',(A0)+
(SUBQ.B  #1,D0
(BRA     rmdspc
 END
 END CleanText;
 
 (*$l+*)
 PROCEDURE WriteText: BOOLEAN;
"VAR oldend: POINTER TO CHAR; blockAnz, lastInBl, ioerr : Cardinal;
&oldch: CHAR;
 BEGIN
"IF saveinfo THEN
$tags['=']:= ptrEnd;
$tags[';']:= ptr;
"END;
"IF makeDLE & NOT leaveDLEonWrite THEN
$makeDLE := False; Cleantext
"END;
"oldend:= ptrend-2L;
"oldch:= oldend^;
"oldend^:= CHR (26); (* Ctrl-Z *)
"IF saveinfo THEN
$INC (ptrend);
$IF odd (ptrend-ptrstart) THEN
&inc (ptrend)
$END;
"END;
"WriteBytes (f,ptrStart,ptrend-ptrstart-2L);
"oldend^:= oldch;
"ptrend:= ADDRESS (oldend)+2L;
"IOResult := State (f);
"IF saveinfo & (ioresult >= 0) THEN
$PutInfo;
$WriteBytes (f,adr(infobuffer),long(infoLen));
$IOResult := State (f);
"END;
"tags['=']:= ptrStart;
"tags[';']:= ptrStart;
"ResetState(f);
"Close(f);
"ioerr := State (f);
"IF SuccessFull(1) THEN
$IOResult := ioerr;
$IF SuccessFull(3) THEN
&saved:=true;
&RETURN true
$END
"END;
"RETURN false
 END WriteText;
 
 VAR fullDate: Date; fullTime: Time;
 
 PROCEDURE GetDT;
"BEGIN
$GetDateTime (f, fullDate, fullTime);
$fileD:= PackDate (fullDate);
$fileT:= PackTime (fullTime)
"END GetDT;
 
 (*$l+*)
 PROCEDURE SaveText(VAR fn:STRING; sBack, sWarn, keepTime:BOOLEAN):BOOLEAN;
"VAR createTime, createDate:CARDINAL; gotOld:BOOLEAN; bp, be, bf:STRING;
 BEGIN
"IF autoIncVer & NOT saved & NOT restoreFileDT THEN
$WriteString (IncrementVersion())
"END;
"WriteLn;
"Open (f,fn,readonly);
"IOResult := State(f);
"gotOld:=IOResult>=0;
"IF gotOld THEN
$Close (f);
$IF sWarn THEN
&WriteString('File already exists. Overwrite it?');
&IF NOT Yes() THEN RETURN false END;
&WriteLn
$END;
$IF sBack OR autoBack THEN
&WriteString('Backing up...');WriteLn;
&bf:=fn;
&SplitPath (bf, bf, bp);
&SplitName (bp, bp, be);
&Append (bp, bf, strok);
&Append('.BAK',bf,strok);
&ioresult:= FDelete (ADR(bf));
&ioresult:= Rename (ADR(fn),ADR(bf));
&IF NOT SuccessFull(7) THEN RETURN false END
$END;
$ioresult:= FDelete (ADR(fn));
"END;
"Create (f,fn,writeonly,noreplace);
"IOResult := State (f);
"IF SuccessFull(9) THEN
$WriteString('Writing ');WriteString(fn); WriteLn;
$IF WriteText () THEN
&Open (f,fn,readonly);
&IF restoreFileDT OR keepTime THEN
(fullDate:= UnpackDate (fileD);
(fullTime:= UnpackTime (fileT);
(SetDateTime (f, fullDate, fullTime);
&ELSE
(GetDT
&END;
&Close (f);
&RETURN TRUE
$ELSE
&IF sBack OR autoBack THEN
(ioresult:= FDelete (ADR(fn));
(ioresult:= Rename (ADR(bf),ADR(fn));
&END;
$END
"END;
"RETURN false
 END SaveText;
 
 (*$l-*)
 PROCEDURE GetInfo;      (* Marker usw. aus infoBlock holen *)
 BEGIN
 ASSEMBLER
(movem.l a0/A1/d0/d1/d2/d3/d4/d5/d6,-(a7)
(CLR     saveinfo
(clr     leaveDLEonWrite   ; damit ReadText nix falsch macht
(BRA     cont
(
 getlcard
(move.l  a1,-(a7)
(lea     printline,a1
(move.l  a1,(a3)+
(moveq   #8,D3
(move    d3,(a3)+
 copstr  move.b  (a0)+,(a1)+
(dbra    d3,copstr
(clr.b   (a1)
(clr.w   -(a7)
(move.l  a7,(a3)+
(clr.w   -(a7)
(move.l  a7,(a3)+
(movem.l d0/d1/a0/a2,-(a7)
(jsr     strtolcard
(movem.l (a7)+,d0/d1/a0/a2
(addq.l  #4,a7
(move.l  (a7)+,a1
(move.l  -(a3),d2
(rts
(
 cont    LEA     -infoLen(A2),A0
(CMPA.L  ptrStart,A0
(BLS.W   noget
(MOVE.L  A0,D0
(CMPI.B  #$0D,(A0)+
(BNE.L   noget
(CMPI.B  #$0A,(A0)+
(BNE.L   noget
(CMPI.B  #'(',(A0)+
(BNE.L   noget
(CMPI.B  #'*',(A0)+
(BNE.L   noget
(CMPI.B  #' ',(A0)+
(BNE.L   noget
(
(MOVE.L  D0,A2
(
((*
*MOVE.L  ptrStart,A1
*CMPI.B  #DLEchar,(a1)
*BNE.W   noget           ; Es ist eine Info da, aber wir ignorieren sie
(*)
(
(; Die tags werden erstmal in einen Kopierpuffer geladen und erst
(; am Ende, wenn sicher ist, da die Infoline noch aktuell ist,
(; per restoreTags in den richtigen Puffer bertragen.
(
(lea     svs2,A1
(move.l  ptrStart,d1
(moveq   #41,d0
 coptag  bsr     getlcard
(add.l   d1,d2
(move.l  d2,(A1)+
(dbf     d0,coptag
(
(move.b  (a0)+,d0
(andi    #1,d0
(move    d0,findCase
(
(bsr     getlcard
(add.l   d1,d2
(move.l  d2,svlptr
(
(moveq   #79,d0
 coptab  move.b  (a0)+,(a3)+
(dbf     d0,coptab
(clr.w   (a3)+
(movem.l d0-d2/a0-A2,-(a7)
(jsr     gettabs
(movem.l (a7)+,d0-d2/a0-A2
(
(lea     saveStack,A1
(moveq   #15,d0
 ctag2   bsr     getlcard
(add.l   d1,d2
(move.l  d2,(A1)+
(dbf     d0,ctag2
(
(move.b  (a0)+,d0
(andi    #$3C,d0
(move    d0,ptrCount
(
(move.b  (a0)+,d0
(andi    #1,d0
(move    d0,autoBack
(
(move.b  (a0)+,d0
(move    d0,d1
(andi    #1,d0
(move    d0,autoIncVer
(lsr     #1,d1
(andi    #1,d1
(move    d1,leaveDLEonWrite
(
(; Konsistenzprfung der Infoline:
(; tags['='] mu identisch mit ptrEnd sein
 
(MOVE    #1,saveinfo
 
 noGet   movem.l (a7)+,a0/A1/d0/d1/d2/d3/d4/d5/d6
 END
 END GetInfo;
 
 (*$l-*)
 PROCEDURE GetFile;     (* file laden *)
 BEGIN
"ASSEMBLER
.move.l  flen,d0
.move.l  d0,d5
.add.l   A2,d0
.move.l  d0,d6             ;VORRAUSSICHTLICHES TEXTENDE
.tst.l   d5
.beq     nullget
.addi.l  #$100,d0
.cmp.l   hilf,d0
.blt     blockok
.jsr     Overflow
.move    #-1,ioresult
.bra.w   lesende
"blockok     MOVE.L  f,(A3)+
.MOVE.L  A2,(A3)+
.MOVE.L  D5,(A3)+
.clr.l   -(a7)
.move.l  a7,(a3)+
.movem.l A1/A2/d0/d1/d2,-(a7)
.JSR     ReadBytes
.MOVE.L  f,(A3)+
.JSR     State
.MOVE    -(A3),IOResult
.move    #11,(a3)+
.jsr     SuccessFull
.movem.l (a7)+,A1/A2/d0/d1/d2
.addq.l  #4,a7
 
.tst     -(a3)
.beq.S   lesende
 
+nullget
.movea.l d6,A1
.clr.b   (A1)
.move.l  A1,A2
.
"lesende     move.l  A2,-(a7)
"END;
"IF State (f) >= 0 THEN
$GetDT;
"END;
"ResetState(f);
"Close(f);
"ASSEMBLER     movea.l (a7)+,A2
"END
 END GetFile;
 
 (*$l-*)
 PROCEDURE ReadText;     (* File von Diskette laden und aufbereiten *)
 BEGIN                   (* alle Text-Pointer setzen *)
 ASSEMBLER
(clr.w   saveinfo
(move.l  bufferL,hilf
(move.l  ptrStart,A2     ;ZEIGER LESEN
(move.l  A2,ptr
(move.l  a2,-(a7)
(jsr     ResetTextOptions
(move.l  (a7)+,a2
(jsr     GetFile
(tst     IOResult
(bmi.w   noload
(TST.L   D5
(; BEQ.W   noload
(beq     skipeot
(jsr     getinfo
 look40  move.b  -(a2),d0
(beq     look40
(cmpi.b  #26,d0          ; ctrl-z
(beq     skipeot
(addq.l  #1,a2
 skipeot clr.b   (A2)+
(clr.b   (A2)+
(move.l  A2,ptrEnd
(TST.W   saveinfo
(BEQ     noinfo
(lea     svs2,a1         ; Kopie v. 'tags'
(cmpa.l  $34(a1),a2      ; tags['='] = ptrEnd?
(beq     infook
(move.l  $34(a1),d0      ; tags['='] berhaupt definiert?
(MOVE.L  ptrStart,A1
(cmp.l   a1,d0
(bcs     chkold          ; nein -> auf DLE prfen
(cmp.l   a2,d0           ; (A2=ptrEnd)
(bcs     noinfo          ; ja -> info nicht mehr gltig
 chkold  CMPI.B  #DLEchar,(a1)
(bne     noinfo          ; bei alten Texten ist DLE das Kriterium
 infook  MOVE.W  #1,saveinfo
(JSR     restoreTags
(bra     info0
 noinfo  CLR.W   saveinfo
 info0   clr.b   (A2)+
(clr.b   (A2)+
(clr.b   (A2)+
(clr.b   (A2)+
(move    #1,saved
(move.l  ptrStart,d1
(tst     errorNr
(beq     nomark
(clr     errorNr
(move.l  errorpos,d0
(beq     nomark
(add.l   d1,d0
(lea     tags,A1
(move.l  d0,$3C(A1)      ; tags['?'] setzen
 nomark  lea     tabs,a0
(cmpi.b  #80,(a0)
(bne     noload
(moveq   #39,d0
 cptab   move    (a0)+,(a3)+
(dbf     d0,cptab
(clr.w   (a3)+
(jsr     GetTabs
 noload  jsr     CountTabs
(tst     leaveDLEonWrite
(bne     noclean         ; Text wurde mit DLEs gespeichert
(jsr     Cleantext
 noclean
 END
 END ReadText;
 
 
 
 (*$l-*)
 PROCEDURE Page(dir: BOOLEAN);   (* 20*Repeatfactor Zeilen vor/zurck *)
 BEGIN
 ClrKBDbuffer;
 ASSEMBLER
(move.l ptr,a0
(move.l a0,scrPtr
(jsr    RptfOK   ; liefert rptf in D0
(move.l d0,d5
(; umrechnen in Zeilenanzahl
(move.l d5,d0
(asl.l  #2,d0  ; Zeilen := rptf * 20
(add.l  d0,d5
(asl.l  #2,d5
(lea    NextCR,A1
(tst    -(a3)
(beq    pbild
(lea    LastCR,A1
 pbild   jsr    (A1)
(bne    nokor1   ; end of text
(subq.l #1,d5
(bgt    pbild
 nokor1  jsr    LineSt
(clr.l  rptf
(move.l a0,ptr
(move.l #ScreenOut,(a3)+
(jmp    CondScreen
 END
 END Page;
"
 (*$l-*)
 PROCEDURE Down;         (* eine Zeile runter *)
 BEGIN
 ASSEMBLER
*clr    forceTab
*move.l ptr,a0
 cr1       move.b (a0)+,d0
*beq    Downrt
*cmpi.b #CRchar,d0
*bne    cr1
*move.b ptrX,hilf
*jsr    WriteLn
*move   ptrLine,d0
*addq   #1,d0
*move   d0,ptrLine
*cmp    maxLine,d0
*ble    crzanflf
*move   maxLine,ptrLine
*move.l a0,-(a7)
*clr    cmdFlag
*jsr    LineOut
*move.l (a7)+,a0
 crzanflf  move   ptrY,d1
*move.b ptrX,d1
*moveq  #0,d0
*move.b ch,d0
*clr.b  d1
*tst    delFlag
*bne    crzanf1
*cmpi   #downKey,d0
*bne    crzanf1
*move.b hilf,d1
 crzanf1   jmp    FindCursor
 Downrt    move   #1,forceTab
 END
 END Down;
 
 (*$l-*)
 PROCEDURE UpNoCursor;           (* eine Zeile rauf *)
 BEGIN
 ASSEMBLER
(clr     forceTab
(move.l  ptr,a0
(jsr     LineSt
(tst.b   -1(a0)
(beq     uprt
(jsr     LastCR
(jsr     LineSt
(cmpi    #1,ptrLine
(bhi     up1
(clr     cmdflag
(moveq   #HomeChar,d0
(jsr     ChrOut
(moveq   #ClrLnChar,D0
(jsr     ChrOut
(moveq   #UpChar,D0
(jsr     ChrOut
(moveq   #DownChar,D0
(jsr     ChrOut
(movem.l d0/a0,-(a7)
(jsr     LineOut
(movem.l (a7)+,d0/a0
(rts
 up1     subq.b  #1,ptrY
(subq    #1,ptrLine
(rts
 uprt    move    #1,forceTab
 END
 END UpNoCursor;
 
 (*$l-*)
 PROCEDURE Up;           (* eine Zeile rauf *)
 BEGIN
 ASSEMBLER
(clr     forceTab
(move.l  ptr,a0
(jsr     LineSt
(tst.b   -1(a0)
(beq.l   uprt
(jsr     LastCR
(jsr     LineSt
(cmpi    #1,ptrLine
(bhi     up1
(move    ptrX,-(a7)
(clr     cmdflag
(moveq   #HomeChar,d0
(jsr     ChrOut
(moveq   #ClrLnChar,D0
(jsr     ChrOut
(moveq   #UpChar,D0
(jsr     ChrOut
(moveq   #DownChar,D0
(jsr     ChrOut
(movem.l d0/a0,-(a7)
(jsr     LineOut
(movem.l (a7)+,d0/a0
(move    (a7)+,ptrX
(bra     up2
 up1     subq.b  #1,ptrY
(subq    #1,ptrLine
 up2     move    ptrY,d1
(clr.b   d1
(cmpi.b  #CRchar,ch
(beq     upzanf
(move.b  ptrX,d1
 upzanf  jmp     FindCursor
 uprt    move    #1,forceTab
 END
 END Up;
 
 (*$l-*)
 PROCEDURE ScrollUp;
"BEGIN
$ASSEMBLER
*clr    forceTab
*move.l ptr,a0
 cr1       move.b (a0)+,d0
*beq.w  Downrt
*cmpi.b #CRchar,d0
*bne    cr1
*
*; prfen, ob noch /ptrLine/ Zeilen darunter sind
*move.l  a0,temp
*move    maxline,d1
*sub     ptrline,d1
*cmp     d1,d1
*bra     con1
 lup1      jsr     nextcr
 con1      dbne    d1,lup1
*bne.w   downrt
*
*; jsr     lastcr
*; jsr     LineSt
*move   ptrY,d1
*move.b ptrX,d1
*move   d1,-(a7)
*move   ptrLine,-(a7)
*move   maxLine,ptrLine
*move   maxLine,D1
*lsl    #8,d1
*jsr    gotoxyd1       ; auf letzte Zeile springen
*jsr    writeln
*clr    cmdFlag
*jsr    LineOut
*move.l temp,a0
*move   (a7)+,ptrLine
*move   (a7)+,d1
*jmp    FindCursor
 Downrt    move   #1,forceTab
$END
"END ScrollUp;
 
 (*$l-*)
 PROCEDURE ScrollDown;
"BEGIN
$ASSEMBLER
(clr     forceTab
(move.l  ptr,a0
(jsr     LineSt
(tst.b   -1(a0)
(beq.l   uprt
(jsr     LastCR
(jsr     LineSt
 
(; prfen, ob noch /ptrLine/ Zeilen darber sind
(move.l  a0,temp
(move    ptrline,d1
(subq    #1,d1
(cmp     d1,d1
(bra     con1
 lup1    jsr     lastcr
 con1    dbne    d1,lup1
(bne.w   uprt
 
(jsr     LineSt
(move    ptrY,d1
(move.b  ptrX,d1
(move    d1,-(a7)
(moveq   #HomeChar,d0
(jsr     ChrOut
(moveq   #ClrLnChar,D0
(jsr     ChrOut
(moveq   #UpChar,D0
(jsr     ChrOut
(move   #$0100,D1
(jsr    gotoxyd1
(move   ptrLine,-(a7)
(move   #1,ptrLine
(clr    cmdFlag
(jsr    LineOut
(move.l temp,a0
(move   (a7)+,ptrLine
(move   (a7)+,d1
(jmp     FindCursor
 uprt    move    #1,forceTab
$END
"END ScrollDown;
 
 (*$l-*)
 PROCEDURE Right;        (* ein Zeichen nach rechts *)
 BEGIN
 ASSEMBLER
(clr    forceTab
(move.l ptr,a0
 again   move.b (a0)+,d0
(beq    force
(cmpi.b #CRchar,d0
(beq    rcr
(cmpi.b #$20,d0
(bcs    again
(move.l a0,ptr
(move   ptrY,d1
(move.b ptrX,d1
(cmp.b  maxCol,d1
(beq    force
(addq.b #1,d1
(jmp    GotoXYd1
 rcr     jmp    Down
 force   move   #1,forceTab
 END
 END Right;
 
 
 (*$l-*)
 PROCEDURE GotoEOLN;
 BEGIN
 ASSEMBLER
 goright move.l  ptr,a0
(move.b  (a0),d0
(beq     xit
(cmpi.b  #CRchar,d0
(beq     xit
(jsr     Right
(bra     goright
 xit
 END
 END GotoEOLN;
 
 (*$l-*)
 PROCEDURE WordRight;    (* ein Wort nach rechts *)
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(move.b  (a0),d0
(jsr     alphanum
(bne     lp2
 lp1     jsr     Right
(tst     forceTab
(bne     wrout
(move.l  ptr,a0
(move.b  (a0),d0
(jsr     AlphaNum
(beq     lp1
 lp2     jsr     Right
(tst     forceTab
(bne     wrout
(move.l  ptr,a0
(move.b  (a0),d0
(jsr     AlphaNum
(bne     lp2
 wrout
 END
 END WordRight;
 
 (*$l-*)
 PROCEDURE Left;         (* ein Zeichen nach links *)
 BEGIN
 ASSEMBLER
(clr    forceTab
(move.l ptr,a0
 again   move.b -(a0),d0
(beq    leftrt
(cmpi.b #CRchar,d0
(beq    crback
(cmpi.b #DLEchar,-1(a0)
(bne    delit
(tst.b  -2(a0)
(beq    leftrt
(bra    crback
 delit   cmpi.b #$20,d0
(bcs    again
(jsr    LineSt
(move   ptrY,d1
(move.b ptrX,d1
(subq.b #1,d1
(jmp    FindCursor
(move.l a0,ptr
(moveq  #LeftChar,d0
(jmp    ChrOut
 crback  jsr    UpNoCursor
(jsr    LineSt
(move   ptrY,d1
(move.b maxCol,d1
(jmp    FindCursor
 leftrt  move   #1,forceTab
 END
 END Left;
 
 (*$l-*)
 PROCEDURE OnSOLn (): BOOLEAN;
 BEGIN
 ASSEMBLER
(moveq   #1,d0
(move.l  ptr,a0
(cmpi.b  #CRchar,-1(a0)
(beq     xit
(cmpi.b  #dlechar,-2(a0)
(beq     xit
(clr     d0
 xit     move    d0,(a3)+
 END
 END OnSOLn;
 
 (*$l-*)
 PROCEDURE GotoSOLN;
 BEGIN
 ASSEMBLER
 goleft  move.l  ptr,a0
(move.b  -1(a0),d0
(beq     xit
(cmpi.b  #CRchar,d0
(beq     xit
(move.b  -2(a0),d0
(beq     xit
(cmpi.b  #DLEchar,d0
(beq     xit
(jsr     Left
(bra     goleft
 xit
 END
 END GotoSOLN;
 
 (*$l-*)
 PROCEDURE WordLeft;    (* ein Wort nach links *)
 BEGIN
 ASSEMBLER
 lp1     jsr     Left
(tst     forceTab
(bne     wrout
(move.l  ptr,a0
(move.b  (a0),d0
(jsr     AlphaNum
(bne     lp1
 lp2     move.l  ptr,a0
(move.b  -1(a0),d0
(beq     wrout
(cmpi.b  #DLEchar,-2(a0)
(beq     wrout
(jsr     alphanum
(bne     wrout
(jsr     Left
(tst     forceTab
(beq     lp2
 wrout
 END
 END WordLeft;
 
 (*$l-*)
 PROCEDURE DelRight;             (* nach rechts lschen *)
 BEGIN
 ASSEMBLER
(clr    forceTab
(move.l ptr,a0
 again   move.b (a0)+,d0
(beq    force
(cmpi.b #CRchar,d0
(beq    rcr
(cmpi.b #$20,d0
(bcs    again
(move.l a0,ptr
(move.b ptrX,d1
(cmp.b  maxCol,d1
(beq    force
(moveq  #' ',d0
(cmpa.l delPtr,a0
(bhi    delaus
(move.b -1(a0),d0
 delaus  jmp    ChrOut
 rcr     jmp    Down
 force   move   #1,forceTab
 END
 END DelRight;
 
 (*$l-*)
 PROCEDURE DelLeft;              (* nach links lschen *)
 BEGIN
 ASSEMBLER
(clr    forceTab
(move.l ptr,a0
 again   move.b -(a0),d0
(beq    leftrt
(cmpi.b #CRchar,d0
(beq    crback
(cmpi.b #DLEchar,-1(a0)
(bne    delit
(tst.b  -2(a0)
(beq    leftrt
(bra    crback
 delit   cmpi.b #$20,d0
(bcs    again
(move.l a0,ptr
(moveq  #LeftChar,d0
(jsr    ChrOut
(move.b (a0),d0
(cmpa.l delPtr,a0
(bcc    delaus
(moveq  #' ',d0
 delaus  jsr    ChrOut
(moveq  #LeftChar,d0
(jmp    ChrOut
 crback  jsr    UpNoCursor
(jsr    LineSt
(move   ptrY,d1
(move.b maxCol,d1
(jmp    FindCursor
 leftrt  move   #1,forceTab
 END
 END DelLeft;
 
 (*$l-*)
 PROCEDURE DelLine;              (* Zeile lschen mit DelRight/Left *)
 BEGIN
 ASSEMBLER
 delln   move.l temp,a0
(cmpa.l ptr,a0
(bgt    delfor
(blt    delbck
(rts
 delfor  jsr    DelRight
(bra    delln
 delbck  jsr    DelLeft
(bra    delln
 END
 END DelLine;
 
 (*$l-*)
 PROCEDURE DelWordRight;         (* Wort rechts lschen *)
 BEGIN
 ASSEMBLER
(bra     lp0
 again   move.b  (a0)+,d0
(beq     wrout
(cmpi.b  #CRchar,d0
(bne     nocr
(cmpi.b  #DLEchar,(a0)
(bne     ok
(addq.l  #2,a0
(bra     ok
 nocr    cmpi.b  #$20,d0
(bcs     again
 ok      rts
 lp0     move.l  ptr,a0
(move.b  (a0),d0
(beq     wrout
(jsr     alphanum
(bne     lp2
 lp1     bsr     again
(move.b  (a0),d0
(beq     wrout
(jsr     AlphaNum
(beq     lp1
 lp2     bsr     again
(move.b  (a0),d0
(beq     wrout
(jsr     AlphaNum
(bne     lp2
(move.l  a0,temp
(jsr     DelLine
 wrout
 END
 END DelWordRight;
 
 (*$l-*)
 PROCEDURE DelWordLeft;          (* Wort links lschen *)
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(bra     lp1
 again   move.b  -(a0),d0
(beq     dwlout
(cmpi.b  #CRchar,d0
(beq     leftok
(cmpi.b  #DLEchar,-1(a0)
(bne     delit
(subq.l  #1,a0
(bra     again
 delit   cmpi.b  #$20,d0
(bcs     again
 leftok  rts
 lp1     bsr     again
(tst.b   d0
(beq     dwlout
(jsr     AlphaNum
(bne     lp1
 lp2     move.b  -1(a0),d0
(beq     dwlok
(cmpi.b  #DLEchar,-2(a0)
(beq     dwlok
(jsr     alphanum
(bne     dwlok
(bsr     again
(tst.b   d0
(beq     dwlout
(tst     forceTab
(beq     lp2
 dwlok   move.l  a0,temp
(jsr     DelLine
 dwlout
 END
 END DelWordLeft;
 
 (*$l-*)
 PROCEDURE DelToEOLN;            (* bis Zeilenende lschen *)
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(jsr     NextCR
(bne     nodel
(subq.l  #1,a0
(move.l  a0,temp
(jmp     DelLine
 nodel
 END
 END DelToEOLN;
 
 (*$l-*)
 PROCEDURE DelToSOLN;            (* bis Zeilenanfang lschen *)
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(jsr     LastCR
(bne     noadd
(addq.l  #1,a0
 noadd   cmpi.b  #DLEchar,(a0)
(bne     ok
(addq.l  #2,a0
 ok      move.l  a0,temp
(jmp     DelLine
 END
 END DelToSOLN;
 
 (*$l-*)
 PROCEDURE DelDown;              (* nach unten lschen *)
 BEGIN
 ASSEMBLER
*move.l ptr,a0
 cr1       move.b (a0)+,d0
*bne    cr11
*rts
 cr11      cmpi.b #CRchar,d0
*bne    cr1
*moveq  #0,d0
*move.b ch,d0
*move.b ptrX,d1
*cmpi   #downKey,d0
*beq    crmitte
*moveq  #0,d1
 crmitte   moveq  #0,d3
*cmpi.b #DLEchar,(a0)
*bne    xit
*addq.l #1,a0
*move.b (a0)+,d3
*sub.b  #DLEoffset,d3
*cmp.b  d3,d1
*ble    xit
 fc1       move.b (a0),d4
*beq    xit
*cmpi.b #CRchar,d4
*beq    xit
*addq.l #1,a0
*addq.b #1,d3
*cmp.b  d3,d1
*bne    fc1
 xit       move.l a0,temp
*jmp    DelLine
 END
 END DelDown;
 
 (*$l-*)
 PROCEDURE DelUp;              (* nach oben lschen *)
 BEGIN
 ASSEMBLER
(move.l ptr,a0
(jsr    LineSt
(jsr    LastCR
(bne    uprt
(jsr    LineSt
(move.b ptrX,d1
(cmpi.b #EnterKey,ch
(bne    crmitt
(moveq  #0,d1
 crmitt  moveq  #0,d3
(cmpi.b #DLEchar,(a0)
(bne    xit
(addq.l #1,a0
(move.b (a0)+,d3
(sub.b  #DLEoffset,d3
(cmp.b  d3,d1
(ble    xit
 fc1     move.b (a0),d4
(beq    xit
(cmpi.b #CRchar,d4
(beq    xit
(addq.l #1,a0
(addq.b #1,d3
(cmp.b  d3,d1
(bne    fc1
 xit     move.l a0,temp
(jmp    DelLine
 uprt
 END
 END DelUp;
 
 (*$l-*)
 PROCEDURE InsWrite;     (* Bildschrim ab Cursor neu aufbauen *)
 BEGIN
 ASSEMBLER
(move   d1,-(a7)
(jsr    GotoXYd1
(clr    d0
(move.b ptrY,d0
(move   d0,ptrLine
(move.l ptr,a0
 inslnw  jsr    LineOut
(moveq  #0,d0
(move.b ptrY,d0
(cmp    maxLine,d0
(bcc    inslnx
(jsr    WriteLn
(bra    inslnw
 inslnx  move   (a7)+,d1
(jmp    GotoXYd1
 END
 END InsWrite;
 
 (*$l-*)
 PROCEDURE InsRight;     (* ein Zeichen nach rechts im Insert-Buf. (bufferM) *)
 END InsRight;
 
 (*$l-*)
 PROCEDURE InsBackSpace; (* ein Zeichen aus Insert-Buffer lschen (bufferM) *)
 BEGIN
 ASSEMBLER
+clr    forceTab
+move.l bufferL,a0
+cmpa.l bufferH,a0
+bcs    eleft1
+move.l ptr,a0
+cmpi.b #DLEchar,-2(a0)
+bne    ilefterr
+move.b -(a0),d0
+cmpi.b #DLEoffset,d0
+bls    ilefterr
+subq.b #1,d0
+move.b d0,(a0)
+move.b d0,dleWert
+bra.l  insback
 ilefterr   move   #1,forceTab
+rts
 eleft1     cmpi.b #CRchar,(a0)
+beq    crleft
+cmpi.b #DLEchar,1(a0)
+beq    dleleft
+move.b (a0),d0
+addq.l #1,bufferL
+addq.l #1,bufferM
+cmpi.b #$20,d0
+bcs    insbctrl
+bra    insback
 dleleft    move.b (a0),d0
+cmpi.b #DLEoffset,d0
+bhi    dleleft1
+addq.l #2,a0
 crleft     addq.l #1,a0
+move.l a0,bufferL
+move.l a0,bufferM
+move   ptrY,d1
+clr.b  d1
+subi   #256,d1
+ble    ilefterr
 findx      cmpi.b #CRchar,(a0)
+beq    foundx
+addq.l #1,a0
+addq.b #1,d1
+cmpa.l bufferH,a0
+bls    findx
+move.l bufferH,a0
+subq.b #1,d1
+add.b  ptrXIns,d1
 foundx     cmpi.b #DLEchar,-(a0)
+bne    foundx1
+subq.b #2,d1
+add.b  -(a0),d1
+sub.b  #DLEoffset,d1
 foundx1    jmp    InsWrite
 dleleft1   subq.b #1,d0
+move.b d0,dleWert
+move.b d0,(a0)
 insback    moveq  #BSchar,d0
+jsr    ChrOut
 insbctrl   move   ptrY,d1
+move.b ptrX,d1
+move   d1,-(a7)
+move.l ptr,a0
+jsr    LineOut
+move   (a7)+,d1
+jmp    GotoXYd1
 END
 END InsBackSpace;
 
 (*$l-*)
 PROCEDURE InsLeft;      (* ein Zeichen nach links im Insert-Buf. (bufferM) *)
 BEGIN
 ASSEMBLER jmp     InsBackSpace
 END
 END InsLeft;
 
 (*$l-*)
 PROCEDURE InsDelete;    (* Zeichen unter Cursor lschen (bufferM) *)
 BEGIN
 ASSEMBLER jmp     InsBackSpace
 END
 END InsDelete;
 
 (*$l-*)
 PROCEDURE InsLine;      (* eine Zeile einfgen *)
 BEGIN
 ASSEMBLER
(move   #3,(a3)+
(jsr    Available
(tst    -(a3)
(bne    ins1
(jsr    Overflow
(jmp    InsCmd
 ins1    jsr    ClrLn
(moveq  #ClrEOLNchar,d0
(jsr    ChrOut
(move.l bufferL,a0
(move.b #CRchar,-(a0)
(move.b dleWert,d5
(move.b d5,d4
(subi.b #DLEoffset,d4
(move.b d4,d6
(tst    makeDLE
(beq    inodle
(move.b #DLEchar,-(a0)
(move.b d5,-(a0)
(bra    ins2
 inodle  subq.b #1,d4
(bmi    ins2
(move.b #' ',-(a0)
(bra    inodle
 ins2    move.l a0,bufferL
(move.l a0,bufferM
(move   ptrY,d1
(move.b d6,d1
(jmp    InsWrite
 END
 END InsLine;
 
 (*$l-*)
 PROCEDURE IntoBuffer(ch: CHAR);         (* ch im Insert-Buffer ablegen *)
 BEGIN
 ASSEMBLER
(subq.l #1,a3
(moveq  #0,d0
(move.b -(a3),d0
(move   #1,(a3)+
(jsr    Available
(tst    -(a3)
(bne    ins1
(jsr    Overflow
(jmp    InsCmd
 ins1    move   #1,forceTab
(move.b ptrX,d1
(cmp.b  maxCol,d1
(bcc    ins2
 ins11   jsr    ChrOut
(clr    forceTab
 ins2    move.l bufferL,a0
(cmpi.b #' ',d0
(bne    bufch
(cmpi.b #DLEchar,1(a0)
(beq    bufdle
(cmpa.l bufferH,a0
(bcs    bufch
(move.l ptr,A1
(cmpi.b #DLEchar,-2(A1)
(bne    bufch
(lea    -1(A1),a0
 bufdle  addq.b #1,dleWert
(bpl    bufdl1
(subq.b #1,dleWert
 bufdl1  addq.b #1,(a0)
(bpl    bufwrt
(subq.b #1,(a0)
(bra    bufwrt
 bufch   move.b d0,-(a0)
(move.l a0,bufferL
(move.l a0,bufferM
 bufwrt  move   ptrY,d1
(move.b ptrX,d1
(move   d1,-(a7)
(move.l ptr,a0
(jsr    LineOut
(move   (a7)+,d1
(jmp    GotoXYd1
 END
 END IntoBuffer;
 
 (*$l-*)
 PROCEDURE Break;
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(cmpi.b  #DLEchar,-2(a0)
(beq     fndna
(move.b  -1(a0),d0
(jsr     AlphaNum
(bne     spcvor
 fndna   move.b  (a0)+,d0        ;suche non-alpha-char.
(beq.l   exbrk
(jsr     AlphaNum
(beq     fndna
(subq.l  #1,a0
 spcvor  cmpi.b  #' ',(a0)+
(beq     spcvor
(subq.l  #1,a0
(move.l  a0,ptr
(jsr     LineSt          ;a0 zeigt auf voriges CR
(moveq   #DLEoffset,d0
(moveq   #1,d1
(tst     makeDLE
(beq     nodle
(cmpi.b  #DLEchar,(a0)
(bne     nodle
(addq.l  #2,d1
(move.b  1(a0),d0
 nodle   move    d1,d2
(move.b  d0,dleWert
(move.l  ptr,a0
(move.l  a0,(a3)+
 spcweg  move.b  -(a0),d0
(cmpi.b  #DLEchar,d0
(beq     fnddle
(cmpi.b  #' ',d0
(bne     nospc
(subq.l  #1,d1
(bra     spcweg
 fnddle  addq.l  #1,d1
 nospc   move.l  d1,(a3)+
(add.l   d1,ptr
(move    d2,-(a7)
(jsr     MoveText
(move    (a7)+,d2
(move.l  ptr,a0
(suba    d2,a0
(move.b  #CRchar,(a0)+
(tst     makeDLE
(beq     exbrk
(move.b  #DLEchar,(a0)+
(move.b  dleWert,(a0)+
 exbrk   jsr     ScreenOut
 END
 END Break;
 
 (*$l-*)
 PROCEDURE Glue;
 BEGIN
 ASSEMBLER
(jsr     RptfOK
 gluelp  move.l  ptr,a0
(moveq   #-1,d1
 fndcr   move.b  (a0)+,d0
(beq     exglue
(cmpi.b  #CRchar,d0
(bne     fndcr
(cmpi.b  #DLEchar,-3(a0)
(beq     spcda
(cmpi.b  #' ',-2(a0)
(beq     spcda
(move.b  #' ',-1(a0)
(addq.l  #1,d1
 spcda   cmpi.b  #DLEchar,(a0)
(bne     movok
(addq.l  #2,a0
(subq.l  #2,d1
 movok   move.l  a0,(a3)+
(move.l  d1,(a3)+
(adda.l  d1,a0
(move.l  a0,ptr
(jsr     MoveText
(subq.l  #1,rptf
(;bne     gluelp         ;Glue ohne Rptf!!
 exglue  jsr     ScreenOut
(clr.l  rptf
 END
 END Glue;
 
 (*$l-*)
 PROCEDURE DelOneChar;
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(move.b  (a0),d0
(beq     xit
(cmpi.b  #CRchar,d0
(beq     xit
(addq.l  #1,a0
(move.l  a0,(a3)+
(move.l  #-1,(a3)+
(jsr     MoveText
(jsr     PushPtr
(move    ptrY,d1
(move.b  ptrX,d1
(move.l  ptr,a0
(move    #1,insflag
(jsr     LineOut
(clr     insflag
(jsr     GotoXYd1
 xit
 END
 END DelOneChar;
 
 (*$l-*)
 PROCEDURE DelOneCharLeft;
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
(tst.b   -(a0)
(beq     xit
(move.b  -1(a0),d0
(beq     xit
(cmpi.b  #DLEchar,d0
(bne     nodle
(move.b  (a0),d0
(subq.b  #1,d0
(cmpi.b  #DLEoffset,d0
(bge     store0
(moveq   #DLEoffset,d0
 store0  move.b  d0,(a0)+
(move.l  a0,ptr
(subq.l  #2,a0
(move    ptrY,d1
(clr.b   d1
(jsr     GotoXYd1
(jsr     LineOut
(jmp     GotoPtr
 nodle   jsr     Left
(jmp     DelOneChar
 xit
 END
 END DelOneCharLeft;
 
 (*$l-*)
 PROCEDURE InsOneChar;
 BEGIN
 ASSEMBLER
&(*move.l  ptr,a0
(move.b  -(a0),d0
(beq     nodle
(cmpi.b  #DLEchar,-1(a0)
(bne     nodle
(addq.b  #1,d0
(bmi     xit
(move.b  d0,(a0)
(subq.l  #1,a0
(move    ptrY,d1
(clr.b   d1
(jsr     GotoXYd1
(jsr     LineOut
(jmp     GotoPtr
 nodle*) move    #1,(a3)+
(jsr     Available
(tst     -(a3)
(beq     xit
(move.l  ptr,(a3)+
(move.l  #1,(a3)+
(jsr     MoveText
(jsr     PushPtr
(move    ptrY,d1
(move.b  ptrX,d1
(move    #1,insflag
(move.l  ptr,a0
(move.b  #' ',(a0)
(jsr     LineOut
(clr     insflag
(jsr     GotoXYd1
 xit
 END
 END InsOneChar;
 
 (*$l+*)
 PROCEDURE InsMode;              (* Insert-Modus *)
"VAR ptrLTemp:CARDINAL;
 BEGIN
"InsCmd;
"ASSEMBLER
,move.b ptrX,ptrXIns
,move   ptrLine,ptrLTemp(A6)
,move   #1,insFlag
,move.l bufferH,a0
,move.l a0,bufferL
,move.l a0,bufferM
,move.l ptr,a0
,move.b -1(a0),temp
,jsr    LineSt
,moveq  #DLEoffset,d0
,cmpi.b #DLEchar,(a0)+
,bne    ikeindle
,move.b (a0),d0
"ikeindle  move.b d0,dleWert
"END;
"REPEAT
$ReadCh;
$IF ch=EnterKey THEN
&InsLine;
&IF ptrLine=maxLine THEN InsCmd END
$ELSIF ch=leftKey THEN InsLeft
$ELSIF ch=BSkey THEN InsBackSpace
$ELSIF ch=DELkey THEN InsDelete
$ELSIF ch=TabLeftKey THEN REPEAT InsLeft UNTIL TabSet()
$ELSIF ch=rightKey THEN
&IF bufferM=bufferL THEN IntoBuffer(' ') ELSE InsRight END
$ELSIF ch=TabRightKey THEN
&REPEAT
(IF bufferM=bufferL THEN IntoBuffer(' ') ELSE InsRight END
&UNTIL TabSet()
$ELSIF ch IN allowed THEN IntoBuffer(ch)
$ELSIF accept THEN BufferToText(false) END
"UNTIL abort OR accept;
"PushPtr;
"lastPtr:=ptr;
"insFlag:=false;
"IF abort THEN
$ASSEMBLER move.l ptr,a0 move.b temp,-1(a0) move ptrLTemp(A6),ptrLine END;
$ScreenOut
"END
 END InsMode;
 
 (*$l+*)
 PROCEDURE DelMode;              (* Delete-Modus *)
"VAR ptrLTemp:CARDINAL;
 BEGIN
"ASSEMBLER move.l ptr,delPtr move ptrLine,ptrLTemp(A6) clr cmdFlag
*move #1,delFlag clr.l rptf
"END;
"LOOP
$IF CmdLineAway(FALSE) THEN
&PutCmdOrTab('Delete: /F1/ or /Enter/ deletes, /ESC/ ignores');
&cmdFlag:=true
$END;
$ReadUpCh;
$IF accept THEN AbInBuffer; EXIT
$ELSIF abort THEN DelInBuffer; EXIT
$ELSIF DirKey() OR Rptfx10() THEN
$ELSE RptfOk;
&REPEAT
(IF (ch=leftKey) OR (ch=BSkey) OR (ch=DELkey) THEN DelLeft
(ELSIF (ch=rightKey) OR (ch=' ') THEN DelRight
(ELSIF ch=TabLeftKey THEN REPEAT DelLeft UNTIL (ptr<=ptrStart) OR TabSet()
(ELSIF ch=TabRightKey THEN REPEAT DelRight UNTIL (ptr>=ptrEnd-2L) OR TabSet()
(ELSIF ch=EnterKey THEN IF direction THEN DelUp ELSE DelDown END;
(ELSIF ch=EOLNkey THEN DelToEOLN
(ELSIF ch=SOLNkey THEN DelToSOLN
(ELSIF ch=WordLeftKey THEN DelWordLeft
(ELSIF ch=WordRightKey THEN DelWordRight
(ELSIF ch=upKey THEN DelUp
(ELSIF ch=downKey THEN DelDown
(END;
(DEC(rptf)
&UNTIL (rptf=0L) OR KeyPressed()
$END
"END;
"cmdFlag:=false; delFlag:=false;
"IF (ptr>delPtr) OR abort THEN ptr:=delPtr END;
"PushPtr;
"lastPtr:=ptr;
"ptrLine:=ptrLTemp;
"ScreenOut
 END DelMode;
 
 (*$l-*)
 PROCEDURE Zap;          (* Zap zum lschen grsserer Stcke *)
 BEGIN
"temp:=ptr;
"ChkLastPtr;
"CASE ChkZap() OF
"0:AbInBuffer; ScreenOut |
"1:PutCmd('Zap more than 200 characters? ');
$IF Yes() THEN AbInBuffer; ScreenOut ELSE ptr:=temp END |
"2:PutCmd('Zap: no room to buffer - delete anyway? ');
$IF Yes() THEN
&bufferL:=bufferH;
&MoveText(delPtr,LONGINT(ptr)-LONGINT(delPtr));
&ScreenOut
$ELSE ptr:=temp
$END
"END
 END Zap;
 
 (* ED5.ICL *)
 
 (*$l-*)
 PROCEDURE Exchange;
 BEGIN
"cmdFlag:=false;
"LOOP
$IF CmdLineAway(FALSE) THEN
&PutCmdOrTab('Exchange: /ESC/, /F1/ or /Enter/ to END');
&cmdFlag:=true
$END;
$ReadCh;
$IF accept OR abort THEN EXIT
$ELSIF ch=EOLNkey THEN GotoEOLN
$ELSIF ch=SOLNkey THEN GotoSOLN
$ELSIF ch=leftKey THEN Left
$ELSIF ch=rightKey THEN Right
$ELSIF ch=wordLeftKey THEN WordLeft
$ELSIF ch=wordRightKey THEN WordRight
$ELSIF ch=TabLeftKey THEN REPEAT Left UNTIL TabSet()
$ELSIF ch=TabRightKey THEN REPEAT Right UNTIL TabSet()
$ELSIF ch=EnterKey THEN Down
$ELSIF (ch=PageDownKey) OR (ch=PageUpKey) THEN Page(ch=PageUpKey)
$ELSIF ch=upKey THEN Up
$ELSIF ch=downKey THEN Down
$ELSIF ch=scrlUpKey THEN ScrollUp;
$ELSIF ch=scrlDownKey THEN ScrollDown;
$ELSIF ch=DELkey THEN DelOneChar
$ELSIF ch=INSkey THEN InsOneChar
$ELSIF ch=BSkey THEN DelOneCharLeft
$ELSIF (ch IN allowed) & Exchg(ch) THEN ASSEMBLER
&move.b ptrX,d0 cmp.b maxCol,d0 bhi no move.b ch,d0 jsr ChrOut no END
$END
"END;
"PushPtr;
"cmdFlag:=false
 END Exchange;
 
 (*$l+*)
 PROCEDURE Adjust;       (* zum Einrcken von Zeilen und Blcken *)
"VAR dlediff:CARDINAL;
 BEGIN
"ASSEMBLER clr dlediff(A6) clr cmdFlag clr.l rptf END;
"LOOP
$IF CmdLineAway(FALSE) THEN
&PutCmdOrTab('Adjust: <-, ->, L(eft, /CR/, /ESC/');
&cmdFlag:=true
$END;
$ReadUpCh;
$IF abort OR accept THEN EXIT
$ELSIF DirKey() OR Rptfx10() THEN
$ELSE RptfOK;
&ASSEMBLER
&adjloop    move.l ptr,a0          ;Hauptschleife
1jsr    LineSt          ;a0 zeigt auf evtl. DLE
1moveq  #0,d0
1move.b ch,d0
1cmpi   #upKey,d0
1beq.l  adjup
1cmpi.b #EnterKey,d0
1bne    adj0
1tst.w  direction
1bne.w  adjUp
1bra.w  adjDown
&adj0       cmpi   #downKey,d0
1beq.l  adjDown
1cmpi.b #DLEchar,(a0)+      ;kein DLE => gleich wieder raus
1bne.l  adjmor1
1move.b (a0),d1         ;Space-Count nach DLE
1cmpi   #leftKey,d0
1bne    adj1
1cmpi.b #DLEoffset,d1
1beq.l  adjmor1
1subq.b #1,d1
1subq.b #1,dlediff(A6)
1move.b d1,(a0)         ;eins nach links
1bra.l  adjzeile
&adj1       cmpi.b #' ',d0
1beq    adj11
1cmpi   #rightKey,d0
1bne    adj2
&adj11      addq.b #1,d1
1bpl    adjright
1subq.b #1,d1
&adjright   addq.b #1,dlediff(A6)
1move.b d1,(a0)         ;eins nach rechts
1bra.l  adjzeile
&adj2       cmpi.b #'L',d0         ;L(eft-Adjust
1bne    adj3
1moveq  #DLEoffset,d1
1sub.b  (a0),d1
1move.b d1,dlediff(A6)  ;Distanz fr weitere Zeilen ber.
1move.b #DLEoffset,(a0)
1bra.l  adjzeile
&adj3       cmpi.b #TabRightKey,d0
1bne    adj4
1sub.b  #DLEoffset,d1
1move.b d1,ptrX
&adjtab     addq.b #1,dleDiff(A6)
1addq.b #1,ptrX
1bmi    adjzeile
1addq.b #1,(a0)
1jsr    TabSet
1tst    -(a3)
1beq    adjtab
1bra    adjzeile
&adj4       cmpi.b #TabLeftKey,d0
1bne.l  adjmore
1sub.b  #DLEoffset,d1
1move.b d1,ptrX
&adjbaktab  subq.b #1,dleDiff(A6)
1subq.b #1,ptrX
1bmi    adjzeile
1subq.b #1,(a0)
1jsr    TabSet
1tst    -(a3)
1beq    adjbaktab
1bra    adjzeile
&adjDown    jsr    Down
1bra    adjupDown
&adjup      jsr    Up
&adjupDown  move.l ptr,a0
1jsr    LineSt
1cmpi.b #DLEchar,(a0)+
1bne    adjmor1
1move.b (a0),d3
1add.b  dlediff(A6),d3  ;Zeile erst mal um dlediff verschieben
1cmpi.b #DLEoffset,d3
1bge    adjhl
1moveq  #DLEoffset,d3
&adjhl      move.b d3,(a0)
&adjzeile   clr    saved
1clr     restoreFileDT
1move   ptrY,d1
1clr.b  d1
1jsr    GotoXYd1
1addq.l #1,a0
1move.l a0,ptr
1jsr    LineSt
1jsr    LineOut
1jsr    GoToPtr
&adjmor1    jsr    KeyPressed        ;bei Repeatfactor evtl. abbrechen
1tst    -(a3)
1bne    adjmor2
1subq.l #1,rptf
1bne.l  adjloop
&adjmor2    clr.l  rptf
&adjmore
&END
$END
"END;
"cmdFlag:=false
 END Adjust;
 
 (*$l-*)
 PROCEDURE SetTag;       (* Tag an aktuelle Text-Position setzen *)
 BEGIN
"PutCmd('Set tag: enter 0..9 or A..Z: ');
"ASSEMBLER
*jsr    ChrIn
*jsr    ShiftUp
*cmpi   #'Z',d0        ;'Z' hchster erlaubter Marker
*bhi    notag
*subi   #'0',d0        ;'0'=Untergrenze abziehen
*blt    notag
*lsl    #2,d0          ;in der Tabelle stehen LONGs
*lea    tags,a0
*move.l ptr,0(a0,d0.w)
"notag
"END
 END SetTag;
 
 (*$l-*)
 PROCEDURE GotoLine (l:LONGCARD;col:CARDINAL);
 BEGIN
"ASSEMBLER
(move.l  ptr,scrPtr
(move.l  ptrStart,a0
(move.w  -(a3),d2
(move.l  -(a3),d1
(beq     asgn
 lp      subq.l  #1,d1
(beq     asgn
(jsr     NextCR
(bra     lp
 asgn    tst.b   (a0)
(beq     pre0
(addq.l  #1,a0           ; DLE berspringen
(move.b  (a0)+,d1
(subi.b  #DLEoffset,d1
(sub.b   d1,d2
(bmi     set0
(adda.w  d2,a0
 set0    move.l  a0,ptr
 ext0    jmp     CenterScreen
 pre0    jsr     LastCR
(addq.l  #3,a0           ; hinter DLE
(bra     ext0
"END
 END GotoLine;
 
 (*$l-*)
 PROCEDURE Jump;         (* Setzen des Text-Pointers *)
 BEGIN
 ASSEMBLER
(move.l  rptf,d1
(bne.l   count
(END; PutCmd('Jump: B(egin, E(nd, L(ast or tag '); ASSEMBLER
(jsr     ReadUpCh
(move    ptrCount,workCount
(move.l  ptr,scrPtr
 jmplp   move.l  ptr,a0
(cmpi.b  #'L',d0
(bne     nolast
(move.l  lastPtr,a0
(bra     nomar1
 nolast  cmpi.b  #'E',d0
(bne     noend
(move.l  ptrEnd,a0
(subq.l  #2,a0
(bra     nomar1
 noend   cmpi.b  #'B',d0
(bne     nobeg
(move.l  ptrStart,a0
 nomar1  bra.l   nomark
 nobeg   cmpi.b  #' ',d0
(bne     nospc
(jsr     ReadUpCh
(move.l  ptr,a0
(bra.l   nosyn
 nospc   lea     ptrStack,A1
(move    workCount,d1
(cmpi.b  #'+',d0
(bne     noplus
(addq    #4,d1
(bra     bckpls
 noplus  cmpi.b  #'-',d0
(bne     noback
(subq    #4,d1
 bckpls  andi    #$3C,d1
(move.l  0(A1,d1.w),a0
(move    d1,workCount
(bsr.l   nomark
(jsr     ReadUpCh
(cmpi.b  #'-',d0
(beq     nospc
(bra     jmplp
 noback  cmpi.b  #'?',d0
(bne     nosyn
(tst.l   ErrorPos
(beq     nosyn
(END; PutCmd(ErrMsg); ASSEMBLER
(tst     saved
(bne     syn1
(lea     tags,A1
(move.l  $3C(A1),a0
(bra     syn2
 syn1    move.l  ptrStart,a0
(adda.l  ErrorPos,a0
(lea     tags,A1
(move.l  a0,$3C(A1)
 syn2    bsr     nomark
(jmp     ErrorWait
 nosyn   cmpi.b  #'Z',d0
(bhi     nomark
(subi.b  #'0',d0
(bcs     nomark
(asl     #2,d0
(lea     tags,A1
(move.l  0(A1,d0.w),a0
 nomark  cmpa.l  ptrStart,a0
(bcs     bad
(cmpa.l  ptrEnd,a0
(bcc     bad
(bra     asgn
 count   move.l  d1,(a3)+
(clr     (a3)+
(jmp     gotoLine
 asgn    move.l  a0,ptr
 bad     move.l  #CenterScreen,(a3)+
(jmp     CondScreen
 END
 END Jump;
 
 (*$l+*)
 PROCEDURE WriteTitle;
"BEGIN
$writestring ('Gepard-Atari Editor '+Version+' for Megamax Modula-2'); WriteLn;
$writestring
$('Copyright  [1985..1990], Thomas Tempelmann, Schusterwolfstr. 13, 81241 Mnchen');
$writeLn;
$writeLn
"END WriteTitle;
 
 PROCEDURE UpdatePath (VAR tPath: ARRAY OF CHAR);
"VAR res: INTEGER;
"BEGIN
$MakeFullPath (tPath, res);
$ConcatPath (tPath, Path1, Path1);
"END UpdatePath;
 
 PROCEDURE Getpath (VAR tPath: String);
"BEGIN
$GetDefaultPath(tPath);
$Append('*.*',tPath,strOk);
"END GetPath;
L(*H*)
 PROCEDURE getFilefromBox (title: MaxStr): String;
"VAR selectOK,Ok   :Boolean;
&REST,TEMPPATH,fName: STRING;
"BEGIN
$IF UseGem THEN
&Write(ClrScrnChar);
&IF GEMVersion () <= $120 THEN
(GotoXY ( (cols-Length(title)) DIV 2, 1);
(WriteString (title);
&END;
&SelectFile(title,Path1,FName1,selectOK);
&Write(ClrScrnChar);
&SplitPath(Path1,tempPath,Rest);
&abort:= NOT selectOK OR Empty (FName1);
&IF NOT abort then
(Concat(tempPath,FName1,fName,Ok);
(if Ok then return fName end
&END;
&Return ''
$ELSE
&WriteString (title);
&Write (' ');
&ReadString (fName);
&IF Empty (fName) THEN abort:= TRUE END;
&IF Abort THEN fName:= '' END;
&RETURN fName
$END
!END getFilefromBox;
 
 PROCEDURE NewFile;      (* neues File laden *)
"VAR fn:STRING;
 BEGIN
"ClrKBDbuffer;
"ClrCmdLine;
"IF NOT saved & Worthy() THEN
$WriteString('New file: Throw away changes ? ');
$IF NOT Yes() THEN GoToPtr; RETURN END
"END;
"GotoXY(0,0); Write(ClrEOLnchar);
"fn:=getFilefromBox('Load which file?');
"IF ChkName(fn) THEN
$SearchFile (fn,SrcPaths,fromStart,strok,fn);
$Open (f,fn,readOnly);
$IOResult:=State(f);
$IF SuccessFull(13) THEN
&UpdatePath (fn);
&WriteString('Reading ');WriteString(fn);WriteLn;
&flen:= FileSize(f);
&ReadText;
$END;
$IF IOResult=0 THEN Flip(fileName,fn) END
"END;
"jumpPtr (tags[';']);
"tags[';']:= ptrEnd
 END NewFile;
 
 (*$l+*)
 PROCEDURE CopyText;         (* einkopieren eines Files oder des Buffers *)
"VAR copyname:STRING; tagDisplace:LONGINT;
 BEGIN
"PutCmd('Copy: B(uffer');
"ReadUpCh;
"IF ch='B' THEN
$BufferToText(true); PushPtr; ScreenOut
"END
 END CopyText;
 
 (*$l-*)
 PROCEDURE FiReDefault;  (* Defaultwerte fr Find/Replace *)
 BEGIN
 ASSEMBLER
(tst.l  rptf
(bne    nodflt
(tst    infinite
(bne    nodflt
(move   #1,verify
(move   #1,infinite
 nodflt  jmp    ClrCmdLine
 END
 END FiReDefault;
 
 (*$l+*)
 PROCEDURE Prompt(ps:STRING; id1:STRING; VAR inp1:STRING);
 BEGIN           (* Prompt fr Find/Replace *)
"ASSEMBLER
$jsr     PutDir
$moveq   #'(',d0
$jsr     ChrOut
$moveq   #'?',d0
$tst     verify
$beq     inf
$jsr     ChrOut
 inf
$tst     infinite
$beq     inf1
$moveq   #'/',d0
$jsr     ChrOut
$bra     inf2
 inf1
$move.l  rptf,(a3)+
$jsr     WriteLCard
 inf2
$moveq   #')',d0
$jsr     ChrOut
$moveq   #' ',d0
$jsr     ChrOut
"END;
"WriteString(ps);
"IF findWord THEN WriteString(' Word') END;
"WriteString(id1);
"WriteString(': ');
"ReadString(inp1)
 END Prompt;
 
 (*$l+*)
 PROCEDURE ConvToST (VAR s:ARRAY OF CHAR);
"VAR i,n:CARDINAL;
"BEGIN
$n:=ORD(s[0]);
$FOR i:=1 TO n DO
&s[i-1]:=s[i]
$END;
$s[n]:=0C
"END ConvToST;
 
 (*$l+*)
 PROCEDURE ConvToGep (VAR s:ARRAY OF CHAR);
"VAR i,n:CARDINAL;
"BEGIN
$n:=Length(s);
$FOR i:=n TO 1 BY -1 DO
&s[i]:=s[i-1]
$END;
$s[0]:=CHR(n)
"END ConvToGep;
 
 (*$l+*)
 PROCEDURE Find;         (* oldString suchen *)
 VAR s: String;
 BEGIN
"FiReDefault;
"IF NOT findSame THEN Prompt('Find','',oldString) END;
"GoToPtr;
"IF NOT abort & (Length(oldString)>0) THEN
$scrPtr:=ptr;
$ConvToGep (oldString);
$LOOP
&IF Search() THEN
(IF verify THEN
*CenterScreen;
*PutCmd('Find: /SPACE/ to proceed, any key to end');
*ReadCh;IF ch#' ' THEN EXIT END
(END;
(ASSEMBLER move.l rptf,d0 tst infinite beq decr addq.l #2,d0
(decr subq.l #1,d0 move.l d0,rptf bne goOn END; EXIT; ASSEMBLER
(!goOn
(END
&ELSE
(CondScreen(CenterScreen);
(Concat(CardToStr(rptf,0),' Find: string not found',s,strok);
(PutCmd(s);
(ErrorWait; EXIT
&END
$END;
$ConvToST (oldString);
$CondScreen(CenterScreen)
"END
 END Find;
 
 (*$l-*)
 PROCEDURE Look;
 BEGIN
 ASSEMBLER
(move.l  ptr,a0
 fndna   cmpi.b  #DLEchar,-2(a0)
(beq     Lookit
(move.b  -1(a0),d0
(beq     Lookit
(jsr     AlphaNum
(bne     Lookit
(subq.l  #1,a0
(bra     fndna
 Lookit  lea     oldString,A1
(moveq   #0,d6
 Looklp  move.b  (a0)+,d0
(move.b  d0,d1
(jsr     AlphaNum        ;d1 bleibt erhalten
(bne     ex
(move.b  d1,0(A1,d6.w)
(clr.b   1(A1,d6.w)
(addq.b  #1,d6
(cmpi    #79,d6
(bcs     Looklp
(subq.b  #1,d6
 ex      tst.b   d6
(beq     noLook
(JSR     PushPtr         ; fr Rcksprung mit J-
(move.l  ptr,a0
(tst     findSame
(bne     fnd
(move    #1,findSame
(move.l  ptrStart,a0
(tst     direction
(beq     fnd
(move.l  ptrEnd,a0
(subq.l  #2,a0
 fnd     move.l  a0,ptr
(jmp     Find
 noLook
 END
 END Look;
 
 (*$l+*)
 PROCEDURE FReplace;      (* oldString suchen und durch newString erstzen *)
"VAR tagDisplace:LONGINT; s: String;
 BEGIN
"FiReDefault;
"IF NOT findSame THEN
$Prompt('Replace',' old',oldString);
$IF NOT abort & (Length(oldString)>0) THEN Home;
&Prompt('Replace',' new',newString)
$END
"END;
"GoToPtr;
"IF NOT abort & (Length(oldString)>0) THEN
$tagDisplace:=LONG (INTEGER(Length(newString)-Length(oldString)));
$scrPtr:=ptr;
$ConvToGep (oldString);
$LOOP
&IF Search() THEN
(IF verify THEN
*CenterScreen;
*PutCmd('Replace: /SPACE/ replaces, /RETURN/ skips, /ESC/ ends');
*REPEAT ReadCh UNTIL (ch=' ') OR (ch=EnterKey) OR abort
(ELSE
*Home;WriteLCard(rptf);
*IF KeyPressed() THEN ChrIn END
(END;
(IF abort THEN EXIT END;
(IF NOT verify OR (ch=' ') THEN
*IF Available(SHORT(tagDisplace)) THEN
,IF direction THEN
.MoveText(delPtr,tagDisplace); FillIn(ptr,newString)
,ELSE
.MoveText(ptr,tagDisplace); FillIn(delPtr,newString);
.ASSEMBLER move.l tagDisplace(A6),d0 add.l d0,ptr END
,END;
,PushPtr;
,ASSEMBLER move.l rptf,d0 tst infinite beq decr addq.l #2,d0
,decr subq.l #1,d0 move.l d0,rptf bne goOn END; EXIT; ASSEMBLER
,!goOn
,END
*ELSE
,CondScreen(CenterScreen);
,PutCmd('Replace: Out of memory');ErrorWait; EXIT
*END
(END
&ELSE
(CondScreen(CenterScreen);
(Concat(CardToStr(rptf,0),' Replace: string not found',s,strok);
(PutCmd(s);
(ErrorWait; EXIT
&END
$END;
$ConvToST (oldString);
$CondScreen(CenterScreen)
"END
 END FReplace;
 
 
 (*$l-*)
 PROCEDURE ScreenTop: ADDRESS;
 BEGIN
 ASSEMBLER
(move.l ptr,a0           ;aktueller Ptr
(move   ptrLine,d1       ;aktuelle Zeile
 pcr     cmp    maxLine,d1       ;bis in letzte Bildschirmzeile vorpirschen
(bhi    zcr
(jsr    NextCR           ;setzt A0 auf nchstes CR+1
(addq   #1,d1
(bra    pcr
 zcr     subq   #1,d1
(beq    korr
(jsr    LastCR           ;wieder zurck, damit Bildschirm immer voll
(bra    zcr
 korr    move.l a0,(a3)+
 END
 END ScreenTop;
 
 PROCEDURE ScreenTop1: ADDRESS;  (* geht nur nach oben, sonst Fehler bei *)
 BEGIN                           (* Mausaktion auf letzter Seite (H)    *)
 ASSEMBLER
(move.l ptr,a0           ;aktueller Ptr
(move   ptrLine,d1       ;aktuelle Zeile
(beq    zero
 subl    subq   #1,d1
(beq    zero
(jsr    LastCR           ;ein CR zurck
(bra    subl
 zero    move.l a0,(a3)+
 END
 END ScreenTop1;
 
 PROCEDURE ScreenTop2: ADDRESS;
"BEGIN
$ASSEMBLER
(jsr    screentop1
(move.l -(a3),a0
(jsr    lineSt
(move.l a0,(a3)+
$END
"END ScreenTop2;
 
 PROCEDURE ScreenBottom: ADDRESS;
 BEGIN
 ASSEMBLER
(move.l ptr,a0
(move   ptrLine,d1
 pcr     cmp    maxLine,d1       ;bis in letzte Bildschirmzeile vorpirschen
(bhi    zcr0
(jsr    NextCR
(addq   #1,d1
(bra    pcr
 zcr0    move.l a0,(a3)+
 END
 END ScreenBottom;
 
 
 (*$l-*)
 PROCEDURE HardCopyFromTo(a,b:ADDRESS; fwd:BOOLEAN);
"PROCEDURE timeOut;
$BEGIN
&PutCmd ('Printer: Timeout');Bell;ErrorWait;
$END timeOut;
"BEGIN
$ASSEMBLER
(MOVEM.L D3/D4/A4/A5,-(A7)
(MOVE    -(A3),D3
(MOVE.L  -(A3),A5
(MOVE.L  -(A3),A4
(MOVEQ   #CRChar,D0
(BRA     print
 
&get
(TST     D3
(BNE     forw
(CMPA.L  A4,A5
(BLS     noget
(MOVE.B  -(A5),D0
(RTS
&forw
(CMPA.L  A5,A4
(BCC     noget
(MOVE.B  (A4)+,D0
(RTS
&noget
(CLR     D0
(RTS
 
&prn
(MOVE.W  D0,-(A7)
(MOVE    #5,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(TST.W   D0
(RTS
 
&again
(JSR     KeyPressed
(TST     -(A3)
(BEQ     nokey
(JSR     GetKeyD0
(CMPI.B  #EscKey,D0
(BEQ     ende
&noKey
(BSR     get
(BEQ     ende
(CMPI.B  #CRChar,D0
(BNE     nocr
(BSR     prn
(BEQ     timeout0
(MOVEQ   #LFChar,D0
(BRA     print
&nocr
(CMPI.B  #DLEChar,D0
(BNE     print
(BSR     get
(BEQ     ende
(SUBI.B  #' ',D0
(BCS     again
(CLR     D4
(MOVE.B  D0,D4
(BRA     pdle
&ldle
(MOVEQ   #' ',D0
(BSR     prn
(BEQ     timeout0
&pdle
(DBRA    D4,ldle
(BRA     again
&print
(BSR     prn
(BNE     again
&timeout0
(BSR     timeOut
(BRA     ret
&ende
(MOVEQ   #CRChar,D0
(BSR     prn
(BEQ     ret
(MOVEQ   #LFChar,D0
(BSR     prn
&ret
(MOVEM.L (A7)+,D3/D4/A4/A5
$END
"END HardCopyFromTo;
 
 (*$l+*)
 PROCEDURE HardCopy;
 BEGIN
"PutCmd('HardCopy: S(creen, B(uffer, A(ll');
"ReadUpCh;
"IF ch='S' THEN HardCopyFromTo(ScreenTop2(),ScreenBottom(),true)
"ELSIF ch='B' THEN HardCopyFromTo(bufferL,bufferH,false)
"ELSIF ch='A' THEN HardCopyFromTo(ptrStart,ptrEnd,true)
"END
 END HardCopy;
 
 PROCEDURE wrNotSaved;
"BEGIN
$WriteString('Last changes have not been saved yet!')
"END wrNotSaved;
 
 (*$l+*)
 PROCEDURE Environment;
"PROCEDURE OnOff(x:BOOLEAN);
"(*$l-*)
"BEGIN
$ASSEMBLER tst -(a3) bne on moveq #'f',d0 jsr ChrOut bra on1
$on moveq #'n',d0 on1 jsr ChrOut jmp WriteLn
$END
"END OnOff;
"(*$l+*)
"VAR sTime:STRING; tabString:String; i:CARDINAL; tg: CHAR;
 BEGIN
"LOOP
$Write(ClrScrnChar);
$writeTitle;
$IF NOT saved THEN
&wrNotSaved;
$ELSE
&WriteString ("Editor's internal version: ");
&WriteString (intVersion);
$END;
$WriteLn;
$WriteLn;
$WriteString('Filename: ');WriteString(fileName); WriteLn;
$WriteString(' last update: '); DateToText (UnpackDate (fileD), '', sTime); WriteString(sTime);
$WriteString(' / '); TimeToText (UnpackTime (fileT), '', sTime); WriteString(sTime); WriteLn;
$IF restoreFileDT THEN
&WriteString (' last code: '); WriteString (CodeName); WriteString (', '); WriteString (CardToStr (Codesize,0)); WriteString (' bytes'); WriteLn;
$END;
$WriteLn;
$WriteString('O(ld: ');WriteString(oldString);WriteLn;
$WriteString('N(ew: ');WriteString(newString);WriteLn;
$WriteString('F(lip Old and New');WriteLn;
$WriteLn;
$WriteString('A(uto backup is o'); OnOff(autoBack);
$WriteString('C(ase sensitivity is o'); OnOff(findCase);
$WriteString('I(ncrement version is o'); OnOff(autoIncVer);
$WriteString('Q(uick save & load is o'); OnOff(leaveDLEonWrite);
$WriteString('S(ave <Editor-Info-Line> is o'); OnOff(saveInfo);
$WriteLn;
$WriteString('Tags: ');
$FOR tg:='0' TO 'Z' DO
&IF (ptrStart<tags[tg]) & (tags[tg]<ptrEnd) THEN
(Write(tg)
&ELSE
(Write(' ')
&END
$END;
$WriteLn;
$WriteLn;
$WriteString('T(ab setting'); WriteLn;
$tabString:=TabsToStr(); WriteString(tabString); WriteLn;
$WriteLn;
$WriteString('Enter option: '); ReadUpCh; WriteLn;
$IF    ch='A' THEN Negate(autoBack)
$ELSIF ch='C' THEN Negate(findCase)
$ELSIF ch='F' THEN Flip(oldString,newString)
$ELSIF ch='I' THEN Negate(autoIncVer)
$ELSIF ch='Q' THEN Negate(leaveDLEonWrite)
$ELSIF ch='S' THEN Negate(saveInfo)
$ELSIF ch='N' THEN WriteString('New: ');ReadString(newString)
$ELSIF ch='O' THEN WriteString('Old: ');ReadString(oldString)
$ELSIF ch='T' THEN ReadString(tabString);GetTabs(tabString);
$ELSIF ch='X' THEN
&makeDLE:=FALSE; CleanText; makeDLE:=TRUE; CleanText;
&ChkLastPtr; ptr:= ptrStart; CenterScreen
$ELSE EXIT
$END
"END;
"ScreenOut;
"cmdFlag:=false
 END Environment;
 
 
 FORWARD CloseTextFrame;
 
 (*$l+*)
 PROCEDURE QuitEditor;           (* Q(uit- Untermen *)
"VAR fn:STRING; show,sWarn:BOOLEAN; p:CARDINAL;
 BEGIN
"ClrKBDbuffer;
"fn:= '';
"cmdFlag:=false;
"show:=true; sWarn:=false;
"Write(ClrScrnChar);
"LOOP
$IF show THEN
&GotoXY(0,0);
&IF saveinfo THEN WriteString('Editor Info-Line will be saved') END;
&ClrLn;
&IF leaveDLEonWrite THEN WriteString('Quick save is active') END;
&ClrLn;
&ClrLn;
&IF NOT saved AND Worthy() THEN
(wrNotSaved
&END;
&ClrLn;
&ClrLn;
&WriteString ('Filename: '); WriteString (fileName); ClrLn;
&ClrLn;
&WriteString('E(xit'); ClrLn;
&WriteString('I(ncrement'); ClrLn;
&WriteString  ('U(pdate  (Save & Exit)'); ClrLn;
&IF filesInMem=0 THEN
(WriteString('C(ompile (Update & Compile)'); ClrLn;
(WriteString('X(exute  (Execute)'); ClrLn;
(WriteString('M(ake    (Update & Make)'); ClrLn;
(WriteString('R(un     (Make & Execute)'); ClrLn;
&END;
&WriteString('S(ave'); ClrLn;
&WriteString('B(ack up and save'); ClrLn;
&WriteString('K(eep time stamp and save'); ClrLn;
&WriteString('W(rite to a file...'); ClrLn;
&WriteString('N(ew filename...'); ClrLn;
&WriteString('O(ther filename, no save...'); ClrLn;
&WriteString('ESC to return'); ClrLn;
&show:=false
$END;
$GoToXY(0,21);
$ReadUpCh; IF ch> ' ' THEN Write(ch) END;
$Write(ClrEOSchar);
$IF (ch=ESCkey) OR (ch=EnterKey) THEN EXIT
$ELSIF ch='I' THEN WriteString (IncrementVersion())
$ELSIF ch='E' THEN
&saved:=saved OR NOT Worthy();
&IF NOT saved THEN WriteLn;
(WriteString('Throw away changes since last update? ');
(saved:=Yes()
&END;
&IF saved THEN
(IF filesInMem=0 THEN endOfEd:=true ELSE CloseTextFrame END;
(EXIT
&END
$ELSIF ch='W' THEN WriteLn;
&(* WriteString('Write file: '); ReadString(fn); *)
&fn:=getFilefromBox('Write file:');
&show:=true;
&IF NOT abort & ChkName(fn) & SaveText(fn,false,true,false) THEN END
$ELSIF ch='O' THEN WriteLn;
&(* WriteString('Other filename: '); ReadString(fn); *)
&fn:=getFilefromBox('Other filename:');
&show:=true;
&IF NOT abort & ChkName(fn) THEN
(Flip(fn,fileName); sWarn:=true
&END
$ELSIF ch='N' THEN WriteLn;
&(* WriteString('New filename: '); ReadString(fn); *)
&fn:=getFilefromBox('New filename:');
&show:=true;
&IF NOT abort & ChkName(fn) & SaveText(fn,false,true,false) THEN
(Assign (fn,TextName,strok);
(Flip(fn,fileName);
&END
$ELSIF Length(fileName)>0 THEN
&IF (ch='S') OR (ch='K') THEN
(IF SaveText(fileName,false,sWarn,ch='K') THEN
*Assign (filename,TextName,strok);
(END
&ELSIF (ch='U')
&OR (
((filesInMem=0) & ( (ch='C') OR (ch='X') OR (ch='M') OR (ch='R') )
&) THEN
(IF SaveText(fileName,false,sWarn,false) THEN
*Assign (filename,TextName,strok);
*IF filesInMem=0 THEN
,endOfEd:=true;
,IF ch='C' THEN
.exitCode:= 1
,ELSIF ch='X' THEN
.exitCode:= 2
,ELSIF ch='M' THEN
.exitCode:= 3
,ELSIF ch='R' THEN
.exitCode:= 4
,END
*ELSE
,CloseTextFrame
*END;
*EXIT
(END
&ELSIF ch='B' THEN
(IF SaveText(fileName,true,false,false) THEN
*Assign (filename,TextName,strok);
(END
&END
$END
"END;
"IF NOT endOfEd THEN
$IF ~makeDLE THEN
&makeDLE:= True;
&WriteLn;
&WriteString ('please wait...');
&Cleantext;
$END;
$ScreenOut
"END
 END QuitEditor;
 
 (*$l+*)
 PROCEDURE OpenTextFrame;
 BEGIN
"IF (bufferL-ptrEnd<1500L) THEN
$PutCmd('Not enough memory for text-frame'); Bell; ErrorWait
"ELSE
$ASSEMBLER
,jsr     finish
,move.l  ptrEnd,d0
,addq.l  #3,d0
,bclr    #0,d0
,move.l  d0,a0
,move.l  total,(a0)+
,move    direction,(a0)+
,move    saved,(a0)+
,move    saveinfo,(a0)+
,move    makeDLE,(a0)+
,move    leaveDLEonWrite,(a0)+
,move    findCase,(a0)+
,move    autoBack,(a0)+
,move    autoIncVer,(a0)+
,move.l  errorpos,(a0)+
,lea     ptrStack,A1
,moveq   #58,d0
$allptr  move.l  (A1)+,(a0)+
,dbf     d0,allptr
,lea     filename,A1
,moveq   #40,d0
$allfn   move    (A1)+,(a0)+
,dbf     d0,allfn
,lea     tabs,A1
,moveq   #40,d0
$alltab  move    (A1)+,(a0)+
,dbf     d0,alltab
,move    nrOfTabs,(a0)+
,move    ptrLine,(a0)+
,move    ptrCount,(a0)+
,move    fileD,(a0)+
,move    fileT,(a0)+
,move    restoreFileDT,(a0)+
,move.l  ptr,(a0)+
,move.l  lastPtr,(a0)+
,move.l  ptrStart,(a0)+
,move.l  ptrEnd,(a0)+
,clr     (a0)+
,
,addq    #1,filesInMem
,move.l  a0,ptrStart
,move.b  #DLEchar,(a0)+
,move.b  #DLEoffset,(a0)+
,move.l  a0,ptr
,move.l  a0,lastPtr
,clr     (a0)+
,move.l  a0,ptrEnd
,clr.l   (a0)+
,moveq #58,d0 lea ptrStack,a0 lp clr.l (a0)+ dbf d0,lp
,jsr      ResetTextOptions
,clr.b fileName
,clr delFlag clr insFlag clr.l total
,jsr Prepare
,move.l d0,startupTime clr.l errorpos
,move #1,ptrLine jsr ScreenOut
$END
"END
 END OpenTextFrame;
 
 (*$l+*)
 PROCEDURE CloseTextFrame;
 BEGIN
"saved:=saved OR NOT Worthy();
"IF filesInMem=0 THEN
$PutCmd('No old text frame to close'); Errorwait; RETURN
"ELSIF NOT saved THEN
$ClrCmdLine;
$WriteString('Close text frame: Throw away changes ? ');
$IF NOT Yes() THEN GoToPtr; RETURN END
"END;
"ASSEMBLER
*move.l  ptrStart,a0
*subq.l  #2,a0
*move.l  -(a0),ptrEnd
*move.l  -(a0),ptrStart
*move.l  -(a0),lastPtr
*move.l  -(a0),ptr
*move    -(a0),restoreFileDT
*move    -(a0),fileT
*move    -(a0),fileD
*move    -(a0),ptrCount
*move    -(a0),ptrLine
*move    -(a0),nrOfTabs
*moveq   #40,d0
*lea     tabs,A1
*lea     82(A1),A1
"alltab  move    -(a0),-(A1)
*dbf     d0,alltab
*moveq   #40,d0
*lea     filename,A1
*lea     82(A1),A1
"allfn   move    -(a0),-(A1)
*dbf     d0,allfn
*moveq   #58,d0
*lea     ptrStack,A1
*lea     236(A1),A1
"allptr  move.l  -(a0),-(A1)
*dbf     d0,allptr
*move.l  -(a0),errorpos
*move    -(a0),autoIncVer
*move    -(a0),autoBack
*move    -(a0),findCase
*move    -(a0),leaveDLEonWrite
*move    -(a0),makeDLE
*move    -(a0),saveinfo
*move    -(a0),saved
*move    -(a0),direction
*move.l  -(a0),total
*jsr     Prepare
*move.l  d0,startupTime
*subq    #1,filesInMem
"END
 END CloseTextFrame;
 
 
 (*$? mayCallCompiler:
 
 TYPE
(Header = RECORD
3LayoutNr : BYTE;
3Id : BYTE;
3QualificationFlag : CARDINAL;
3Key : LONGCARD;
3OffsExTree : ADDRESS;
3DefinedItems : CARDINAL;
3OffsImpList : ADDRESS;
3VarSize : LONGCARD;
3ModName : ADDRESS
1END;
 
(
(TreeEntry = RECORD
6OffsNextItemNr: CARDINAL;
6Name: CHAR
4END;
 
 (*$L-*)
 PROCEDURE CompName (ad: ADDRESS): MaxStr;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  A3,A2
(LEA     256(A3),A3
"CopyHelpStr
(MOVE.B  (A0)+,D0
(BEQ     EndCopy
(CMPI.B  #$FE,D0
(BCC     EndCopy
(MOVE.B  D0,(A2)+
(BRA     CopyHelpStr
"EndCopy
(CLR.B   (A2)+
$END
"END CompName;
 
 VAR defFile: File; size: LONGCARD;
$returnVal: BOOLEAN;
 
 (*$L+*)
 PROCEDURE Process;
 
"VAR str: POINTER TO ARRAY [0..7] OF CHAR;
&first, continue, success: BOOLEAN;
&Data: POINTER TO Header;
&helpString: String;
&BytesRead: LONGCARD;
&modName: ADDRESS;
 
 BEGIN
"(* Process File *)
"Home;
"IF (bufferL - ptrEnd < size + 1500L) THEN
$WriteString ('Insufficient memory!');
$ReadCh;
$returnVal:= FALSE;
$RETURN
"END;
"Data:= ptrEnd + 4L; (* leave some bytes unused for security resons *)
"ReadBytes (defFile, Data, size, BytesRead);
"IF BytesRead # size THEN
$(* if not all bytes read exit *)
$WriteString ('Read error!');
$ReadCh;
$returnVal:= TRUE;
$RETURN
"END;
"str:= ADDRESS (Data);
"INC (Data,8);
"IF (Compare (str^, "MM2Code") # equal) OR (Data^.ID # BYTE (3)) THEN
$(* not a DEF file *)
$returnVal:= TRUE;
$RETURN
"END;
"(* display modname *)
"modName:= ADDRESS(Data)+Data^.ModName;
"WriteString (CompName (modName));
"continue:= TRUE;      (* default: scan next file *)
"first:= TRUE;         (* first check the modname itself *)
"(* scan list of exported items *)
"ASSEMBLER
(; Cursorpos. merken
(move   ptrY,d0
(move.b ptrX,d0
(move   d0,yx
(MOVE.L  modName(A6),A1
(BRA.W   searchStart
(
"CaseSen
(; put next character of item-name in D0 and next of oldString in D1,
(; increment index.
(MOVE.B  0(A1,D2.W),D0
(MOVE.B  0(A2,D2.W),D1
(ADDQ.W  #1,D2
(RTS
"NoCaseSen
(; same as CaseSen, but characters are converted to capitals.
(CLR     D0
(MOVE.B  0(A2,D2.W),D0
(MOVE.B  0(A4,D0.W),D0
(MOVE.W  D0,D1
(MOVE.B  0(A1,D2.W),D0
(MOVE.B  0(A4,D0.W),D0
(ADDQ.W  #1,D2
(RTS
"
"ItemFound
(BSR.W   showItem
(BNE     CmpFailed
"endOfTree
(RTS
(
"CompNext
(MOVE.W  (A0)+,D0                        ; modul-lokale Item-Nr
(BEQ.L   endOfTree
(LEA     2(A0),A1
"CompFirst
(MOVEQ   #0,D2                           ; D2 := index in strings
"CmpNext
(JSR     (A5)                            ; get next characters in D0/D1
(TST.B   D0
(BEQ.W   ItemEnd
(CMP.B   #$FE,D0                         ; check end of item-name
(BCC.W   ItemEnd                         ; end of name
(CMP.B   D0,D1
(BEQ     CmpNext                         ; equal -> continue with next
(TST.B   D1
(BNE     CmpFailed
(TST.W   findWord
(BNE     CmpFailed
(BRA.W   ItemFound
"ItemEnd
(; End of name of item is reached. if also end of oldString ->
(; item is correct.
(TST.B   D1
(BEQ.W   ItemFound
"CmpFailed
(; skip to next item and continue search
(TST.W   first(A6)
(BEQ     notFirst
(CLR.W   first(A6)
(MOVE.L  Data(A6),A0                     ; A0 := pointer to header
(MOVE.L  Header.OffsExTree(A0),D0        ; D0 := offset to list of items
(BEQ.L   endOfTree                       ; no exported items
(ADDA.L  D0,A0                           ; A0 := pointer to list of items
(BRA     CompNext
"notFirst
(ADDQ.B  #1,D0
(BEQ     endOfName
(ADDA.W  D2,A1
"luup2 MOVE.B  (A1)+,D0
(BPL     luup2
(ADDQ.B  #1,D0
(BNE     luup2
"endOfName
(CMPI.B  #13,1(A1)
(BNE     noRecord
(
(; lokalen Record-Baum durchsuchen
(MOVE.L  A0,-(A7)
(LEA     8(A1),A0
(BSR     CompNext
(MOVE.L  (A7)+,A0
(TST     continue(A6)
(BEQ     endOfTree
(
"noRecord
(MOVE.W  TreeEntry.OffsNextItemNr(A0),D0 ; offset to next item
(BEQ.L   endOfTree
(ADDA.W  D0,A0
(BRA     CompNext
(
"writeName
(LEA     helpString(A6),A2
(CLR     D1
"CopyHelpStr
(MOVE.B  (A1)+,D0
(BEQ     EndCopy
(CMPI.B  #$FE,D0
(BCC     EndCopy
(ADDQ    #1,D1
(MOVE.B  D0,(A2)+
(BRA     CopyHelpStr
"EndCopy
(CLR.B   (A2)+
(MOVE.B  #'.',D0
(JSR     ChrOut                          ; write '.'
(LEA     helpString(A6),A2
(MOVE.L  A2,(A3)+
(MOVE.W  D1,(A3)+
(JMP     BufferWrite                     ; write helpString
"
"wrn   ; Namen auf Stack rckwrts ausgeben
(MOVE.L  4(A0),D0
(BEQ     wrn3
(MOVE.L  A1,-(A7)
(MOVE.L  D0,A1
(ADDQ.L  #2,A1
(ADDQ.L  #8,A0
(BSR     wrn
(MOVE.L  (A7)+,A1
"wrn3  BRA     writeName
 
 
"showItem
(; search successful
(MOVEM.L A0/A2/A5,-(A7)
(TST.W   first(A6)
(BNE     NoNam
(LEA     16(A7),A0
(BSR     wrn
"NoNam JSR     Bell
(MOVE.B  #' ',D0
(JSR     ChrOut                          ; write ' '
(MOVE.B  #'?',D0
(JSR     ChrOut                          ; write '?'
(JSR     ReadCh                          ; get input
(TST     abort
(BNE     FindEnd                         ; ESC -> abort
(TST     accept
(BNE     FindEnd                         ; F1 -> load
(MOVE.B  ch,D0
(CMPI.B  #EnterKey,D0
(BEQ     FindEnd
(JSR     ShiftUp                         ; convert to capitals
(CMPI.B  #'Y',D0
(BNE     ContSearch
"FindEnd
(; User wants to load this def.-module
(CLR     continue(A6)
"ContSearch
(MOVE    yx,d1
(JSR     GotoXYd1
(MOVEQ   #ClrEOLNchar,d0
(JSR     ChrOut
(MOVEM.L (A7)+,A0/A2/A5
(TST     continue(A6)
(RTS
 
"searchStart
(MOVE.L  A4,-(A7)
(MOVE.L  A5,-(A7)                        ; save A5
(LEA     ShiftTab,A4
(LEA     NoCaseSen(PC),A5
(TST.W   findCase
(BEQ     StartSearch2                    ; not case sensitive
(LEA     CaseSen(PC),A5
"StartSearch2
(LEA     oldString,A2                    ; A2 := pointer to oldString
(CLR.L   -(A7)
(BSR     CompFirst
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A5                        ; restore A5
(MOVE.L  (A7)+,A4
"END;
"IF ~continue & ~abort THEN
$modNameFound:= first;
$oldString:= helpString;
$defFound:= TRUE
"END;
"returnVal:= continue
 END Process;
 
 PROCEDURE ProcessDefFile (defFile0: File; size0: LONGCARD): BOOLEAN;
"VAR exc:Exception;
"BEGIN
$defFile:= defFile0;
$size:= size0;
$Call (Process, exc);
$RETURN returnVal
"END ProcessDefFile;
 
 (*$L+*)
 PROCEDURE ProcessDefFile1 (REF path : ARRAY OF CHAR; entry : DirEntry): BOOLEAN;
"VAR name: ARRAY [0..139] OF CHAR;
&f: File;
&cont: BOOLEAN;
"BEGIN
$Assign (path, name, success);
$Append (entry.name, name, success);
$Open (f, name, readOnly);
$cont:= ProcessDefFile (f, entry.size);
$IF defFound THEN Assign (entry.name, filename, success) END;
$Close (f);
$RETURN cont
"END ProcessDefFile1;
 
 (*$L+*)
 PROCEDURE ProcessDefFile2 (entry : LibEntry) : BOOLEAN;
"VAR cont: BOOLEAN;
"BEGIN
$Seek (DefLibFile.f, entry.start, fromBegin);
$cont:= ProcessDefFile (DefLibFile.f, entry.size);
$IF defFound THEN Assign (entry.name, filename, success) END;
$RETURN cont
"END ProcessDefFile2;
 
 (*$L+*)
 PROCEDURE FindDefinition;
 
 VAR
(Entry : PathEntry;
(wild : ARRAY [1..141] OF CHAR;
(b2, success : BOOLEAN;
(result : INTEGER;
 
 BEGIN
"IF (bufferL-ptrEnd<1500L) THEN
$PutCmd('Not enough memory for this function'); Bell; ErrorWait; RETURN
"END;
"(* determine identifier to be searched *)
"ASSEMBLER
(; code is copied from procedure look and modified
(move.l  ptr,a0
 fndna   cmpi.b  #DLEchar,-2(a0)         ; is it start of line ?
(beq     Lookit                  ; yes -> start of word found
(move.b  -1(a0),d0               ; get previous character
(beq     Lookit                  ; if it's zero -> start of word found
(jsr     AlphaNum
(bne     Lookit                  ; if it's no alphanum. -> start found
(subq.l  #1,a0                   ; search backwards
(bra     fndna
 Lookit
(; now copy whole word into oldString
(lea     oldString,A1            ; A1 := pointer to oldString
(moveq   #0,d6                   ; length of copied word
 Looklp  move.b  (a0)+,d0                ; get one char
(move.b  d0,d1                   ; save char
(jsr     AlphaNum        ;d1 bleibt erhalten
(bne     ex                      ; if it's not alphanum. -> word copied
(move.b  d1,0(A1,d6.w)           ; put char
(clr.b   1(A1,d6.w)              ; clear next byte
(addq.b  #1,d6                   ; inc. length
(cmpi    #79,d6
(bcs     Looklp                  ; repeat until 80 characters copied
(subq.b  #1,d6                   ; dec. length
 ex      tst.b   d6
(beq.l   noLook                  ; if length = 0 -> no search
"END;
"success:= findCase;
"b2:= findWord;
"OpenTextFrame;
"findCase:= success;
"findWord:= b2;
"(* all memory between ptrEnd and bufferL can now be used *)
"defFound:= FALSE;
"
"(* Query Def-Libfile *)
"Assign (DefLibName, wild, success);
"ReplaceHome (wild);
"OpenLib (DefLibFile, wild, result);
"IF result >= 0 THEN
$LibQuery (DefLibFile, ProcessDefFile2, result);
$CloseLib (DefLibFile)
"END;
"
"(* Query normal .DEF files *)
"IF NOT defFound THEN
$ResetList (DefPaths);
$LOOP
&Entry:= NextEntry (DefPaths);
&IF (Entry = NIL) OR defFound OR abort THEN EXIT END;
&(* Process Entry *)
&Concat (Entry^, '*.', wild, success);
&Append (DefSfx, wild, success);
&ReplaceHome (wild);
&DirQuery (wild, FileAttrSet{}, ProcessDefFile1, result);
$END;
"END;
 
"IF defFound THEN
$ASSEMBLER
(; change extension from .def to .d
(LEA     filename,A0                     ; A0 := pointer to filename
"TestOneChar
(MOVE.B  (A0)+,D0                        ; get one char from name
(CMPI.B  #'.',D0
(BNE     TestOneChar                     ; repeat until '.' found
(CLR.B   1(A0)                           ; terminate string after 'D'
$END;
$Write(ClrScrnchar);
$SearchFile (filename,SrcPaths,fromStart,success,filename);  (* Search
csource *)
$success:= findCase;
$Open (f,filename,readOnly);
$IOResult:=State(f);
$IF SuccessFull(13) THEN
&WriteString('Reading ');WriteString(filename);WriteLn;
&flen:= FileSize(f);
&ReadText
$END;
$findCase:= success;
$IF IOResult#0 THEN
&CloseTextFrame;
&cmdFlag:= FALSE;
&ScreenOut
$ELSE
&(* file is read. Now set Cursor *)
&ScreenOut;
&IF NOT modNameFound THEN
(findWord:= TRUE;
(findSame:= TRUE;
(findCase:= TRUE;
(Find
&END
$END
"ELSE
$(* Kein File gefunden *)
$CloseTextFrame;
$ScreenOut;
$cmdFlag:=false;
"END;
"ASSEMBLER
 noLook
"END;
 END FindDefinition;
 *)
 
 (*$L+*)
 (*$? mayCallCompiler:
 PROCEDURE callCompiler;
"VAR ok: BOOLEAN; ex: INTEGER; msg: ARRAY [0..125] OF CHAR;
&res: LoaderResults; l, l2: LONGINT;
&ad: ADDRESS; tim, dat: CARDINAL; p: POINTER TO CHAR;
&oldSize: LONGCARD; str: Strings.String;
"BEGIN
$(*
%* Puffer bis auf 1000 Byte freien Rest verkleinern
%*)
$l:= LONGINT (bufferH-ptrEnd-1000L); (* Lnge des freien Puffers *)
$IF l>0L THEN
&IF NOT FullStorBaseAccess () THEN
((* wenn kein Vergrern des Speichers am Ende mglich,
)* dann geben wir hier nur 2/3 des noch freien Speichers frei. *)
(l2:= AllAvail();
(IF l2 >= 2 * l THEN
*l:= 0
(ELSIF l2 >= l THEN
*l:= l DIV 3;
(ELSE
*l:= l - l DIV 3;
(END
&END;
&IF l > 0 THEN
(IF ODD (l) THEN DEC (l) END;
(DEALLOCATE (bufferStart, l);
(bufferH:= bufferStart + MemSize (bufferStart);
(ASSEMBLER
*MOVE.L  bufferH,D0
*BCLR    #0,D0
*MOVE.L  D0,A0
*CLR.L   -(A0)
*CLR.L   -(A0)
*MOVE.L  A0,bufferH
*MOVE.L  A0,bufferL
(END;
&END;
$END;
$
$ScanMode:= FALSE;
$IF autoIncVer & NOT saved THEN
&str:= IncrementVersion ()
$ELSE
&str:= ''
$END;
$PutCmd (conc ("Compiling...   ", str));
$p:= ptrEnd;
$p^:= 3C;
$
$Concat (fileName, ' /Q /@', msg, ok);
$Append (LHexToStr (ptrStart,0), msg, ok);
$IF MainOutputPath[0] # 0C THEN
&Append (' /O', msg, ok);
&Append (MainOutputPath, msg, ok);
$END;
$IF CompilerArgs[0] # 0C THEN
&Append (' ', msg, ok);
&Append (CompilerArgs, msg, ok);
$END;
$tim:= DirTime (); dat:= Today ();
$oldSize:= DefaultStackSize;
$DefaultStackSize:= 16000;
$CallModule (CompilerParm.name, StdPaths, msg, NIL, ex, str, res);
$DefaultStackSize:= oldSize;
$p^:= 0C;
$IF Inconsistent () THEN
&Bell; PutCmd ("Memory management is damaged! Save text with backup and reboot!"); ErrorWait
$END;
$IF res # noError THEN
&Bell; PutCmd (conc ("Compiler couldn't be executed: ", str)); ErrorWait
$ELSE
&CASE ex OF
(0:   restoreFileDT:= TRUE; fileD:= dat; fileT:= tim;
-ScreenOut|
(2,3: Assign (ErrorMsg, ErrMsg, ok);
-GotoLine (TextLine, TextCol-1);
-tags['?']:= ptr;
-ErrorPos:= ptr-ptrStart;
-Bell; PutCmd(ErrMsg); ErrorWait |
(4:   ScreenOut; Bell; PutCmd('Include files are not allowed here!'); ErrorWait |
&ELSE
-ScreenOut; Bell; GetStateMsg (ex, str); PutCmd(str); ErrorWait
&END
$END;
$ad:= bufferStart;
$IF (l>0L) & FullStorBaseAccess () THEN
&Enlarge (bufferStart, l, ok);
&IF ~ok THEN
(bufferStart:= ad (* wird anscheinend vom Storage zerstrt?! *);
(Bell;
(PutCmd ("Editor's buffer is nearly full. You'd better save the text and quit/reboot!");
(ErrorWait
&ELSE
(bufferH:= bufferStart + MemSize (bufferStart);
(ASSEMBLER
*MOVE.L  bufferH,D0
*LSR     #1,D0
*LSL     #1,D0
*MOVE.L  D0,A0
*CLR.L   -(A0)
*CLR.L   -(A0)
*MOVE.L  A0,bufferH
*MOVE.L  A0,bufferL
(END
&END
$END;
"END callCompiler;
 *)
 
 (*$L-*)
 PROCEDURE Supexec ( p : PROC );
 BEGIN
 ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #38,-(A7)
(TRAP    #14
(ADDQ.L  #6,A7
 END
 END Supexec;
 
 (*$L-*)
 PROCEDURE Setrez (r: CARDINAL);
 BEGIN
 ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVEQ   #-1,D0
(MOVE.L  D0,-(A7)
(MOVE.L  D0,-(A7)
(MOVE    #5,-(A7)
(TRAP    #14
(ADDA.W  #12,A7
 END
 END Setrez;
 
 (*$L-*)
 PROCEDURE Getrez (): CARDINAL;
 BEGIN
 ASSEMBLER
(MOVE    #4,-(A7)
(TRAP    #14
(ADDQ.L  #2,A7
(MOVE.W  D0,(A3)+
 END
 END Getrez;
 
 (*$L-*)
 PROCEDURE SetColor (n,c: CARDINAL): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #7,-(A7)
(TRAP    #14
(ADDQ.L  #6,A7
(MOVE.W  D0,(A3)+
$END;
"END SetColor;
"
 (*$L-*)
 PROCEDURE Wvbl;
 BEGIN
 ASSEMBLER
(LEA     $FF8200,A1
(MOVEP.W 1(A1),D0
(NOP
(NOP
 W1      MOVEP.W 5(A1),D1
(CMP.W   D0,D1
(BEQ     W1
 W2      MOVEP.W 5(A1),D1
(CMP.W   D0,D1
(BNE     W2
 END
 END Wvbl;
 
 (*$L-*)
 PROCEDURE initFont8_8;
"BEGIN
$ASSEMBLER
(MOVE.L  pFont8_8,A0
(; Daten in Font-Puffer kopieren, dabei umverteilen
(LEA     fontbuffer,A1
(MOVE.W  #255,D0
 l:      MOVEQ   #7,D1
(CLR     D2
 m:      MOVE.B  0(A0,D2.W),(A1)+
(ADDI.W  #$100,D2
(DBRA    D1,m
(ADDQ.L  #1,A0
(DBRA    D0,l
$END;
"END initFont8_8;
 
 (*$L-*)
 PROCEDURE initFont8_16;
"BEGIN
$ASSEMBLER
(MOVE.L  pFont8_16,A0
(LEA     fontbuffer,A1
(MOVE.W  #255,D0
 n:      MOVEQ   #15,D1
(CLR     D2
 o:      MOVE.B  0(A0,D2.W),(A1)+
(ADDI.W  #$100,D2
(DBRA    D1,o
(ADDQ.L  #1,A0
(DBRA    D0,n
$END;
"END initFont8_16;
 
 (*$L-*)
 PROCEDURE GetpScreen;
 BEGIN
"ASSEMBLER
(; zuerst dafr sorgen, da wir die shift-bits bei bconin bekommen.
(MOVE.B  $484,oldconterm
(BSET    #3,$484
(MOVE.L  $44E,pScreen
 
((*
(MOVE    SR,-(A7)
(MOVE    #$2700,SR
(JSR     Wvbl
(CLR     D1
(LEA     $FF8260,A2
(TST     isTT            ; bei TT immer auf 640*400
(BEQ     noTT
(ADDQ.L  #2,A2
 noTT    MOVE.L  A2,ColorReg
(MOVE.B  (A2),D0
(ANDI    #7,D0
(MOVE.B  D0,oldShiftMode
(TST     isTT            ; bei TT immer auf 640*400
(BNE     doTT
(BTST    #1,D0
(SEQ     D1
(MOVE.W  D1,color
(BEQ     mono
(BTST    #0,D0
(SNE     D1
(MOVE.W  D1,UseGEM     ; falls Auflsung gewechselt, kein GEM verw.
(BSET    #0,$FF8260
(JSR     initFont8_8
(BRA     ende
 doTT    CMPI.B  #2,oldShiftMode
(BEQ     mono
(CLR     UseGEM     ; falls Auflsung gewechselt, kein GEM verw.
(MOVE.B  (A2),D0
(ANDI    #$F8,D0
(OR.B    #2,D0
(MOVE.B  D0,(A2)
(BRA     mono2
 mono:   MOVE    #1,UseGEM
(; Daten in Font-Puffer kopieren, dabei umverteilen
 mono2   JSR     initFont8_16
 ende    MOVE    (A7)+,SR
(*)
"END
 END GetpScreen;
 
 (*$L-*)
 PROCEDURE ResetpScreen;
 BEGIN
 ASSEMBLER
((*
(; auf VBL warten
(MOVE    SR,-(A7)
(MOVE    #$2700,SR
(JSR     Wvbl
(MOVE.L  ColorReg,A2
(MOVE.B  (A2),D0
(ANDI    #$F8,D0
(OR.B    oldShiftMode,D0
(MOVE.B  D0,(A2)
(MOVE    (A7)+,SR
(*)
(MOVE.B  oldconterm,$484
 END
 END ResetpScreen;
 
 (*$L+*)
 
 PROCEDURE OscanIs () : BOOLEAN;
"VAR oScan : CARDINAL;
 BEGIN
"ASSEMBLER
$MOVE.W      #4200,-(SP)
$TRAP        #14
$ADDQ.L      #2,SP
$MOVE.W      D0,oScan(A6)
"END;
"RETURN oScan # 4200
 END OscanIs;
 
 PROCEDURE OscanSwitch (mode : INTEGER) : INTEGER;
"VAR oScanMode : INTEGER;
 BEGIN
"ASSEMBLER
$MOVE.W      mode(A6),-(SP)
$MOVE.W      #4206,-(SP)
$TRAP        #14
$ADDQ.L      #4,SP
$MOVE.W      D0,oScanMode(A6)
"END;
"RETURN oScanMode
 END OscanSwitch;
 
 (*$L-*)
 PROCEDURE EsetShift (shftMode: WORD): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE    #80,-(A7)
(TRAP    #14
(ADDQ.L  #4,A7
(MOVE.W  D0,(A3)+
$END
"END EsetShift;
 
 (*$L-*)
 PROCEDURE EgetShift (): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE    #81,-(A7)
(TRAP    #14
(ADDQ.L  #2,A7
(MOVE.W  D0,(A3)+
$END
"END EgetShift;
 
 
 TABLE.B ColdStart: 1;
 
 VAR oldOscan : INTEGER;
 
 
 (*$L+,A+*)
 PROCEDURE InitScreen;
"VAR i,newShiftMode: CARDINAL;
"BEGIN
$isTT:= Machine() >= 2;
$IF Oscanis() THEN oldOscan:= Oscanswitch (0); END;
$UseGem:= TRUE;
$color:= FALSE;
$rez_changed:= FALSE;
$IF ~isTT THEN
&oldShiftMode:= Getrez ();
&IF oldShiftMode # 2 THEN
(rez_changed:= TRUE;
(Setrez (1);
(oldColor[0]:= SetColor (0, $777);
(FOR i:= 1 TO 3 DO oldColor[i]:= SetColor (i, 0) END;
(color:= TRUE
&END;
$ELSE
&newShiftMode:= EgetShift ();
&ASSEMBLER
+MOVE.W newShiftMode(A6),D0
+ANDI   #$F0FF,D0
+ORI    #$0200,D0             ; 640*400 setzen
+MOVE.W D0,newShiftMode(A6)
&END;
&oldShiftMode:= EsetShift (newShiftMode);
$END;
$ASSEMBLER
(;*** ^ auf Fontdaten holen:
(DC.W    $A000
(MOVE.L  (A1)+,A0      ; f. System-Font 6*6 (Icon)
(MOVE.L  (A1)+,A0      ; f. System-Font 8*8 (Farbe)
(LEA     pFont8_8,A2
(MOVE.L  76(A0),(A2)
(MOVE.L  (A1)+,A0      ; f. System-Font 8*16 (S/W)
(LEA     pFont8_16,A2
(MOVE.L  76(A0),(A2)
$END;
$IF color THEN initFont8_8 ELSE initFont8_16 END;
$Supexec (GetpScreen);
"END InitScreen;
 
 
 (*$L+*)
 
 PROCEDURE InitEditor;           (* Initialisierung der Pointer und Flags *)
"VAR bufferLaenge: LONGINT; v, r: CARDINAL; d: Date;
 BEGIN
"PointsPerChar:= 8;
"IF color THEN
$LinesPerChar:= 8
"ELSE
$LinesPerChar:= 16
"END;
"allowed:=ASCII{' '..255C};
"bufferLaenge:=(INT(MemAvail())-32000) * 2 DIV 3;
"IF bufferLaenge > 0 THEN
$Allocate(bufferStart,bufferLaenge);
"END;
"IF bufferStart=NIL THEN WriteString('Not enough memory'); HALT END;
"ASSEMBLER
*move.l  bufferStart,a0
*move.l  a0,d0
*clr.l   (a0)+
*move.l  a0,ptrStart
*move.b  #DLEchar,(a0)+
*move.b  #DLEoffset,(a0)+
*move.l  a0,ptr
*move.l  a0,lastPtr
*clr     (a0)+
*move.l  a0,ptrEnd
*clr.l   (a0)+
*add.l   bufferLaenge(A6),d0
*bclr.l  #0,d0
*move.l  d0,a0
*clr.l   -(a0)
*clr.l   -(a0)
*move.l  a0,bufferL
*move.l  a0,bufferH
*moveq   #25,d0
*move    d0,lines
*subq    #1,d0
*move    d0,maxLine
*moveq   #80,d0
*move    d0,cols
*subq    #1,d0
*move.b  d0,maxCol
*subq    #1,d0
*move.b  d0,maxColM1
*
*clr     exitCode
*clr     endOfEd
*clr     filesInMem
*clr     cmdFlag
*clr     delFlag
*clr     insFlag
*jsr     ResetTextOptions
*addq    #1,sessions
*clr.l   total
*jsr     Prepare
*move.l  d0,startupTime
*clr.b   oldString
*clr.b   newString
*move    #30,countDefault
*CLR.L   ShortKeyPtr
*CLR     Inserting
*MOVE    #1,errorNr
 
*; Warmstart-Init geht nur, wenn die betroffenen Variablen als
*; TABLEs definiert werden (so auch die Find/Rpl-Strings).
*; tst.b   ColdStart
*; beq.l   warm
*; clr.b   ColdStart
 
*move    #1,sessions
*clr     cmdMode
*clr     tabMode
*clr.l   keepTime
"warm
"END
 END InitEditor;
 
 (*$l+*)
 PROCEDURE StopEditor;
 VAR i: CARDINAL;
 BEGIN
"DeAllocate(bufferStart,0L);
"Finish;
"(*
"SetNewDesk (NIL, Root);
"ForceDeskRedraw;
"*)
"Supexec (ResetpScreen);
"IF isTT THEN
$oldShiftMode:= EsetShift (oldShiftMode);
"ELSE
$IF rez_changed THEN Setrez (oldShiftMode) END;
$IF color THEN
&FOR i:= 0 TO 3 DO dumCard:= SetColor (i, oldColor[i]) END;
$END;
"END;
"IF Oscanis() THEN oldOscan:= Oscanswitch (oldOscan) END;
"SelectFile:= FileSelectProc (oldSelect);
"GrafMouse (mouseOn, NIL);
"MouseControl (FALSE);
"ForceDeskRedraw;
"ExitGem (hdl);
 END StopEditor;
 
 
 VAR first: boolean; argv:ARRAY [0..4] OF PtrArgStr;
$argc,strpos:CARDINAL; nullCh:CHAR;
 
 
 (*$l-*)
 PROCEDURE Right1;   (* ohne DOWN am Zeilen-Ende *)
 BEGIN
 ASSEMBLER
(;clr    forceTab
(move.l ptr,a0
 again   move.b (a0)+,d0
(beq    donix
(cmpi.b #CRchar,d0
(beq    donix
(cmpi.b #$20,d0
(bcs    again
(move.l a0,ptr
(move   ptrY,d1
(move.b ptrX,d1
(cmp.b  maxCol,d1
(beq    donix
(addq.b #1,d1
(jmp    GotoXYd1
 donix
 END
 END Right1;
 
 (*$l+*)
 PROCEDURE ShowCmdLine;
"BEGIN
$CASE cmdMode OF
&0: PutCmdOrTab(
 'Edit: C(py D(el E(nv F(ind I(ns J(mp N(ew Q(uit R(epl T(ag X(chg Z(ap   /'
(+Version+'/')|
&1: PutCmdOrTab(
 'Edit: A(djust B(reak G(lue H(ardcopy L(ook M(id O(pp P(age              /'
(+Version+'/')|
&2: PutCmdOrTab(
 'Edit: ?:info  K:show tabs  F2:set tab  F3/F4: Open/Close text frame     /'
(+Version+'/')|
&3: PutCmdOrTab(
 'Edit: F5: Compile  F6: Look for exported identifier                     /'
(+Version+'/')|
&4: PutCmdOrTab(
 'Edit: Find/Replace/Look prefix: S(ame V(erify W(ord                     /'
(+Version+'/')|
$END;
$cmdFlag:=true
"END ShowCmdLine;
 
 (*$l+*)
 PROCEDURE WaitForKey;
 
"VAR maus: BOOLEAN;
 
"PROCEDURE CursorsOn;
$BEGIN
&Write (CursorOnChar);
&IF UseGem AND NOT maus THEN
(GrafMouse (arrow, NIL);
(GrafMouse (mouseOn, NIL);
(maus:= TRUE;
&END;
$END CursorsOn;
 
"PROCEDURE CursorsOff;
$BEGIN
&IF UseGem & maus THEN
(GrafMouse (mouseOff, NIL);
(maus:= FALSE;
&END;
&ScrnCurOff;
$END CursorsOff;
 
"VAR
$i, mousePtrX, mousePtrY: CARDINAL;
 
"BEGIN
$maus:= FALSE;
$CursorsOn;
$IF CmdLineAway(TRUE) THEN
&CursorsOff;
&ShowCmdLine;
&CursorsOn;
$END;
$LOOP
&(* MAUS ist hier an *)
&IF Keypressed() THEN
(IF UseGem THEN GrafMouse (mouseOff, NIL); maus:= FALSE END;
(ReadUpCh;
(EXIT     (*Taste wurde gedrckt, Byte in Ch*)
&ELSE       (*H*)
(GetMouseState(dev,MousePoint, buttons); (*hlt Ablauf nicht an *)
(IF (msbut1 IN buttons) THEN
*IF Mousepoint.y <= (LinesPerChar DIV 2) then
,ch:= UpKey;
,EXIT
*ElSIF Mousepoint.y > (INTEGER(Lines)*LinesPerChar-2) THEN
,ch:= DownKey;
,EXIT
*ELSIF (Mousepoint.y >= LinesPerChar)
*AND   (Mousepoint.y < (INTEGER(Lines)*LinesPerChar-2)) THEN
,(*Maustaste gedrckt und nicht Statuszeile*)
,CursorsOff;
,Ptr:=ScreenTop1();
,ptrLine:= 1;
,ASSEMBLER
0MOVE    #$0100,D1
0JSR     GotoXYD1        ; x=0, y=1
,END;
,mousePtrX := Mousepoint.x DIV PointsPerChar; (* 0-79*)
,mousePtrY := Mousepoint.y DIV LinesPerChar; (* 1-24, Cmd-Zeile=0 *)
,ch:= downKey;
,for i:=1 to mousePtrY-1 do Down end;
,GotoSOln;
,For i:=CursorX+1 to mousePtrX do Right1 end;
,ClrKbdbuffer;
,CursorsOn;
*END;
(END (*if Maus gedrckt*)
&END (*IF Key ELSE mouse*)
$END (*LOOP, keine Taste gedrckt*);
$CursorsOff;
"END WaitForKey;
 
 (*$l+*)
 BEGIN   (* of Editor *)
"(* Screen lschen
$Conout (CHR(27)); Conout ('E');
"*)
"InitScreen;
"oldSelect:= ADDRESS (SelectFile);
"IF NOT UseGem THEN SelectFile:= NoSelect; END;
"InitGem(RC,dev,success);
"if success then hdl:= CurrGemHandle() end;
"HomePath:= ShellPath;
"GrafMouse (mouseOff, NIL);
"MouseControl (TRUE);
"MenuBar (NIL, FALSE);
"InitEditor;
"Write(ClrScrnChar);
"writeTitle;
"nullCh:=0C;
"InitArgCV (argc,argv);
"ErrorPos:=0L;
"GetPath(Path1); FName1:= '';
"first := TRUE;
"REPEAT
$IF first & (length(ArgV[1]^) # 0) THEN
&Assign (ArgV[1]^,filename,strok);
&splitpath(filename,Path1,FName1);
&IF Path1[0] = 0C THEN
(GetPath (Path1)
&ELSE
(Append ('*.*', Path1, strok)
&END
$ELSE
&(* writestring('Edit which file? ');
)filename := '';
)readstring(filename);
'*)
&filename:=getFilefromBox('Edit which file?');
$END;
$fnOK:=ChkName(fileName);
$IF fnOK THEN
&SearchFile (filename,SrcPaths,fromStart,strok,filename);
&Open (f,filename,readonly);
&IOResult:= State(f);
&IF IOResult >= 0 THEN
(UpdatePath (filename);
(writeLn;
(WriteString('Reading '); WriteString(fileName); WriteLn;
(flen:= FileSize(f);
(ReadText
&ELSE
(WriteString ('File not found !');
(ErrorWait
&END
$END;
$first := FALSE;
"UNTIL NOT fnOK OR (IOResult>=0);
"strpos:=0;
"ErrLine:= StrToLCard (ArgV[2]^,strpos,strok);
"IF fnOK & (ErrLine#0L) THEN
$strpos:=0;
$GotoLine (ErrLine, StrToCard (ArgV[3]^,strpos,strok));
$tags['?']:= ptr;
$ErrorPos:= ptr-ptrStart;
$Assign (argv[4]^,ErrMsg,strok);
$PutCmd(ErrMsg); ErrorWait
"ELSE
$jumpPtr (tags[';']);
$tags[';']:= ptrEnd
"END;
"REPEAT (*2*)
$WaitForKey; (* Mausaktionen werden allein in der Routine behandelt, *)
0(* auerhalb dieser Routine ist die Maus immer aus      *)
$IF Rptfx10() OR DirKey() THEN
$ELSIF ch='/' THEN Negate(infinite)
$ELSIF ch='S' THEN Negate(findSame)
$ELSIF ch='V' THEN Negate(verify)
$ELSIF ch='W' THEN Negate(findWord)
$ELSE
&CASE ch OF
&'A': Adjust |
&'C': CopyText |
&'D': DelMode |
&'E': Environment |
&'F': Find |
&'G': Glue |
&'H': HardCopy |
&'I': Inserting := True; InsMode; Inserting := False  |
&'J': Jump |
&'K': Negate(tabMode); cmdFlag:=false |
&'L': Look |
&'M': CenterScreen |
&'N': NewFile |
&'O': Page(true) |
&'P': Page(false) |
&'Q': QuitEditor |
&'R': FReplace |
&'T': SetTag |
&'X': Exchange |
&'Y': ASSEMBLER move.l rptf,d0 beq no move d0,countDefault !no END |
&'Z': Zap|
&ELSE
(IF ch=BreakKey THEN Break
((*$? mayCallCompiler:
(ELSIF ch=FindDefKey THEN FindDefinition
(*)
(ELSIF ch=HomeKey THEN CenterScreen
(ELSIF ch=INSKey THEN Inserting := True; InsMode; Inserting := False
(ELSIF ch=DELKey THEN DelMode
(ELSIF (ch=OpenFrameKey) THEN OpenTextFrame
(ELSIF (ch=CloseFrameKey) THEN
*CloseTextFrame;
*cmdFlag:=false;
*ScreenOut
(ELSIF ch=Helpkey THEN
*IF tabMode THEN tabMode:= FALSE ELSE cmdMode:= (cmdMode+1) MOD 5 END;
*cmdFlag:= FALSE
(ELSIF ch='?' THEN Info
(ELSIF (ch=PageDownKey) OR (ch=PageUpKey) THEN Page(ch=PageUpKey)
((*$? mayCallCompiler:
*ELSIF ch=compileKey THEN callCompiler
(*)
(ELSE
*RptfOK;
*REPEAT
,IF (ch=' ') OR (ch=rightKey) THEN Right
,ELSIF ch=EOLNkey THEN GotoEOLN
,ELSIF ch=SOLNkey THEN GotoSOLN
,ELSIF (ch=BSkey) OR (ch=leftKey) THEN Left
,ELSIF ch=wordLeftKey THEN WordLeft
,ELSIF ch=wordRightKey THEN WordRight
,ELSIF ch=TabRightKey THEN
.REPEAT
0Right
.UNTIL (OnSOLn() AND KeyPressed()) OR (ptr>=ptrEnd-2L) OR TabSet()
,ELSIF ch=TabLeftKey THEN
.REPEAT
0Left
.UNTIL (OnSOLn() AND KeyPressed()) OR (ptr<=ptrStart) OR TabSet()
,ELSIF ch=upKey THEN Up
,ELSIF ch=downKey THEN Down
,ELSIF ch=scrlUpKey THEN ScrollUp;
,ELSIF ch=scrlDownKey THEN ScrollDown;
,ELSIF ch=EnterKey THEN IF direction THEN Up ELSE Down END;
,END;
,DEC(rptf)
*UNTIL (rptf=0L) OR KeyPressed()
(END
&END;
&ASSEMBLER clr.l rptf clr findWord clr findSame clr infinite clr verify
&END
$END;
"UNTIL endOfEd (*2*);
"StopEditor;
"TermProcess (exitCode)
 END GEP_ED.
  
(* $FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$00007A4D$FFE597C0$000263E0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$FFE597C0$00007A4DT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFE406A8$00007AD7$FFE406A8$00007A62$00007A9C$FFE406A8$00007B10$00007A9C$00007A4D$00002A9C$00002BD3$00002BE3$00007AC2$00007E04$00007AC2$FFE406A8*)
