 IMPLEMENTATION MODULE Excepts; (* V#107 *)
 (*$Y+,R-*)
 
 (*$M-  ntig, da Adr./Lngen der Prozeduren ermittelt werden! *)
 
 (*!!! Es fehlen die Etv-Vektoren. *)
 
 (*
"09.04.88 TT  Alle Funktionen f. 68020 angepat. 2 Versionen m. cond.
/compiling! Achtung: RaiseExc nicht f. Bus/Addr-Error bei 68020!
"28.08.88 TT  Level wird bei ..Install.. richtig gesetzt, soda Sys-Funktionen
/nun laufen.
/Bei Sys-Funktionen wird nicht mehr automatisch abgemeldet
"25.10.88 TT  CatchRemoval-Aufruf
"04.07.89 TT  CPU_FPU.CNF wird included;
/XBRA-Kennung ("MM2X") eingefgt
"19.08.89 TT  RaiseExc luft nun sowohl mit 020 als mit 000; f. 020
/Korrekturen von GS bernommen; CPU_FPU.CNF nicht mehr importiert
"01.05.90 TT  ResetVec maskiert High-Byte vor Vergleich aus.
"11.06.90 TT  excHandler20 springt vorigen Vektor korrekt an
"13.06.90 TT  EnterSupervisorMode raus
"27.11.90 TT  Kleine Korrekturen; Vom Supervisor-Stack werden bei 68000 alle
/Daten (SR/PC, ggf. Buserror-Daten), bei 68010 und hher nur noch
/SR/PC runtergeholt, alle weitere Daten bleiben drauf;
/'ExcDesc' enthlt nicht mehr das Felder 'parm'.
"12.12.90 TT  Pre/Post-Handler definiert, InstallPostExc fehlt aber noch!
"14.02.92 TT  GEMDOS.Super-Aufrufe statt Supexec wg. MinT.
 *)
 
 FROM SYSTEM IMPORT LONGWORD, WORD, ADDRESS, TSIZE, ADR, ASSEMBLER;
 
 FROM MOSGlobals IMPORT MemArea;
 
 FROM MOSSupport IMPORT ToSuper, ToUser;
 
 FROM Storage IMPORT SysAlloc, DEALLOCATE;
 
 FROM SysTypes IMPORT ExcSet, ExcDesc, Exceptions;
 
 FROM PrgCtrl IMPORT EnvlpCarrier, SetEnvelope, CatchProcessTerm, TermCarrier;
 
 FROM ResCtrl IMPORT RemovalCarrier, CatchRemoval;
 
 IMPORT SysInfo;
 
 
 CONST   DftSF = $0010;
 
(XBRA_ID = 'MM2X';
 
 
 TYPE    PtrEntry = POINTER TO Entry;
(Entry    = RECORD
5desc: ExcDesc; (* mu am Anfang bleiben! *)
5call: PreExcProc;
5stackLow : ADDRESS;
5stackHigh: ADDRESS;
5xbra: ARRAY [0..3] OF CHAR; (* 'XBRA' *)
5myID: ARRAY [0..3] OF CHAR; (* MM2-Kennung *)
5old: ADDRESS;
5(* hier folgt direkt das EntryData-Record *)
3END;
 
 TYPE    PtrUser = POINTER TO User;
(User    = RECORD
4v    : POINTER TO ARRAY [0..60000] OF PtrEntry;
4numbs: ExcSet;
4level: INTEGER;
4next, prev : PtrUser;
4(* es folgen:
6- ARRAY [0..n-1] OF PtrEntry
6- alle 'Entry' mit jew. einer entryProc dahinter
4*)
2END;
 
 
 VAR VecInfo: ARRAY Exceptions OF PtrEntry;
$root: User;
$Level: INTEGER;
$has020, useSF: BOOLEAN;
$raiseV: ADDRESS;
$busHdl: ADDRESS;
 
 
 FORWARD excHandler0;
 FORWARD excHandler20;
 
 TYPE    EntryData = RECORD
6d1: WORD;
6d2:WORD;
6pEntry1: PtrEntry;
6d3:WORD;
6pEntry2: PtrEntry;
6d4:WORD;
6excNo: CARDINAL
6(* ... und noch beliebig mehr Bytes... *)
4END;
 
 PROCEDURE busEntry;
"(*$L-*)
"BEGIN
$ASSEMBLER
H; Byte
(MOVEM.L D0-A6,$123456           ; 0-6   +4.L : Adr. v. 'ExcDesc'
(MOVE.L  #0,A0                   ; 8-12  +10.L: Adr. v. 'Entry'
(MOVE    #0,ExcDesc.excNo(A0)    ; 14-18 +16.W: Vektornr.
(MOVE.L  busHdl,-(A7)            ; 20-24
H; 26
$END
"END busEntry;
"(*$L+*)
 
 PROCEDURE normEntry0;
"(*$L-*)
"BEGIN
$ASSEMBLER
H; Byte
(MOVEM.L D0-A6,$123456           ; 0-6   +4.L : Adr. v. 'ExcDesc'
(MOVE.L  #0,A0                   ; 8-12  +10.L: Adr. v. 'Entry'
(MOVE    #0,ExcDesc.excNo(A0)    ; 14-18 +16.W: Vektornr.
(MOVE.W  (A7)+,ExcDesc.regSR(A0)
(MOVE.L  (A7)+,ExcDesc.regPC(A0)
(JMP     excHandler0
$END
"END normEntry0;
"(*$L+*)
 
 PROCEDURE normEntry20;
"(*$L-*)
"BEGIN
$ASSEMBLER
H; Byte
(MOVEM.L D0-A6,$123456           ; 0-6   +4.L : Adr. v. 'ExcDesc'
(MOVE.L  #0,A0                   ; 8-12  +10.L: Adr. v. 'Entry'
(MOVE    #0,ExcDesc.excNo(A0)    ; 14-18 +16.W: Vektornr.
(MOVE.W  (A7)+,ExcDesc.regSR(A0)
(MOVE.L  (A7)+,ExcDesc.regPC(A0)
(JMP     excHandler20
$END
"END normEntry20;
"(*$L+*)
 
 PROCEDURE fastEntry;
"(*$L-*)
"BEGIN
$ASSEMBLER
H; Byte
(MOVEM.L D0-A6,$123456           ; 0-6   +4.L : Adr. v. 'ExcDesc'
(MOVE.L  #0,A0                   ; 8-12  +10.L: Adr. v. 'Entry'
(MOVE    #0,ExcDesc.excNo(A0)    ; 14-18 +16.W: Vektornr.
(MOVE.W  (A7)+,ExcDesc.regSR(A0)
(MOVE.L  (A7)+,ExcDesc.regPC(A0)
 
(MOVE.L  A7,ExcDesc.regSSP(A0)
(MOVE.L  USP,A1
(MOVE.L  A1,ExcDesc.regUSP(A0)
 
(; Routine aufrufen
(MOVE.L  Entry.stackLow(A0),A3
(MOVE.L  Entry.stackHigh(A0),A7
(MOVE.L  A0,-(A7)
(MOVE.L  A0,(A3)+
(MOVE.L  Entry.call(A0),A0
(JSR     (A0)
(
(MOVE.L  (A7)+,A0        ; ^Entry
 
(; Register zurcksetzen und RTE
(MOVE.L  ExcDesc.regUSP(A0),A1
(MOVE.L  A1,USP
(MOVE.L  ExcDesc.regSSP(A0),A7
(MOVE.L  ExcDesc.regPC(A0),-(A7)
(MOVE.W  ExcDesc.regSR(A0),-(A7)
(
(TST     -(A3)           ; vorigen Vektor anspringen ?
(BNE     cont4           ; ja
(
(MOVEM.L ExcDesc.regD0(A0),D0-A6
(RTE
(
 cont4:  MOVE.L  Entry.old(A0),-(A7)
(MOVEM.L ExcDesc.regD0(A0),D0-A6
$END
"END fastEntry;
"(*$L+*)
 
 PROCEDURE entryEnd; END entryEnd;
 
 
 PROCEDURE busHdl0;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; BusError-Daten holen
(MOVE.W  (A7)+,ExcDesc.superSR(A0)
(MOVE.L  (A7)+,ExcDesc.accessAddr(A0)
(MOVE.W  (A7)+,D0
(MOVE.W  D0,ExcDesc.instruction(A0)
(
(MOVE.W  (A7)+,D1                ; SR vom Stack
(MOVE.W  D1,ExcDesc.regSR(A0)
(MOVE.L  (A7)+,A2                ; PC vom Stack
(
(; Adr. der Instruktion suchen (2 bis 10 Bytes vor PC)
(MOVEQ   #-2,D1
 find    CMP.W   0(A2,D1.W),D0   ; Instr. gefunden ?
(BEQ     found           ; Ja, PC (A2) auf die Adr. setzen
(SUBQ    #2,D1           ; weiter zurck
(CMPI    #-10,D1         ; nicht mehr als 10 Bytes zurck
(BCC     find            ; weitersuchen
 contn   MOVE.L  A2,ExcDesc.regPC(A0)
(JMP     excHandler0     ; nicht gefunden, PC unverndert lassen
 found   ADDA    D1,A2
(BRA     contn
$END
"END busHdl0;
"(*$L+*)
 
 PROCEDURE busHdl20;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; BusError-Daten holen
(MOVE.W  (A7)+,ExcDesc.regSR(A0) ; SR vom Stack
(MOVE.L  (A7)+,ExcDesc.regPC(A0) ; PC vom Stack
(
(MOVE.W  4(A7),ExcDesc.superSR(A0)
(MOVE.L  10(A7),ExcDesc.accessAddr(A0)
(MOVE.W  6(A7),D0
(MOVE.W  D0,ExcDesc.instruction(A0)
(
((* bei 68020 zeigt PC anscheinend schon auf die Error-Instr. *)
(JMP     excHandler20
$END
"END busHdl20;
"(*$L+*)
 
 
 PROCEDURE excHandler0;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  A7,ExcDesc.regSSP(A0)
(MOVE.L  USP,A1
(MOVE.L  A1,ExcDesc.regUSP(A0)
(
(; Routine aufrufen
(ANDI    #$CFFF,SR       ; User Mode
(MOVE.L  Entry.stackLow(A0),A3
(MOVE.L  Entry.stackHigh(A0),A7
(MOVE.L  A0,-(A7)
(MOVE.L  A0,(A3)+
(MOVE.L  Entry.call(A0),A0
(JSR     (A0)
(
(; zurck in den Supervisor-Mode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
 
(; Register zurcksetzen und RTE
(MOVE.L  (A7)+,A2        ; ^Entry
(MOVE.L  ExcDesc.regUSP(A2),A1
(MOVE.L  A1,USP
(MOVE.L  ExcDesc.regSSP(A2),A7
(MOVE.L  ExcDesc.regPC(A2),-(A7)
(MOVE.W  ExcDesc.regSR(A2),-(A7)
(
(TST     -(A3)           ; vorigen Vektor anspringen ?
(BNE     cont4           ; ja
(
(MOVEM.L ExcDesc.regD0(A2),D0-A6
(RTE
 
 cont4:  CMPI.W  #4,ExcDesc.excNo(A2)
(BCC     cont3
(MOVE.W  ExcDesc.instruction(A2),-(A7)
(MOVE.L  ExcDesc.accessAddr(A2),-(A7)
(MOVE.W  ExcDesc.superSR(A2),-(A7)
 cont3:  MOVE.L  Entry.old(A2),-(A7)
(MOVEM.L ExcDesc.regD0(A2),D0-A6
$END
"END excHandler0;
"(*$L+*)
 
 PROCEDURE excHandler20;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; wie excHandler0, nur ohne Sonderbehandlung fr Bus/Adr-Error
(MOVE.L  A7,ExcDesc.regSSP(A0)
(MOVE.L  USP,A1
(MOVE.L  A1,ExcDesc.regUSP(A0)
(
(; Routine aufrufen
(ANDI    #$CFFF,SR       ; User Mode
(MOVE.L  Entry.stackLow(A0),A3
(MOVE.L  Entry.stackHigh(A0),A7
(MOVE.L  A0,-(A7)
(MOVE.L  A0,(A3)+
(MOVE.L  Entry.call(A0),A0
(JSR     (A0)
(
(; zurck in den Supervisor-Mode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
 
(; Register zurcksetzen und RTE
(MOVE.L  (A7)+,A2        ; ^Entry
(MOVE.L  ExcDesc.regUSP(A2),A1
(MOVE.L  A1,USP
(MOVE.L  ExcDesc.regSSP(A2),A7
(MOVE.L  ExcDesc.regPC(A2),-(A7)
(MOVE.W  ExcDesc.regSR(A2),-(A7)
(
(TST     -(A3)           ; vorigen Vektor anspringen ?
(BNE     cont4           ; ja
(
(MOVEM.L ExcDesc.regD0(A2),D0-A6
(RTE
 
 cont4:  MOVE.L  Entry.old(A2),-(A7)
(MOVEM.L ExcDesc.regD0(A2),D0-A6
$END
"END excHandler20;
"(*$L+*)
 
 
 PROCEDURE SetVec (no: CARDINAL; newV: ADDRESS; VAR oldV: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
(MOVE.L  -(A3),A1        ; ADR (oldV)
(MOVE.L  -(A3),A2        ; newV
(MOVE    -(A3),D0        ; no
(MOVE    SR,D2
(ORI     #$0700,SR
(LSL     #2,D0
(MOVE.W  D0,A0           ; A0: Vektoradr.
(MOVE.L  (A0),(A1)
(MOVE.L  A2,(A0)         ; newV
(MOVE    D2,SR
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END SetVec;
"(*$L=*)
 
 PROCEDURE ResetVec (no: CARDINAL; entry: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
(MOVE.L  -(A3),D1        ; D1: entry
(MOVE.W  -(A3),D0        ; D0: Vektornr.
(MOVE    SR,D2
(ORI     #$0700,SR
(TST     has020
(BNE     is020a
(ANDI.L  #$FFFFFF,D1
%is020a:
(LSL     #2,D0
(MOVE.W  D0,A0           ; A0: Vektoradr.
%l: MOVE.L  (A0),A1
(TST     has020
(BNE     is020b
(EXG     D1,A1
(ANDI.L  #$FFFFFF,D1
(EXG     D1,A1
%is020b:
(CMPA.L  D1,A1           ; 'entry' gefunden?
(BEQ     f
(CMPI.L  #$58425241,-12(A1) ; Ist dies ein XBRA-Eintrag?
(BNE     n               ; Nein -> entry hier trotzdem austragen
(LEA     -4(A1),A0       ; Vorige Vektoradr. nach A0
(BRA     l
%n: MOVE.L  D1,A1
%f: MOVE.L  -4(A1),(A0)     ; Entry.old eintragen
(MOVE    D2,SR
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END ResetVec;
"(*$L=*)
 
 PROCEDURE Move (from,len,to:LONGWORD);
"BEGIN
$ASSEMBLER
(MOVE.L  from(A6),A0
(MOVE.L  len(A6),D0
(MOVE.L  to(A6),A1
(LSR.L   #1,D0
(BRA     c
$l2: SWAP    D0
$l1: MOVE.W  (A0)+,(A1)+
%c: DBRA    D0,l1
(SWAP    D0
(DBRA    D0,l2
$END
"END Move;
 
 PROCEDURE linkIn ( p: PtrUser );
"BEGIN
$WITH p^ DO
&next:= root.next;
&prev:= ADR (root)
$END;
$WITH root DO
&prev^.next := p;
&next := p
$END
"END linkIn;
 
 PROCEDURE linkOut ( p: PtrUser );
"BEGIN
$WITH p^ DO
&prev^.next := next;
&next^.prev := prev
$END
"END linkOut;
 
 PROCEDURE Install ( REF traps: ExcSet; call0: ADDRESS;
4userMode: BOOLEAN; workSpace: MemArea;
4VAR hdl: ADDRESS; mylevel: INTEGER; post: BOOLEAN );
 
"PROCEDURE entryLen (n:CARDINAL; VAR procS: ADDRESS): LONGCARD;
$VAR procE: ADDRESS;
$BEGIN
&IF ~userMode THEN
(procS:= ADDRESS(fastEntry);
(procE:= ADDRESS(entryEnd)
&ELSIF n<4 THEN
(procS:= ADDRESS(busEntry);
(procE:= ADDRESS(normEntry0)
&ELSIF useSF THEN
(procS:= ADDRESS(normEntry20);
(procE:= ADDRESS(fastEntry)
&ELSE
(procS:= ADDRESS(normEntry0);
(procE:= ADDRESS(normEntry20)
&END;
&RETURN procE-procS
$END entryLen;
 
"VAR i,c:CARDINAL;
&l:LONGCARD;
&procS: ADDRESS; procL: LONGCARD;
&pUser: PtrUser;
&pEntry: PtrEntry;
&pData: POINTER TO EntryData;
"BEGIN
$hdl:=NIL;
$IF post THEN
&HALT (* noch nicht impl. *);
&RETURN
$END;
$(* Zhle Elemente in 'traps'-Set *)
$c:=0;
$l:= TSIZE(User);
$FOR i:=MIN(Exceptions) TO MAX(Exceptions) DO
&IF i IN traps THEN
(IF ~userMode & (i<4) THEN
*ASSEMBLER
0TRAP    #6
0DC.W    -14     ; Ill. call
*END;
*RETURN
(END;
(l:= l + entryLen (i,procS) + TSIZE (Entry) + 4L;
(INC (c)
&END;
$END;
$IF c#0 THEN
&SysAlloc ( hdl, l );
&IF hdl#NIL THEN
(pUser:=hdl;
(pUser^.numbs:= traps;
(pUser^.level:= mylevel;
(linkIn (pUser);
(pEntry:= ADDRESS(pUser) + TSIZE(User);
(pUser^.v:= ADDRESS(pEntry);
(pEntry:= ADDRESS(pEntry) + 4L * LONG (c);
(c:= 0;
(FOR i:=MIN(Exceptions) TO MAX(Exceptions) DO
*IF i IN traps THEN
,pUser^.v^[c]:= pEntry;
,pEntry^.stackLow:= workSpace.bottom;
,pEntry^.stackHigh:= workSpace.bottom+workSpace.length;
,pEntry^.call:= PreExcProc (call0);
,pEntry^.xbra:= 'XBRA';
,pEntry^.myID:= XBRA_ID;
,pData:= ADDRESS (pEntry) + TSIZE (Entry);
,procL:= entryLen (i,procS);
,Move (procS,procL,pData);
,pData^.excNo:= i;
,pData^.pEntry1:= pEntry;
,pData^.pEntry2:= pEntry;
,SetVec (i,pData,pEntry^.old);
 
,pEntry:= ADDRESS(pData) + procL;
,INC (c)
*END
(END
&END
$END
"END Install;
 
 PROCEDURE InstallPreExc (REF traps: ExcSet;
9call: PreExcProc; usermode: BOOLEAN;
9workSpace: MemArea; VAR hdl: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    Level,(A3)+
(CLR     (A3)+
(JMP     Install
$END
"END InstallPreExc;
"(*$L+*)
 
 PROCEDURE InstallPostExc (REF traps: ExcSet;
9call: PostExcProc; usermode: BOOLEAN;
9workSpace: MemArea; VAR hdl: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    Level,(A3)+
(MOVE    #1,(A3)+
(JMP     Install
$END
"END InstallPostExc;
"(*$L+*)
 
 PROCEDURE SysInstallPreExc (REF traps: ExcSet;
9call: PreExcProc; usermode: BOOLEAN;
9workSpace: MemArea; VAR hdl: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #-1,(A3)+
(CLR     (A3)+
(JMP     Install
$END
"END SysInstallPreExc;
"(*$L+*)
 
 PROCEDURE SysInstallPostExc (REF traps: ExcSet;
9call: PostExcProc; usermode: BOOLEAN;
9workSpace: MemArea; VAR hdl: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #-1,(A3)+
(MOVE    #1,(A3)+
(JMP     Install
$END
"END SysInstallPostExc;
"(*$L+*)
 
 PROCEDURE DeInstallExc ( VAR hdl: ADDRESS );
"VAR i,c:CARDINAL;
&pUser: PtrUser;
&dummy:ADDRESS;
"BEGIN
$IF hdl#NIL THEN
&pUser:=hdl;
&c:=0;
&FOR i:=MIN(Exceptions) TO MAX(Exceptions) DO
(IF i IN pUser^.numbs THEN
*ResetVec (i,ADR(pUser^.v^[c]^.old)+4L (* Zeiger auf eigene Routine *));
*INC (c)
(END
&END;
&linkOut (pUser);
&DEALLOCATE (hdl,0L)
$END;
"END DeInstallExc;
 
 
 
 PROCEDURE RaiseExc0 ( no: HardExceptions );
 (*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #6,A7           ; Platz f. PC/SR bei Supervisormode
(
(MOVEM.L D0-D2/A0-A2,-(A7)
(
(MOVE.L  #1,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0              ; sind wir schon im Supervisormode ?
(BNE     supv
(
(; In den Supervisor-Mode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  A7,USP
(MOVE.L  D0,A7
(
(SUBA.W  #10,A7          ; Platz v. RTS-Adr/SR/PC
(MOVE    SR,D0
(ANDI    #$CFFF,D0
(MOVE.W  D0,4(A7)        ; SR auf Superv-Stack
(MOVE.L  USP,A0
(ADDA.W  #$18,A0
(MOVE.L  6(A0),6(A7)     ; PC auf Superv-Stack
(MOVE.L  -(A0),-(A7)     ; D0-D2/A0-A2 von User- auf Superv-Stack
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(ADDA.W  #$18+10,A0
(MOVE.L  A0,USP
(
(MOVE    -(A3),D2        ; Vektornr.
(LSL     #2,D2           ; * 4
(MOVE.W  D2,A0
(MOVE.L  (A0),A0         ; Vektor
(MOVE.L  A0,$18(A7)      ; als RTS-Wert hinter die 6 geretteten Regs
(MOVEM.L (A7)+,D0-D2/A0-A2
(RTS
 
 supv:   MOVE    -(A3),D2        ; Vektornr.
(LSL     #2,D2           ; * 4
(MOVE.W  D2,A0
(MOVE.L  (A0),A0         ; Vektor
(MOVE.L  A0,$18(A7)      ; als RTS-Wert hinter die 6 geretteten Regs
(MOVE.W  SR,$18+4(A7)    ; SR auf Superv-Stack
(MOVEM.L (A7)+,D0-D2/A0-A2
$END
"END RaiseExc0;
"(*$L+*)
 
 PROCEDURE RaiseExc20 ( no: HardExceptions );
"(*$L-*)
"CONST c1=12;
"BEGIN
$ASSEMBLER
(SUBQ.W  #8,A7                ; space for format/offset word 68020
(MOVEM.L D0-D2/A0-A2,-(A7)    ; Stack :  +32 L   Callers return address
E;       ^  +30 W   Format/Offset (68020)
E;       |  +28 W   SR
E;       +  +24 L   PC for RTS
E;       |  +20 L   A2
E;       |  +16 L   A1
E;       -  +12 L   A0
E;       |  + 8 L   D2
E;       v  + 4 L   D1
E;     A7 ->+ 0 L   D0 (points to low byte)
(MOVE.L  32(A7),D0       ; return address
(MOVE    #DftSF,34(A7)   ; +34 W   Format/Offset ( 68020 )
(MOVE.L  D0,30(A7)       ; +30 L   Callers return address
(
(MOVE.L  #1,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0              ; sind wir schon im Supervisormode ?
(BNE     supv
(
(; In den Supervisor-Mode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  A7,USP
(MOVE.L  D0,A7
(
(SUBA.W  #c1,A7          ; Platz v. RTS-Adr/SR/PC
(MOVE.L  USP,A0
(ADDA.W  #$18,A0
(MOVE    SR,D0
(ANDI    #$CFFF,D0
(MOVE.W  D0,4(A7)        ; SR auf Superv-Stack
(MOVE.L  6(A0),6(A7)     ; PC auf Superv-Stack
(MOVE.W  10(A0),10(A7)   ; SF auf Superv-Stack
(MOVE.L  -(A0),-(A7)     ; D0-D2/A0-A2 von User- auf Superv-Stack
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(MOVE.L  -(A0),-(A7)
(ADDA.W  #$18+c1,A0
(MOVE.L  A0,USP
(
(MOVE    -(A3),D2        ; Vektornr.
(LSL     #2,D2           ; * 4
(MOVE.W  D2,A0
(MOVE.L  (A0),A0         ; Vektor
(MOVE.L  A0,$18(A7)      ; als RTS-Wert hinter die 6 geretteten Regs
(
(CMPI    #16,D2          ; Bus- o. Address error ?
(BCS     buser2          ; ja
(MOVEM.L (A7)+,D0-D2/A0-A2
(RTS
 
 buser2: MOVEM.L (A7)+,D0-D2/A0-A2
(SUBQ.L  #8,A7
(MOVE.L  8(A7),(A7)
(CLR.L   4(A7)
(CLR.L   8(A7)
(RTS
 
 supv:   MOVE    -(A3),D2        ; Vektornr.
(LSL     #2,D2           ; * 4
(MOVE.W  D2,A0
(MOVE.L  (A0),A0         ; Vektor
(MOVE.L  A0,$18(A7)      ; als RTS-Wert hinter die 6 geretteten Regs
(MOVE.W  SR,$18+4(A7)    ; SR auf Superv-Stack
 
(CMPI    #16,D2          ; Bus- o. Address error ?
(BCS     buserr          ; ja
(MOVEM.L (A7)+,D0-D2/A0-A2
(RTS
 
 buserr: MOVEM.L (A7)+,D0-D2/A0-A2
(SUBQ.L  #8,A7
(MOVE.L  8(A7),(A7)
(CLR.L   4(A7)
(CLR.L   8(A7)
$END
"END RaiseExc20;
"(*$L+*)
 
 PROCEDURE RaiseExc ( no: HardExceptions );
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  raiseV,-(A7)
$END
"END RaiseExc;
"(*$L+*)
 
 
 PROCEDURE releaseLevel;
"VAR p,pn: PtrUser;
"BEGIN
$p:= ADR (root);
$p:= p^.next;
$WHILE p # ADR (root) DO
&pn:= p^.next;
&IF p^.level>=Level THEN
(DeInstallExc (p)
&END;
&p:=pn
$END
"END releaseLevel;
 
 PROCEDURE chgLevel (start:BOOLEAN; inChild:BOOLEAN; VAR exitCode:INTEGER);
"BEGIN
$IF inChild THEN
&IF start THEN
(INC (Level)
&ELSE
(releaseLevel;
(DEC (Level)
&END
$END
"END chgLevel;
 
 PROCEDURE freeSys;
"BEGIN
$Level:= MinInt;
$releaseLevel
"END freeSys;
 
 VAR eHdl: EnvlpCarrier;
$tHdl: TermCarrier;
$rHdl: RemovalCarrier;
$wsp: MemArea;
 
 BEGIN
"useSF:= SysInfo.UseStackFrame ();
"has020:= SysInfo.Has020 ();
"IF useSF THEN
$busHdl:= ADDRESS (busHdl20);
$raiseV:= ADDRESS (RaiseExc20)
"ELSE
$busHdl:= ADDRESS (busHdl0);
$raiseV:= ADDRESS (RaiseExc0)
"END;
"root.next:= ADR (root);
"root.prev:= ADR (root);
"SetEnvelope (eHdl,chgLevel,wsp);
"CatchProcessTerm (tHdl,releaseLevel,wsp);
"CatchRemoval (rHdl,freeSys,wsp);
 END Excepts.
  
(* $FFEAF9A1$FFFB2ED7$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$00002AF9$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$00002AB7$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$00000F1A$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$FFFA9F05$000004B8T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000020C6$FFEFB5B0$FFEFB5B0$000022AA$000020E8$000021F3$00002560$000004B9$000004EB$000004B8$0000058F$000004B8$0000056E$00000578$000021F3$00002581*)
