 IMPLEMENTATION MODULE GEMDOS;
 (*$Z-,Y+,S-,N+,R-,L-*)
 
 (*
 TT 20.10.91: $M- entfernt.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SYSTEM IMPORT BYTE, ADDRESS, LONGWORD, CAST;
 
 VAR s, s2: ARRAY [0..129] OF CHAR;
 
 PROCEDURE str0;
"BEGIN
$ASSEMBLER
(; in A2 wird Adr. v. ^str / HIGH (str) bergeben
(LEA     s,A1
(MOVEQ   #126,D1
(MOVE.L  (A2),A0
(MOVE    4(A2),D0
(MOVE.L  A1,(A2)         ; ^str umsetzen auf 's'
(BRA     y
(
%x  SUBQ    #1,D0
(BCS     ok2       ; Source-Ende, Dest. muss Endmarke bekommen
%y  MOVE.B  (A0)+,(A1)+
(DBEQ    D1,x
$ok2 CLR.B   (A1)+
$END
"END str0;
 
 
 PROCEDURE strb0;
"BEGIN
$ASSEMBLER
(; in A2 wird Adr. v. ^str / HIGH (str) bergeben
(LEA     s2,A1
(MOVEQ   #126,D1
(MOVE.L  (A2),A0
(MOVE    4(A2),D0
(MOVE.L  A1,(A2)         ; ^str umsetzen auf 's2'
(BRA     y
(
%x  SUBQ    #1,D0
(BCS     ok2       ; Source-Ende, Dest. muss Endmarke bekommen
%y  MOVE.B  (A0)+,(A1)+
(DBEQ    D1,x
$ok2 CLR.B   (A1)+
$END
"END strb0;
 
 
 PROCEDURE OldTerm ();
"BEGIN
$ASSEMBLER
(CLR     -(A7)
(TRAP    #1
(ADDQ.L  #2,A7
$END
"END OldTerm;
"
 PROCEDURE ConIn (VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #1,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
$END
"END ConIn;
 
 PROCEDURE ConScanIn (VAR ch: CHAR; VAR scan: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #1,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
(MOVE.L  (A7)+,A0
(SWAP    D0
(MOVE.B  D0,(A0)
$END
"END ConScanIn;
 
 PROCEDURE ConOut (ch: CHAR);
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #2,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END ConOut;
 
 PROCEDURE AuxIn (VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #3,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
$END
"END AuxIn;
 
 PROCEDURE AuxOut (ch: CHAR);
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #4,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END AuxOut;
 
 PROCEDURE PrnOut (ch: CHAR);
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #5,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END PrnOut;
 
 PROCEDURE RawIO (VAR ch: CHAR; rw: IOMode);
"BEGIN
$ASSEMBLER
(TST     -(A3)
(BEQ     rd
(MOVE.L  -(A3),A0
(MOVE.B  (A0),D0
(MOVE    D0,-(A7)
(MOVE    #6,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(RTS
$rd: MOVE.L  -(A3),-(A7)
(MOVE    #$FF,-(A7)
(MOVE    #6,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
$END
"END RawIO;
 
 PROCEDURE RawIn (VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #7,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
$END
"END RawIn;
 
 PROCEDURE RawScanIn (VAR c: CHAR; VAR sc: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #7,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
(MOVE.L  (A7)+,A0
(SWAP    D0
(MOVE.B  D0,(A0)
$END
"END RawScanIn;
 
 PROCEDURE NecIn (VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #8,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(MOVE.B  D0,(A0)
$END
"END NecIn;
 
 PROCEDURE ConWS (REF str: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #9,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END;
"END ConWS;
 
 PROCEDURE ConRS (VAR str: ARRAY OF BYTE);
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #10,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END ConRS;
 
 PROCEDURE ConIS (): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE    #11,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END ConIS;
 
 PROCEDURE SetDrv (drive: CARDINAL; VAR used: LONGCARD);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE    #14,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE.L  D0,(A0)
$END
"END SetDrv;
 
 PROCEDURE ConOS (): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE    #16,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END ConOS;
 
 PROCEDURE PrnOS (): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE    #17,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END PrnOS;
 
 PROCEDURE AuxIS (): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE    #18,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END AuxIS;
 
 PROCEDURE AuxOS (): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE    #19,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END AuxOS;
 
 PROCEDURE GetDrv (VAR drive: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    #$19,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
$END
"END GetDrv;
 
 PROCEDURE SetDTA (dtaAddr: ADDRESS);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$1A,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END SetDTA;
 
 PROCEDURE GetDate (VAR packeddate: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    #$2A,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
$END
"END GetDate;
 
 PROCEDURE SetDate (packeddate: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE    #$2B,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END SetDate;
 
 PROCEDURE GetTime (VAR packedtime: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    #$2C,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
$END
"END GetTime;
 
 PROCEDURE SetTime (packedtime: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE    #$2D,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END SetTime;
 
 PROCEDURE GetDTA (VAR dtaAddr: ADDRESS);
"BEGIN
$ASSEMBLER
(MOVE    #$2F,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
$END
"END GetDTA;
 
 PROCEDURE Version (VAR versionNo: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    #$30,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
$END
"END Version;
 
 PROCEDURE TermRes (keepAmount: LONGCARD; exitcode: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$31,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
$END
"END TermRes;
 
 PROCEDURE DFree (VAR infoblock: DiskInfoBuffer; drive1: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$36,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
$END
"END DFree;
 
 PROCEDURE DirCreate (REF path: ARRAY OF CHAR): BOOLEAN;
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$39,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END;
"END DirCreate;
 
 PROCEDURE DirDelete (REF path: ARRAY OF CHAR): BOOLEAN;
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$3A,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END;
"END DirDelete;
 
 PROCEDURE SetPath (REF path: ARRAY OF CHAR): BOOLEAN;
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$3B,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END;
"END SetPath;
 
 PROCEDURE Create (REF fname: ARRAY OF CHAR; mode: CARDINAL; VAR handle: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$3C,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A0
(MOVE.W  D0,(A0)
$END
"END Create;
 
 PROCEDURE Open (REF fname: ARRAY OF CHAR; mode: CARDINAL; VAR handle: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$3D,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A0
(MOVE.W  D0,(A0)
$END
"END Open;
 
 PROCEDURE Close (handle: INTEGER): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE    #$3E,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END Close;
 
 PROCEDURE Read (handle: INTEGER; VAR noOfBytes: LONGCARD; buffer: ADDRESS);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,-(A7)
(MOVE.L  D0,-(A7)
(MOVE.L  (A0),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVE.L  (A7)+,A0
(TST.L   D0
(BMI     err
(MOVE.L  D0,(A0)
(RTS
&err:
(CLR.L   (A0)
$END
"END Read;
 
 PROCEDURE Write (handle: INTEGER; VAR noOfBytes: LONGCARD; buffer: ADDRESS);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,-(A7)
(MOVE.L  D0,-(A7)
(MOVE.L  (A0),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE    #$40,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVE.L  (A7)+,A0
(TST.L   D0
(BMI     err
(MOVE.L  D0,(A0)
(RTS
&err:
(CLR.L   (A0)
$END
"END Write;
 
 PROCEDURE Delete (REF fname: ARRAY OF CHAR): BOOLEAN;
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$41,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END;
"END Delete;
 
 PROCEDURE Seek (pos: LONGINT; handle: INTEGER; mode: SeekMode;
0VAR newPosFromBeginning: LONGINT);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$42,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
(MOVE.L  (A7)+,A0
(MOVE.L  D0,(A0)
$END
"END Seek;
 
 PROCEDURE Attrib (REF fname: ARRAY OF CHAR; mode: TimeAccessMode; VAR attr: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  (A7),A0
(MOVE.W  (A0),-(A7)
(MOVE.W  -(A3),-(A7)
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$43,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
(MOVE.L  (A7)+,A0
(MOVE.W  D0,(A0)
$END
"END Attrib;
 
 PROCEDURE GetPath (VAR path: ARRAY OF CHAR; drive1: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),-(A7)
(MOVE    #$47,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
$END
"END GetPath;
 
 PROCEDURE Alloc (amount: LONGINT; VAR addr: ADDRESS);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$48,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  D0,(A0)
$END
"END Alloc;
 
 PROCEDURE Free (addr: ADDRESS): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$49,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END Free;
 
 PROCEDURE Shrink (addr: ADDRESS; newAmount: LONGCARD): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(CLR.W   -(A7)
(MOVE    #$4A,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END Shrink;
 
 PROCEDURE Pexec ( Mode: CARDINAL; Name, Arguments, Environment: ADDRESS;
2VAR Result: LONGINT );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE    #$4B,-(A7)
(TRAP    #1
(ADDA.W  #16,A7
(MOVE.L  (A7)+,A0
(MOVE.L  D0,(A0)
$END
"END Pexec;
 
 PROCEDURE Term (exitcode: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE    -(A3),-(A7)
(MOVE    #$4C,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END Term;
 
 PROCEDURE SFirst (REF fname: ARRAY OF CHAR; mode: CARDINAL; VAR res: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$4E,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A0
(MOVE.W  D0,(A0)
$END
"END SFirst;
 
 PROCEDURE SNext (VAR res: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE    #$4F,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
$END
"END SNext;
 
 PROCEDURE Rename (REF oldname, newname: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LEA     -6(A3),A2
(JSR     str0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(LEA     -6(A3),A2
(JSR     strb0
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(CLR     -(A7)
(MOVE    #$56,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
$END
"END Rename;
 
 PROCEDURE DaTime (handle: INTEGER; dataEndTimeAddr: ADDRESS;
8mode: TimeAccessMode);
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),-(A7)
(MOVE.L  -(A3),D0
(MOVE.W  -(A3),-(A7)
(MOVE.L  D0,-(A7)
(MOVE    #$57,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
$END
"END DaTime;
 
 PROCEDURE Super (stack: LONGINT): LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  D0,(A3)+
$END
"END Super;
 
 PROCEDURE Dup ( stdHandle: INTEGER; VAR newHandle: INTEGER );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE    #$45,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE.W  D0,(A0)
$END
"END Dup;
"
 PROCEDURE Force ( stdHandle, newHandle: INTEGER ): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$46,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(TST.L   D0
(SEQ     D0
(ANDI    #1,D0
(MOVE.W  D0,(A3)+
$END
"END Force;
 
 PROCEDURE Xalloc ( Bytes: LONGINT; mode: CARDINAL; VAR Addr: ADDRESS );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$44,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A0
(MOVE.L  D0,(A0)
$END
"END Xalloc;
 
 END GEMDOS.
 
(* $FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$00001FFF$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$FFEA2909$00000060T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000033ED$000032A8$000033CD$0000340C$0000002D$00000065$FFEDA586$FFEDA586$00000060$000032FE$0000331A$00003189$0000342C$000033AB$000033C1$000033AB*)
