DEFINITION MODULE KbdCtrl;

(*
 *                                                 Thomas Tempelmann 28.08.88
 *                                                             Stand 04.22.90
 *
 * Die Funktionen dieses Moduls bieten Zugriff auf den Tastaturpuffer.
 * Sie knnen auch in Interruptroutinen aufgerufen werden.
 *
 * VORSICHT:
 *   Die Funktionen, die direkt auf den Tastaturpuffer zugreifen, verhindern
 *   nicht, da whrenddessen gerade ein neues Zeichen im Interrupt eingefgt
 *   wird. Werden die Funktionen im Tastatur-Interrupt aufgerufen, macht
 *   das natrlich nichts, weil whrenddessen kein weiterer Interrupt auf-
 *   treten kann. Erfolt der Aufruf aber aus dem User-Modus bzw. im normal
 *   laufenden Programm, mssen whrenddessen die Interrupts gesperrt werden.
 *   Das ist beispielsweise durch ein "Monitor-Modul" (Prioritt im Modulkopf,
 *   mu mind. 5 sein!) oder durch die Funktion 'LockKeyBuffer' (s.u.) mglich.
 *
 * Damit bei den Tastenabfragen ber die hiesigen Funktionen oder auch
 * ber die BIOS/GEMDOS-Funktionen im oberen Wort neben dem Scan-Code
 * auch der Status der Shift-, Ctrl- und Alt- Tasten bermittelt wird,
 * wird Bit 3 der Systemvariable 'conterm' (bei Adr. $484) automatisch
 * bei der Initialisierung dieses Modul von seinem Krper (Body) gesetzt.
 * Bei Prozeende des (ltesten) importierenden Moduls oder Freigabe eines
 * importierenden residenten Moduls/Programms wird der alte Wert in 'conterm'
 * wiederhergestellt.
 * Der alte Wert wird in der globalen Variablen 'PreviousMode' gerettet
 * und kann ggf. verndert werden, um damit eine andere Rckstellung des
 * Wertes bei Programmende/-freigabe zu bewirken.
 * Zwischendurch kann der 'conterm'-Wert auch mit der Funktion 'SetMode'
 * verndert werden.
 *)

FROM MOSGlobals IMPORT Key, CtrlKey, CtrlSet;
FROM SYSTEM IMPORT ADDRESS;


VAR PreviousMode: BOOLEAN;
 (*
  * Enthlt den Wert des 'conterm'-Bits (Nr.3) vor dem Start dieses
  * Moduls.
  * Der Wert dieser Variablen wird bei Programmende/-freigabe wieder
  * nach 'conterm' geschrieben.
  *)

PROCEDURE CurrentMode (): BOOLEAN;
PROCEDURE SetMode (extended: BOOLEAN);
PROCEDURE SetExtMode (VAR lastMode: BOOLEAN);
 (*
  * 'CurrentMode' liefert den aktuellen Status des Bit 3 aus 'conterm',
  * 'SetMode' setzt oder lscht das Bit, je nach dem bergebenen
  * BOOLEAN-Wert.
  * 'SetExtMode' setzt das Bit und liefert in 'lastMode' den vorherigen
  * Wert, soda dieser danach mit 'SetMode (lastMode)' zurckgesetzt
  * werden kann (dies ist eine optimierte Funktion, um kurzzeitig das Bit
  * zu setzen und danach wiederherzustellen).
  * VORSICHT: Diese drei Prozeduren nicht in Interrupt-Routinen aufrufen!
  *)


PROCEDURE LookKey ( VAR k: Key; VAR ok: BOOLEAN );
 (*
  * Liefert die als nchste anstehende Taste (also die lteste im
  * Puffer), ohne sie aus dem Puffer zu entfernen.
  * Wenn 'ok' = FALSE, ist keine Taste vorhanden.
  *)

PROCEDURE GetKey ( VAR k: Key; VAR ok: BOOLEAN );
 (*
  * Holt die als nchste anstehende (die lteste) Taste aus dem Puffer.
  * Wenn 'ok' = FALSE, ist keine Taste vorhanden.
  *)

PROCEDURE LookMostRecentKey ( VAR k: Key; VAR ok: BOOLEAN );
 (*
  * Liefert die zuletzt eingefgte Taste (also die jngste im
  * Puffer), ohne sie aus dem Puffer zu entfernen.
  * Wenn 'ok' = FALSE, ist keine Taste vorhanden.
  *)

PROCEDURE PushBackKey ( VAR k: Key; VAR ok: BOOLEAN );
 (*
  * Schreibt die Taste so in den Puffer zurck, da sie als
  * nchste Taste wieder ausgelesen wird.
  * Wenn 'ok' = FALSE, ist der Puffer voll.
  *)

PROCEDURE PutKey ( VAR k: Key; VAR ok: BOOLEAN );
 (*
  * Fgt die Taste in Puffer hinten an, so, als ob die Taste
  * gedrckt worden wre.
  * Wenn 'ok' = FALSE, ist der Puffer voll.
  *)

PROCEDURE ClrKeyBuffer;
 (*
  * Lscht die anstehenden Tasten im Puffer.
  *)

PROCEDURE KeysAvail (): CARDINAL;
 (*
  * Liefert Anzahl der vorhandenen Tasten im Puffer
  *)

PROCEDURE KeyBufferSize (): CARDINAL;
 (*
  * Liefert Fassungsvermgen des Puffers.
  *)

VAR KbdRec: ADDRESS;
 (*
  * Zeigt auf den verwendeten Tastaturpuffer-Descriptor des BIOS.
  * Wird von diesem Modul automatisch initialisiert, kann jedoch
  * bei Bedarf verndert werden.
  *)


(*
 *   Die folgenden beiden Funktionen erlauben es, mehrere Tasten mittels
 * 'PutKey' oder 'PushBackKey' nacheinander in den Puffer zu schreiben,
 * ohne da Tastendrcke von der Tastatur dazwischengeraten knnen.
 * Dazu werden alle Interrupts gesperrt.
 *   Bei ihrer Verwendung ist unbedingt darauf zu achten, da nach dem Aufruf
 * von 'LockKeyBuffer' und dem Einfgen der Tasten wieder 'UnlockKeyBuffer'
 * aufgerufen wird. Auch sollte die Zeit zwischen den beiden Aufrufen so
 * kurz wie mglich gehalten werden.
 *)

PROCEDURE LockKeyBuffer ( VAR hdl: LONGCARD );
 (*
  * Sperrt die Interrupts bis einschl. Level 6. Dabei wird in 'hdl'
  * ein Wert zurckgegeben, der beim Aufruf von 'UnlockKeyBuffer'
  * wieder bergeben werden mu.
  *)

PROCEDURE UnlockKeyBuffer ( hdl: LONGCARD );
 (* Gibt die Interrupts wieder frei *)

END KbdCtrl.
