 IMPLEMENTATION MODULE ModCtrl;
 (*$Y+,P-,V+,C-,R-*)
 
 (* V#115
"15.01.88  TT  GetModName mit Prozedurnamen
"01.04.88  TT  findName fngt Bus/Addr-Error ab.
"02.04.88  TT  InstallModule: Bei unterstem Level wird Basepage, Environment
0und aller allozierter Speicher (ALLOCATE + SysAlloc) resident
0gemacht.
"10.06.88  TT  GetModName: IF-Abfrage vor Prozedurnamen-Ermitteln korrigiert.
"27.08.88  TT  GetModName/findName zerstrt nicht mehr Addr-Error-Exc-Vektor
0und auerdem wird Stack bei Bus/Addr-Error nun auch bei 68020
0richtig wiederhergestellt.
"30.09.88  TT  KeepAll wieder aus InstallModule entfernt;
0ModList und eigenes CODE-Segment/Basepage werden bei DeInstall
0entfert, wenn Prg resident war.
"09.12.88  TT  Residentmachen/Freigabe von gelinktem Modul wird ber 'linked'-
0Flag in 'state' statt ber ModLevel erkannt.
"10.12.88  TT  ReleaseModule holt sich eigene Basepage-Adr via 'GetPDB' statt
0aus 'BaseProcess'.
"04.07.89  TT  Install/ReleaseModule: Residentmachen bei gelinkten Prgs
0erfolgt erst bei deren Prozeende.
"14.07.89  TT  ReleaseModule: Freigabe der base page/tpa geschieht direkt
0ber gemdos.mfree, da sonst Probleme bei residenten Prgs
0auftritt.
"26.07.89  TT  CatchProcessTerm wird nicht doppelt installiert, wenn
0InstallModule doppelt aufgerufen wird.
"09.10.89  TT  GetModName bestimmt Proc-Name nun wieder korrekt;
0falls sourceName bei GetSourceName nicht pat, wird Pfad
0abgeschnitten
"13.06.90  TT  EnterSupervisorMode-Aufrufe raus
"17.07.90  TT  QueryImports neu
"26.09.90  TT  GetProcAddr meldet nicht schon Erfolg, wenn nur der zu kurz
0angegebene Name pat.
"14.02.92  TT  GEMDOS.Super-Aufrufe statt Supexec wg. MinT.
"23.02.92  TT  Anpassung an neues "CreateBasePage".
"24.06.94  TT  Neben FullStorBaseAccess wird nun auch ExtendedMemoryAccess
0beim Residentinstallieren geprft, damit man dieses Flag auch
0noch im Hauptprg. auf FALSE setzen kann. Falls Modul resident
0installiert wird, wird PtermRes erst ganz am Ende aller
0Termination-Handler aufgerufen (bisher passierte dies eher
0gleich am Anfang und so wurden evtl. die restlichen Handler
0zu spt aufgerufen). Falls Ptermres() zum Installieren benutzt
0werden mu, wird dies nicht mehr hier sondern in MOSCtrl
0erledigt.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR, WORD, ADDRESS, DEREF, TSIZE, LONGWORD;
 
 FROM ModBase IMPORT FindRef, ModLst, CallEnvelopes, ModRef, ModStates,
0MarkState, ModState, PtrModHeader, ModHeader,
0CreateBasePage, ExecProcess, ModLoaded, ModStr;
 
 FROM StorBase IMPORT Keep, FullStorBaseAccess;
 
 FROM MOSCtrl IMPORT BaseResident, CallRemoveProcs, GetPDB, PDB,
(TermEntry, ModLevel, PtrPDB;
 
 FROM MOSSupport IMPORT ToSuper, ToUser;
 
 FROM SysTypes IMPORT PtrBP;
 
 FROM MOSGlobals IMPORT IllegalState, MemArea;
 
 FROM PrgCtrl IMPORT TermProcess, TermCarrier, CatchProcessTerm;
 
 FROM Lists IMPORT ResetList, PrevEntry, RemoveEntry, DeleteList, List,
(NextEntry, LDir;
 
 FROM FileNames IMPORT PathConc, SplitPath;
 
 FROM Strings IMPORT Assign, Length, StrEqual, Upper, Delete, Split, Pos;
 
 FROM MOSConfig IMPORT ExtendedMemoryAccess;
 
 
 VAR caught,ok,error:BOOLEAN;
$wsp: MemArea;
$tcarrier: TermCarrier;
$MakeResident, madeResident: BOOLEAN;
 
 PROCEDURE findNameAddr (modhead,name:ADDRESS): ADDRESS;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; Format der Namen vor Procs:
(;   ... code ... RTS
(;   0-Byte auf gerade Adr.
(;   Name mit Null am Ende
(;   [0-Byte f. SYNC]
(;   Ptr auf vorige Proc hinter diesen Ptr
(;
(SUBQ.L  #4,A3
(SUBQ.L  #4,A7
(JSR     ToSuper
(
(LEA     err2(PC),A0
(MOVE.L  8,D0
(MOVE.L  A0,8            ; Bus error
(MOVE.L  12,D1
(MOVE.L  A0,12           ; Addr error
(
(MOVE.L  (A3),A2         ; rel
(MOVE.L  -(A3),A0        ; mod
(MOVE.L  ModHeader.body(A0),D1
%l: MOVE.L  D1,A1
(ADDA.L  A0,A1           ; A1 zeigt auf Proc-Beginn (hinter Namen)
(
(MOVEM.L D1/A1/A2,(A3)   ; D1/A1/A2 retten
(SUBQ.L  #6,A1
%m: TST.B   -(A1)
(BNE     m
(ADDQ.L  #1,A1           ; nun zeigt A1 auf Namen
(; vergleichen
%n: MOVE.B  (A1)+,D1
(BEQ     found
(CMPI.B  #'a',D1
(BCS     o
(CMPI.B  #'z',D1
(BHI     o
(SUBI.B  #32,D1
%o: CMP.B   (A2)+,D1
(BEQ     n
(MOVEM.L (A3),D1/A1/A2
(
(MOVE.L  -(A1),D1        ; Vorgnger-Proc
(BEQ     e               ; nicht gefunden ('rel' zu klein)
(BRA     l
%err2
(SUBA.W  #14,A7          ; Bus/Addr-Error, SSP korrigieren
(MOVEQ   #0,D1
(BRA     e
%found:
(TST.B   (A2)            ; auch Name im Code zuende?
(BNE     l               ; nein: weitersuchen
(MOVEM.L (A3),D1/A1/A2
%e: MOVE.L  D1,(A3)+
(
(MOVE.L  D0,8            ; Bus error
(MOVE.L  D1,12           ; Addr error
(
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END findNameAddr;
"(*$L=*)
 
 PROCEDURE GetProcAddr (mname: ARRAY OF CHAR; VAR location: ADDRESS);
"VAR dummy, pname: ARRAY [0..39] OF CHAR; withPN, getBody, ok: BOOLEAN;
&code: ADDRESS; ref0: ModRef;
"BEGIN
$Upper (mname);
$withPN:= Pos ('.', mname, 0) > 0;
$IF withPN THEN
&Split (mname, Pos ('.', mname, 0), mname, pname, ok);
&Delete (pname, 0, 1, ok);
&IF pname[0]=0C THEN
(withPN:= FALSE
&ELSE
(getBody:= StrEqual (pname, mname);
&END
$END;
$location:= NIL;
$IF ModLoaded (mname, FALSE, dummy, ref0) THEN
&IF withPN THEN
(code:= ref0^.header;
(IF getBody THEN
*location:= code + ref0^.header^.body
(ELSIF procSym IN ref0^.state THEN
*location:= findNameAddr (code, ADR (pname));
*IF location # NIL THEN INC (location, LONGCARD(code)) END;
(END
&ELSE
(location:= ref0^.codeStart
&END
$END
"END GetProcAddr;
 
 (*$H+*)
 PROCEDURE ProcQuery (REF modName: ARRAY OF CHAR;
9call   : ProcQueryProc;
5VAR ok     : BOOLEAN);
"VAR dummy: ModStr; ref0: ModRef; p, pa: ADDRESS; pn: LONGCARD;
"TYPE PL = POINTER TO LONGCARD;
'PC = POINTER TO CHAR;
'PS = POINTER TO ARRAY [0..39] OF CHAR;
"BEGIN
$ok:= FALSE;
$IF ModLoaded (modName, FALSE, dummy, ref0) THEN
&WITH ref0^ DO
(IF (procSym IN state) THEN
*(*  ... code ... RTS
.0-Byte auf gerade Adr.
.Name mit Null am Ende
.0-Byte f. SYNC]
.Ptr auf vorige Proc hinter diesen Ptr *)
*pn:= header^.body; (* Beim Body fngt die Kette rckw. an *)
*WHILE pn # 0 DO
,p:= ADDRESS(header) + pn; (* Proc-Adr. absolut *)
,pa:= p; (* Proc-Adr. merken *)
,DEC (p, 4); (* zum Ptr vor Name *)
,pn:= DEREF (PL(p));
,DEC (p, 3); (* zum Ende des Namens *)
,WHILE DEREF(PC(p)) # 0C DO DEC (p) END; (* zum Beginn d. Namens *)
,call (DEREF (PS(p+1)), pa)
*END;
*ok:= TRUE
(END;
&END; (* WITH *)
$END
"END ProcQuery;
 
 PROCEDURE ModQuery ( call: ModQueryProc );
"VAR l:List; m: ModRef;
"BEGIN
$l:=ModLst;
$ResetList (l);
$LOOP
&m:= NextEntry (l);
&IF m = NIL THEN EXIT END;
&WITH m^ DO
(call ( codeName^, codeStart, codeLen, varRef, varLen,
/fileName (*PathConc (fileName, filePath)*),
/~(program IN state), loaded IN state,
/(installed IN state) OR (linked IN state) );
&END;
$END
"END ModQuery;
 
 PROCEDURE QueryImports (REF client: ARRAY OF CHAR; call: ModQueryProc);
"VAR dummy: ModStr; ref0: ModRef; imp: POINTER TO ModRef;
"BEGIN
$IF ModLoaded (client, FALSE, dummy, ref0) THEN
&imp:= ADDRESS (ref0^.imports);
&IF imp # NIL (* existiert Importliste? *) THEN
(WHILE imp^ # NIL DO
*WITH imp^^ DO
,call (codeName^, codeStart, codeLen, varRef, varLen,
2fileName (*PathConc (fileName, filePath)*),
2~(program IN state), loaded IN state,
2(installed IN state) OR (linked IN state))
*END;
*INC (imp, 4)
(END
&END
$END
"END QueryImports;
 (*$H-*)
 
 
 PROCEDURE findName (modhead:ADDRESS;rel:LONGCARD): ADDRESS;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; Format der Namen vor Procs:
(;   ... code ... RTS
(;   0-Byte auf gerade Adr.
(;   Name mit Null am Ende
(;   [0-Byte f. SYNC]
(;   ^ auf vorige Proc hinter diesen ^ (rel. zu header!)
(;
(SUBQ.L  #4,A3
(SUBQ.L  #4,A7
(JSR     ToSuper
 
(LEA     err2(PC),A0
(MOVE.L  8,-(A7)
(MOVE.L  A0,8            ; Bus error
(MOVE.L  12,-(A7)
(MOVE.L  A0,12           ; Addr error
(MOVE.L  A7,A2
 
(MOVE.L  (A3),D0         ; rel
(MOVE.L  -(A3),A0        ; header
(ADD.L   ModHeader.codeStart(A0),D0
(MOVE.L  ModHeader.body(A0),D1
 
%l: MOVE.L  D1,A1           ; rel. Proc-Beginn
(ADDA.L  A0,A1           ; abs. Proc-Beginn
(CMP.L   D1,D0
(BCC     found
(MOVE.L  -(A1),D1        ; Vorgnger-Proc
(BEQ     e               ; nicht gefunden ('rel' zu klein)
(BRA     l
%err2
(MOVE.L  A2,A7           ; Bus/Addr-Error, SSP korrigieren
(MOVEQ   #0,D1
(BRA     e
%found:
(SUBQ.L  #6,A1
%m: TST.B   -(A1)
(BNE     m
(ADDQ.L  #1,A1
(MOVE.L  A1,D1
%e: MOVE.L  D1,(A3)+
(
(MOVE.L  (A7)+,12        ; Addr error
(MOVE.L  (A7)+,8         ; Bus error
$
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END findName;
"(*$L=*)
 
 PROCEDURE GetModName ( Ad          : Address;
7VAR modul   : ARRAY OF Char;
7VAR relAddr : LONGCARD;
7VAR procName: ARRAY OF CHAR );
"VAR i: ModRef; n: POINTER TO ARRAY [0..79] OF CHAR;
"BEGIN
$FindRef (ad,i);
$relAddr:= 0L;
$procName[0]:= 0C;
$IF i=NIL THEN
&modul[0]:= 0C;
$ELSE
&Assign (i^.codename^,modul,ok);
&relAddr:= ad - i^.codeStart;
&IF procSym IN i^.state THEN
(n:= findName (i^.header, relAddr);
(IF n # NIL THEN
*Assign (n^, procName, ok)
(END
&END;
&IF crunched IN i^.state THEN
(relAddr:= 0L (* wurde vorher noch gebraucht ! *)
&END
$END
"END GetModName;
 
 
 VAR dummy: ADDRESS;
 
 PROCEDURE CatchProcessTermLast (VAR hdl: TermCarrier; call: Proc; wsp: MemArea);
"(*
#* Proc ganz ans Ende der Term-Liste, damit diese Routine als ALLERLETZTE
#* aufgerufen wird.
#* Zudem wird die Routine im untersten PDB, also dem des gelinkten Prozesses,
#* installiert.
#*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(CLR.L   -(A7)
(MOVE.L  A7,(A3)+
(MOVE.L  #dummy,(A3)+
(JSR     GetPDB
(MOVE.L  (A7)+,A0
(MOVE.L  A0,D0
(BEQ     noMod
(; untersten PDB finden
&findBottom:
(MOVE.L  PDB.prev(A0),D0
(BEQ     foundBottom
(MOVE.L  D0,A0
(BRA     findBottom
&foundBottom:
(; Ende der Term-Liste finden
&findEnd:
(MOVE.L  PDB.TermProcs(A0),D1
(BEQ     foundEnd
(MOVE.L  D1,A0
(BRA     findEnd
&foundEnd:
(MOVE.L  -(A3),D2
(MOVE.L  -(A3),A2
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A1
(MOVE.L  A1,PDB.TermProcs(A0)    ; pdb.TermProcs:= ADR (hdl)
(CLR.L   TermEntry.next(A1)      ; hdl.next:= NIL (end of list)
(MOVE.L  D0,TermEntry.call(A1)   ; hdl.call:= call
(MOVE.L  D2,TermEntry.wsp.length(A1)
(MOVE.L  A2,TermEntry.wsp.bottom(A1)
(RTS
&noMod:
(TRAP    #6
(DC.W    -14     ; Ill. call
(SUBA.W  #$10,A3
$END
"END CatchProcessTermLast;
"(*$L+*)
 
 PROCEDURE termination;
"VAR p: PtrPDB; pr: ADDRESS; bp: PtrBP;
"BEGIN
$IF MakeResident & madeResident THEN
&madeResident:= TRUE;
&GetPDB (p,pr);
&bp:= p^.basePageAddr;
&Keep (bp);
&Keep (bp^.p_env)
$END
"END termination;
 
 PROCEDURE InstallModule (removalInfo: PROC; wsp: MemArea);
"VAR i:ModRef; ad:Address; inst: BOOLEAN;
"BEGIN
$ASSEMBLER
&MOVE.L  4(A5),ad(A6)       ; RTS-Adr. v.Stack
$END;
$FindRef (ad,i);
$inst:= FALSE;
$IF i=NIL THEN
&(* Ist wohl ein gelinktes, optimiertes Modul *)
&inst:= TRUE;
$ELSIF ~(installed IN i^.state) THEN
&Incl (i^.state,installed);
&i^.removeInfo:= removalInfo;
&i^.removeWsp:= wsp;
&IF linked IN i^.state THEN
(inst:= TRUE;
&END
$END;
$IF inst THEN
&(*
'* Das Residentmachen des eigenen Programmbereichs & basepage
'* erfolgt erst beim Prozeende, falls dann MakeResident noch TRUE ist.
'*)
&IF NOT caught & FullStorBaseAccess () & ExtendedMemoryAccess THEN
(CatchProcessTermLast (tcarrier, termination, wsp);
(MakeResident:= TRUE;
(madeResident:= FALSE;
(caught:= TRUE
&ELSE
((*
)* Prg mu mit Ptermres() resident gemacht werden.
)* Das wird automatisch in MOSCtrl erledigt.
)*)
(BaseResident:= TRUE;
&END
$END
"END InstallModule;
 
 
 PROCEDURE Mfree (ad: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.W  #$49,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END Mfree;
"(*$L=*)
 
 PROCEDURE ReleaseModule;
"VAR i:ModRef; ad:Address; p: PtrPDB; pr: ADDRESS; bp: PtrBP; deinst: BOOLEAN;
"BEGIN
$ASSEMBLER
&MOVE.L  4(A5),ad(A6)       ; RTS-Adr. v.Stack
$END;
$FindRef (ad,i);
$deinst:= FALSE;
$IF i=NIL THEN
&(* Ist wohl ein gelinktes, optimiertes Modul *)
&deinst:= TRUE
$ELSIF installed IN i^.state THEN
&EXCL (i^.state,installed);
&IF (linked IN i^.state) THEN
(deinst:= TRUE;
&END
$END;
$IF deinst & (MakeResident OR BaseResident) THEN
&BaseResident:= FALSE;
&MakeResident:= FALSE;
&IF ModLevel = 0 THEN
((*
)* Nur eigene Freigabe, wenn DeInstall nicht noch vor Ende des
)* eigenen Prozesses, unter dem auch Installed wurde, aufgerufen
)* wird.
)*)
(CallRemoveProcs; (* Hierber wird auch 'removal' in ModBase aufgerufen *)
((*
)* Auch der eigene Programmplatz wird freigegeben -> Vorsicht !
)*)
(IF madeResident THEN
*GetPDB (p, pr);
*bp:= p^.basePageAddr;
*Mfree (bp^.p_env);(* nicht DEALLOCATE verwenden, weil durch         *)
*Mfree (bp);       (* Removal-Aufrufe bereits Storage abgemeldet ist!*)
*(*
+* Hiernach mu das Programm selbst enden !
+*)
)END
&END;
$END
"END ReleaseModule;
 
 
 PROCEDURE FirstModuleStart ():Boolean;
"VAR i:ModRef; ad:Address;
"BEGIN
$ASSEMBLER
&MOVE.L  4(A5),ad(A6)       ; RTS-Adr. v.Stack
$END;
$FindRef (ad,i);
$IF i=NIL THEN
&(* Ist wohl ein gelinktes, optimiertes Modul *)
&RETURN TRUE
$ELSE
&RETURN (firstCall IN i^.state) OR (linked IN i^.state)
$END
"END FirstModuleStart;
 
 
 PROCEDURE GetOwnName (VAR codeName: ARRAY OF CHAR);
"VAR i:ModRef; ad:Address;
"BEGIN
$ASSEMBLER
&MOVE.L  4(A5),ad(A6)       ; RTS-Adr. v.Stack
$END;
$codename[0]:=0C;
$FindRef (ad,i);
$IF i=NIL THEN
&(* Ist wohl ein gelinktes, optimiertes Modul *)
&codeName[0]:= 0C
$ELSE
&Assign (i^.codeName^,codeName,ok)
$END
"END GetOwnName;
 
 
 PROCEDURE GetSourceName ( REF codeName  : ARRAY OF CHAR;
:VAR sourceName: ARRAY OF CHAR;
:VAR opts      : LONGWORD );
"VAR r:ModRef; mname:ModStr; path: ARRAY [0..127] OF CHAR;
&p: POINTER TO ModStr;
"BEGIN
$IF ModLoaded (codename,FALSE,mname,r) & ~(program IN r^.state) THEN
&p:= ADDRESS (r^.header) + r^.header^.sourceName;
&Assign (p^, sourceName, ok);
&IF ~ ok THEN
(SplitPath (p^, path, sourceName)
&END;
&opts:= r^.header^.options
$ELSE
&sourceName[0]:=0C;
&opts:= LONGWORD (0L)
$END
"END GetSourceName;
 
 
 PROCEDURE CallProcess (    pro      : PROC;
;workSpace: MemArea;
7VAR ok       : BOOLEAN;
7VAR exitCode : INTEGER );
 
"VAR bp: PtrBP; termState: CARDINAL; noStr: CHAR;
"
"BEGIN (* CallProcess *)
$noStr:= 0C;
$ok:= CreateBasePage (bp, 0, ADR(noStr), LONGCARD(7));
$IF ok THEN
&WITH bp^ DO
(p_lowtpa:= workSpace.bottom;
(p_hitpa:= p_lowtpa + workSpace.length
&END;
&ExecProcess (bp, pro, ADR(noStr), LONGCARD(7), termState, exitCode);
&ok:= termState = 2;
&Mfree (bp^.p_env);
&Mfree (bp)
$END
"END CallProcess;
 
 END ModCtrl.
 
(* $FFEFFD49$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$00000002$FFFADB5A$00003A27$FFFADB5A$00002803$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$FFFADB5A$00000002T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00002984$00002D40$00002D14$000029BE$000029AB$00003201$00003307$00003311$000030B6$00003086$000008E4$00000002$00000CBD$0000299F$00002993$00000CBD*)
