 IMPLEMENTATION MODULE Paths; (* V#077 *)
 
 (*$Y+,R-*)
 
 (*
 IMPORT TOSDebug;
 *)
 
 (*
 01.04.88: TT  SearchFile: wenn Abbruch bei fileselect, wird Leername
0geliefert; kein Stringoverflow bei '?'/OK.
 02.08.89: TT  Append durch Assign ersetzt
 04.05.90  TT  SearchFile: leerer Dateiname fhrt nicht mehr zur Suche
 12.05.90  TT  Aufruf von Fileselector bernimmt Namen nun endlich wieder
 16.05.90  TT  Validate bei SetHomePath
 25.06.90  TT  Aufteilung in Paths/PathEnv/PathCtrl
 11.11.90  TT  Wenn Datei gefunden, wird trotzdem Fsnext aufgerufen, um
.GEMDOS-Strukturen zurckzusetzen
 25.04.91  TT  Fsnext nur noch bei TOS 1.0 & 1.2
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR, ADDRESS;
 
 FROM Lists IMPORT NextEntry, EndOfList, ResetList, ListEmpty, LCarrier;
 
 FROM MOSGlobals IMPORT PathStr, FileStr, NameStr, MemArea;
 
 FROM Directory IMPORT DefaultDrive, GetDefaultPath,
(DTA, GetDTA, SetDTA, MakeFullPath, DirEntry, GetDTAEntry;
 
 FROM FileNames IMPORT DriveToStr, SplitPath, ConcatPath, ValidatePath;
 
 IMPORT Strings, FastStrings;
 
 FROM PathCtrl IMPORT PathList;
 
 FROM PathEnv IMPORT SelectFile, ReplaceHome;
 
 FROM Storage IMPORT ALLOCATE, DEALLOCATE;
 
 
 VAR needFsnext, ok: BOOLEAN;
 
 PROCEDURE check ( REF name: ARRAY OF CHAR ): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
((*
(TST.W   TOSDebug.Hex
(BEQ     noBrk
(BREAK
&noBrk
(*)
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(CLR.B   0(A0,D0.W)      ; Null an Namensende
(CLR.W   -(A7)           ; attrib, only files
(MOVE.L  A0,-(A7)        ; ^name
(MOVE    #$4E,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #8,A7
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END;
"END check;
"(*$L=*)
 
 PROCEDURE checkNext; (* gibt DTA-Puffer wieder frei, indem bis zum Ende
6* gesucht wird *)
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST.W   needFsnext
(BEQ     ende
&again
(MOVE    #$4F,-(A7)
(TRAP    #1              ; Fsnext
(ADDQ.L  #2,A7
(TST.L   D0
(BPL     again
&ende
$END;
"END checkNext;
"(*$L=*)
 
 (*$D-*)
 
 PROCEDURE prepare (VAR name: ARRAY OF CHAR; VAR fsel: BOOLEAN);
"BEGIN
$ReplaceHome (name);
$fsel:= (name[0] = FSelSymbol);
$IF fsel THEN
&Strings.Delete (name, 0, 1, ok)
$END;
"END prepare;
 
 PROCEDURE getName (dta: DTA; VAR resultName: ARRAY OF CHAR);
"VAR entry: DirEntry;
"BEGIN
$GetDTAEntry (dta, entry);
$ConcatPath (resultName, entry.name, resultName)
"END getName;
 
 PROCEDURE doFSel (REF  firstPath: ARRAY OF CHAR;
2dta: DTA;
2VAR pathName, name: ARRAY OF CHAR;
2VAR resultName: ARRAY OF CHAR;
2VAR abort, found: BOOLEAN );
"VAR sfx: ARRAY [0..3] OF CHAR; res: INTEGER; ok: BOOLEAN;
"BEGIN
$FastStrings.Copy ( name, Strings.PosLen ('.',name,1), 4, sfx );
$IF (pathName[0]=0C) AND (firstPath[0]#0C) THEN
&Strings.Assign (firstPath, pathName, ok);
$END;
$MakeFullPath (pathName, res);
$IF res < 0 THEN
&GetDefaultPath (pathName);
$END;
$IF sfx[0]=0C THEN sfx:= '.*' END;
$Strings.Append ('*', pathName, ok);
$FastStrings.Append (sfx, pathName);
$SelectFile ('',pathName,name,ok);
$IF ok THEN
&abort:= FALSE;
&ConcatPath ( pathName, name, resultName );
&found:= check (resultName);
&IF found THEN getName (dta, resultName); checkNext END
$ELSE
&abort:= TRUE;
&found:= FALSE;
&resultName[0]:= 0C (* bei Abbruch keinen Namen liefern *)
$END;
"END doFSel;
 
 PROCEDURE SearchFile ( REF iname: ARRAY OF CHAR; VAR path: PathList; start: ListPos;
7VAR found: BOOLEAN; VAR resultName: ARRAY OF CHAR );
 
"VAR pathName, firstPath: PathStr; firstname: FileStr;
&name: ARRAY [0..11] OF CHAR;
&p: POINTER TO PathStr; fsel, abort, firstChecked: BOOLEAN;
&olddta, dta: DTA;
 
"PROCEDURE find (VAR path: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&FastStrings.Concat (path,name,resultName);
&found:= check (resultName);
&IF found THEN getName (dta, resultName); checkNext END;
&RETURN found
$END find;
 
"PROCEDURE myFSel;
$BEGIN
&doFSel (firstPath, dta, pathName, name, resultName, abort, found)
$END myFSel;
 
"PROCEDURE clrup;
$BEGIN
&DISPOSE (dta);
&SetDTA (olddta)
$END clrup;
 
"BEGIN
$found:= FALSE;
$
$(*
$IF Strings.StrEqual ('RUNTIME.DEF', iname) THEN
&TOSDebug.Active:= TRUE;
&TOSDebug.Step:= 0
$END;
$*)
$
$FastStrings.Assign (iname, firstname);
$prepare (firstname, fsel);
$SplitPath (firstname, firstPath, name);
$IF name [0] = 0C THEN
&resultName[0]:= 0C;
&RETURN
$END;
$
$GetDTA (olddta);
$NEW (dta);
$IF dta # NIL THEN SetDTA (dta) END;
$
$pathName:= '';
$firstChecked:= (start=fromStart);
$IF firstChecked THEN
&ResetList (path);
&IF fsel THEN
(myFSel;
(IF abort OR found THEN clrup; RETURN END
&ELSIF ListEmpty (path) OR (firstPath[0]#0C) THEN
((* Zuerst angegebenen Path prfen *)
(IF find (firstPath) THEN clrup; RETURN END;
&END
$END;
$(* Jetzt die PathList durchsuchen *)
$LOOP
&p:= NextEntry(path);
&IF p=NIL THEN EXIT END;
&FastStrings.Assign (p^, pathName);
&prepare (pathName, fsel);
&ValidatePath (pathName);
&IF fsel THEN
(myFSel;
(IF abort OR found THEN clrup; RETURN END
&ELSE
(IF ~ (firstChecked & Strings.StrEqual (firstPath,pathName) )
(AND find (pathName) THEN clrup; RETURN END
&END
$END;
$clrup;
$Strings.Assign(firstname,resultName,ok)
"END SearchFile;
 
 (*$D-*)
 
 PROCEDURE MakeFullName ( VAR name: ARRAY OF CHAR; maySelect: BOOLEAN; VAR ok: BOOLEAN );
"VAR shortname: NameStr; pathName: PathStr; res: INTEGER; olddta, dta: DTA;
&abort, fsel: BOOLEAN;
"BEGIN
$ok:= TRUE;
$GetDTA (olddta);
$NEW (dta);
$IF dta # NIL THEN SetDTA (dta) END;
$prepare (name, fsel);
$IF maySelect & fsel THEN
&SplitPath (name, pathName, shortname);
&doFSel ('', dta, pathName, shortname, name, abort, ok)
$END;
$MakeFullPath (name, res);
$IF ok AND (res >= 0) THEN
&ok:= check (name);
&IF ok THEN getName (dta, name); checkNext END
$ELSE
&ok:= FALSE
$END;
$DISPOSE (dta);
$SetDTA (olddta)
"END MakeFullName;
 
 PROCEDURE FullName ( REF name: ARRAY OF CHAR; maySelect: BOOLEAN ): FileStr;
"VAR fullname: FileStr;
"BEGIN
$Strings.Assign (name, fullname, ok);
$MakeFullName (fullname, maySelect, ok);
$RETURN fullname
"END FullName;
 
 BEGIN
"ASSEMBLER
(BRA     c
%t: MOVE.L  $4F2,A0         ; ^TOS-Header
(MOVE.L  8(A0),D0        ; wg. altem AHDI
(RTS
%c: PEA     t(PC)
(MOVE    #38,-(A7)
(TRAP    #14             ; Supexec
(ADDQ.L  #6,A7
(MOVE.L  D0,A0
(MOVE.W  2(A0),D1
(CMPI    #$0104,D1
(SCS     D0
(ANDI    #1,D0
(MOVE    D0,needFsnext
"END
 END Paths.
 
(* $FFF8727B$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFED4934$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$00000FD8$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$FFFD5105$00000291T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001947$00001922$00000768$0000074F$00000768$000007DC$00000768$000004D5$000001F6$00000294$00000267$00000270$00000291$00001825$00001919$00001951*)
