 IMPLEMENTATION MODULE Strings;
 (*$Y+,R-,L-,N+*)
 (* V#075 *)
 
 (*
!4. 7.87  Reg-Save geprft / ok
 16.10.87  Append neu, Compare korrigiert (war fehlerhaft, wenn str1 voll)
 13.01.88  Compare korrigiert f. Umlaute
 19.02.88  Assign: konnte Fehler machen, wenn source-Str voll und D0.L#0
 01.04.88  Pos: fand nix, wenn source voll; PosLen beschleunigt
 18.06.88  Upper/Lower: 0C-Abfrage -> jetzt schneller
 13.08.88  Upper/Lower: jetzt noch schneller, da Tabelle verwendet; gleich-
*zeitig werden nun auch frz. Akzente usw. bercksichtigt.
 14.08.89  Chr neu
 16.09.89  Compare: MOVEM.W durch .L, weil sonst D3-D5 verndert wurden
 20.09.89  Wegen REF-Parms wird Fehler ausgelst, wenn bei Insert, Copy
*oder Append 'source' und 'dest' dieselben Adressen sind.
 23.11.89  Pos: wenn start = Length (source), kamen falsche Erg., nun -1
 09.01.90  Keine Fehlermeldung mehr, wenn bei Copy, Insert oder Append
*source mit dest identisch ist. Stattdessen wird dann der String
*lokal auf den Stack kopiert. Das gleiche geht nun auch bei
*Split und Concat, soda auch sie nun REF-Parms bekommen knnen
*Ist allerdings noch nicht getestet!
 06.05.90  LINK wird bei copyAnOnStack-Anwendungen NACH MOVEM gemacht, weil
*sonst ggf. das Rckladen der Regs nicht funktionieren wrde
 20.07.90  DelTrailingBlanks geht nun
 20.10.90  Insert: MOVE SR durch SCC ersetzt; Compare & StrEqual beschleunigt.
 26.11.90  Lower: "" wird nun korrekt umgesetzt (blieb bisher gro).
 04.12.90  copyA0/1OnStack: Jetzt wird nicht mehr evtl. ein Byte zuviel kopiert,
*was bei einer 68020 zu einem Busfehler kommen liee.
 05.02.91  Compare bei Umlauten korrigiert und getestet (mit 'MakeUpper').
 04.02.92  Append berschreibt nicht mehr Byte hinter dest-String mit 0, wenn
*dest vollst. gefllt wird und src mit 0C endet.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 IMPORT MOSGlobals;
 
 
 PROCEDURE copyA1OnStack;
"(*
#* Kopiert String in A1/D1.W auf Stack und korrigiert A1
#*)
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,(A3)+     ; Rcksprung-Adr retten
(MOVE.L  A0,(A3)+        ; A0 retten
(MOVE.W  D1,(A3)+        ; D1 retten
(ADDQ    #2,D1
(BCLR    #0,D1           ; SYNC D1
(SUBA.W  D1,A7
(CMPA.L  A3,A7
(BCC     N
(TRAP    #6
(DC.W    MOSGlobals.OutOfStack
&N MOVE.L  A7,A0
(MOVE.W  -2(A3),D1
&L MOVE.B  (A1)+,(A0)+
(DBEQ    D1,L
(MOVE.L  A7,A1
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(MOVE.L  -(A3),-(A7)     ; und Rcksprung
$END
"END copyA1OnStack;
 
 PROCEDURE copyA0OnStack;
"(*
#* Kopiert String in A0/D0.W auf Stack und korrigiert A0
#*)
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,(A3)+     ; Rcksprung-Adr retten
(MOVE.L  A1,(A3)+        ; A1 retten
(MOVE.W  D0,(A3)+        ; D0 retten
(ADDQ    #2,D0
(BCLR    #0,D0           ; SYNC D0
(SUBA.W  D0,A7
(CMPA.L  A3,A7
(BCC     N
(TRAP    #6
(DC.W    MOSGlobals.OutOfStack
&N MOVE.L  A7,A1
(MOVE.W  -2(A3),D0
&L MOVE.B  (A0)+,(A1)+
(DBEQ    D0,L
(MOVE.L  A7,A0
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),-(A7)     ; und Rcksprung
$END
"END copyA0OnStack;
 
 PROCEDURE EatSpaces ( VAR str: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(ADDQ    #1,D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,A1
&L SUBQ    #1,D0
(BCS     E
(MOVE.B  (A0)+,D1
(BEQ     E
(CMPI.B  #' ',D1
(BEQ     L
(MOVE.B  D1,(A1)+
(BRA     L
&E CMPA.L  A0,A1
(BEQ     F
(CLR.B   (A1)
&F
$END
"END EatSpaces;
 
 PROCEDURE DelBlanks ( VAR str: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(ADDQ    #1,D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,A1
&L SUBQ    #1,D0
(BCS     E
(MOVE.B  (A0)+,D1
(BEQ     E
(CMPI.B  #9,D1           ; TAB
(BEQ     L
(CMPI.B  #' ',D1
(BEQ     L
(MOVE.B  D1,(A1)+
(BRA     L
&E CMPA.L  A0,A1
(BEQ     F
(CLR.B   (A1)
&F
$END
"END DelBlanks;
 
 PROCEDURE DelLeadingBlanks ( VAR s: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(ADDQ    #1,D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,A1
(MOVEQ   #1,D2
(
(SUBQ    #1,D0
(BCS     E
(MOVE.B  (A0)+,D1
(BEQ     E
(CMPI.B  #9,D1           ; TAB
(BEQ     L
(CMPI.B  #' ',D1
(BNE     F
 
&L SUBQ    #1,D0
(BCS     E
(MOVE.B  (A0)+,D1
(BEQ     E
(TST     D2
(BEQ     N
(CMPI.B  #9,D1           ; TAB
(BEQ     L
(CMPI.B  #' ',D1
(BEQ     L
(MOVEQ   #0,D2
&N MOVE.B  D1,(A1)+
(BRA     L
&E CMPA.L  A0,A1
(BEQ     F
(CLR.B   (A1)
&F
$END
"END DelLeadingBlanks;
 
 PROCEDURE DelTrailingBlanks ( VAR s: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(ADDQ    #1,D0
(MOVE.L  -(A3),A0
(MOVE.L  A0,A2
&L SUBQ    #1,D0
(BCS     E
(MOVE.B  (A0)+,D1
(BEQ     E
(CMPI.B  #9,D1           ; TAB
(BEQ     L
(CMPI.B  #' ',D1
(BEQ     L
(MOVE.L  A0,A2
(BRA     L
&E CMPA.L  A0,A2
(BEQ     F
(CLR.B   (A2)
&F
$END
"END DelTrailingBlanks;
 
 PROCEDURE Chr (REF s:ARRAY OF CHAR;n:CARDINAL):CHAR;
"BEGIN
$ASSEMBLER
(MOVEQ   #0,D2
(MOVE.W  -(A3),D1
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(CMP.W   D0,D1
(BHI     null
&l MOVE.B  (A0)+,D2
(DBEQ    D1,l
&null
(MOVE.B  D2,(A3)+
(ADDQ.L  #1,A3
$END
"END Chr;
 
 PROCEDURE Empty ( REF str: ARRAY OF CHAR ): BOOLEAN;
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A3
(MOVE.L  -(A3),A0
(TST.B   (A0)
(SEQ     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END Empty;
 
 PROCEDURE Pos ( REF pattern, source: ARRAY OF CHAR; start: INTEGER ): INTEGER;
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE    -(A3),D6         ;start
(MOVE    -(A3),D0         ;HIGH(source)
(MOVE.L  -(A3),A0         ;source
(MOVE    -(A3),D5         ;HIGH(pattern)
(MOVE.L  -(A3),A1         ;pattern
(
(TST.B  (A1)
(BEQ    null             ; pattern = ''
(
(TST     D6              ; start mu >= 0 sein
(BPL     c1
(MOVEQ   #0,D6
(
 c1      MOVEQ  #0,D2
 l1      ; Test, ob start hinter Stringende
(TST.B  0(A0,D2.W)       ; A0: ADR (source)
(BEQ    null             ; erst prfen, ob Stringende
(CMP    D6,D2
(BEQ    st0              ; dann erst Start prfen
(ADDQ   #1,D2
(CMP    D0,D2            ; D0: HIGH (source)
(BLS    l1
(BRA    null
 
 st0:    MOVE   D2,D3            ; D2 ist neuer Startwert
(MOVEQ  #0,D1
(;D1:=Index in pattern
(;D3:=Index in source
(MOVE.B 0(A1,D1.W),D4
 !vergl  ; pattern nicht zu Ende -> prfen, ob source nicht schon zu Ende
(CMP    D0,D3
(BHI    null             ; source schon zu Ende -> kein Sinn mehr
(CMP.B  0(A0,D3.W),D4
(BNE    nequ
(CMP    D5,D1            ; pattern zu Ende -> gefunden
(BEQ    ok
(ADDQ   #1,D1
(ADDQ   #1,D3
(MOVE.B 0(A1,D1.W),D4
(BNE    vergl
(; pattern zu Ende -> gefunden
 ok      MOVE   D2,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
(RTS
 nequ    ADDQ   #1,D2
(TST.B  0(A0,D2.W)
(BNE    st0              ; HIGH-Grenze wird gleich geprft
(; source zu Ende -> nicht gefunden
 !null   MOVE   #-1,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
"END
 END Pos;
 
 PROCEDURE PosLen ( REF pattern, source: ARRAY OF CHAR; pos: INTEGER ): CARDINAL;
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE    -(A3),D6         ;start
(MOVE    -(A3),D0         ;HIGH(source)
(MOVE.L  -(A3),A0         ;source
(MOVE    -(A3),D5         ;HIGH(pattern)
(MOVE.L  -(A3),A1         ;pattern
(
(TST.B  (A1)
(BEQ    nullf            ; pattern = ''
(
(TST     D6
(BPL     c1
(MOVEQ   #0,D6
(
 c1      MOVEQ  #0,D2
 l1      ; Test, ob start hinter Stringende
(TST.B  0(A0,D2.W)       ; erst prfen, ob Stringende
(BEQ    null0
(CMP    D6,D2
(BEQ    st0              ; dann erst Start prfen
(ADDQ   #1,D2
(CMP    D0,D2
(BLS    l1
(BRA    null0
 
 st0:    MOVE   D2,D3            ; D2 ist neuer Startwert
(MOVEQ  #0,D1
(;D1:=Index in pattern
(;D3:=Index in source
(MOVE.B 0(A1,D1.W),D4
 !vergl  ; pattern nicht zu Ende -> prfen, ob source nicht schon zu Ende
(CMP    D0,D3
(BHI    null2            ; source schon zu Ende -> kein Sinn mehr
(CMP.B  0(A0,D3.W),D4
(BNE    nequ
(CMP    D5,D1            ; pattern zu Ende -> gefunden
(BEQ    ok
(ADDQ   #1,D1
(ADDQ   #1,D3
(MOVE.B 0(A1,D1.W),D4
(BNE    vergl
(; pattern zu Ende -> gefunden
 ok      MOVE   D2,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
(RTS
 nequ    TST.B  0(A0,D2.W)
(BEQ     null0           ; source war Null-terminiert
(ADDQ   #1,D2
(TST.B  0(A0,D2.W)
(BNE    st0              ; HIGH-Grenze wird gleich geprft
(; source zu Ende -> nicht gefunden
 !null0  MOVE.W  D2,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
(RTS
 !nullf  MOVE.L  A0,(A3)+
(MOVE    D0,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
(JMP     Length
 !null2  MOVE.W  D3,(A3)+
(MOVEM.L (A7)+,D3-D6
(UNLK    A5
"END
 END PosLen;
 
 
 PROCEDURE Concat (REF s1,s2: ARRAY OF CHAR;
2VAR d: ARRAY OF CHAR; VAR success: BOOLEAN);
 BEGIN
"ASSEMBLER
(MOVEM.L D3-D5/A4,-(A7)
(LINK    A5,#0            ;LINK mu wg. copyAnOnStack nach MOVEM stehen!
(MOVE.L  -(A3),A4         ;Adr (success)
(MOVE    -(A3),D5         ;HIGH(dest)
(MOVE.L  -(A3),A2         ;dest
(MOVE    -(A3),D1         ;HIGH(source2)
(MOVE.L  -(A3),A1         ;source2
(MOVE    -(A3),D0         ;HIGH(source1)
(MOVE.L  -(A3),A0         ;source1
(
(CMPA.L  A2,A0
(BNE     notEqu
(JSR     copyA0OnStack
&notEqu
(
(CMPA.L  A2,A1
(BNE     notEqu2
(JSR     copyA1OnStack
&notEqu2
(
(CLR.B   (A2)
(CLR     (A4)            ; success := FALSE
(MOVEQ   #0,D4           ; index f. dest
(MOVEQ   #0,D2           ; index f. source
 loop1   CMP     D0,D2
(BHI     cop2            ; Stringende berschritten
(MOVE.B  0(A0,D2.W),D3
(BEQ     cop2
(CMP     D5,D4           ; pat Zeichen noch in String ?
(BHI     ende0
(MOVE.B  D3,0(A2,D4.W)   ; Zeichen kopieren
(ADDQ    #1,D4
(ADDQ    #1,D2
(BRA     loop1
(
 cop2    MOVEQ   #0,D2           ; index f. source
 loop2   CMP     D1,D2
(BHI     ok              ; Stringende berschritten
(MOVE.B  0(A1,D2.W),D3
(BEQ     ok
(CMP     D5,D4           ; pat Zeichen noch in String ?
(BHI     ende0
(MOVE.B  D3,0(A2,D4.W)   ; Zeichen kopieren
(ADDQ    #1,D4
(ADDQ    #1,D2
(BRA     loop2
(
 ok      MOVE    #1,(A4) ; success := TRUE
(CMP     D5,D4   ; pat 0C noch in String ?
(BHI     ende0
(CLR.B   0(A2,D4.W)
 ende0   UNLK    A5
(MOVEM.L (A7)+,D3-D5/A4
"END
 END Concat;
 
 
 PROCEDURE Length ( REF source: ARRAY OF CHAR ): CARDINAL;
 BEGIN
"ASSEMBLER
(MOVE   -(A3),D1
(MOVE.L -(A3),A0
(MOVE.L A0,D0
 l       TST.B  (A0)+
(DBEQ   D1,l
(BNE    c
(SUBQ.L #1,A0
 c       SUBA.L D0,A0
(MOVE.W A0,(A3)+
"END
 END Length;
 
 PROCEDURE Compare (REF str0,str1: ARRAY OF CHAR) : Relation;
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(CLR.W   D2
 
 l       MOVE.B  (A0)+,D2
(BEQ     equ1
(CMP.B   (A1)+,D2
(BNE     ne
(SUBQ    #1,D0
(BCS     e
(DBRA    D1,l
 
(; str1 zu Ende, str0 aber nicht
(TST.B   (A0)+
(BEQ     equ0
(BRA     hi
 
 equ1    ; str0 zu Ende, str1 prfen
(TST.B   (A1)+
(BEQ     equ0
(BRA     low
 
 ne      LEA     tab(PC),A2
(MOVE.B  0(A2,D2.W),D1
(MOVE.B  -(A1),D0
(CMP.B   0(A2,D0.W),D1
(BHI     hi
(BCS     low
(CMP.B   D0,D2   ; wenn Umlaute gleich, dann ASCII-Wert vergleichen
(BHI     hi
(BRA     low
 
 e       ; str0 zu Ende, str1 prfen
(TST     D1
(BEQ     equ0
(TST.B   (A1)+
(BNE     low
 
 equ0    MOVE    #equal,(A3)+
(RTS
 hi      MOVE    #less,(A3)+
(RTS
 low     MOVE    #greater,(A3)+
(RTS
 
 tab     DC.B    $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B    $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B    $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F
(DC.B    $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F
(DC.B    $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F
(DC.B    $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F
(DC.B    $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F
(DC.B    $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F
(DC.B    'C','u','e','a','a','a','a','c','e','e','e','i','i','i','A','A'
(DC.B    'E','a','A','o','o','o','u','u','y','O','U',$9B,$9C,$9D,'s',$9F
(DC.B    'a','i','o','u','n','N','a','o',$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF
(DC.B    'a','o','O','o','o','O','A','A','O',$B9,$BA,$BB,$BC,$BD,$BE,$BF
(DC.B    'i','I',$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF
(DC.B    $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF
(DC.B    $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF
(DC.B    $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
$END
"END Compare;
 
 PROCEDURE StrEqual ( REF str1, str2: ARRAY OF CHAR ): BOOLEAN;
 BEGIN
"ASSEMBLER
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(CLR.W   D2
 
 l       MOVE.B  (A0)+,D2
(BEQ     equ1
(CMP.B   (A1)+,D2
(BNE     ne
(SUBQ    #1,D0
(BCS     e
(DBRA    D1,l
 
(; str1 zu Ende, str0 aber nicht
(TST.B   (A0)+
(BEQ     equ0
(BRA     ne
 
 equ1    ; str0 zu Ende, str1 prfen
(TST.B   (A1)+
(BEQ     equ0
 
 ne      CLR     (A3)+
(RTS
 
 e       ; str0 zu Ende, str1 prfen
(TST     D1
(BEQ     equ0
(TST.B   (A1)+
(BNE     ne
 
 equ0    MOVE    #1,(A3)+
 
 (* alt:
(MOVE    D5,-(A7)
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(MOVE    -(A3),D5
(MOVE.L  -(A3),A1
(MOVEQ   #0,D1
 l       MOVE.B  (A0)+,D2
(CMP.B   (A1)+,D2
(BNE     ne0
(TST.B   D2
(BEQ     equ0
(ADDQ    #1,D1
(CMP     D0,D1
(BHI     e
(CMP     D5,D1
(BLS     l
(
(; str1 zu Ende, str0 aber nicht
(TST.B   (A0)+
(BEQ     equ0
(
 ne0     CLR     (A3)+
(MOVE    (A7)+,D5
(RTS
(
 e       ; str0 zu Ende, str1 prfen
(CMP     D5,D1
(BHI     equ0
(TST.B   (A1)+
(BNE     ne0
(
 equ0    MOVE    #1,(A3)+
(MOVE    (A7)+,D5
 *)
"END
 END StrEqual;
 
 
 PROCEDURE Upper (VAR s:ARRAY OF CHAR);
 BEGIN
"ASSEMBLER
(MOVE    -(A3),D1
(MOVE.L  -(A3),A0
(LEA     tab(PC),A1
(CLR     D0
 l       MOVE.B  (A0),D0
(BEQ     e
(MOVE.B  0(A1,D0.W),(A0)+
(DBRA    D1,l
 e       RTS
 
"tab:  DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','[','\',']','^','_'
(DC.B '`','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','{','|','}','~',''
(DC.B '','','','A','','','','','E','E','E','I','I','I','',''
(DC.B '','','','O','','O','U','U','','','','','','','',''
(DC.B 'A','I','O','U','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
"END
 END Upper;
 
 PROCEDURE Lower (VAR s:ARRAY OF CHAR);
 BEGIN
"ASSEMBLER
(MOVE    -(A3),D1
(MOVE.L  -(A3),A0
(LEA     tab(PC),A1
(CLR     D0
 l       MOVE.B  (A0),D0
(BEQ     e
(MOVE.B  0(A1,D0.W),(A0)+
(DBRA    D1,l
 e       RTS
"
 tab     DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'
(DC.B 'p','q','r','s','t','u','v','w','x','y','z','[','\',']','^','_'
(DC.B '`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'
(DC.B 'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
"END
 END Lower;
 
 
 PROCEDURE Delete ( VAR str: ARRAY OF CHAR; index, len: INTEGER; VAR success: BOOLEAN );
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(MOVEM.L D3-D5/A4,-(A7)
(MOVE.L  -(A3),A4
(MOVE    -(A3),D2         ;D2:=len
(MOVE    -(A3),D1         ;D1:=index
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(
(; Len(str) bestimmen
(MOVE.L  A0,D4
(MOVE.L  A0,D5
(MOVE    D0,D3
 l1      TST.B   (A0)+
(DBEQ    D3,l1
(BNE     c
(SUBQ.L  #1,A0
 c       MOVE.L  A0,D3
(SUB.L   D4,D3
(MOVE.L  D5,A0
(
(TST     D1              ; neg. index ?
(BPL     c1
(ADD     D1,D2           ; dann index:=0, len verringern
(CLR     D1
(
 c1      TST     D2              ; len neg. ?
(BPL     c3
(CLR     D2              ; dann len:=0
(
 c3      MOVE    D1,D4           ; index
(ADD     D2,D4           ; index + len
(CMP     D3,D4           ; ist index+len<=len(str) ?
(BLS     fits
(CMP     D0,D1           ; Nein, dann gibt's nix zu kopieren
(BHI     err
(CLR.B   0(A0,D1.W)      ; Lnge auf index krzen
(BRA     err
(
 fits    TST     D2
(BEQ     ok
(SUB     D4,D3
(BRA     c2
 l2      MOVE.B  0(A0,D4.W),0(A0,D1.W)
(ADDQ    #1,D4
(ADDQ    #1,D1
 c2      DBRA    D3,l2
(CLR.B   0(A0,D1.W)
(
 ok      MOVE    #1,(A4)
(MOVEM.L (A7)+,D3-D5/A4
(UNLK    A5
(RTS
(
 err     CLR     (A4)
(MOVEM.L (A7)+,D3-D5/A4
(UNLK    A5
 END
 END Delete;
 
 PROCEDURE Assign ( REF source: ARRAY OF CHAR;
3VAR dest: ARRAY OF CHAR; VAR success: BOOLEAN );
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),A2        ;Adr (success)
(MOVE    -(A3),D1
(MOVE.L  -(A3),A1
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(BRA     y
(
%x  SUBQ    #1,D0
(BCS     ok2       ; Source-Ende, Dest. muss Endmarke bekommen
%y  MOVE.B  (A0)+,(A1)+
(DBEQ    D1,x
(BEQ     ok        ; Endmarke der Source wurde eben kopiert
(
(TST     D0        ;*** Ende der Schleife, weil Dest voll
(BEQ     ok        ; Source komplett kopiert (hatte keine Endmarke)
(TST.B   (A0)
(BEQ     ok        ; sonst muss die Endmarke das naechste Zeichen sein
(
(CLR     (A2)
(UNLK    A5
(RTS
(
$ok2 CLR.B   (A1)+
$ok  MOVE    #1,(A2)
(UNLK    A5
"END
 END Assign;
 
 PROCEDURE Split ( REF source: ARRAY OF CHAR; pos: INTEGER;
2VAR dest1, dest2: ARRAY OF CHAR; VAR success: BOOLEAN );
 BEGIN
"ASSEMBLER
(MOVEM.L D4-D6/A4,-(A7)
(LINK    A5,#0            ;LINK mu wg. copyAnOnStack nach MOVEM stehen!
(MOVE.L  -(A3),A4        ; success
(MOVE    -(A3),D6
(MOVE.L  -(A3),A2        ; dest2
(MOVE    -(A3),D5
(MOVE.L  -(A3),A1        ; dest1
(MOVE    -(A3),D1        ; pos
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0        ; source
(
(CMPA.L  A1,A0
(BNE     notEqu
(JSR     copyA0OnStack
(BRA     notEqu2
&notEqu
(
(CMPA.L  A2,A0
(BNE     notEqu2
(JSR     copyA0OnStack
&notEqu2
(
(CLR.B   (A1)
(CLR.B   (A2)
(MOVE    #1,(A4)
(
(MOVEQ   #0,D2           ; source-counter
 l       CMP     D1,D2           ; pos erreicht ?
(BGE     scnd
(CMP     D0,D2           ; source geleert ?
(BHI     err             ; ja.
(CMP     D5,D2
(BHI     full
(MOVE.B  (A0)+,(A1)+
 c       BEQ     err2
(ADDQ    #1,D2
(BRA     l
(
 full    CLR     (A4)
(TST.B   (A0)+
(BRA     c
(
 full2   TST.B   (A0)+
(BEQ     ende
(
 err     CMP     D5,D2
(BHI     err2
(CLR.B   (A1)+           ; Endemarke bei dest1 setzen
(
 err2    CLR     (A4)
(BRA     ende
(
 scnd    CMP     D5,D2
(BHI     scnd0
(CLR.B   (A1)+           ; Endemarke bei dest1 setzen
 scnd0   MOVEQ   #0,D4
 l2      CMP     D6,D4           ; dest2 voll ?
(BHI     full2
(MOVE.B  (A0)+,(A2)+
(BEQ     ende
(ADDQ    #1,D2
(ADDQ    #1,D4
(CMP     D0,D2
(BLS     l2
(CMP     D6,D4
(BHI     ende
(CLR.B   (A2)+           ; Endemarke bei dest2 setzen
 ende
(UNLK    A5
(MOVEM.L (A7)+,D4-D6/A4
"END
 END Split;
 
 
 PROCEDURE Append ( REF source : ARRAY OF CHAR;
3VAR dest   : ARRAY OF CHAR;
3VAR success: BOOLEAN        );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),A2
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1        ; source
(
(CMPA.L  A1,A0
(BNE     notEqu
(JSR     copyA1OnStack
&notEqu
(
'L1:
(TST.B   (A0)+
(DBEQ    D0,L1
(BNE     inv
(SUBQ.L  #1,A0
(ADDQ    #1,D0
'L2:
(MOVE.B  (A1)+,D2
(BEQ     valid3
(SUBQ    #1,D0
(BCS     inv2
(MOVE.B  D2,(A0)+
(DBRA    D1,L2
(BRA     valid3
'inv:
(TST.B   (A1)
(BEQ     valid
'inv2:
(CLR     (A2)
(UNLK    A5
(RTS
'valid3:
(TST     D0
(BEQ     valid
(CLR.B   (A0)+
'valid:
(MOVE    #1,(A2)
(UNLK    A5
$END
"END Append;
 
 PROCEDURE Insert ( REF source: ARRAY OF CHAR; pos: INTEGER;
3VAR dest: ARRAY OF CHAR; VAR success: BOOLEAN );
 BEGIN
"ASSEMBLER
(MOVEM.L D3-D6/A4,-(A7)
(LINK    A5,#0           ;LINK mu wg. copyAnOnStack nach MOVEM stehen!
(MOVE.L  -(A3),A4        ;Adr (success)
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0        ;dest
(MOVE    -(A3),D4        ;D4:=index
(MOVE    -(A3),D1
(MOVE.L  -(A3),A1        ;source
(
(CMPA.L  A1,A0
(BNE     notEqu
(JSR     copyA1OnStack
&notEqu
(
(MOVEQ   #1,D6           ; success-Wert
(
(;Len (source) nach D2
(MOVEQ   #0,D2
 l2      TST.B   0(A1,D2.W)
(BEQ     stre2
(ADDQ    #1,D2
(CMP     D1,D2
(BLS     l2
(
 stre2   ; Len(dest) nach D5
(MOVE.L  A0,D1
(MOVE    D0,D5
 l       TST.B   (A0)+
(DBEQ    D5,l
(BNE     c
(SUBQ.L  #1,A0
 c       MOVE.L  A0,D5
(SUB.L   D1,D5
(
(CMP     D5,D4           ; index>len(dest) ?
(BGT     err             ; dann Fehler
(
(TST     D4              ; index
(BPL     idxpos
(
(MOVE    D2,D3           ; len (source)
(ADD     D4,D3           ; + index
(BLE     err             ; sind negativ, also nix zu kopieren
(
(CLR     D6              ; success ist FALSE
(SUBA.W  D4,A1           ; source um neg. index erhhen
(CLR     D4              ; index:=0
(MOVE    D3,D2           ; Kopierbarer Rest ist neues len(source)
(
 idxpos: TST     D2              ; len(source)=0 ?
(BEQ     ok              ; dann nix kopieren, ok
(
(; A0 steht hinter dest-Ende
(
(; D1: Kopierlnge := len(dest) - index
(MOVE    D5,D1
(SUB     D4,D1
(
(; D0: Platz fr Einfgung := high(dest)+1 - len(dest)
(ADDQ    #1,D0
(SUB     D5,D0
(BEQ     err             ; kein Platz
(
(CMP     D0,D2           ; len(source) <= Platz ?
(SCC.B   -(A7)           ;   Flags (<) retten
(BLS     novrfl          ; dann kein Overflow
(
(CLR     D6              ; Vorh. Platz ist Kopierdiff; success := FALSE
(BRA     movup
(
 novrfl: MOVE    D2,D0           ; len(source) ist Kopierdiff.
(
 movup:  ; Stringende aufschieben, D0: Kopierdifferenz/Einfgungslnge
(MOVE.L  A0,A2
(ADDA.W  D0,A2           ; Einfgungslnge add.
(TST.B   (A7)+           ; wird String vollst. aufgefllt ?
(BNE     c3              ; ja
(CLR.B   (A2)            ; sonst neues Nullbyte ans Stringende
(BRA     c3
 l3      MOVE.B  -(A0),-(A2)
 c3      DBRA    D1,l3
(
(; source einfgen
(ADDA.W  D0,A1           ; Einfgungslnge add.
(SUBQ    #1,D0
 l4      MOVE.B  -(A1),-(A2)
(DBRA    D0,l4
(
 ok      MOVE    D6,(A4)
(UNLK    A5
(MOVEM.L (A7)+,D3-D6/A4
(RTS
(
 err     CLR     (A4)
(UNLK    A5
(MOVEM.L (A7)+,D3-D6/A4
"END
 END Insert;
 
 PROCEDURE Copy (REF source: ARRAY OF CHAR; index,len:INTEGER;
0VAR dest:ARRAY OF CHAR; VAR success: BOOLEAN);
 BEGIN
"ASSEMBLER
(MOVEM.L D3-D6,-(A7)
(LINK    A5,#0            ;LINK mu wg. copyAnOnStack nach MOVEM stehen!
(MOVE.L  -(A3),A0         ;Adr (success)
(MOVE    -(A3),D6         ;HIGH(dest)
(MOVE.L  -(A3),A2         ;dest
(MOVE    -(A3),D0         ;D0:=len
(MOVE    -(A3),D5         ;D5:=index
(MOVE    -(A3),D1         ;HIGH(source)
(MOVE.L  -(A3),A1         ;source
(
(CMPA.L  A1,A2
(BNE     notEqu
(JSR     copyA1OnStack
&notEqu
 
(CLR.B   (A2)
(CLR     (A0)            ; success := FALSE
(MOVEQ   #0,D4           ; index f. dest
(MOVEQ   #-1,D2          ; index f. source
(
(TST     D5              ; neg. start ?
(BPL     c1
(
(ADD     D5,D0           ; dann start:=0, DEC (len,-start)
(CLR     D5
(
 c1      TST     D0
(BGT     start
(
(; nur noch prfen fr 'success'
 l2      ADDQ    #1,D2
(CMP     D5,D2           ; haben wir start-index erreicht ?
(BEQ     ok
(CMP     D1,D2
(BHI     ende             ; Stringende berschritten
(TST.B   0(A1,D2.W)
(BEQ     ende
(BRA     l2              ; Nein, noch nicht kopieren
(
 l       ADDQ    #1,D2
(CMP     D1,D2
(BHI     ende             ; Stringende berschritten
(MOVE.B  0(A1,D2.W),D3
(BEQ     ende
(CMP     D5,D2           ; haben wir start-index erreicht ?
(BCS     l               ; Nein, noch nicht kopieren
(CMP     D6,D4           ; pat Zeichen noch in String ?
(BHI     ende0
(MOVE.B  D3,0(A2,D4.W)   ; Zeichen kopieren
(ADDQ    #1,D4
 start   DBRA    D0,l
(
 ok      MOVE    #1,(A0) ; success := TRUE
 ende    CMP     D6,D4   ; pat 0C noch in String ?
(BHI     ende0
(CLR.B   0(A2,D4.W)
 ende0   UNLK    A5
(MOVEM.L (A7)+,D3-D6
"END
 END Copy;
 
 
 PROCEDURE Space ( n: INTEGER ): String;
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(MOVE.L  A3,A0
(ADDA.W  #80,A3
(MOVEQ   #' ',D1
(BRA     C
&L MOVE.B  D1,(A0)+
&C SUBQ    #1,D0
(BPL     L
(CLR.B   (A0)+
$END
"END Space;
 
 END Strings.
  
(* $FFEEEE24$FFE9FBF8$FFE9FBF8$FFE9FBF8$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$00002BC9$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$FFFC3D36$00000002T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000006A4$000006AC$00000722$00000002$00000725$000006AC$00000722$FFEE60E2$00000722$FFEE60E2$00002A9D$00002AF0$00005113$FFEE60E2$000051E0$00005113*)
