/*
 *	Aes object library interface
 *
 *	    objc_add	      Add an object to an object tree
 *	    objc_delete      Delete an object from an object tree
 *	    objc_draw	      Draw an Object
 *	    objc_find	      Find an Object under mouse
 *	    objc_offset      Compute offset of object relative to screen
 *	    objc_order       Move an object to a new position
 *	    objc_edit	      Let user edit text in an object
 *	    objc_change      Change an Objects state
 *     objc_sysvar      Return/modify color and placement of 3d effects
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 *    modified: cg -- d2cg@dtek.chalmers.se
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_objc_add
#define L_objc_del
#define L_objc_dra
#define L_objc_fin
#define L_objc_off
#define L_objc_ord
#define L_objc_edi
#define L_objc_cha
#define L_objc_sys

#endif /* __DEF_ALL__ */


#ifdef L_objc_add

/* Add an Object to tree
 *	return 0 on error	>0 no error
 */
int objc_add(void *Tree, int Parent, int Child)
{
    _int_in[0] = Parent;
    _int_in[1] = Child;
    _addrin[0] = Tree;
    return __aes__(AES_CONTROL_ENCODE(40, 2, 1, 1));
}
#endif /* L_objc_add */

#ifdef L_objc_del

/* Delete an Object from a tree
 *	return 0 on error	>0 no error
 */
int objc_delete(void *Tree, int Object)
{
    _addrin[0] = Tree;
    _int_in[0]  = Object;
    return __aes__(AES_CONTROL_ENCODE(41, 1, 1, 1));
}
#endif /* L_objc_del */


#ifdef L_objc_dra

/* Draw an Object
 *	Tree	Address of Tree containing Object
 *	Start	Index of Starting Object
 *	Depth	max depth to draw to
 *	Cx, Cy, Cw, Ch define the clipping rectangle
 *
 *	return 0 on error	>0 no error
 */
int objc_draw(void *Tree, int Start, int Depth,
	      int Cx, int Cy, int Cw, int Ch)
{
    _int_in[0] = Start;
    _int_in[1] = Depth;
    _int_in[2] = Cx;
    _int_in[3] = Cy;
    _int_in[4] = Cw;
    _int_in[5] = Ch;
    _addrin[0] = Tree;
    
    return __aes__(AES_CONTROL_ENCODE(42, 6, 1, 1));
}
#endif /* L_objc_dra */


#ifdef L_objc_fin

/* Find an object under mouse form
 *	Tree	Address of tree containing object Start
 *	Start	The object at which to start the search
 *	Depth	Max depth of tree to search
 *	Mx, My	mouse Location
 *
 *	returns	Index of object found (0 thru n), -1 == no object
 */
int objc_find(void *Tree, int Start, int Depth, int Mx, int My)
{
    _int_in[0] = Start;
    _int_in[1] = Depth;
    _int_in[2] = Mx;
    _int_in[3] = My;
    _addrin[0] = Tree;

    return __aes__(AES_CONTROL_ENCODE(43, 4, 1, 1));
}
#endif /* L_objc_fin */

#ifdef L_objc_off

/* Compute Object offset rel. to screen
 *	returns 0 on error	>0 no error
 */
int objc_offset(void *Tree, int Object,
		int  *X, int *Y)
{
    int retval;
    
    _addrin[0] = Tree;
    _int_in[0] = Object;
    
    retval = __aes__(AES_CONTROL_ENCODE(44, 1, 3, 1));

    *X = _int_out[1];
    *Y = _int_out[2];

    return retval;
}
#endif /* L_objc_off */


#ifdef L_objc_ord

/* Move an Object to NewPos in Tree
 *	returns 0 on error	>0 no error
 */
int objc_order(void *Tree, int Object, int NewPos)
{
    _int_in[0] = Object;
    _int_in[1] = NewPos;
    _addrin[0] = Tree;
    
    return __aes__(AES_CONTROL_ENCODE(45, 2, 1, 1));
}
#endif /* L_objc_ord */


#ifdef L_objc_edi

/* Let user edit text in Object
 *	returns 0 on error	>0 no error
 */
int objc_edit(void *Tree, int Object, int Char, int Index, int Kind,
	      int *NewIndex)
{
    int retval;
    
    _int_in[0] = Object;
    _int_in[1] = Char;
    _int_in[2] = Index;
    _int_in[3] = Kind;
    _addrin[0] = Tree;

    retval = __aes__(AES_CONTROL_ENCODE(46, 4, 2, 1));

    *NewIndex = _int_out[1];
    
    return retval;
}
#endif /* L_objc_edi */

#ifdef L_objc_cha

/* Ch.State of Ob
 *	returns 0 on error	>0 no error
 */
int objc_change(void *Tree, int Object, int Res, int Cx, int Cy, int Cw,
		int Ch,	int NewState, int Redraw)
{
    _int_in[0] = Object;
    _int_in[1] = Res;	/* reserved (for what?) */
    _int_in[2] = Cx;
    _int_in[3] = Cy;
    _int_in[4] = Cw;
    _int_in[5] = Ch;
    _int_in[6] = NewState;
    _int_in[7] = Redraw;
    _addrin[0] = Tree;
    
    return __aes__(AES_CONTROL_ENCODE(47, 8, 1, 1));
}
#endif /* L_objc_cha */


#ifdef L_objc_sys

int objc_sysvar(int mode, int which, int in1, int in2, int *out1, int *out2)
{
	int	retvar;
	
    _int_in[0] = mode;
    _int_in[1] = which;	/* reserved (for what?) */
    _int_in[2] = in1;
    _int_in[3] = in2;
    
    retvar = __aes__(AES_CONTROL_ENCODE(48, 4, 3, 0));

	*out1 = _int_out[1];
	*out2 = _int_out[2];

	return retvar;
}
#endif /* L_objc_sys */

	
/* - eof - */	
