/*
 *	Aes window library interface
 *
 *	    wind_create		Create a window
 *	    wind_open		Open a window in its initial size
 *	    wind_close		Close a window (not de-allocated)
 *	    wind_delete		De-Allocate a window
 *	    wind_get		Returns info about a window
 *	    wind_set		Sets various attributes of a window
 *	    wind_find		Find window under mouse.
 *	    wind_update		Advise AES about exclusive use of a window
 *	    wind_calc		Calc work area/border area of a window
 *	    wind_new		close and delete all windows
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"
#include	<stdarg.h>

#ifdef __DEF_ALL__

#define L_wind_cre
#define L_wind_ope
#define L_wind_clo
#define L_wind_del
#define L_wind_get
#define L_wind_set
#define L_wind_fin
#define L_wind_upd
#define L_wind_cal
#define L_wind_new

#endif /* __DEF_ALL__ */


#ifdef L_wind_cre

/* wind_create
 *	Parts	The window parts to be present
 *		NAME	0x0001	Title Bar
 *		CLOSE	0x0002	Close Box
 *		FULL	0x0004	Full Box
 *		MOVE	0x0008	Move Bar
 *		INFO	0x0010	Info line
 *		SIZE	0x0020	Size Box
 *		UPARROW 0x0040	Up arrow on vert slider
 *		DNARROW 0x0080  Dn arrow on vert slider
 *		VSLIDE  0x0100	Vert slider
 *		LFARROW 0x0200	Left  arrow on horz slider
 *		RTARROW 0x0400	Right arrow on horz slider
 *		HSLIDE  0x0800  Horz slider
 *
 *	Wx,Wy,Ww,Wh	Max window size
 *
 *	retrun	WindowHandle	Identifier of the created window <0 == error
 */
int wind_create(int Parts, int Wx, int Wy, int Ww, int Wh)
{
    _int_in[0] = Parts;
    _int_in[1] = Wx;
    _int_in[2] = Wy;
    _int_in[3] = Ww;
    _int_in[4] = Wh;
    
    return __aes__(AES_CONTROL_ENCODE(100, 5, 1, 0));
}
#endif /* L_wind_cre */


#ifdef L_wind_ope

/* wind_open
 *	WindowHandle	The window's identifying handle
 *	Wx,Wy,Ww,Wh	Position and size to open at
 *
 *	returns 0 on error	>0 no error
 */
int wind_open(int WindowHandle, int Wx, int Wy, int Ww, int Wh)
{
    _int_in[0] = WindowHandle;
    _int_in[1] = Wx;
    _int_in[2] = Wy;
    _int_in[3] = Ww;
    _int_in[4] = Wh;
    
    return __aes__(AES_CONTROL_ENCODE(101, 5, 1, 0));
}
#endif /* L_wind_ope */


#ifdef L_wind_clo

int wind_close(int WindowHandle)
{
    _int_in[0] = WindowHandle;
    return __aes__(AES_CONTROL_ENCODE(102, 1, 1, 0));
}
#endif /* L_wind_clo */


#ifdef L_wind_del

int wind_delete(int WindowHandle)
{
    _int_in[0] = WindowHandle;
    return __aes__(AES_CONTROL_ENCODE(103, 1, 1, 0));
}
#endif /* L_wind_del */

#ifdef L_wind_get

/*
 * wind_get
 *	WindowHandle	Window identifier
 *	What		WF_WORKXYWH(4)	coordinates of inside work area
 *			WF_CURRXYWH(5)	curr coordinates of entire window
 *			WF_PREVXYWH(6)	coordinates of previous window
 *			WF_FULLXYWH(7)  coordinate of window at its max size
 *			WF_HSLIDE(8)	position of horz slider in W1
 *			WF_VSLIDE(9)	position of vert slider in W1
 *			WF_TOP(10)	window handle of window on top in W1
 *			WF_FIRSTXYWH(11) coord. of first rect in window list
 *			WF_NEXTXYWH(12) coord. of next window in rect in list
 *			13,14 reserved
 *			WF_HSLSIZE(15)	size of horz slider in W1
 *			WF_VSLSIZE(16)	size of vert slider in W1
 *
 *	returns 0 on error	>0 no error
 */
int wind_get(int WindowHandle, int What,
	     int *W1, int *W2, int *W3, int *W4)
{
    int retval;

    _int_in[0] = WindowHandle;
    _int_in[1] = What;

    retval = __aes__(AES_CONTROL_ENCODE(104, 2, 5, 0));

    *W1 = _int_out[1];
    *W2 = _int_out[2];
    *W3 = _int_out[3];
    *W4 = _int_out[4];
    return retval;
}
#endif /* L_wind_get */

#ifdef L_wind_set

/*
 * wind_set
 *	What		Same as above except
 *			WF_KIND(1)	Window components in W1
 *			WF_NAME(2)	Window Title in W1 and W2
 *			WF_INFO(3)	Window info line in W1 and W2
 *			WF_NEWDESK(14)	Address of new desktop tree in W1 W2
 *					index of object in W3
 *
 *	return 0 on error	>0 no error
 */
 
#ifndef	PURE_C

int wind_set(int WindowHandle, int What, int W1, int W2, int W3, int W4)
{
    _int_in[0] = WindowHandle;
    _int_in[1] = What;
#ifdef __MSHORT__
	
    _int_in[2] = W1;
    _int_in[3] = W2;
    _int_in[4] = W3;
    _int_in[5] = W4;

#else
    /* for 32 bit ints stuff the address into _int_in[2] and [3] */
    switch(What)
    {
     /* NAME    INFO    NEWDESK */
	case 2: case 3: case 14:
		{ unsigned short *s = (unsigned short *)&W1;
		  _int_in[2] = s[0];
		  _int_in[3] = s[1];
		  if(What == 14 /* NEWDESK */)
			_int_in[4] = W2;
		}
		break;
	default:
		_int_in[2] = W1;
		_int_in[3] = W2;
		_int_in[4] = W3;
		_int_in[5] = W4;
    }
#endif /* __MSHORT__ */

    return __aes__(AES_CONTROL_ENCODE(105, 6, 1, 0));
}


#else	PURE_C

int wind_set(int WindowHandle, int What, ...)
{
	va_list	p;
	
    _int_in[0] = WindowHandle;
    _int_in[1] = What;

	va_start(p,What);
	
	_int_in[2] = va_arg(p,int);
	_int_in[3] = va_arg(p,int);
	_int_in[4] = va_arg(p,int);
	_int_in[5] = va_arg(p,int);
	    
    va_end(p);

    return __aes__(AES_CONTROL_ENCODE(105, 6, 1, 0));
}
#endif /* PURE_C */
#endif /* L_wind_set */

#ifdef L_wind_fin

/*  Find window under mouse
 * 	returns handle of window undex X,Y
 */
int wind_find(int X, int Y)
{
    _int_in[0] = X;
    _int_in[1] = Y;
    return __aes__(AES_CONTROL_ENCODE(106, 2, 1, 0));
}
#endif /* L_wind_fin */

#ifdef L_wind_upd

/* wind_update
 *	Code	END_UPDATE(0)	end of update
 *		BEG_UPDATE(1)	begin update of window
 *		END_MCTRL(2)	end control of mouse functions
 *		BEG_MCTRL(3)	begin control of mouse functions
 *
 *	returns 0 on error	>0 no error
 */
int wind_update(int Code)
{
    _int_in[0] = Code;
    return __aes__(AES_CONTROL_ENCODE(107, 1, 1, 0));
}
#endif /* L_wind_upd */

#ifdef L_wind_cal

/*
 * wind_calc
 *	Type	= 0 return border area
 *		= 1 return inner work area
 *	Parts	As above
 *	InX,InY, InW, InH input value, when Type = 0 coord. of inner area
 *			               when Type = 1 coord. of border area
 *	OutX,OutY,OutW, OutH	calculated coordinates
 *
 *	return 0 on error	>0 o error
 */
int wind_calc(int Type, int Parts,
	      int InX,  int InY, int InW, int InH,
	      int *OutX, int *OutY, int *OutW, int *OutH)
{
    int retval;

    _int_in[0] = Type;
    _int_in[1] = Parts;
    _int_in[2] = InX;
    _int_in[3] = InY;
    _int_in[4] = InW;
    _int_in[5] = InH;
    
    retval = __aes__(AES_CONTROL_ENCODE(108, 6, 5, 0));
    
    *OutX = _int_out[1];
    *OutY = _int_out[2];
    *OutW = _int_out[3];
    *OutH = _int_out[4];
    
    return retval;
}
#endif /* L_wind_cal */

#ifdef L_wind_new

/*
 * wind_new
 *	Close and delete all windows, reset wind_update(), flush all buffers
 *	restore mouse ownership to system
 *
 */
void wind_new(void)
{
    (void) __aes__(AES_CONTROL_ENCODE(109, 0, 0, 0));
}	
#endif /* L_wind_new */

/* - eof - */
