/*		vdiesc.c
 Copyright 1991 Jens Tingleff (uunet!titan.ee.ic.ac.uk!jensting)
 
 Dedicated to public domain
*/

#include <stddef.h>

#include "common.h"



#ifdef __DEF_ALL__

#define L_vq_chcel
#define L_v_exit_c
#define L_v_enter_
#define L_v_curup
#define L_v_curdow
#define L_v_currig
#define L_v_curlef
#define L_v_curhom
#define L_v_eeos
#define L_v_eeol
#define L_vs_curad
#define L_v_curtex
#define L_v_rvon
#define L_v_rvoff
#define L_vq_curad

#endif /* __DEF_ALL__ */


#ifdef L_vq_chcel

/*		vq_chcells
 * Inquire addressable aplha character cells.
 * -1 for no cursor addressing (value for `*n_cols' ?)
 */
void vq_chcells(int handle, int *n_rows, int *n_cols)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 1), handle);
    *n_rows = _intout[0];
    *n_cols = _intout[1];
}
#endif /* L_vq_chcel */


#ifdef L_v_exit_c

/*		v_exit_cur
 * Exit alpha mode.
 */
void v_exit_cur(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 2), handle);
}
#endif /* L_v_exit_c */


#ifdef L_v_enter_

/*		v_enter_cur
 * Enter alpha mode
 */
void v_enter_cur(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 3), handle);
}
#endif /* L_v_enter_ */


#ifdef L_v_curup

/*		v_curup
 * Alpha cursor up (do nothing if at top).
 */
void v_curup(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 4), handle);
}
#endif /* L_v_curup */


#ifdef L_v_curdow

/*		v_curdown
 * Aplha cursor down (do nothing if at bottom).
 */
void v_curdown(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 5), handle);
}
#endif /* L_v_curdow */

#ifdef L_v_currig

/*		v_curright
 * Aplha cursor right (do nothing if at right edge).
 */
void v_curright(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 6), handle);
}
#endif /* L_v_currig */

#ifdef L_v_curlef

/*		v_curleft
 * Aplha cursor left (do nothing if at left edge).
 */
void v_curleft(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 7), handle);
}
#endif /* L_v_curlef */

#ifdef L_v_curhom

/*		v_curhome
 * Aplha cursor home.
 */
void v_curhome(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 8), handle);
}
#endif /* L_v_curhom */



#ifdef L_v_eeos

/*		v_eeos
 * Erase to end of screen.
 */
void v_eeos(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 9), handle);
}
#endif /* L_v_eeos */


#ifdef L_v_eeol

/*		v_eeol
 * Erase to end of line.
 */
void v_eeol(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 10), handle);
}
#endif /* L_v_eeol */



#ifdef L_vs_curad

/*		vs_curaddress
 * Direct aplha cursor address.
 */
void vs_curaddress(int handle, int row, int col)
{
    _intin[0] = row;
    _intin[1] = col;

    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 11), handle);
}
#endif /* L_vs_curad */


#ifdef L_v_curtex

/*		v_curtext
 * Output cursor addressable text (string `s').
 */
void v_curtext(int handle, char *s)
{
    int	i;

    if(*s == '\000')
    {
	return;
    }

    for(i=0; s[i] != '\000'; i++)	/* Error checking ? we don't 	*/
					/* need no stinking error 	*/
					/* checking !			*/
    {
	_intin[i] = s[i];
    }

    __vdi__(VDI_CONTRL_ENCODE(5, 0, i, 12), handle);
}
#endif /* L_v_curtex */

#ifdef L_v_rvon

/*		v_rvon
 * Reverse video on.
 */
void v_rvon(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 13), handle);
}
#endif /* L_v_rvon */


#ifdef L_v_rvoff

/*		v_rvoff
 * Reverse video off
 */
void v_rvoff(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 14), handle);
}
#endif /* L_v_rvoff */

#ifdef L_vq_curad

/*		vq_curaddress
 * Inquire current cursor address.
 */
void vq_curaddress(int handle, int *cur_row, int *cur_col)
{
    __vdi__(VDI_CONTRL_ENCODE(5, 0, 0, 15), handle);
    *cur_row = _intout[0];
    *cur_col = _intout[1];
}
#endif /* L_vq_curad */
