/*
 *	Vdi drawing primitives library interface
 *
 * 		v_bar		bar
 * 		v_arc		arc
 * 		v_pieslice	pie
 * 		v_circle	circle
 * 		v_ellarc	elliptical arc
 * 		v_ellpie	elliptical pie
 * 		v_ellipse	ellipse
 * 		v_rbox		rounded rect
 * 		v_rfbox		rounded filled rect
 * 		v_justified	justified text
 *
 *		    ++jrb	bammi@cadence.com
 *		    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include <stddef.h>
#include "common.h"

#ifdef __DEF_ALL__

#define L_v_bar
#define L_v_arc
#define L_v_piesli
#define L_v_circle
#define L_v_ellarc
#define L_v_ellpie
#define L_v_ellips
#define L_v_rbox
#define L_v_rfbox
#define L_v_justif

#endif /* __DEF_ALL__ */


#ifdef L_v_bar

/* v_bar	bar
 * returns void
 */
void v_bar(int handle, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register int i;
    
    for(i = 0; i < 4; i++)
	_ptsin[i] = pxyarray[i];
#endif

    __vdi__(VDI_CONTRL_ENCODE(11, 2, 0, 1), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_bar */

#ifdef L_v_arc

/* v_arc	arc
 * returns void
 */
void v_arc(int handle, int x, int y, int radius, int begang, int endang)
{
    extern void bzero(void *, size_t);
    
    bzero(_ptsin, 8 * sizeof(short));
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[6] = radius;
    _intin[0] = begang;
    _intin[1] = endang;
    
    __vdi__(VDI_CONTRL_ENCODE(11, 4, 2, 2), handle);
}
#endif /* L_v_arc */

#ifdef L_v_piesli

/* v_pieslice	pie
 * returns void
 */
void v_pieslice(int handle, int x, int y, int radius, int begang, int endang)
{
    extern void bzero(void *, size_t);
    
    bzero(_ptsin, 8 * sizeof(short));
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[6] = radius;
    _intin[0] = begang;
    _intin[1] = endang;
    
    __vdi__(VDI_CONTRL_ENCODE(11, 4, 2, 3), handle);
}
#endif /* L_v_piesli */

#ifdef L_v_circle

/* v_circle	circle
 * returns void
 */
void v_circle(int handle, int x, int y, int radius)
{
    extern void bzero(void *, size_t);
    
    bzero(_ptsin, 6 * sizeof(short));
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[4] = radius;
    
    __vdi__(VDI_CONTRL_ENCODE(11, 3, 0, 4), handle);
}
#endif /* L_v_circle */

#ifdef L_v_ellarc

/* v_ellarc	elliptical arc
 * return void
 */
void v_ellarc(int handle, int x, int y, int xrad, int yrad,
	      int begang, int endang)
{
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[2] = xrad;
    _ptsin[3] = yrad;
    _intin[0] = begang;
    _intin[1] = endang;
    
    __vdi__(VDI_CONTRL_ENCODE(11, 2, 2, 6), handle);
}
#endif /* L_v_ellarc */

#ifdef L_v_ellpie

/* v_ellpie	elliptical pie
 * return void
 */
void v_ellpie(int handle, int x, int y, int xrad, int yrad,
	      int begang, int endang)
{
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[2] = xrad;
    _ptsin[3] = yrad;
    _intin[0] = begang;
    _intin[1] = endang;
    
    __vdi__(VDI_CONTRL_ENCODE(11, 2, 2, 7), handle);
}
#endif /* L_v_ellpie */

#ifdef L_v_ellips

/* v_ellipse	ellipse
 * returns void
 */
void v_ellipse(int handle, int x, int y, int xrad, int yrad)
{
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[2] = xrad;
    _ptsin[3] = yrad;

    __vdi__(VDI_CONTRL_ENCODE(11, 2, 0, 5), handle);
}
#endif /* L_v_ellips */

#ifdef L_v_rbox

/* v_rbox	rounded rect
 * returns void
 */
void v_rbox(int handle, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register int i;
    
    for(i = 0; i < 4; i++)
	_ptsin[i] = pxyarray[i];
#endif

    __vdi__(VDI_CONTRL_ENCODE(11, 2, 0, 8), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_rbox */

#ifdef L_v_rfbox

/* v_rfbox	rounded filled rect
 * returns void
 */
void v_rfbox(int handle, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register int i;
    
    for(i = 0; i < 4; i++)
	_ptsin[i] = pxyarray[i];
#endif
    
    __vdi__(VDI_CONTRL_ENCODE(11, 2, 0, 9), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_rfbox */

#ifdef L_v_justif

/* v_justified	justified text
 * returns void
 */
void v_justified(int handle, int x, int y, char *str, int len,
		 int word_space, int char_space)
{
    register short *wptr = _intin;
    
    _ptsin[0] = x;
    _ptsin[1] = y;
    _ptsin[2] = len;
    _ptsin[3] = 0;
    *wptr++ = word_space;
    *wptr++ = char_space;
    while (0 != (*wptr = (unsigned char) *str++))
	wptr += 1;

    __vdi__(VDI_CONTRL_ENCODE(11, 2, (int)(wptr - _intin), 10), handle);
}
#endif /* L_v_justif */

/* -eof- */
