/*
 *	Vdi raster funcs library interface
 *
 *		vro_cpyfm	copy raster opaque
 * 		vrt_cpyfm	copy raster transparent
 * 		vr_trnfm	transform form
 * 		v_get_pixel	get pix
 *
 *		    ++jrb	bammi@cadence.com
 *		    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_vro_cpyf
#define L_vrt_cpyf
#define L_vr_trnfm
#define L_v_get_pi

#endif /* __DEF_ALL__ */


#ifdef L_vro_cpyf

/* vro_cpyfm	copy raster opaque
 * returns void
 */
void vro_cpyfm(int handle, int mode, int pxyarray[],
	       void *src,  void *dst)
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register short i;

    for(i = 0; i < 8; i++)
	_ptsin[i] = pxyarray[i];
#endif

    _intin[0] = mode;
    *((void **)(&_contrl[7])) = src;
    *((void **)(&_contrl[9])) = dst;

    __vdi__(VDI_CONTRL_ENCODE(109, 4, 1, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_vro_cpyf */

#ifdef L_vrt_cpyf

/* vrt_cpyfm	copy raster transparent
 * returns void
 */
void vrt_cpyfm(int handle, int mode, int pxyarray[],
	       void *src,  void *dst, int color[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register short i;

    for(i = 0; i < 8; i++)
	_ptsin[i] = pxyarray[i];
#endif

    _intin[0] = mode;
    _intin[1] = color[0];
    _intin[2] = color[1];

    *((void **)(&_contrl[7])) = src;
    *((void **)(&_contrl[9])) = dst;

    __vdi__(VDI_CONTRL_ENCODE(121, 4, 3, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_vrt_cpyf */

#ifdef L_vr_trnfm

/* vr_trnfm	transform form
 * returns void
 */
void vr_trnfm(int handle, void *src, void *dst)
{
    *((void **)(&_contrl[7])) = src;
    *((void **)(&_contrl[9])) = dst;

    __vdi__(VDI_CONTRL_ENCODE(110, 0, 0, 0), handle);
}
#endif /* L_vr_trnfm */

#ifdef L_v_get_pi

/* v_get_pixel	get pix
 * returns void (results in args)
 */
void v_get_pixel( int handle, int x, int y, int *pel, int *index)
{
    _ptsin[0] = x;
    _ptsin[1] = y;
 
    __vdi__(VDI_CONTRL_ENCODE(105, 1, 0, 0), handle);
    
    *pel = _intout[0];
    *index = _intout[1];
}
#endif /* L_v_get_pi */

/* -eof- */
