/*
 *	Aes scrap interface
 *
 *		scrp_read	read the directory path for scrap dir
 *		scrp_write	define access path for scrap dir
 *		scrp_clear	remove all files in scrap dir
 *
 *			++fgth	ridderbusch.pad@nixdorf.com
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_scrp_rea
#define L_scrp_wri
#define L_scrp_cle

#endif /* __DEF_ALL__ */


#ifdef L_scrp_rea

/* read the path for the scrap directory
 *	returns 0 on error	>0 no error
 */
int scrp_read(char *Scrappath)
{
    _addrin[0] = Scrappath;
    return __aes__(AES_CONTROL_ENCODE(80, 0, 1, 1));
}
#endif /* L_scrp_rea */

#ifdef L_scrp_wri

/* define the path for the scrap directory
 *	returns 0 on error	>0 no error
 */
int scrp_write(char *Scrappath)
{
    _addrin[0] = Scrappath;
    return __aes__(AES_CONTROL_ENCODE(81, 0, 1, 1));
}
#endif /* L_scrp_wri */

#if 0
/* not present in GEM < V2 */

#ifdef L_scrp_cle

/* clear all files in the scrap directory
 *	returns 0 on error	>0 no error
 */
int scrp_clear(void)
{
    return __aes__(AES_CONTROL_ENCODE(82, 0, 1, 0));
}
#endif /* L_scrp_cle */
#endif
