/*
 *	Aes event library interface
 *
 *	    evnt_keybd	Wait for a keyboard event
 *	    evnt_button	Wait for a mouse button
 *	    evnt_mouse	Wait for a mouse to enter/leave a rectangle
 *	    evnt_mesag	Wait for a message from another application
 *	    evnt_timer	Wait for a specified amount of time
 *	    evnt_multi	Wait for one of many possible events
 *	    evnt_dclick	Set or get the present double click speed
 *	    
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_evnt_key
#define L_evnt_but
#define L_evnt_mou
#define L_evnt_mes
#define L_evnt_tim
#define L_evnt_mul
#define L_evnt_dcl

#endif /* __DEF_ALL__ */


#ifdef L_evnt_key

/* Wait for a keyboard event
 *	returns	kdb code of the key hit
 */
int evnt_keybd(void)
{
    return __aes__(AES_CONTROL_ENCODE(20, 0, 1, 0));
}
#endif /* L_evnt_key */


#ifdef L_evnt_but

/* wait for a mouse button state
 *	Clicks		The number of times to wait for a button to enter state
 *	WhichButton	Which of the mouse buttonss (1 for left 2 for right)
 *	WhichState	Which state are we waiting for (0 = down  1 = up)
 *	Mx, My		X,Y coordinate of mouse when event occured
 *	ButtonState	The button state when event occured
 *	KeyState	State of Shift, Ctrl and Alt keys when event occured
 *
 *	returns		The number of times the button actually entered
 *			the desired state.
 */
int evnt_button(int Clicks, 
		int WhichButton,
		int WhichState,
		int *Mx, int *My,
		int *ButtonState, int *KeyState)
{
    int retval;
    
    _int_in[0] = Clicks;
    _int_in[1] = WhichButton;
    _int_in[2] = WhichState;
    
    retval = __aes__(AES_CONTROL_ENCODE(21, 3, 5, 0));
    *Mx = _int_out[1];
    *My = _int_out[2];
    *ButtonState = _int_out[3];
    *KeyState    = _int_out[4];
    return retval;
}
#endif /* L_evnt_but */


#ifdef L_evnt_mou

/* wait for mouse event
 *	EnterExit	=0 return on entry	=1 return on exit
 *	InX,InY,InW,InH The rectangle to monitor entry/exit out of
 *	OutX,OutY     X,Y coordinate of mouse when event occured
 *	ButtonState   State of mouse buttons when event occured (1=l  2=r but)
 *	KeyState      State of Shift, Ctrl and Alt keys when event occured
 *
 *	always returns a reserved val.
 */
int evnt_mouse(int EnterExit, int InX, int InY, int InW, int InH,
	       int *OutX, int *OutY, 
	       int *ButtonState, 
	       int *KeyState)
{
    int retval;
    
    _int_in[0] = EnterExit;
    _int_in[1] = InX;
    _int_in[2] = InY;
    _int_in[3] = InW;
    _int_in[4] = InH;
    retval = __aes__(AES_CONTROL_ENCODE(22, 5, 5, 0));
    *OutX = _int_out[1];
    *OutY = _int_out[2];
    *ButtonState = _int_out[3];
    *KeyState    = _int_out[4];
    return retval;
}
#endif /* L_evnt_mou */


#ifdef L_evnt_mes

/* Wait for a 16 byte message from pipe
 *	returns a reserved value
 */
int evnt_mesag(int MesagBuf[])
{
#ifndef __MSHORT__
#ifdef __GNUC__
    volatile
#endif
	short dummy[8];
    register int i;
    register int   retval;

    _addrin[0] = (void *)&dummy[0];	/* Address of 16 byte message buffer */
    retval = __aes__(AES_CONTROL_ENCODE(23, 0, 1, 1));
    if(MesagBuf != (int *)0)
	for(i = 0; i < 8; i++)
	    MesagBuf[i] = dummy[i];
    return retval;
#else
    _addrin[0] = MesagBuf;	/* Address of 16 byte message buffer */
    return __aes__(AES_CONTROL_ENCODE(23, 0, 1, 1));
#endif    
}
#endif /* L_evnt_mes */


#ifdef L_evnt_tim

/* sleep for Interval
 *	returns a reserved value
 */
int evnt_timer(unsigned long Interval)
{
    unsigned short *i = (unsigned short *)&Interval;
    
    _int_in[0] = i[1];
    _int_in[1] = i[0];
    return __aes__(AES_CONTROL_ENCODE(24, 2, 1, 0));
}
#endif /* L_evnt_tim */

#ifdef L_evnt_mul

#ifdef __GNUC__
asm(".stabs \"___evnt_multi\",5,0,0,_evnt_multi"); /* dept of clean tricks */
#else
	/* foo */
#endif

/* wait for one of many events
 *	Type	The types of Events to wait for
 *		rest of the parameters analogus to ones defined above.
 *
 *	returns	The event that ended the wait
 *
 */
int evnt_multi(int Type,
	       int Clicks,		/* Inputs */
	       int WhichButton,
	       int WhichState,
	       int EnterExit1, int In1X, int In1Y, int In1W, int In1H,
	       int EnterExit2, int In2X, int In2Y, int In2W, int In2H,
	       int MesagBuf[],
	       unsigned long Interval,
	       int *OutX, int *OutY, 	/* Outputs */
	       int *ButtonState,
	       int *KeyState,
	       int *Key, 
	       int *ReturnCount)
{
    unsigned short *i = (unsigned short *)&Interval;
    int retval;
#ifndef __MSHORT__
    register int j;
#ifdef __GNUC__
    volatile
#endif
	short dummy[8];
#endif    
    
    _int_in[0] = Type;
    _int_in[1] = Clicks;
    _int_in[2] = WhichButton;
    _int_in[3] = WhichState;
    
    _int_in[4] = EnterExit1;
    _int_in[5] = In1X;
    _int_in[6] = In1Y;
    _int_in[7] = In1W;
    _int_in[8] = In1H;
    
    _int_in[9] = EnterExit2;
    _int_in[10] = In2X;
    _int_in[11] = In2Y;
    _int_in[12] = In2W;
    _int_in[13] = In2H;
    
    _int_in[14] = i[1];
    _int_in[15] = i[0];
    
#ifdef __MSHORT__
    _addrin[0] = MesagBuf;
#else
    _addrin[0] = (void *)&dummy[0];
#endif

    retval = __aes__(AES_CONTROL_ENCODE(25, 16, 7, 1));
    
    *OutX = _int_out[1];
    *OutY = _int_out[2];
    *ButtonState = _int_out[3];
    *KeyState    = _int_out[4];
    *Key	 = _int_out[5];
    *ReturnCount = _int_out[6];

#ifndef __MSHORT__
    if(MesagBuf != (int *)0)
        for(j = 0; j < 8; j++)
	    MesagBuf[j] = dummy[j];
#endif

    return retval;
}
#endif /* L_evnt_mul */

#ifdef L_evnt_dcl

/*  Set/get double click speed
 *	returns current setting
 */
int evnt_dclick(int ToSet,	/*  Speed to set at [0,4] */
		int SetGet)	/*  1= set  0=get         */
{
    _int_in[0] = ToSet;
    _int_in[1] = SetGet;
    return __aes__(AES_CONTROL_ENCODE(26, 2, 1, 0));
}
#endif /* L_evnt_dcl */


/* - eof - */	
